// Persistence of Vision Ray Tracer Include File
// Part of the IRTC GIP object archives
// Version: 1.0

// Object: IR_Brownstone         

// Object Description: My idea of a Brownstone Building
// Author: Ib Rasmussen
// Email: ibras@post4.tele.dk
// Date (yyyy-mm-dd): 1999.12.08

// Origin: Lower right corner of the front brick wall
// Orientation: Y = up
// Dimensions: 1 unit = 1 cm
// Size: x-axis: -3 to 55 + 640 * NoOfStairs
//       y-axis: -60 to 865 + 250 * (NoOfFloors - 3)
//       z-axis: -250 to 710
//
// Includes required: colors.inc  
// Bitmap file required: BSbilbrd.gif
                      
// Comments: The size of the building is controlled by the variables
//           NoOfFloors and NoOfStairs. NoOfFloors has to be at least 3.
//           NoOfStairs is the number of segments, that are put together.
//           Each segment is 4 windows wide.
//           
//           NOTE: The building is only designed to be viewed from the
//                 front.

/*********************** Control Variables ***************************/

#ifndef (ShowGlass)
   #local ShowGlass=1;
#end   

#ifndef (ShowDetail)
   #local ShowDetail=1;
#end   

// Local

#ifndef (NoOfFloors)
   #local NoOfFloors=3;
#end   

#if (NoOfFloors < 3)
   #local NoOfFloors=4;
#end
   
#ifndef (NoOfStairs)
   #local NoOfStairs=1;
#end   

#if (NoOfFloors < 1)
   #local NoOfFloors=1;
#end
   
#ifndef (BSBboard)
   #local BSBboard=1;
#end   

#declare BSRand = seed(2);

/************************* Declarations ******************************/

/*-------------------------- Textures -------------------------------*/


#local BHeight= 7.5;
#local BWidth=  26.6666666;

#local T_BSMortarcolour=texture {
   pigment { granite
      turbulence 0.6
      color_map{
	      [0.000, 0.154   color rgbf <0.35, 0.35, 0.283, 0.000>
			                color rgbf <0.35, 0.35, 0.339, 0.000>]
	      [0.154, 0.300   color rgbf <0.35, 0.35, 0.35, 0.000>
			                color rgbf <0.35, 0.35, 0.283, 0.000>]
	      [0.300, 0.320   color rgbf <0.25, 0.25, 0.25, 0.000>
			                color rgbf <0.3, 0.3, 0.3, 0.000>]
	      [0.320, 0.615   color rgbf <0.35, 0.35, 0.35, 0.000>
			                color rgbf <0.35, 0.35, 0.283, 0.000>]
	      [0.615, 0.812   color rgbf <0.35, 0.35, 0.283, 0.000>
			                color rgbf <0.35, 0.35, 0.339, 0.000>]
	      [0.812, 1.001   color rgbf <0.35, 0.35, 0.35, 0.000>
			                color rgbf <0.05, 0.05, 0.05, 0.000>]
      }
   }
   scale <3, 3, 3>
   finish { ambient 0.3 diffuse 0.7 }
}

#local T_BSBrickcolour=texture {
   pigment { bozo
      turbulence 1.0
      color_map{
	      [0.0, 0.5   color rgbf <0.13, 0.04, 0.04, 0.0>
  		               color rgbf <0.20, 0.07, 0.04, 0.0>]
	      [0.5, 1.001 color rgbf <0.20, 0.07, 0.04, 0.0>
		               color rgbf <0.13, 0.04, 0.04, 0.0>]
      }
   }
   scale <30, 30, 30>
}

#local T_BSBrick=texture {
#if (ShowDetail = 1)
   brick texture {T_BSMortarcolour}, texture {T_BSBrickcolour}
   brick_size <BWidth, BHeight, BWidth>
   mortar 1.8
#else
   pigment { VeryDarkBrown }
#end   
}

#local T_BSSandstone=texture {
   pigment { granite
      turbulence 0.6
      color_map{
	      [0.000, 0.154   color rgbf <0.7, 0.7, 0.566, 0.000>
			                color rgbf <0.7, 0.7, 0.677, 0.000>]
	      [0.154, 0.300   color rgbf <0.7, 0.7, 0.7, 0.000>
			                color rgbf <0.7, 0.7, 0.566, 0.000>]
	      [0.300, 0.320   color rgbf <0.5, 0.5, 0.5, 0.000>
			                color rgbf <0.6, 0.6, 0.6, 0.000>]
	      [0.320, 0.615   color rgbf <0.7, 0.7, 0.7, 0.000>
			                color rgbf <0.7, 0.7, 0.566, 0.000>]
	      [0.615, 0.812   color rgbf <0.7, 0.7, 0.566, 0.000>
			                color rgbf <0.7, 0.7, 0.677, 0.000>]
	      [0.812, 1.001   color rgbf <0.7, 0.7, 0.7, 0.000>
			                color rgbf <0.1, 0.1, 0.1, 0.000>]
      }
   }
   scale <3, 3, 3>
   finish { ambient 0.3 diffuse 0.7 }
}

#local T_BSWindowGlass=texture {
   pigment { color Clear }
#if (ShowGlass = 1)
   finish {
      ambient 0
      diffuse 0
      reflection 0.1
      phong 0.3
      phong_size 60
   }
   normal { bumps 0.01 scale <150, 100, 1> }
//   normal { bumps 0.03 scale 2 }
#end
}

#local T_BSWindowFrame=texture {
   pigment { colour rgb <0.1 0.05, 0.03> }
}

#local T_BSDoor=texture {
   pigment { colour rgb <0.1 0.02, 0.01> }
   finish {phong 0.05  phong_size 500}
}

#local T_BSJern=texture{
   pigment { Gray05 }
   finish {phong 0.05  phong_size 10}
   normal { bumps 0.1 scale <0.5, 0.5, 1> }
}

#local T_BSRoofcover=texture {
   pigment { color rgb <0.2, 0.2, 0.2> }
}

/*------------------------- Objects ----------------------------------*/


/*-------------- Windows ------------------*/

#local BSWindowFrame=union {
   difference {
      box { <-38, -40, 0>, <38, 40, 4> }
      box { <-34, -36, -1>, <34, 36, 5> }
      texture { T_BSWindowFrame }
   }
   box { <-34, -36, 1.5>, <34, 36, 1.7> texture { T_BSWindowGlass } interior { ior 1.5 } }
}

#local BSWindow1=union{
   difference {
      box { <-40, -80, 4>, <40, 80, 30> }
      box { <-38, -78, -1>, <38, 78, 31> }
      texture { T_BSWindowFrame }
   }
   object { BSWindowFrame translate <0, -38, 12> }
   object { BSWindowFrame translate <0,  38, 8> }
   box { <-45,  79.8, -1>, <45,  88, 30> texture { T_BSSandstone } }
   box { <-45, -85, -5>, <45, -79.5, 30> texture { T_BSSandstone } }
}

#local BSWindow2Top=union{
   difference {
      cylinder { <0, 0, 4>, <0, 0, 30>, 40 }
      cylinder { <0, 0, -1>, <0, 0, 31>, 38 }
      plane { y, 0 }
   }
   box { <-38, -2, 8>, <38, 2, 12> }
   difference {
      cylinder { <0, 0, 8>, <0, 0, 12>, 38 }
      cylinder { <0, 0, 3>, <0, 0, 13>, 34 }
      plane { y, 0 translate <0, 2, 0> }
   }
//   box { <-2, 2, 8>, <2, 35, 12> }
   difference {
      cylinder { <0, 0, 9.5>, <0, 0, 9.7>, 35 }
      plane { y, 0 translate <0, 2, 0> }
      texture { T_BSWindowGlass }  
      interior { ior 1.5 } 
   }
   difference {
      cylinder { <0, 0, -1>, <0, 0, 30>, 52 }
      cylinder { <0, 0, -2>, <0, 0, 31>, 40 }
      plane { y, 10 }
      texture { T_BSSandstone }
   }       
   difference {
      box { <-6, 38, -1>, <6, 54, 30> }
      plane { x, 0 rotate <0, 0,  5> translate <-6, 54, 0> }
      plane {-x, 0 rotate <0, 0, -5> translate < 6, 54, 0> }
      texture { T_BSSandstone }
   }       
      
   texture { T_BSWindowFrame }
}

#local BSWindow2=union{
   object { BSWindow2Top translate <0, 78, 0> }
   difference {
      box { <-40, -80, 4>, <40, 78, 30> }
      box { <-38, -78, -1>, <38, 80, 31> }
      texture { T_BSWindowFrame }
   }
   object { BSWindowFrame translate <0, -38, 12> }
   object { BSWindowFrame translate <0,  38, 8> }
   box { <-45, -85, -5>, <45, -79.5, 30> texture { T_BSSandstone } }
}

#local BSWindow3=union{
   difference {
      box { <-40, 0, 4>, <40, 90, 30> }
      box { <-38, 2, -1>, <38, 91, 31> }
   }
   difference {
      cylinder { <0, 78.3333, 4>, <0, 78.3333, 30>, 41.6667 }
      cylinder { <0, 78.3333, -1>, <0, 78.3333, 31>, 39.7506 }
      plane { y, 0 translate <0, 90, 0> }
   }

   difference {
      box { <-38, 2, 8>, <38, 60, 12> }
      box { <-34, 6, -1>, <34, 56, 31> }
   }
   box { <-34, 6, 9.5>, <34, 56, 9.7> texture { T_BSWindowGlass } interior { ior 1.5 } }

   difference {
      box { <-38, 56, 8>, <38, 90, 12> }
      box { <-34, 60, -1>, <34, 91, 31> }
   }
   difference {
      cylinder { <0, 78.3333, 8>, <0, 78.3333, 12>, 39.7506 }
      cylinder { <0, 78.3333, 0>, <0, 78.3333, 31>, 35.9459 }
      plane { y, 0 translate <0, 90, 0> }
   }
   merge {
      box { <-34, 60, 9.5>, <34, 90, 9.7> }
      difference {
         cylinder { <0, 78.3333, 9.5>, <0, 78.3333, 9.7>, 35.95 }
         plane { y, 0 translate <0, 89.99, 0> }
      }
      texture { T_BSWindowGlass } 
      interior { ior 1.5 } 
   }
   texture { T_BSWindowFrame }
}

/*--------------- Doors -------------------*/

#local BSBasementDoor=union{
   difference {
      box { <-45, 0, 0>, <45, 205, 5> }
      box { <-35, 10, -1>, <-5,  70, 2> }
      box { < 35, 10, -1>, < 5,  70, 2> }
      box { <-35, 80, -1>, <-5, 195, 2> }
      box { < 35, 80, -1>, < 5, 195, 2> }
   }   
   box { <-32, 13, 0>, <-8,  67, 2> }
   box { < 32, 13, 0>, < 8,  67, 2> }
   box { <-32, 83, 0>, <-8, 192, 2> }
   box { < 32, 83, 0>, < 8, 192, 2> }
   
   union{
      cylinder { <-40, 75, 0>, <-40, 75, -3>, 1 } 
      sphere { <0, 0, 0>, 2.5 scale <1, 1, 0.5> translate <-40, 75, -3> }
      texture { T_Brass_4A }
   }
      
   texture {T_BSWindowFrame }
}
  
#local BSFDListe30=difference {
   union{
      box { <-35, 0, 0>, <35, 4, 1> rotate <25, 0, 0> }
      cylinder { <-35, 3.4, -0.5>, <35, 3.4, -0.5>, 0.4 }
   }   
   plane { x, 0 rotate <0, 0,  45> translate <-15, 3, 0> }
   plane {-x, 0 rotate <0, 0, -45> translate < 15, 3, 0> }
}   
     
#local BSFDListe60=difference {                            
   union{
      box { <-35, 0, 0>, <35, 4, 1> rotate <25, 0, 0> }
      cylinder { <-35, 3.4, -0.5>, <35, 3.4, -0.5>, 0.4 }
   }   
   plane { x, 0 rotate <0, 0,  45> translate <-30, 3, 0> }
   plane {-x, 0 rotate <0, 0, -45> translate < 30, 3, 0> }
}   
     
#local BSFDGlasListe30=difference {
   union{
      box { <-35, 0, 0>, <35, -3, 1> rotate <-25, 0, 0> }
      cylinder { <-35, 0.4, 0>, <35, 0.4, 0>, 0.4 }
   }   
   plane { x, 0 rotate <0, 0,  45> translate <-15, 0, 0> }
   plane {-x, 0 rotate <0, 0, -45> translate < 15, 0, 0> }
}   
     
#local BSFDGlasListe115=difference {
   union{
      box { <-120, 0, 0>, <120, -3, 1> rotate <-25, 0, 0> }
      cylinder { <-120, 0.4, 0>, <120, 0.4, 0>, 0.4 }
   }   
   plane { x, 0 rotate <0, 0,  45> translate <-57.5, 0, 0> }
   plane {-x, 0 rotate <0, 0, -45> translate < 57.5, 0, 0> }
}   
           
#local BSFrontDoorTopListe=union{
   box { <-1, 0, 0>, <1, 37, 3> }
   cylinder { <0, 0, 0>, <0, 37, 0>, 0.5 }
}   

#local BSFrontDoorTop=union{
   difference {
      cylinder { <0, 0, 0>, <0, 0, 5>, 45 }
      cylinder { <0, 0, -1>, <0, 0, 6>, 38.001 }
      cone { <0, 0, 1.001>, 38, <0, 0, -0.001>, 40 }
      plane { y, 0 }
   }  
   difference {
      torus { 40.4 0.4 rotate <90, 0, 0> }
      plane { y, 0 translate <0, 4.2, 0> }
   }  
   difference {
      box { <-40, 0, 0>, <40, 7, 5> }
      plane { z, 0 rotate <25, 0, 0> translate <0, 5, 0> }
   }                                      
   cylinder { <-40, 4.6, 0>, <40, 4.6, 0>, 0.4 }
   
   object { BSFrontDoorTopListe rotate <0, 0, -45> translate <0, 5, 0> }
   object { BSFrontDoorTopListe translate <0, 5, 0> }
   object { BSFrontDoorTopListe rotate <0, 0,  45> translate <0, 5, 0> }
            
   difference {
      cylinder { <0, 0, 1>, <0, 0, 2>, 45 }
      plane { y, 0 translate <0, 5, 0> }
      texture { T_BSWindowGlass }
   }  

   texture {T_BSDoor }
}
           
#local BSFrontDoor=union{
   difference {
      box { <-45, 0, 0>, <45, 205, 5> }
      box { <-35, 10, -1>, <-5,  70, 2> }
      box { < 35, 10, -1>, < 5,  70, 2> }
      box { <-35, 80, -1>, <-5, 195, 7> }
      box { < 35, 80, -1>, < 5, 195, 7> }
   }   
   box { <-32, 13, 0>, <-8,  67, 2> }
   box { < 32, 13, 0>, < 8,  67, 2> }
   object { BSFDListe30 translate <-20, 67, 0.5> }
   object { BSFDListe30 translate < 20, 67, 0.5> }
   object { BSFDListe30 rotate <0, 0, 180> translate <-20, 13, 0.5> }
   object { BSFDListe30 rotate <0, 0, 180> translate < 20, 13, 0.5> }
   object { BSFDListe60 rotate <0, 0,  90> translate <-32, 40, 0.5> }
   object { BSFDListe60 rotate <0, 0, -90> translate < -8, 40, 0.5> }
   object { BSFDListe60 rotate <0, 0,  90> translate <  8, 40, 0.5> }
   object { BSFDListe60 rotate <0, 0, -90> translate < 32, 40, 0.5> }

   object { BSFDGlasListe30 translate <-20, 195, 0> }
   object { BSFDGlasListe30 translate < 20, 195, 0> }
   object { BSFDGlasListe30 rotate <0, 0, 180> translate <-20, 80, 0> }
   object { BSFDGlasListe30 rotate <0, 0, 180> translate < 20, 80, 0> }
   object { BSFDGlasListe115 rotate <0, 0,  90> translate <-35, 137.5, 0> }
   object { BSFDGlasListe115 rotate <0, 0, -90> translate < -5, 137.5, 0> }
   object { BSFDGlasListe115 rotate <0, 0,  90> translate <  5, 137.5, 0> }
   object { BSFDGlasListe115 rotate <0, 0, -90> translate < 35, 137.5, 0> }
                 
                
   box { <-35, 80, 1>, <-5, 195, 1.2> texture { T_BSWindowGlass } }
   box { < 35, 80, 1>, < 5, 195, 1.2> texture { T_BSWindowGlass } }

   union{
      cylinder { <-40, 75, 0>, <-40, 75, -3>, 1 } 
      sphere { <0, 0, 0>, 2.5 scale <1, 1, 0.5> translate <-40, 75, -3> }
      texture { T_Brass_4A }
   }
                    
   object { BSFrontDoorTop translate <0, 210, 0> }
                    
   //Karm
   box { <-52, 0, -1>, <-45, 210, 0> }
   box { < 52, 0, -1>, < 45, 210, 0> }
   box { <-52, 0, -2>, <-47, 210, 0> }
   box { < 52, 0, -2>, < 47, 210, 0> }
   box { <-52, 0, -3>, <-50, 210, 0> }
   box { < 52, 0, -3>, < 50, 210, 0> }
   cylinder { <-47, 0, -1>, <-47, 210, -1>, 1 }
   cylinder { < 47, 0, -1>, < 47, 210, -1>, 1 }
   difference {
      cylinder { <0, 210, -1>, <0, 210, 0>, 52 }
      cylinder { <0, 210, -5>, <0, 210, 1>, 45 }
      plane { y, 0 translate <0, 210, 0> }
   }   
   difference {
      cylinder { <0, 210, -2>, <0, 210, 0>, 52 }
      cylinder { <0, 210, -5>, <0, 210, 1>, 47 }
      plane { y, 0 translate <0, 210, 0> }
   }   
   difference {
      cylinder { <0, 210, -3>, <0, 210, 0>, 52 }
      cylinder { <0, 210, -5>, <0, 210, 1>, 50 }
      plane { y, 0 translate <0, 210, 0> }
   }   
   difference {
      torus { 47, 1 rotate <90, 0, 0> translate <0, 210, -1> }
      plane { y, 0 translate <0, 210, 0> }
   }   
   box { <-45, 205, -1>, < 45, 210, 0> }
      
   texture {T_BSDoor }
}

#local BSIronGateRing=difference{
   cylinder { <0, 0,  0>, <0, 0, 2>, 5 }
   cylinder { <0, 0, -1>, <0, 0, 3>, 4.0 }
}

#local BSIronGateDoor=union{
   box { <-2, 0, 0>, <0, 235, 2> }
   box { <-55, 0, 0>, <0, 2, 2> }
   box { <-55, 0, 0>, <-52, 180, 2> }
   difference {
      cylinder { <0, 180, 0>, <0, 180, 2>, 55 }
      cylinder { <0, 180, -1>, <0, 180, 3>, 52 }
      plane { y, 0 translate <0, 180, 0> }
      plane { -x, 0 }
   }
   box { <-55,  12, 0>, <0,  14, 2> }
   box { <-55,  64, 0>, <0,  66, 2> }
   box { <-55,  76, 0>, <0,  78, 2> }
   box { <-55, 168, 0>, <0, 170, 2> }
   box { <-55, 180, 0>, <0, 182, 2> }
   #local xpos = -7;
   #while (xpos > -50)
      object { BSIronGateRing translate <xpos,   7, 0> }
      object { BSIronGateRing translate <xpos,  71, 0> }
      object { BSIronGateRing translate <xpos, 175, 0> }
      #local xpos = xpos-10;
   #end
   difference {
      cylinder { <0, 180, 0>, <0, 180, 2>, 42 }
      cylinder { <0, 180, -1>, <0, 180, 3>, 40 }
      plane { y, 0 translate <0, 182, 0> }
      plane { -x, 0 translate <-2, 0, 0> }
   }
   difference {
      cylinder { <0, 182,  0>, <0, 182, 2>, 14 }
      cylinder { <0, 182, -1>, <0, 182, 3>, 12 }
      plane { y, 0 translate <0, 182, 0> }
      plane { -x, 0 translate <-2, 0, 0> }
   }
   box { <-53, -1, 0>, <-13, 1, 2> rotate <0, 0, -15> translate <-1, 181, 0> }
   box { <-53, -1, 0>, <-13, 1, 2> rotate <0, 0, -30> translate <-1, 181, 0> }
   box { <-53, -1, 0>, <-13, 1, 2> rotate <0, 0, -45> translate <-1, 181, 0> }
   box { <-53, -1, 0>, <-13, 1, 2> rotate <0, 0, -60> translate <-1, 181, 0> }
   box { <-53, -1, 0>, <-13, 1, 2> rotate <0, 0, -75> translate <-1, 181, 0> }
   object { BSIronGateRing translate <-45.87, 0, 0> rotate <0, 0,  -7.5161> translate <-1, 181, 0> }
   object { BSIronGateRing translate <-45.87, 0, 0> rotate <0, 0, -22.5459> translate <-1, 181, 0> }
   object { BSIronGateRing translate <-45.87, 0, 0> rotate <0, 0, -37.5613> translate <-1, 181, 0> }
   object { BSIronGateRing translate <-45.87, 0, 0> rotate <0, 0, -52.5612> translate <-1, 181, 0> }
   object { BSIronGateRing translate <-45.87, 0, 0> rotate <0, 0, -67.5457> translate <-1, 181, 0> }
   object { BSIronGateRing translate <-45.87, 0, 0> rotate <0, 0, -82.5160> translate <-1, 181, 0> }

   #local xpos = -7.8;
   #while (xpos > -50)
      box { <xpos-0.6, 78, 0>, <xpos+0.6, 168, 2> }
      #local xpos = xpos - 6.4;
   #end

   #local xpos = -4.6;
   #while (xpos > -50)
      difference {
         cylinder { <xpos, 123,  0>, <xpos, 123, 2>, 2.7 }
         cylinder { <xpos, 123, -1>, <xpos, 123, 3>, 1.8 }
      }
      #local xpos = xpos - 6.4;
   #end

   difference {
      cylinder { <-27, 39,  0>, <-27, 39, 2>, 25 }
      cylinder { <-27, 39, -1>, <-27, 39, 3>, 23 }
   }
   cylinder { <-53, 13, 1>, < -1, 65, 1>, 0.7 }
   cylinder { <-53, 65, 1>, < -1, 13, 1>, 0.7 }
   cylinder { <-27, 13, 1>, <-27, 65, 1>, 0.7 }
   cylinder { <-53, 39, 1>, < -1, 39, 1>, 0.7 }
   cylinder { <-37.76996, 65, 1>, <-16.2304, 13, 1>, 0.7 }
   cylinder { <-37.76996, 13, 1>, <-16.2304, 65, 1>, 0.7 }
   cylinder { <-53, 28.2304, 1>, < -1, 49.7696, 1>, 0.7 }
   cylinder { <-1, 28.2304, 1>, < -53, 49.7696, 1>, 0.7 }
   cylinder { <-27, 39, 0>, <-27, 39, 2>, 5 }
   texture { T_BSJern }
}

#local BSIronGateHandle=union{
   cylinder { <-10, 0, -5>, <0, 0, -5>, 1 }
   cylinder { <  0, 0, -5>, <0, 0,  5>, 1 }
   cylinder { <-10, 0,  5>, <0, 0,  5>, 1 }
   sphere { <0, 0, -5>, 1 }
   sphere { <0, 0,  5>, 1 }
}

#local BSIronGateHinge=union{
   sphere { <0, 8, 0>, 0.6 }
   cylinder { <0, 0.1, 0>, <0, 8, 0>, 0.6 }
   cylinder { <0, -0.1, 0>, <0, -8, 0>, 0.6 }
   sphere { <0, -8, 0>, 0.6 }
   texture { T_BSJern }
}

#local BSIronGateLeft=union{
   object { BSIronGateDoor translate <0, 0, -2> }
   difference {
      box { <-14, 100, 0>, <-1, 110, -2> }
      cylinder { <-4, 104, -5>, <-4, 104, 5>, 0.7 }
      box { <-4.4, 101.5, -5>, <-3.6, 104, 5> }
   }
   object { BSIronGateHandle rotate <0, 0, 5> translate <-3, 107, -1> }
   object { BSIronGateHinge translate <-55, 160, 0> }
   object { BSIronGateHinge translate <-55,  40, 0> }
   texture { T_BSJern }
}

#local BSIronGateRight=union{
   object { BSIronGateDoor scale <-1, 1, 1> translate <0, 0, -2> }
   box { <1, 100, 0>, <8, 110, -2> }
   object { BSIronGateHinge translate < 55, 160, 0> }
   object { BSIronGateHinge translate < 55,  40, 0> }
   texture { T_BSJern }
}

/* --------------- Misc ------------------*/

#local BSFloorLine=box {
   <-400, 0, -1>, <240, 10, 30>
   texture { T_BSSandstone }
}
                
/*
#local BSBillboard=union{
#if (ShowDetail = 1)
   box { <0, 0, -1>, <1, 1, 0> texture { pigment { image_map { gif "BSbilbrd.gif" } } } 
         scale <330, 220, 1> translate <-165, -110, 0> 
   }               
#else
   box { <0, 0, -1>, <1, 1, 0> texture { pigment { White } } scale <330, 220, 1> translate <-165, -110, 0> } 
#end   
   difference {
      box { <-175, -120, -3>, <175, 120, 0> }
      box { <-165, -110, -4>, <165, 110, 1> }
      texture { pigment { Gray50 } }
   }
}      
*/
                     
/*-------------- Basement Floor ------------------*/              

#local BSKeystone=union{
   difference { 
      box { <-10, -26, -4>, <10, 0, 30> }
      plane { x, 0 rotate <0, 0,  4> translate <-10, 0, 0> }
      plane {-x, 0 rotate <0, 0, -4> translate < 10, 0, 0> }
   }
   difference { 
      box { <-10, -26, -7>, <170, 0, -4> }
      plane { z, 0 rotate <0,  19,  4> translate <0, 0, -7> }
      plane { z, 0 rotate <0, -19, -4> translate <0, 0, -7> }
      plane {-y, 0 rotate <-60, 0, 0> translate <0,  -1, -4> }
      plane { y, 0 rotate < 60, 0, 0> translate <0, -25, -4> }
   }
   texture { T_BSSandstone }
}

#local BSWallCoveringPane1=difference {
   box { <45, 0, -3>, <120, 30, 0> }
   plane { x, 0 rotate <0, -45, 0> translate < 45,  0, -1.5> }
   plane {-x, 0 rotate <0,  45, 0> translate <120,  0, -1.5> }
   plane { y, 0 rotate < 45, 0, 0> translate <  0,  0, -1.5> }
   plane {-y, 0 rotate <-45, 0, 0> translate <  0, 30, -1.5> }
}

#local BSWallCoveringPane2=difference {
   box { <200, 0, -3>, <240, 30, 0> }
   plane { x, 0 rotate <  0, -45, 0> translate <200,  0, -1.5> }
   plane { y, 0 rotate < 45,   0, 0> translate <  0,  0, -1.5> }
   plane {-y, 0 rotate <-45,   0, 0> translate <  0, 30, -1.5> }
}

#local BSWallCoveringPane3=difference {
   box { <110, 135, -3>, <155, 175, 0> }
   plane {-y, 0 rotate <-45, 0, 0> translate <0, 175, -1.5> }
   plane { x, 0 rotate <0, 0, 55> translate <110, 150, 0> }
   plane {-x, 0 rotate <0, 0, 4> translate <150, 175, 0> }
   plane { x, 0 rotate <0, -45, 0> translate <110, 150, -1.5> }
   plane { x, 0 rotate <0, -45, 55> translate <110, 150, -1.5> }
   cylinder { <160, 108.3333, -40>, <160, 108.3333, 10>, 41.6667 }
   cone { <160, 108.3333, -1.499>, 41.6667, <160, 108.3333, -3.001>, 43.1667 }
}

#local BSWallCovering=union{
   difference {
      box { <45, -60, -3>, <240, 30, 0> }
      plane {-y, 0 rotate <-45, 0, 0> translate <0, 30, -1.5> }
   }
   object { BSWallCoveringPane1 translate <0, 30, 0> }
   object { BSWallCoveringPane2 translate <0, 30, 0> }
   object { BSWallCoveringPane1 translate <0, 60, 0> }
   object { BSWallCoveringPane2 translate <0, 60, 0> }
   object { BSWallCoveringPane1 translate <0, 90, 0> }
   object { BSWallCoveringPane2 translate <0, 90, 0> }

   difference {
      box { <45, 120, -3>, <130, 150, 0> }
      plane { y, 0 rotate <45, 0, 0> translate <0, 120, -1.5> }
      plane {-y, 0 rotate <-45, 0, 0> translate <0, 150, -1.5> }
      plane { x, 0 rotate <0, -45, 0> translate < 45, 0, -1.5> }
      plane {-x, 0 rotate <0, 0, 55> translate <110, 150, 0> }
      plane {-x, 0 rotate <0, 45, 55> translate <110, 150, -1.5> }
      cylinder { <160, 108.3333, -40>, <160, 108.3333, 10>, 41.6667 }
      cone { <160, 108.3333, -1.499>, 41.666, <160, 108.3333, -3.001>, 43.1667 }
   }

   difference {
      box { <190, 120, -3>, <240, 150, 0> }
      plane { y, 0 rotate <45, 0, 0> translate <0, 120, -1.5> }
      plane {-y, 0 rotate <-45, 0, 0> translate <0, 150, -1.5> }
      plane { x, 0 rotate <0, 0, -55> translate <210, 150, 0> }
      plane { x, 0 rotate <0, -45, -55> translate <210, 150, -1.5> }
      cylinder { <160, 108.3333, -40>, <160, 108.3333, 10>, 41.6667 }
      cone { <160, 108.3333, -1.499>, 41.666, <160, 108.3333, -3.001>, 43.1667 }
   }

   object { BSKeystone translate <160, 175, 0> }

   difference {
      box { <70, 150, -3>, <110, 175, 0> }
      plane { y, 0 rotate <45, 0, 0> translate <0, 150, -1.5> }
      plane {-y, 0 rotate <-45, 0, 0> translate <0, 175, -1.5> }
      plane {-x, 0 rotate <0, 45, 0> translate <110, 0, -1.5> }
   }

   object { BSWallCoveringPane3 }
   object { BSWallCoveringPane3 translate <-160, 0, > scale <-1, 1, 1> translate <160, 0, 0> }

   difference {
      box { <210, 150, -3>, <240, 175, 0> }
      plane { y, 0 rotate <45, 0, 0> translate <0, 150, -1.5> }
      plane {-y, 0 rotate <-45, 0, 0> translate <0, 175, -1.5> }
      plane { x, 0 rotate <0, -45, 0> translate <210, 0, -1.5> }
   }

   difference {
      cylinder { <73, 0, 0>, <240, 0, 0>, 12.5 scale <1, 1, 8/12.5> }
      plane { y, 0 }
      plane {-z, 0 }
      translate <0, 175, 0>
   }

   box { <115, 25, -8>, <205, 30, 30> }

   texture { T_BSSandstone }
}

#local BSBasementDrain=union{   
   difference {
      cylinder { <-400, 0, -16>, <-400, 275, -16>, 5 }
      plane {-y, 0 rotate <22.5, 0, 0> translate <0, 184.9289, -11> }
   }   
   difference {
      cylinder { <-400, -5, -5>, <-400, 15, -5>, 5 rotate <45, 0, 0> translate <0, 184.9289, -11> }
      plane { y, 0 rotate <22.5, 0, 0> translate <0, 184.9289, -11> }
      plane {-y, 0 rotate <22.5, 0, 0> translate <0, 192.9289,  -3> }
   }   
   cylinder { <-400, 50, -16>, <-400, 53, -16>, 6 }
   cylinder { <-400, 51.5, 0>, <-400, 51.5, -16>, 1 }
   cylinder { <-400, 160, -16>, <-400, 163, -16>, 6} 
   cylinder { <-400, 161.5, 0>, <-400, 161.5, -16>, 1 }
   cone { <-400, 1, -16>, 8, <-400, 17, -16>, 6 } 
   texture { T_BSJern }
}   

#local BSBasementWall=union{
   difference {
      box { <-400, -60, 0>, <240, 175, 30> }
      box { <-360, 30, -1>, <-280, 120.001, 31> }
      difference {
         cylinder { <-320, 108.3333, -1>, <-320, 108.3333, 31>, 41.6667 }
         box { <-275, 65, -2>, <-365, 120, 32> }
      }
      box { <-200, 30, -1>, <-120, 120.001, 31> }
      difference {
         cylinder { <-160, 108.3333, -1>, <-160, 108.3333, 31>, 41.6667 }
         box { <-115, 65, -2>, <-205, 120, 32> }
      }
      box { <-45, -65, -1>, <45, 145, 31> }
      box { < 200, 30, -1>, < 120, 120.001, 31> }
      difference {
         cylinder { < 160, 108.3333, -1>, < 160, 108.3333, 31>, 41.6667 }
         box { < 115, 65, -2>, < 205, 120, 32> }
      }
   }
   object { BSWallCovering }
   object { BSWallCovering scale <-1, 1, 1> }
   difference {
      object { BSWallCovering }
      box { <0, -100, -10>, <80, 190, 5> }
      translate <-480, 0, 0>
   }
#if (ShowDetail = 1)
   object { BSWindow3 translate <-320,  30, 0> }
   object { BSWindow3 translate <-160,  30, 0> }
   object { BSWindow3 translate < 160,  30, 0> }
             
   object { BSBasementDoor translate <0, -60, 0> }

   object { BSBasementDrain }
#end
   box { <-400, -60, 35>, <240, 174, 40> texture { pigment { Black } } }
                
   texture { T_BSSandstone }
}

/*---------------- First Floor ------------------*/
             
#local BSFirstFloorBricks=difference {
   box { <-400, 0, 0>, <240, 275, 30> }

   box { <-360, 47.5, -1>, <-280, 207.5, 31> }
   cylinder { <-320, 207.5, -1>, <-320, 207.5, 31>, 40 }

   box { <-200, 47.5, -1>, <-120, 207.5, 31> }
   cylinder { <-160, 207.5, -1>, <-160, 207.5, 31>, 40 }

   box { <-57, -1, -1>, <57, 180, 31> }
   cylinder { <0, 180, -1>, <0, 180, 31>, 57 }

   box { < 200, 47.5, -1>, < 120, 207.5, 31> }
   cylinder { < 160, 207.5, -1>, < 160, 207.5, 31>, 40 }

   texture { T_BSBrick translate <0, 5, 0> }
}
 
#local BSFirstFloorDrain=union{   
   difference {
      cylinder { <-400, 0, -8>, <-400, 275, -8>, 5 }
      plane { y, 0 rotate <22.5, 0, 0> translate <0, 17.9289, -3> }
   }   
   cylinder { <-400, 50, -8>, <-400, 53, -8>, 6 }
   cylinder { <-400, 175, -8>, <-400, 178, -8>, 6}
   texture { T_BSJern }
}   

#local BSFirstFloorWall=union{   
   object { BSFirstFloorBricks }
#if (ShowDetail = 1)
   object { BSFirstFloorDrain }
   object { BSWindow2 translate <-320, 127.5, 0> }
   object { BSWindow2 translate <-160, 127.5, 0> }
   object { BSWindow2 translate < 160, 127.5, 0> }
#end   
   difference {
      box { <-400, 0, 35>, <240, 275, 40> }
      box { <-80, -1, 0>, <80, 265, 100> }
      texture { pigment { Black } }
   }
}   
   
/*---------------- Second Floor ------------------*/
             
#local BSSecondFloorBricks=difference {
   box { <-400, 0, 0>, <240, 250, 30> }

   box { <-360, 60, -1>, <-280, 220, 31> }
   box { <-200, 60, -1>, <-120, 220, 31> }
   box { < -40, 60, -1>, <  40, 220, 31> }
   box { < 120, 60, -1>, < 200, 220, 31> }

   texture { T_BSBrick translate <0, 10, 0> }
}                  

#local BSSecondFloorDrain=union{
   cylinder { <-400,   0, -8>, <-400, 250, -8>, 5 }
   cylinder { <-400,  25, -8>, <-400,  28, -8>, 6 }
   cylinder { <-400, 150, -8>, <-400, 153, -8>, 6}
   texture { T_BSJern }
}   

#local BSSecondFloorWall=union{
   object { BSFloorLine }   
   object { BSSecondFloorBricks }
#if (ShowDetail = 1)
   object { BSSecondFloorDrain }
   object { BSWindow1 translate <-320, 140, 0> }
   object { BSWindow1 translate <-160, 140, 0> }
   object { BSWindow1 translate <   0, 140, 0> }
   object { BSWindow1 translate < 160, 140, 0> }
#end
   box { <-400, 0, 35>, <240, 250, 40> texture { pigment { Black } } }
}   

/*-------------------- Roof --------------------*/

#local BSChimneyPot=difference {
   cylinder { <0, 0, 0>, <0, 30, 0>, 10 }
   cylinder { <0, 0, 0>, <0, 31, 0>,  9 }
   texture { 
      pigment { gradient y
         color_map{
	         [0.0, 1.001 color VeryDarkBrown
		                  color Black ]
		   }               
      } 
      scale <1, 30, 1>
   }   
}    

#local BSChimney=union {
   box { <0, 0, -40>, <40, 105, 40> texture { T_BSBrick } }
   box { <-2, 105, -42>, <42, 115, 42> texture { T_BSSandstone } }  
   object { BSChimneyPot translate <20, 115, -22> } 
   object { BSChimneyPot translate <20, 115,   0> } 
   object { BSChimneyPot translate <20, 115,  22> } 
}   
                     
#local BSRoofEdge=union{
   box { <-800, 30,   -6>, <800, 40,  32> }
   box { <-800, 40,  -13>, <800, 55,  32> }
   texture { T_BSSandstone } 
}
                     
#local BSRoofDrain=union{              
   difference {
      box { <-410, 10, -20>, <-390, 30, 0> }
      plane { x, 0 rotate <0, 0,  45> translate <-405, 10, 0> }
      plane {-x, 0 rotate <0, 0, -45> translate <-395, 10, 0> }  
      plane { z, 0 rotate <-45, 0, 0> translate <0, 10, -13> }
   }   
   box { <-412, 26, -22>, <-388, 30, 0> }
   cylinder { <-400, 0, -8>, <-400, 30, -8>, 5 }
   cylinder { <-400, 2, -8>, <-400,  5, -8>, 6 }
   texture { T_BSJern }
}   

#local BSRoof=union {
   box { <-400,  0,   0>, <240, 30,  30> texture { T_BSBrick translate <0, -240, 0> }  }
   box { <-400,  0, 670>, <240, 30, 700> texture { T_BSBrick translate <0, -240, 0> } }
#if (ShowDetail = 1)
   object { BSRoofDrain }
#end
   intersection {                           
      object { BSRoofEdge }
      box { <-400, 10, -50>, <240, 70,  40> }
      texture { T_BSSandstone } 
   }
   intersection {                           
      object { BSRoofEdge rotate <0, 180, 0> }
      box { <-400, 10, -50>, <240, 70,  40> }
      translate <0, 0, 668> 
      texture { T_BSSandstone } 
   }
   box { <-400,  0,  30>, <240, 20, 670> texture { T_BSRoofcover } }
   object { BSChimney translate <200, 20, 250> }
}   
   

/*---------------- Entrance ------------------*/

#local BSPortalTop=union{
   box { <-100,  -6, -10>, <100,  0, 0> }
   box { <-100, -11,  -6>, <100, -6, 0> }
   box { <-100, -15,  -2>, <100, -9, 0> }
   texture { T_BSSandstone }
}
      
#local BSPortal=union {
   box { <-73, 175, -2>, <-56, 355, 31> }
   box { < 73, 175, -2>, < 56, 355, 31> }
   difference {
      box { <-73, 355, -2>, <73, 443, 31> }
      cylinder { <0, 355, -10>, <0, 355, 40>, 56 }
   }
   difference {
      object { BSPortalTop }
      plane { x, 0 rotate <0,  45, 0> translate <-73, 0, 0> }                                                 
      plane {-x, 0 rotate <0, -45, 0> translate < 73, 0, 0> }  
      translate <0, 443, -2> 
   }   
   difference {
      object { BSPortalTop }
      plane { x, 0 }                                                 
      plane {-x, 0 rotate <0, -45, 0> translate <2, 0, 0> }
      rotate <0, 90, 0>  
      translate <-73, 443, 0> 
   }   
   difference {
      object { BSPortalTop }
      plane {-x, 0 }                                                 
      plane { x, 0 rotate <0, 45, 0> translate <-2, 0, 0> }
      rotate <0, -90, 0>  
      translate <73, 443, 0> 
   }   
   difference {
      box { <-73, 355, -3>, <73, 428, 0> }
      box { <-67, 354, -6>, <67, 422, 1> }
   }   
   difference {
      cylinder { <0, 355, -3>, <0, 355, 0>, 68 }
      cylinder { <0, 355, -6>, <0, 355, 1>, 62 }
      plane { y, 0 translate <0, 355, 0> }
   }   
   box { <-73, 175, -3>, <-62, 355, 0> }
   box { < 73, 175, -3>, < 62, 355, 0> }
                                                       
   object { BSKeystone scale <1, 19/26, 1> translate <0, 428, 0> }
   texture { T_BSSandstone }
}

#local BSPorch=union{
   box { <-80, 170, 30>, < 80, 175, 130> texture { T_BSSandstone } }
   box { <-50, 174, 40>, < 50, 175.1, 120> texture { pigment { VeryDarkBrown } } }
   box { <-80, 175, 30>, <-60, 440, 130> }
   box { < 80, 175, 30>, < 60, 440, 130> }
   box { <-80, 440, 30>, < 80, 445, 130> texture { T_BSSandstone } }
   difference {
      box { <-80, 175, 130>, < 80, 445, 140> }
      box { <-45, 175, 127>, < 45, 385, 150> }  
      cylinder { <0, 385, 127>, <0, 385, 150>, 45 }
   }                                  
   box { <-80, 175, 150>, < 80, 450, 160> texture { pigment { Black } } }
   object { BSFrontDoor translate <0, 175, 130> }
   texture { T_Stone22 scale 10 }
}

#local BSStep=union {
    box { <-71, 11.5, -1>, <71, 13, 25> }
    box { <-73, 13, -3>, <73, 16.001, 25> }       
    cylinder { <-73, 14.5, -3>, <73, 14.5, -3>, 1.5 }
}    
      
#local BSStepEnd=union {
   cylinder { <0, -1, 0>, <0, 15, 0>, 11 }
   box { <0, -1, -11>, <3, 15, 11> }
   cylinder { <0, 10.5, 0>, <0, 12, 0>, 12 }
   box { <0, 10.5, -12>, <3, 12, 12> }
   cylinder { <0, 12, 0>, <0, 15.001, 0>, 14 }
   torus { 14, 1.5 translate <0, 13.5, 0> }
}   
         
#local BSSteps=difference {
   union {
      #local zpos = -245;
      #local ypos = -1;
      #while (ypos < 170)
         box { <-70, ypos, zpos>, <70, ypos+16, 0> }
         object { BSStep translate <0, ypos, zpos> }
         #local ypos = ypos + 16;
         #local zpos = zpos + 20;
      #end                       
      box { <-71, 170.5, -20>, <71, 172, 30> }
      box { <-73, 172, -20>, <73, 175.001, 30> }    
      object { BSStepEnd translate <-73, 0, -234> }   
      object { BSStepEnd scale <-1, 1, 1> translate < 73, 0, -234> }   
   }
   cylinder { <-80, 80, 0>, <80, 80, 0>, 70 }
   box { <-80, -10, -70>, <80, 80, 1> }
   texture { T_BSSandstone }
}

#local BSBaluster=union {
   cylinder { <0, 0, 0>, <0, 60, 0>, 1.5 }
   cylinder { <0, 0, 0>, <0,  3, 0>, 3 }
   cone { <0, 3, 0>, 3, <0, 5, 0>, 1 }
   sphere { <0, 10, 0>, 3 }
   difference {
      sphere { <0, 0, 0>, 3 scale <1, 8/3, 1> }
      plane { y, 0 }
      plane {-y, 0 translate <0, 2.8204, 0> }
      translate <0, 10, 0>
   }
   difference {
      cylinder { <0, 12.8204, 0>, <0, 47, 0>, 3 }
      torus { 6, 4.5 scale <1, 48.5/4.5, 1> translate <0, 47, 0> }
   }
   sphere { <0, 52, 0>, 3 }
   difference {
      cylinder { <0, 55, 0>, <0, 62, 0>, 2.5 }
      plane {-y, 0 rotate <-38.66, 0, 0> translate <0, 59, 0> }
   }   
}   

#local BSBannister=union {
   #local zpos = -240;
   #local ypos = 15;
   #while (ypos < 180)
      object { BSBaluster translate <0, ypos, zpos> }
      #local ypos = ypos + 16;
      #local zpos = zpos + 20;
   #end
   object { BSBaluster translate <0, 175, -20> }
   cylinder { <0, 230, -20>, <0, 235, -20>, 3 }
   
   cylinder { <0, 235, 0>, <0, 235, -40>, 1.5 scale <2, 1, 1> }
   sphere { <0, 235, -40>, 1.5 scale <2, 1, 1> }
   cylinder { <0, 235, -40>, <0, 67, -250>, 1.5 scale <2, 1, 1> }
   sphere { <0, 67, -250>, 1.5 scale <2, 1, 1> }

   texture { T_BSJern }
}

#local BSStairs=union {
   object { BSSteps }
#if (ShowDetail = 1)
   object { BSBannister translate <-65, 0, 0> }
   object { BSBannister translate < 65, 0, 0> }
#end   
}

#local BSBasementRailing=union{
   box { <-28,  0, -1.5>, <-25, 57, 1.5> }
   box { < 28,  0, -1.5>, < 25, 57, 1.5> }
   box { <-25,  5, -1.5>, < 25,  7, 1.5> }
   box { <-28, 57, -1.5>, < 28, 59, 1.5> }
   difference {
      cylinder { <0, 32, -1>, <0, 32, 1>, 25 }
      cylinder { <0, 32, -2>, <0, 32, 2>, 23 }
   }
   cylinder { <-26,  6, 0>, < 26, 58, 0>, 0.7 }
   cylinder { <-26, 58, 0>, < 26,  6, 0>, 0.7 }
   cylinder { <  0,  6, 0>, <  0, 58, 0>, 0.7 }
   cylinder { <-26, 32, 0>, < 26, 32, 0>, 0.7 }
   cylinder { <-10.7696, 58, 0>, < 10.7696,  6, 0>, 0.7 }
   cylinder { <-10.7696,  6, 0>, < 10.7696, 58, 0>, 0.7 }
   cylinder { <-26, 21.2304, 0>, < 26, 42.7696, 0>, 0.7 }
   cylinder { < 26, 21.2304, 0>, <-26, 42.7696, 0>, 0.7 }
   cylinder { <  0, 32, -1>, <  0, 32, 1>, 5 }
   texture { T_BSJern }
}

#local BSFencePost= box { <-2, 10, -2>, <2, 115, 2> texture { T_BSJern } }

#local BSFenceGate=union{
   box { <3, 20, -2>, <67.5,  22, 2> }
   box { <3, 113, -2>, <67.5, 115, 2> }
   box { <3, 20, -2>, < 5, 115, 2> }
   box { <66, 20, -2>, <67.5, 115, 2> }
   box { <60, 90, -2>, <67.5, 100, 2> }               
   object { BSIronGateHandle rotate <0, 0, 10> translate <65, 97, 0> }
   cylinder { <10, 20, 0>, <10, 115, 0>, 1 }
   cylinder { <20, 20, 0>, <20, 115, 0>, 1 }
   cylinder { <30, 20, 0>, <30, 115, 0>, 1 }
   cylinder { <40, 20, 0>, <40, 115, 0>, 1 }
   cylinder { <50, 20, 0>, <50, 115, 0>, 1 }
   cylinder { <60, 20, 0>, <60, 115, 0>, 1 }   
   cylinder { <2.5, 30, 2.5>, <2.5, 42, 2.5>, 0.8 }
   cylinder { <2.5, 90, 2.5>, <2.5, 105, 2.5>, 0.8 }
   texture { T_BSJern }
}
   
#local BSFenceLeft=union{  
#if (ShowDetail = 1)
   box { < -75, 20, -217>, <-145,  21, -213> }
   box { <-215, 20, -217>, <-400,  21, -213> }
   box { < -75, 99, -217>, <-145, 100, -213> }
   box { <-215, 99, -217>, <-400, 100, -213> }
   object { BSFencePost translate < -75, 0, -215> }
   object { BSFencePost translate <-145, 0, -215> }
   object { BSFencePost translate <-215, 0, -215> }
   object { BSFencePost translate <-285, 0, -215> }
   object { BSFencePost translate <-355, 0, -215> }
   #local xpos =-85;
   #while (xpos > -145)
      cylinder { <xpos, 20, -215>, <xpos, 115, -215>, 1 }
      #local xpos = xpos - 10;
   #end              
   object { BSFenceGate translate <-215, 0, -215> }
   #local xpos =-225;
   #while (xpos > -400)
      cylinder { <xpos, 20, -215>, <xpos, 115, -215>, 1 }
      #local xpos = xpos - 10;
   #end
   object { BSBasementRailing translate <-100, 1, -75> }
#end      
   
   difference {
      box { <-400, -70, -210>, < 70, 1, 0> }
      box { <-135, -15,  -70>, < 60, 5, 1> }
      box { <-115, -30,  -70>, < 60, 5, 1> }
      box { < -95, -45,  -70>, < 60, 5, 1> }
      box { < -75, -60,  -70>, < 60, 5, 1> }
      texture { T_Stone10 } 
   }
   box { <-400, 0, -220>, <-70, 10, -210> texture { T_Stone8 } }
   texture { T_BSJern }
}

#local BSFenceRight=union{
#if (ShowDetail = 1)
   box { <75, 20, -217>, <240,  21, -213> }
   box { <75, 99, -217>, <240, 100, -213> }
   object { BSFencePost translate < 75, 0, -215> }
   object { BSFencePost translate <145, 0, -215> }
   object { BSFencePost translate <215, 0, -215> }
   #local xpos = 85;
   #while (xpos < 240)
      cylinder { <xpos, 20, -215>, <xpos, 115, -215>, 1 }
      #local xpos = xpos + 10;
   #end 
#end
   box { <70, -70, -210>, <240, 1, 0> texture { T_Stone10 } }
   box { <70, 0, -220>, <240, 10, -210> texture { T_Stone8 } }
   texture { T_BSJern }
}

#local BSFenceEnd=union{
   box { <-30, -70, -215>, <0, 1, 0> texture { T_Stone10 } }
   box { <-30, 0, -220>, <-20, 10, 0> texture { T_Stone8 } }
   box { <-20, 0, -220>, <  0, 10, -210> texture { T_Stone8 } }
#if (ShowDetail = 1)
   object { BSFencePost translate <-25, 0, -215> }
   object { BSFencePost translate <-25, 0, -145> }
   object { BSFencePost translate <-25, 0,  -75> }
   object { BSFencePost translate <-25, 0,   -5> }     
   box { <-27, 20, -5>, <-23,  21, -215> }
   box { <-27, 99, -5>, <-23, 100, -215> }
   box { <-25, 20, -217>, <0,  21, -213> }
   box { <-25, 99, -217>, <0, 100, -213> }
   #local zpos = -15;
   #while (zpos > -220)
      cylinder { <-25, 20, zpos>, <-25, 115, zpos>, 1 }
      #local zpos = zpos - 10;
   #end 
   cylinder { <-15, 20, -215>, <-15, 115, -215>, 1 }
   cylinder { < -5, 20, -215>, < -5, 115, -215>, 1 }
#end   
   translate <BWidth, 0, 0> 
   texture { T_BSJern }
}

#local BSFrontWall=union {
   object { BSBasementWall }
   object { BSFirstFloorWall translate <0, 175, 0> }
#if (ShowDetail = 1)
   object { BSPortal }
   object { BSPorch }    
#end
   #local cnt = 2;
   #while (cnt < NoOfFloors)
      object { BSSecondFloorWall translate <0, cnt*250-50, 0> }
      #local cnt = cnt + 1;
   #end   
}

#local BSFront=union{
   object { BSFrontWall }
   object { BSStairs }
   object { BSFenceRight }
   object { BSFenceLeft }
}
     
#local BSBackside=union{
   box { <-400, 0, 700>, <240, 30, 703> texture { T_BSSandstone } }
   box { <-400, 0, 670>, <240, 450, 700> texture { T_BSBrick } }
   box { <-400, 175, 670>, <240, 187.5, 701> texture { T_BSSandstone } }
   #local cnt = 2;
   #while (cnt < NoOfFloors)  
      union{
         box { <-400, 0 670>, <240, 10, 701> texture { T_BSSandstone } }
         box { <-400, 10, 670>, <240, 250, 700> texture { T_BSBrick translate <0, 10, 0> } }
         translate <0, cnt*250-50, 0> 
      }   
      #local cnt = cnt + 1;
   #end   
}

#local BSSegment=union{
   object { BSFront }
   object { BSBackside }
   object { BSRoof translate <0, NoOfFloors*250-50, 0> }
}
   
/*----------------- Ends --------------------*/

#local BSEndCoveringPane=difference {
   box { <0, 0, -3>, <BWidth, 30, 0> }
   plane { y, 0 rotate < 45,   0, 0> translate <  0,  0, -1.5> }
   plane {-y, 0 rotate <-45,   0, 0> translate <  0, 30, -1.5> }
}

#local BSEndLowerPart=union {   

   box { <0, 0, 0>, <BWidth, 450, 700> texture { T_BSBrick translate <BWidth+400, 0, 0> } }
   box { <-3, 0, -3>, <BWidth, 30, 703> }
   box { <-1, 175, -1>, <BWidth, 187.5, 701> }
   object { BSEndCoveringPane translate <0,  30, 0> }
   object { BSEndCoveringPane translate <0,  60, 0> }
   object { BSEndCoveringPane translate <0,  90, 0> }
   object { BSEndCoveringPane translate <0, 120, 0> }
   object { BSEndCoveringPane translate <0, 150, 0> }
   difference {
      cylinder { <-1, 0, 0>, <BWidth, 0, 0>, 12.5 scale <1, 1, 8/12.5> }
      plane { y, 0 }
      plane {-z, 0 }
      translate <0, 175, 0>       
   }
   texture { T_BSSandstone }
}

#local BSEndMidPart=union {
   box { <-1, 0, -1>, <BWidth, 10, 701> texture { T_BSSandstone } }
   box { <0, 10, 0>, <BWidth, 250, 700> texture { T_BSBrick translate <BWidth+400, 10, 0> } }
}

#local BSEndTopPart=union {
   box { <0, 0, 0>, <BWidth, 30, 700> texture { T_BSBrick  translate <BWidth+400, 0, 0>} }
   difference {
      object { BSRoofEdge }
      plane { x, 0 rotate <0,  45, 0> }
      plane {-x, 0 translate < BWidth, 0, 0> }
      texture { T_BSSandstone } 
   }
   difference {
      object { BSRoofEdge }
      plane { x, 0 rotate <0,  45, 0> translate <-350, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0> translate < 350, 0, 0> }
      rotate <0, 90, 0> translate <0, 0, 350>
      texture { T_BSSandstone } 
   }
   difference {
      object { BSRoofEdge rotate <0, 180, 0> }
      plane { x, 0 rotate <0, -45, 0> }
      plane {-x, 0 translate < BWidth, 0, 0> }
      translate <0, 0, 700>
      texture { T_BSSandstone } 
   }
}                             

#local BSEnd=union {
   object { BSEndLowerPart }
   #local cnt = 2;
   #while (cnt < NoOfFloors)
      object { BSEndMidPart translate <0, cnt*250-50, 0> }
      #local cnt = cnt + 1;
   #end   
   object { BSEndTopPart translate <0, NoOfFloors*250-50, 0>  }
}
   
/*---------------- Assembled Brownstone ------------------*/

#declare IR_Brownstone=
union {
   object { BSEnd }
   object { BSFenceEnd }
   #local cnt = 0;
   #while (cnt < NoOfStairs)
      object { BSSegment translate <BWidth + 400 + cnt*640, 0, 0> }
      #declare BSR = int((rand(BSRand) * 3));
      #switch (BSR)
         #case (0)
            object { BSIronGateLeft translate <55, 0, 0> rotate <0, -90, 0> translate <-55.2, 175, 30> translate <BWidth + 400 + cnt*640, 0, 0> }
            object { BSIronGateRight translate <-55, 0, 0> rotate <0, 90, 0> translate <55.2, 175, 30> translate <BWidth + 400 + cnt*640, 0, 0> }
         #break   
         #case (1)
            object { BSIronGateLeft translate <55, 0, 0> rotate <0, -90, 0> translate <-55.2, 175, 30> translate <BWidth + 400 + cnt*640, 0, 0> }
            object { BSIronGateRight translate <-55, 0, 0> rotate <0, 0, 0> translate <55.2, 175, 30> translate <BWidth + 400 + cnt*640, 0, 0> }
         #break   
         #case (2)
            object { BSIronGateLeft translate <55, 0, 0> rotate <0, 0, 0> translate <-55.2, 175, 30> translate <BWidth + 400 + cnt*640, 0, 0> }
            object { BSIronGateRight translate <-55, 0, 0> rotate <0, 0, 0> translate <55.2, 175, 30> translate <BWidth + 400 + cnt*640, 0, 0> }
         #break  
         #else
            object { BSIronGateLeft translate <55, 0, 0> rotate <0, -90, 0> translate <-55.2, 175, 30> translate <BWidth + 400 + cnt*640, 0, 0> }
            object { BSIronGateRight translate <-55, 0, 0> rotate <0, 0, 0> translate <55.2, 175, 30> translate <BWidth + 400 + cnt*640, 0, 0> }
      #end 
      #local cnt = cnt + 1;
   #end  // while loop
   object { BSEnd scale <-1, 1, 1> translate <BWidth*2 - 1.8 + NoOfStairs*640, 0, 0>  }
   object { BSFenceEnd scale <-1, 1, 1> translate <BWidth*2 + NoOfStairs*640, 0, 0>  }

//   #if (BSBboard = 1)
//      object { BSBillboard rotate <0, 90, 0> translate <0, 580, 190> }
//   #end   

} // end brownstone union

/* **************************************************************** */         

