// Persistence of Vision Ray Tracer Scene Description File
// File: BH_Fair.POV  ...formerly fair.pov
// Vers: 3.1g
// Desc: The first image for the Group Image Project 
// Date: 11/9/1999 
// Auth: The Group Image Project
//
// Version Information
//
// 0.3 - 12/22/1999 - In Development by Ray Benjamin
// 0.4 - 12/30/1999 - added South Park Ave and East Park Ave
// 0.5 - 01/08/2000 - paved streets
// 0.6 - 07/31/2000  - revisions and additions by Brendan Hurley:
//                   - added bridges, sidewalks, bldgs on N, S, E & W 

// POV-Ray version
#version 3.1; 

// SCALING ///////////////////////////////////////////////////////////
// 1 cm = 1 baseUnit 
#ifndef(baseUnit) #declare baseUnit = 1; #end 

/////// DO NOT CHANGE ANYTHING BELOW ///////////////////////////////// 
// Metric 
#ifndef (m)  /***meter****/ #local m  = 100 *baseUnit; #end
#ifndef (km) /*kilometer*/  #local km = 1000*m; #end
#ifndef (cm) /*centimeter*/ #local cm = 1.0 *baseUnit; #end 
#ifndef (mm) /*millimeter*/ #local mm = 0.1 *baseUnit; #end 
// English 
#ifndef(in) /*inch*/ #local in = 2.54 *baseUnit; #end 
#ifndef(ft) /*foot*/ #local ft = 12*in*baseUnit; #end 
#ifndef(yd) /*yard*/ #local yd = 3*ft *baseUnit; #end 

//////////////// ==== Standard POV-Ray Includes ==== /////////////////
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "stones.inc"
#include "metals.inc"
#include "woods.inc"

global_settings { assumed_gamma 1.0 }

// Textures supplied by Jaime Vives Piqueres:
#include "jp_textu.inc"

// Variables used to set the dimensions of the Height field
// that is used for the ground:
#declare HF_X  = 0.2*km;
#declare HF_Z  = 0.2*km;
#declare HF_Y  = 5.0*m;

#declare Max_X =  100*m;
#declare Min_X = -100*m;
#declare Max_Z =  100*m;
#declare Min_Z = -100*m;


// ///////////////////////////////////////////////////////////////////
// Stuff to help me place objects and speed test renders:
// ///////////////////////////////////////////////////////////////////

// Detail Control to speed renderings:
#declare DayTime        = 1; // 0 = night, 1 = day

#declare ShowBobs       = 0; // human-sized cylinders to check scale

#declare AllLights      = 0; // 0 = Daytime, 1 = Nighttime
#declare LampPosts      = 0; // 0 = no lampposts, 1 = lampposts 
#declare LampFlag       = 0; // 0 = no lampposts
#declare ShowDetails    = 0; // 0 = no, 1 = yes
#declare ShowDetail     = ShowDetails;

#declare ShowGlass      = 0;
#declare ShowTrees      = 0; // 0 = no, 1 = yes
#declare ShowDirt       = 0; // 0 = no, 1 = yes show HF ground
#declare ShowWater      = 0; // 0 = no, 1 = yes show creek, pond
#declare SimpleWater    = 0;
#declare ShowApartments = 1; // 1 = show brownstones
#declare ShowSky        = 1; // 0 = no sky  1 = yes sky
#declare ShowCobbles    = 0; // 0 = no cobblestone  1= yes
#declare ShowBridge     = 0; // 0 = traffic hazzard, 1 = safe passage

#declare ShowKruseSt      = 1; // 1 = show Kruse St. & Apts
#declare ShowWinSeatAve   = 1; // 1 = show WinSeat Ave & Apts
#declare ShowEastParkAve  = 1; // 1 = show East Ave & Apts
#declare ShowSouthParkAve = 1; // 1 = show South Ave & Apts

#if ( ShowBobs = 1 )
   #include "rb_layout.inc"
   object { Bob  translate < -80*m, 0,   0*m > }
   object { Bob  translate < -80*m, 0,  -5*m > }
   object { Bob  translate < -80*m, 0,   5*m > }
#end

#if ( ShowTrees = 1 )
   #include "rb_trees.inc"
#end

#if ( LampPosts = 1 )
   #include "IR_Lamppost.inc"
#end

#if ( ShowDirt = 1 )
   // include definition for height field and HF texture:
   #include "rb_fairdirt.inc"
   object { Ground  translate -3.5*m*y }   //-2.9*m*y}
#end

#if ( ShowWater = 1 )
   #include "rb_fairwater.inc"
   #declare Water_Level = -0.70*m;
   // The creek is actually all the water in the set:
   object {Creek translate Water_Level*y}
#end

#if ( ShowBridge = 1 ) 
   // Change path to fit your setup:
   #declare FontPath="c:\\POV-Ray\\Fair\\"       
   #declare Water_Level = -0.70*m;
   #include "IR_Roadbridge.inc"
#end

#declare SideWalkWidth = 3*m;
#declare ParkWalkWidth = 2.0*m;
#declare SideWalkThick = 40*cm;
#declare SideWalkLen   = 1*m;
#declare StreetWidth    = 8*m;
#declare StreetThick    = 20*cm;
#declare StreetBlockLen = 10*m;

// Jaime Vives Piqueres' cobblestone street:
#include "jp_streets.inc"

#declare BrownStoneWidth  = 10*m;
#declare BrownStoneHeight = 20*m;
#declare BrownStoneDepth  = 40*m;
#declare BrownStoneGap    = 30*cm;

#declare BlockLength = 6*(BrownStoneWidth+BrownStoneGap);


//////////////////////////////////////////////////////////////////////
// Declare parts:                                                   //
//////////////////////////////////////////////////////////////////////

#include "rb_fairsky.inc"

#include "bh_fairstreets.inc"     //Brendan's revisions of Ray's file

//////////////////////////////////////////////////////////////////////
// Layout Scene:                                                    // 
//////////////////////////////////////////////////////////////////////

plane {y,-10*m pigment {ForestGreen}}


object {Sun translate <40*km, 400*km, -200*km>}
//object {Sun translate <-200*km, 300*km, -20*km>}


// @@@NOTE  comment  out  *BEFORE*  final  render:
//object {Origin_Marker translate <0,0*m,0>} 


// West side of park:
#if (ShowKruseSt)
    object {Kruse_Street}    
    object {North_Canal_West}
    object {South_Canal_West}
#end


// North side of park:
#if (ShowWinSeatAve)    
    object {WinSeat_Ave}
#end    


// East side of park:
#if (ShowEastParkAve)
    object {East_Park_Ave}
    object {North_Canal_East}
    object {South_Canal_East}
#end    


// South side of park:
#if (ShowSouthParkAve)
    object {South_Park_Ave}
#end


// Fountain:
#declare FountainPos = <6.5*m, Water_Level,10*m>;
object {Fountain rotate 10*y translate FountainPos}


// Trees by water's edge:
object {rb_pine translate <-9*m,-1*m,28*m>}
object {rb_pine scale .98 rotate 30*y translate <-12*m,1.1*m,32*m>}
object {rb_pine scale .88 rotate 50*y translate <-13*m,1.1*m,30*m>}
object {rb_pine scale .91 rotate 70*y translate <-10*m,1.1*m,35*m>}



//////////////////////////////////////////////////////////////////////
// Cameras by Brendan:                                              //
//////////////////////////////////////////////////////////////////////

#declare Look_West =                
camera {                               
   direction < 0, 0, 6 >
   location  <  100*m, 12*m, -15*m >   //cnter of park       
   look_at   <  -80*m, 2*m, -15*m > }  //west street bldgs        

#declare Look_East =                
camera {                               
   direction < 0, 0, 3 >
   location  < -200*m, 10*m, -40*m >   //cnter of park       
   look_at   <  200*m, 10*m, -40*m > } //east street bldgs        

#declare Look_North =
camera {                               
   direction < 0, 0, 7 >
   location  < -65*m, 3*m, -80*m >     //S of north st.       
   look_at   < -65*m, 3*m, 100*m > }   

#declare Look_South =
camera {                               
   direction < 0, 0, 2 >
   location  < 0*m, 20*m,  300*m >     //N of South St.       
   look_at   < 0*m,  5*m, -100*m > }   

#declare Look_WestCanal =
camera {                               
   direction < 0, 0, 9 >
   location  < -80*m, 420*m, -50*m >   // above west canal       
   look_at   < -80*m,  0*m,  -50*m > } 

#declare Look_EastCanal =
camera {                               
   direction < 0, 0, 5 >
   location  < 70*m, 420*m, -75*m >    //above east canal streets
   look_at   < 70*m,   0*m, -75*m > }

#declare Look_Central =
camera {                               
   direction < 0, 0, 2 >
   location  < -200*m, 200*m, -200*m > //S of centr       
   look_at   < 0*m,  0*m,   0*m > }   

#declare Look_Down =         // master overhead shot:
camera {                               
   direction < 0, 0, 2 >
   location  < 0*m, 420*m, 0*m >       //way above cnter of park       
   look_at   < 0*m,   0*m, 0*m > }     //cntr of park

//camera { Look_North }
//camera { Look_South }
//camera { Look_West }
//camera { Look_East }
camera { Look_Down }
//camera { Look_EastCanal }
//camera { Look_WestCanal }
//camera { Look_Central }


// ///////////////////////////////////////////////////////////////////
/*     >>>>  specific views:  <<<<
#declare Look_North =        // bh_fair002 & 002x:
camera {                               
   direction < 0, 0, 3 >
   location  < -30*m, 10*m, -80*m >    //SW of north st.       
   look_at   < -76*m, 5*m,  -20*m > }   // n along west st.

#declare Look_Down =
camera {                               
   direction < 0, 0, 4 >
   location  < 80*m, 420*m, 53*m >     //above N & E Streets intersection       
   look_at   < 80*m,   0*m, 53*m > }     

// ///////////////////////////////////////////////////////////////////
// Cameras by Ray:
// ///////////////////////////////////////////////////////////////////
// Origin Check 
//camera { location 0 look_at <0,0,1> rotate -40*y translate <5*m,2*m,-3*m> }

// Overhead Cam
//camera { location 0 look_at <0,-1,0> rotate 0*y angle 50 translate < 0, 500*m, 0> }

//camera { location 0 look_at <0,-1,0> rotate 0*y angle 50 translate <0.1,290*m,0.1> }

//  Pond Cam - Overhead
//camera { location 0 look_at <0,-1,0> rotate 0*y angle 50 translate FountainPos translate 350*m*y }

// Orthographic Cam
//camera { orthographic location <0,290*m,0> look_at <0,0,0>}
//camera { up <0,0,1> right <1,0,0> location <0.01,0.2*km,0.01> direction <0,-1,0> orthographic angle 90}

// Look at NW Corner
//camera { location <0,0,0> look_at <0,0,1> rotate <0,-20,0> angle 70 translate <-49*m,2*m,65*m>}

// Kruse Street (West) Layout Cam
//camera { location 0 look_at <0,0,1> rotate 0*y angle 70 translate <-63*m,5*m,-10*m> }// rb's view
//camera { location 0 look_at <0,0,1> rotate 0*y angle 70 translate <-63*m,85*m,-80*m> }//bh's view

// Look at Kruse Street from Fountain Area
//camera { location 0 look_at <0,0,1> rotate -90*y angle 50 translate <17*m,2.5*m,-20*m> }
//camera { location 0 look_at <0,0,1> rotate -90*y angle 50 translate <157*m,155.5*m,-20*m> }

// WinSeat Drive (North) Layout Cam
//camera { location 0 look_at <0,0,1> rotate <0,-90,0> angle 70 translate <-3*m,7*m,70*m> }
//camera { location 0 look_at <0,0,1> rotate <3,0,0> angle 70 translate <-70*m+StreetBlockLen*13,3*m,60*m> }

// Fountain Cam - maybe
//camera { location 0 look_at <0,0,1> rotate -43*y angle 70 translate <19*m,Water_Level+1.5*m,-2*m> }

// Grass Cam
//camera { location 0 look_at <0,0,1> rotate 60*y angle 50 translate <17*m,5*m,-20*m> }

// Canal West Cam
//camera { location 0 look_at <0,0,1> rotate -90*y angle 70 translate <-55*m,5*m,-12*m> }
// construction cam - from south
//camera { location 0 look_at <0,0,1> rotate 0*y angle 70 translate <-90*m+StreetBlockLen*1,3*m,-35*m> }

// Canal East Cam
//camera { location 0 look_at <0,0,1> rotate 90*y angle 70 translate <50*m,5*m,40*m> }
// Construction cam - from south
//camera { location 0 look_at <0,0,1> rotate 0*y angle 70 translate <95*m-StreetBlockLen*0,3*m,20*m> }

// West Street Cam
//camera { location 0 look_at <0,0,1> rotate -90*y angle 70 translate <-54*m,3*m,-90*m+StreetBlockLen*19> }
//camera { location 0 look_at <0,0,1> rotate <20,-90,0> angle 70 translate <-67*m,5*m,-90*m+StreetBlockLen*17> }

// South Street Cam
// from north side
//camera { location 0 look_at <0,0,1> rotate -180*y angle 70 translate <-67*m,5*m,-60*m> }
// from south side
//camera { location 0 look_at <0,0,1> rotate <0,0,0> angle 70 translate <-75*m+StreetBlockLen*.5,2*m,-82*m> }

// East Street Cam
//camera { location 0 look_at <0,0,1> rotate 90*y angle 70 translate <57*m,3*m,-82*m+StreetBlockLen*17> }

// Final Cam - maybe
//camera { location 0 look_at <0,0,1> rotate -20*y angle 50 translate <17*m,2.5*m,-20*m> }


//////////////////////////////////////////////////////////////////////
//   END OF FILE                                                    //
//   Versions 1.0 thru 1.5: 11/09/1999 by Ray Benjamin              //
//   Version  1.6         : 07/31/2000 by Brendan Hurley            //
//////////////////////////////////////////////////////////////////////

