// Persistence of Vision Ray Tracer Scene Description File
// File: BH_FairStreets.INC  ...formerly rb_fairstreets.inc
// Vers: 3.1g
// Desc: Include file that describes the streets for fair.pov 
// Date: 12/8/1999 
// Auth: Ray Benjamin
// Revision Date: July-Aug 2000
// Revised by: Brendan Hurley
//
// 0.1 - 12/30/1999 - Ray blocked out basic street design based on Ib's suggestions
// 0.2 - 07/26/2000 - Brendan positioned bldgs, added sidewalks & bridges

// ///////////////////////////////////////////////////////////////////

#include "metals.inc"
#include "pointSellips.inc"

// ///////////////////////////////////////////////////////////////////
//  Declare street and sidewalk parts: ///////////////////////////////
// ///////////////////////////////////////////////////////////////////

#declare Rstreets = seed(8383);

#declare T_SideWalk = texture {
    pigment {
        gradient y
        color_map {
            [0.0 Black]
            [1.0 Gray70]
            }
        }
    scale 1*m
    }
    
#declare T_Street = texture {
    pigment {
        gradient y
        color_map {
            [0.0 Gray70]
            [0.1 Gray70]
            [0.95 Tan]
            [0.99 Tan]
            [1.0 Gray70]
            }
        }
    scale 1*m
    }

// /////////////////////////////////////
// Standard Street Slab:
#declare StreetSlab =
union {
    box {<0,-1*m,0>, <StreetWidth,8*cm,StreetBlockLen>
        texture {T_Street}
        }
    #local part = union {
        object {cobble}
        object {cobble translate <cobble_X*1,0,0>}
        object {cobble translate <cobble_X*2,0,0>}
        }
    object { part translate z*cobble_Z }
    object { part translate z*cobble_Z * 2 }
    object { part translate z*cobble_Z * 3 }
      } // end street slab

// /////////////////////////////////////
#declare T_Curb = 
    texture {
        pigment {Yellow}
        normal {wrinkles}
        finish {Dull}
        scale <5,5,20>
        }
    texture {t_dirty}

#declare T_CurbBase = 
    texture {
        pigment {Gray80}
        normal {bumps}
        finish {Dull}
        }
    texture {t_dirty}    

// /////////////////////////////////////
#declare curb_X = 25*cm;
#declare curb_Y = 25*cm;
#declare curb_Z = 1*m;

#declare CurbStone = union {
    object {
        pointSellips(0.25, 0.25, <0,0,0>, <curb_X,curb_Y,curb_Z>)
        texture {T_Curb}
        }
    box {<0,0,0>, <curb_X,-1*m,curb_Z> texture {T_CurbBase}}    
    }

// /////////////////////////////////////
#declare CurbBlock = union {
    #local ct = 0;
    #while (ct < 10)
        #local jitx = 1 - rand(Rstreets);
        #local jity = 1 - rand(Rstreets);
        #local jitz = 1 - rand(Rstreets); 
        object {CurbStone rotate <jitx,jity,jitz> translate curb_Z*ct*z}        
        #local ct = ct + 1;
    #end
    }

// /////////////////////////////////////
#declare CurbSlab_A =        //street w/ both curbs:
union {
    #local Y_Offset = 10*cm;
    object { CurbBlock  translate < -curb_X, Y_Offset, 0 > }
    object { StreetSlab }
    object { CurbBlock  translate < StreetWidth, Y_Offset, 0 > }
      } // end curb slab A

// /////////////////////////////////////
#declare CurbSlab_B =        //street w/ only one curb: for intersections:
union {
    #local Y_Offset = 10*cm;
//    object { CurbBlock translate <-curb_X,Y_Offset,0>}
    object { StreetSlab }
    object { CurbBlock  translate < StreetWidth, Y_Offset, 0 > }
      } // end curb slab B

// /////////////////////////////////////
#declare SideWalkSlab = 
union {
    object {sidew translate 0*m*z}
    object {sidew translate 1*m*z}
    object {sidew translate 2*m*z}
    object {sidew translate 3*m*z}
    object {sidew translate 4*m*z}
    object {sidew translate 5*m*z}
    object {sidew translate 6*m*z}
    object {sidew translate 7*m*z}
    object {sidew translate 8*m*z}
    object {sidew translate 9*m*z}
    translate 10*cm*y
      } // end side walk slab

// /////////////////////////////////////
#declare StreetSection_A =   //both sidewalks & curbs
union {
    object { SideWalkSlab translate (-curb_X-1*m)*x }
    object { CurbSlab_A }
    object { SideWalkSlab translate ( curb_X+StreetWidth)*x }
      } // end street section inion

// /////////////////////////////////////
#declare StreetSection_B =   //one sidewalk/curb only: for intersections:
union {
//    object { SideWalkSlab translate (-curb_X-1*m)*x }
    object { CurbSlab_B }
    object { SideWalkSlab translate ( curb_X+StreetWidth)*x }
      } // end street section inion

// /////////////////////////////////////
#macro makeSlab(slen)
    object { StreetSlab clipped_by { plane {z,slen}}}
#end


// ///////////////////////////////////////////////////////////////////
//  Declare Whole Streets & Buildings ////////////////////////////////
// ///////////////////////////////////////////////////////////////////

#declare WestStreet_X = -80*m;
#declare EastStreet_X =  68*m;
#declare Canal_West_Z =  -1*m;
#declare Canal_East_Z =  58.8*m;


// West Street ///////////////////////////////////////////////////////
#declare Kruse_Street = 
union {
    #local WestStLen = Max_Z + (-Min_Z);
    #local Xoffset = WestStreet_X;
    #local Yoffset = 1.2*m;
    #local Zoffset = Min_Z;

    //street,curbs,sidewalks:
    object { StreetSection_A  translate < 0, 0, 0 > } //south end
    object { StreetSection_A  translate <0,0,StreetBlockLen*1>}
    //intersection w/ South St:
    object { StreetSection_B
             rotate y*180
             translate <(curb_X+StreetWidth-(5*m)),0,StreetBlockLen*3>}
    object { StreetSection_A  translate <0,0,StreetBlockLen*3>}
    object { StreetSection_A  translate <0,0,StreetBlockLen*4>}
    object { StreetSection_A  translate <0,0,StreetBlockLen*5>}
    object { StreetSection_A  translate <0,0,StreetBlockLen*6>}
    object { StreetSection_B  translate <0,0,StreetBlockLen*7>}//
    object { StreetSection_A  translate <0,0,StreetBlockLen*8>}//bridge 
    object { StreetSection_B  translate <0,0,StreetBlockLen*9>}//
    object { StreetSection_A  translate <0,0,StreetBlockLen*10>}
    object { StreetSection_A  translate <0,0,StreetBlockLen*11>}
    object { StreetSection_A  translate <0,0,StreetBlockLen*12>}
    object { StreetSection_A  translate <0,0,StreetBlockLen*13>}
    object { StreetSection_A  translate <0,0,StreetBlockLen*14>}
    object { StreetSection_A  translate <0,0,StreetBlockLen*15>}
    object { StreetSection_A  translate <0,0,StreetBlockLen*16>}
    //intersection w/ WinSeat Ave:
    object { StreetSection_B
             rotate y*180
             translate <(curb_X+StreetWidth),0,StreetBlockLen*18>}
    object { StreetSection_A  translate <0,0,StreetBlockLen*18>}
    object { StreetSection_A  translate <0,0,StreetBlockLen*19>}//north end

    //buildings:
    #if ( ShowApartments )             //Brendan Hurley's brownstones:
       #include "bh_brown00.inc"
       object {
          BH_Make_Building ( 0, 25*ft, 9 )
          rotate y*-90
          translate  < -13.7*m, 0*m, 104.49*m >
              } // end brownstone apts
       object {
          BH_Courtyard_Building ( 4 )
          rotate y*-90
          scale < 1*ft, 1*ft, 1*ft >
          translate < -15.2*m, 0*m, 55.5*m >
              } // end courtyard apts
    #end // if show apts   

    //bridge over rendered waters:
    #if ( ShowBridge )                 //Ib Rasmussen's bridge:
    object { 
       IR_RoadBridge ( 20*m, 12*m, 11*m, 0*m, Water_Level )
       rotate 90*y
       translate < 4*m, 0*m, 84*m >
           } // end bridge over road
    #end // show bridge

    //move whole street & stuff:
    translate < Xoffset, Yoffset, Zoffset >
      } // end west street union


// West Canal Streets: ///////////////////////////////////////////////
#local Canal_West_X = Min_X+0.001;
#local Canal_West_Len = -(Min_X - WestStreet_X);

#declare North_Canal_West = 
union {
    #local Xoffset = Canal_West_X;
    #local Yoffset = 1.2*m;
    #local Zoffset = Canal_West_Z;
    object { StreetSection_A }
    object { StreetSection_A  translate StreetBlockLen*1*z }
    rotate 90*y // make east/west    
    translate < Xoffset, Yoffset, Zoffset >
      }//end north west canal street

#declare South_Canal_West = 
union {
    #local Xoffset = Canal_West_X;
    #local Yoffset = 1.2*m;
    #local Zoffset = Canal_West_Z-20*m;  //rb
    object { StreetSection_A }
    object { StreetSection_A  translate StreetBlockLen*1*z }
    rotate 90*y // make east/west    
    translate < Xoffset, Yoffset, Zoffset >
      }//end S canal west 


// North Street //////////////////////////////////////////////////////
#declare WinSeat_Ave = 
union {                                
    #local NorthStLen = EastStreet_X - WestStreet_X - StreetWidth;
    #local Xoffset = WestStreet_X + StreetWidth;
    #local Yoffset = 1.2*m;
    #local Zoffset = 79*m;

    //street,curbs,sidewalks:
    object { StreetSection_A  translate <0, 0, 0> }  //west end
    object { StreetSection_A  translate <0,    0, StreetBlockLen*1> }
    object { StreetSection_A
                 rotate -1*x  translate <0,    0, StreetBlockLen*2> }
    object { StreetSection_A  translate <0,16*cm, StreetBlockLen*3> }
    object { StreetSection_A  translate <0,16*cm, StreetBlockLen*4> }
    object { StreetSection_A  translate <0,16*cm, StreetBlockLen*5> }
    object { StreetSection_A  translate <0,16*cm, StreetBlockLen*6> }
    object { StreetSection_A  translate <0,16*cm, StreetBlockLen*7> } 
    object { StreetSection_A  translate <0,16*cm, StreetBlockLen*8> }
    object { StreetSection_A  translate <0,16*cm, StreetBlockLen*9> }
    object { StreetSection_A  translate <0,16*cm, StreetBlockLen*10>}
    object { StreetSection_A  translate <0,16*cm, StreetBlockLen*11>}
    object { StreetSection_A  translate <0,16*cm, StreetBlockLen*12>}
    object { StreetSection_A  
               rotate -0.5*x  translate <0,16*cm, StreetBlockLen*13>} //east end

    //buildings:
    #if (ShowApartments)
       object {                        //Ib Rasmussen's brownstone:
          #local NoOfStairs = 7;
          #local NoOfFoors = 4;
          #include "IR_Brownst.inc"
          object {IR_Brownstone rotate -90*y}
          scale < 1*in, 1*in*0.8, 1*in > 
          translate <-(2*SideWalkWidth+80*cm),-7*cm,0>
              } // end obj Ib's bldg
       object {                        //Brendan Hurley's Brownstone:
          #include "bh_brown00.inc"
          object {
             BH_Make_Building ( 0, 25*ft, 3 )
             rotate -90*y
             translate  < -12*m, 0*m, 118.5*m >
                 } // end Brendan's bldg 
              } // end obj make bldg.
    #end  //if show apts.

    //move whole street & stuff:
    rotate 90*y
    translate < Xoffset, Yoffset, Zoffset >
    } // end union north street & bldgs
    

// East Street ///////////////////////////////////////////////////////
#declare East_Park_Ave =
union {
    #local EastParkAveLen = Max_Z + (-Min_Z);
    #local Xoffset = EastStreet_X;
    #local Yoffset = 1.2*m;
    #local Zoffset = Min_Z;

    //street,curbs,sidewalks:
    object { StreetSection_A } // south end
    object { StreetSection_A translate <0,0,StreetBlockLen*1>}
    //intersection w/ South St:
    object { StreetSection_B translate <0,0,StreetBlockLen*2>}
    object { StreetSection_A  rotate -1*x translate <0,0,StreetBlockLen*3>}
    object { StreetSection_A  translate <0,16*cm,StreetBlockLen*4>}
    object { StreetSection_A  translate <0,16*cm,StreetBlockLen*5>}
    object { StreetSection_A  translate <0,16*cm,StreetBlockLen*6>}
    object { StreetSection_A  translate <0,16*cm,StreetBlockLen*7>}
    object { StreetSection_A  rotate -1*x translate <0,16*cm,StreetBlockLen*8>}
    object { StreetSection_A  translate <0,32*cm,StreetBlockLen*9>}
    object { StreetSection_A  translate <0,32*cm,StreetBlockLen*10>}
    object { StreetSection_A  translate <0,32*cm,StreetBlockLen*11>}
    object { StreetSection_A  translate <0,32*cm,StreetBlockLen*12>}
    //south canal intersection:
    object { StreetSection_B
             rotate y*180
             translate <(StreetWidth),32*cm,StreetBlockLen*14>}
    object { StreetSection_A  translate <0,32*cm,StreetBlockLen*14>}
    //north canal intersection:
    object { StreetSection_B
             rotate y*180
             translate <(StreetWidth),32*cm,StreetBlockLen*16>}
    object { StreetSection_A  translate <0,32*cm,StreetBlockLen*16>}
    //intersection w/ WinSeat Ave:
    object { StreetSection_B  translate <0,32*cm,StreetBlockLen*17>}
    object { StreetSection_A  translate <0,32*cm,StreetBlockLen*18>}
    object { StreetSection_A  translate <0,16*cm,StreetBlockLen*19>} //north end

    //buildings:
    #if (ShowApartments)
       object {              // Brendan Hurley's Brownstone:
          #local FlatRoof = true;
          #local ShowBalcony = false;
          #include "bh_brown00.inc"
          object {
             BH_Make_Building ( 0, 25*ft, 13 )
             rotate -90*y
             translate  < 23*m, 0*m, 33.5*m >
                 }//end macro obj
              } // end Brendan's bldg 
    #end  // of If Show Apts   

    //bridge over rendered waters:
    #if ( ShowBridge )                 //Ib Rasmussen's bridge:
    object { 
       IR_RoadBridge ( 18*m, 9.5*m, 11*m, 0*m, Water_Level )
       rotate 90*y
       translate < 4*m, 0*m, 144.7*m >
           } // end bridge over road
    #end // show bridge

    //move whole street & stuff:
    translate < Xoffset, Yoffset, Zoffset >
      } // end east street & bldgs


// East Canal Streets: ///////////////////////////////////////////////
#local Canal_East_Len = (Max_X - EastStreet_X) - StreetWidth;
#local Canal_East_X = EastStreet_X + StreetWidth;

#declare North_Canal_East = 
union {
    #local Xoffset = Canal_East_X;
    #local Yoffset = 1.2*m;
    #local Zoffset = Canal_East_Z;
    object { StreetSection_A }
    object { StreetSection_A translate StreetBlockLen*1*z}
    object { StreetSection_A translate StreetBlockLen*2*z}
    rotate 90*y // make east/west    
    translate <Xoffset,Yoffset,Zoffset>
    } 

#declare South_Canal_East = 
union {
    #local Xoffset = Canal_East_X;
    #local Yoffset = 1.2*m;
    #local Zoffset = Canal_East_Z - 20*m;
    object { StreetSection_A }
    object { StreetSection_A translate StreetBlockLen*1*z}
    object { StreetSection_A translate StreetBlockLen*2*z}
    rotate 90*y // make east/west    
    translate <Xoffset,Yoffset,Zoffset>
    } 


// South Street //////////////////////////////////////////////////////
#declare South_Park_Ave = 
union {
    #local SouthParkAveLen = EastStreet_X - WestStreet_X - StreetWidth;
    #local Xoffset = WestStreet_X + StreetWidth;
    #local Yoffset = 1.2*m;
    #local Zoffset = -70*m;

    //streets, curbs, sidewalks:
    object { StreetSection_A  }
    object { StreetSection_A translate <0,0,StreetBlockLen*1>}
    object { StreetSection_A translate <0,0,StreetBlockLen*2>}
    object { StreetSection_A translate <0,0,StreetBlockLen*3>}
    object { StreetSection_A translate <0,0,StreetBlockLen*4>}
    object { StreetSection_A translate <0,0,StreetBlockLen*5>}
    object { StreetSection_A translate <0,0,StreetBlockLen*6>}
    object { StreetSection_A translate <0,0,StreetBlockLen*7>}
    object { StreetSection_A translate <0,0,StreetBlockLen*8>}
    object { StreetSection_A translate <0,0,StreetBlockLen*9>}
    object { StreetSection_A translate <0,0,StreetBlockLen*10>}
    object { StreetSection_A translate <0,0,StreetBlockLen*11>}
    object { StreetSection_A translate <0,0,StreetBlockLen*12>}
    object { StreetSection_A translate <0,0,StreetBlockLen*13>}

    //buildings:
    #if (ShowApartments)
       object {                        //Ib Rasmussen's brownstone:
          #local NoOfStairs = 8;
          #local NoOfFoors = 4;
          #include "IR_Brownst.inc"
          object { IR_Brownstone  rotate y*90 }
          scale < 1*in, 1*in*0.8, 1*in > 
          translate < 14.8*m, 0*m, 135*m >
              } // end obj Ib's bldg
    #end  //if show apts.

    //move whole street & stuff:
    rotate 90*y // make east/west    
    translate <Xoffset,Yoffset,Zoffset>
    } 


// ///////////////////////////////////////////////////////////////////
// ///////////////////////////////////////////////////////////////////
