// *******************************************************************
// BH_BROWN00.INC         for POV WIN 3.1g        Ver 1.0 Jan-May 2000
//         Definitions for a basic, user configurable building
// for IRTC GROUP IMAGE PROJECT                      "The Street Fair"
// *******************************************************************

// *******************************************************************
// I.    DEFINE Includes, Constants and Conditionals:
// *******************************************************************
//
// Persistence of Vision Ray Tracer Include File
// Part of the IRTC GIP object archives
// Version: 3.1g for Windows95
// Author: Brendan Hurley
// E-mail: mbhcgc@saber.net
// Web page: www.geocities.com/mbrendanh/
// Date (yyyy.mm.dd): 2000.04.17
//
// **************************************************************
// Object #1: BH_Brownstone
// Object Description: a multi-story brownstone-style apartment building
//                     with a macro to render a block Nbr_Units wide
// Origin: left front corner
// Orientation: front of building faces south
// Dimensions: one building = 25x  40y  80z
//           : one block = (Nbr_Units*25)x 40y 80z
// **************************************************************
// Object #2: BH_Courtyard
// Object Description: a macro to render a multi-story brownstone-style 
//                     apartment building, U-shaped around a courtyard
// Origin: left front corner
// Orientation: front of building faces south
// Dimensions: one building = 90x  (10*Nbr_Storeys)y  60z
//
// Includes required: colors, shapes, textures, stones, woods, skies
//    >>>> and 13_col.inc and 13_col.col  included in this .ZIP
// *******************************************************************


// Scaling //////////////////////////////////////////////////////

// 1 cm = 1 baseUnit
#ifndef ( baseUnit )
   #declare baseUnit = 1;
#end

// Metric
#ifndef (m) #local  m = 100 *baseUnit; #end
#ifndef(cm) #local cm = 1.0 *baseUnit; #end
#ifndef(mm) #local mm = 0.1 *baseUnit; #end
// English
#ifndef(in) #local in = 2.54 *baseUnit; #end 
#ifndef(ft) #local ft = 12*in*baseUnit; #end 
#ifndef(yd) #local yd = 3*ft *baseUnit; #end 

//global_settings{ assumed_gamma 1 }

#version 3.1; 

// *******************************************************************

// **********     GLOBAL DECLARES:     **********
#ifndef ( ShowDetails )
   #declare ShowDetails = yes;
//   #declare ShowDetails = no;          
#end

#ifndef ( ShowGlass )
   #declare ShowGlass = yes;
//   #declare ShowGlass = no;          
#end

// **********     LOCAL DECLARES:     **********
#ifndef ( PlainDoor )
//   #declare PlainDoor = yes;
   #declare PlainDoor = no;          
#end
 
#ifndef ( ShowBalcony )
   #declare ShowBalcony = yes;
//   #declare ShowBalcony = no;          
#end

#ifndef ( FlatRoof )
//   #declare FlatRoof = yes;
   #declare FlatRoof = no;          
#end

#ifndef ( ShowColumns )                //engages 13_col.inc
   #declare ShowColumns = yes;
//   #declare ShowColumns = no;
#end

#ifndef ( GridOn )                     //engages graph paper
//   #declare GridOn = yes;
   #declare Gridon = no;
#end

// *******************************************************************

#ifdef ( Colors_Inc_Temp )
   // do nothing
#else
   #include "colors.inc"
#end

#ifdef ( Shapes_Inc_Temp )
   // do nothing again
#else
   #include "shapes.inc"
#end

#ifdef ( Textures_Inc_Temp )
   // do nothing
#else
   #include "textures.inc"
#end

#ifdef ( Stones_Inc_Temp )
   // do nothing
#else
   #include "stones.inc"
#end

#ifdef ( Woods_Inc_Temp )
   // do nothing
#else
   #include "woods.inc"
#end

// *******************************************************************
//       A. Plain Textures: for low detail test renders:
// *******************************************************************
 
//    DEFINE  flat latex paint finish:
#declare PlainFinish =
finish { ambient 0.3
         diffuse 0.3
         specular 0.4
         roughness 0.01 }

// *************************************
#declare Red_Tex =
texture { pigment { Red  quick_color Red }
          finish { PlainFinish } }

// *************************************
#declare Blue_Tex =
texture { pigment { Blue  quick_color Blue }
          finish { PlainFinish } }

// *************************************
#declare Green_Tex =
texture { pigment { Green  quick_color Green }
          finish { PlainFinish } }

// *************************************
#declare Yellow_Tex =
texture { pigment { Yellow  quick_color Yellow }
          finish { PlainFinish } }

// *************************************
#declare Orange_Tex =
texture { pigment { Orange  quick_color Orange }
          finish { PlainFinish } }

// *************************************
#declare Magenta_Tex =
texture { pigment { Magenta  quick_color Magenta }
          finish { PlainFinish } }

// *************************************
#declare GreenYellow_Tex =
texture { pigment { GreenYellow  quick_color GreenYellow }
          finish { PlainFinish } }

// *************************************
#declare LB_Tex =
texture { pigment { LightBlue  quick_color LightBlue }
          finish { PlainFinish } }

// *************************************
#declare Violet_Tex =
texture { pigment { Violet  quick_color Violet }
          finish { PlainFinish } }

// *************************************
#declare Goldenrod_Tex =
texture { pigment { Goldenrod  quick_color Goldenrod }
          finish { PlainFinish } }

// *************************************
#declare Coral_Tex =
texture { pigment { Coral  quick_color Coral }
          finish { PlainFinish } }

// *************************************
#declare Orchid_Tex =
texture { pigment { Orchid  quick_color Orchid }
          finish { PlainFinish } }

// *************************************
#declare Gold_Tex =
texture { pigment { Gold  quick_color Gold }
          finish { PlainFinish } }

// *************************************
#declare Tan_Tex =
texture { pigment { Tan  quick_color Tan }
          finish { PlainFinish } }

// *************************************
#declare Brown_Tex =
texture { pigment { Brown  quick_color Brown }
          finish { PlainFinish } }

// *************************************
#declare White_Tex =
texture { pigment { White  quick_color White }
          finish { PlainFinish } }

// *************************************
#declare Black_Tex =
texture { pigment { Black  quick_color Black }
          finish { PlainFinish } }

// *************************************
#declare Gray_Tex =
texture { pigment { Gray  quick_color Gray }
          finish { PlainFinish } }

// *************************************
#declare Gray25_Tex =                  // dark
texture { pigment { Gray25  quick_color Gray25 }
          finish { PlainFinish } }

// *************************************
#declare Gray50_Tex =
texture { pigment { Gray50  quick_color Gray50 }
          finish { PlainFinish } }

// *************************************
#declare Gray75_Tex =
texture { pigment { Gray75  quick_color Gray75 }
          finish { PlainFinish } }

// *************************************
#declare Gray95_Tex =                  // light
texture { pigment { Gray95  quick_color Gray95 }
          finish { PlainFinish } }


// *******************************************************************
//       B. Define Elementary Objects:
// *******************************************************************

#declare Arch_Z1 =                     // 0.3 thick
difference {
   object { Disk_Z  scale < 1.0, 1.0, 1.0 > } 
   object { Disk_Z  scale < 0.8, 0.8, 1.1 > }
   clipped_by { plane { -y, 0.0  hollow on } }
           } // end Arch_Z 1

// **************************************************************

#declare Arch_Z2 =                     // 0.05 thick
difference {
   object { Disk_Z  scale <  1.0,  1.0, 1.0 > }
   object { Disk_Z  scale < 0.95, 0.95, 1.1 > }
   clipped_by { plane { -y, 0.0  hollow on } }
           } // end Arch_Z 2

// **************************************************************

//    DEFINE  a semi-circle: straight edge down:
#declare Semi_Circle_1 =
object {
   Disk_Z
   clipped_by { plane { -y, 0.0  hollow on }
                scale <2,1,1> }
       } // end semi circle

// **************************************************************

//    DEFINE  an horizontially clipped torus:
#declare MBH_Torus_1 =
torus { 1.00,      // MAJOR = radius of whole ring
        0.125      // MINOR = radius of tube
        clipped_by { plane { z, 0.0  hollow on } }
          }// end generictorus

// **************************************************************

//    DEFINE  1x 0.5y 0.5z unit cylinders in each axis, flat-ended:
#declare PostX1 =
object { Disk_X  scale < 0.50, 0.25, 0.25 > } 

#declare PostY1 =
object { Disk_Y  scale < 0.25, 0.50, 0.25 > } 

#declare PostZ1 =
object { Disk_Z  scale < 0.25, 0.25, 0.50 > } 

// **************************************************************

//    DEFINE  1x 0.5y 0.5z  unit boxes in each axis: 
#declare CubeX1 =
box { < -0.50, -0.25, -0.25 > < 0.50, 0.25, 0.25 > }

#declare CubeY1 =
box { < -0.25, -0.50, -0.25 > < 0.25, 0.50, 0.25 > }

#declare CubeZ1 =
box { < -0.25, -0.25, -0.50 > < 0.25, 0.25, 0.50 > }

// **************************************************************

//    DEFINE  10x 0.5y 0.5z  unit rods in each axis:                 
#declare XRod =
object { PostX1  scale < 10, 0.25, 0.25 > }

#declare YRod =
object { PostY1  scale < 0.25, 10, 0.25 > }

#declare ZRod =
object { PostZ1  scale < 0.25, 0.25, 10 > }

// **************************************************************

//    DEFINE  a 3-axis grid marker: each bar = 10 units end to end
#declare Mark01 =
union {
   object { XRod  texture { Red_Tex } }
   object { YRod  texture { Green_Tex } }
   object { ZRod  texture { Blue_Tex } }
      } // end Marker 1

// **************************************************************

//    DEFINE  a horizontal grid: 10x 10z:
#declare Grid10XZ =
union {
   object { XRod }
   object { XRod  translate z*1 }
   object { XRod  translate z*2 }
   object { XRod  translate z*3 }
   object { XRod  translate z*4 }
   object { XRod  translate z*5 }
   object { XRod  translate z*-1 }
   object { XRod  translate z*-2 }
   object { XRod  translate z*-3 }
   object { XRod  translate z*-4 }
   object { XRod  translate z*-5 }
   object { ZRod }
   object { ZRod  translate x*1 }
   object { ZRod  translate x*2 }
   object { ZRod  translate x*3 }
   object { ZRod  translate x*4 }
   object { ZRod  translate x*5 }
   object { ZRod  translate x*-1 }
   object { ZRod  translate x*-2 }
   object { ZRod  translate x*-3 }
   object { ZRod  translate x*-4 }
   object { ZRod  translate x*-5 }
   texture { Black_Tex }
      } // end grid 10x 10z

// **************************************************************

//   DEFINE  a vertical grid: 10x 10y:
#declare Grid10XY =
union {
   object { XRod }
   object { XRod  translate y*1 }
   object { XRod  translate y*2 }
   object { XRod  translate y*3 }
   object { XRod  translate y*4 }
   object { XRod  translate y*5 }
   object { XRod  translate y*-1 }
   object { XRod  translate y*-2 }
   object { XRod  translate y*-3 }
   object { XRod  translate y*-4 }
   object { XRod  translate y*-5 }
   object { YRod }
   object { YRod  translate x*1 }
   object { YRod  translate x*2 }
   object { YRod  translate x*3 }
   object { YRod  translate x*4 }
   object { YRod  translate x*5 }
   object { YRod  translate x*-1 }
   object { YRod  translate x*-2 }
   object { YRod  translate x*-3 }
   object { YRod  translate x*-4 }
   object { YRod  translate x*-5 }
   texture { Black_Tex }
      } // end 10x 10y grid


// *******************************************************************
// II.   TEXTURES:  edited from Textures.Inc
// *******************************************************************
//       A. GLASS:
// *******************************************************************

#declare I_Glass=
   interior { ior 1.5 }
  
#declare F_Glass1 =
   finish {
    specular 1
    roughness 0.001
    ambient 0
    diffuse 0
    reflection 0.1 }   
  
// **************************************************************

// Clear:
#declare T_Glass1 =
texture {
    pigment { color rgbf<1.0, 1.0, 1.0, 0.9> }
    finish  { F_Glass1 }
        }

//********************************************************************
//    B. STONE:  well, actually, bricks...
//********************************************************************

//    DEFINE  Ib Rassmensen's brick texture:   (c)Nov 99
#declare BHeight =  0.6;  //my changes
#declare BWidth  =  1.0;

//#declare BHeight =  0.4;  // original
//#declare BWidth  =  0.9;

#declare T_Mortarcolour = 
texture {
   pigment { 
      granite
      turbulence 0.6
      color_map{
	  [0.000, 0.154   color rgbf <0.7, 0.7, 0.566, 0.000>
			  color rgbf <0.7, 0.7, 0.677, 0.000>]
	  [0.154, 0.300   color rgbf <0.7, 0.7, 0.700, 0.000>
			  color rgbf <0.7, 0.7, 0.566, 0.000>]
	  [0.300, 0.320   color rgbf <0.5, 0.5, 0.500, 0.000>
			  color rgbf <0.6, 0.6, 0.600, 0.000>]
	  [0.320, 0.615   color rgbf <0.7, 0.7, 0.700, 0.000>
			  color rgbf <0.7, 0.7, 0.566, 0.000>]
	  [0.615, 0.812   color rgbf <0.7, 0.7, 0.566, 0.000>
			  color rgbf <0.7, 0.7, 0.677, 0.000>]
	  [0.812, 1.001   color rgbf <0.7, 0.7, 0.700, 0.000>
			  color rgbf <0.1, 0.1, 0.100, 0.000>]
               }// end map
           }// end pigment
   scale <3, 3, 3>
   finish { ambient 0.3 diffuse 0.7 }
        } // end mortar texture

#declare T_Brickcolour = 
texture {
   pigment { 
      bozo
      turbulence 1.0
      color_map{
         [0.0, 0.5   color rgbf <0.13, 0.04, 0.04, 0.0>
                     color rgbf <0.20, 0.07, 0.04, 0.0>]
         [0.5, 1.001 color rgbf <0.20, 0.07, 0.04, 0.0>
                     color rgbf <0.13, 0.04, 0.04, 0.0>]
               }// end map
           }// end pigment
   scale <30, 30, 30>
        } // end brick texture

#declare T_BSBrick = 
texture {
   brick texture {T_Mortarcolour}, texture {T_Brickcolour}
   brick_size <BWidth, BHeight, BWidth/2>
   mortar 0.05                         //altered
        } // end BS Brick textr

// **************************************************************

//    DEFINE  Ib Rassmensen's brick texture modified by Brendan Hurley
//    from dark to light brick texture: Jan 00
#declare BH_Height =  2.0;
#declare BH_Width  =  2.5;

#declare T_BH_Mortarcolour = 
texture {
   pigment { 
      granite
      turbulence 0.6
      color_map{
	  [0.000, 0.154   color rgbf <0.7, 0.7, 0.566, 0.000>
			  color rgbf <0.7, 0.7, 0.677, 0.000>]
	  [0.154, 0.300   color rgbf <0.7, 0.7, 0.700, 0.000>
			  color rgbf <0.7, 0.7, 0.566, 0.000>]
	  [0.300, 0.320   color rgbf <0.5, 0.5, 0.500, 0.000>
			  color rgbf <0.6, 0.6, 0.600, 0.000>]
	  [0.320, 0.615   color rgbf <0.7, 0.7, 0.700, 0.000>
			  color rgbf <0.7, 0.7, 0.566, 0.000>]
	  [0.615, 0.812   color rgbf <0.7, 0.7, 0.566, 0.000>
			  color rgbf <0.7, 0.7, 0.677, 0.000>]
	  [0.812, 1.001   color rgbf <0.7, 0.7, 0.700, 0.000>
			  color rgbf <0.1, 0.1, 0.100, 0.000>]
               }// end map
           }// end pigment
   scale <3, 3, 3>
   finish { ambient 0.3 diffuse 0.7 }
        } // end mortar texture

#declare T_BH_Brickcolour = 
texture { T_Stone2  scale < 5, 1, 1 > } // end brick texture


#declare T_BH_BSBrick = 
texture {
   brick texture {T_BH_Mortarcolour}, texture {T_BH_Brickcolour} //texture { Tan_Tex }
   brick_size <BH_Width, BH_Height, BH_Height>
   mortar 0.150
        } // end BH BS Brick textr


// *******************************************************************
// *******************************************************************
// III.  DEFINE  Structural Components
// *******************************************************************
//    A.   Frames: Single: Wall:
// *******************************************************************

//   DEFINE   a frame 10x 10y units
#declare Frame_A =
union {
   object { CubeY1
            scale <   0.5, 10.0, 0.5 >  translate < -5,  0, 0 > }
   object { CubeY1
            scale <   0.5, 10.0, 0.5 >  translate <  5,  0, 0 > }
   object { CubeX1
            scale < 10.25,  0.5, 0.5 >  translate <  0,  5, 0 > }
   object { CubeX1
            scale < 10.25,  0.5, 0.5 >  translate <  0, -5, 0 > }
      } // end Frame A

// **************************************************************

//   DEFINE   a half-height frame 10x 5y units
#declare Frame_B =
union {
   object { CubeY1                                         
            scale < 0.5, 5, 0.5 >  translate < -5, 0, 0 > }
   object { CubeY1                                         
            scale < 0.5, 5, 0.5 >  translate <  5, 0, 0 > }
   object { CubeX1                                        
            scale < 10.25, 0.5, 0.5 >  translate < 0,  2.5, 0 > }
   object { CubeX1                                        
            scale < 10.25, 0.5, 0.5 >  translate < 0, -2.5, 0 > }
      } // end Frame B

// **************************************************************

//   DEFINE   a quarter-height frame 10x 2.5y units
#declare Frame_C =
union {
   object { CubeY1                                         
            scale < 0.5, 2.75, 0.5 >  translate < -5, 0, 0 > }
   object { CubeY1                                          
            scale < 0.5, 2.75, 0.5 >  translate <  5, 0, 0 > }
   object { CubeX1                                        
            scale < 10, 0.5, 0.5 >  translate < 0,  1.25, 0 > }
   object { CubeX1                                        
            scale < 10, 0.5, 0.5 >  translate < 0, -1.25, 0 > }
      } // end Frame C

// **************************************************************

//   DEFINE   half-wide frame unit 5x 10y
#declare Frame_D =
union {
   object { CubeY1
            scale < 0.75, 10, 0.75 >  translate < -2.5, 0, 0 > }
   object { CubeY1
            scale < 0.75, 10, 0.75 >  translate <  2.5, 0, 0 > }
   object { CubeX1
            scale < 5.25, 0.75, 0.75 >  translate < 0, -5, 0 > }
   object { CubeX1
            scale < 5.25, 0.75, 0.75 >  translate < 0,  5, 0 > }
      } // end Frame D

// **************************************************************

//   DEFINE   a 5x 5y frame
#declare Frame_E =
union {
   object { CubeY1
            scale < 0.5, 5.25, 0.5 >  translate < -2.5, 0, 0 > }
   object { CubeY1
            scale < 0.5, 5.25, 0.5 >  translate <  2.5, 0, 0 > }
   object { CubeX1
            scale < 5, 0.5, 0.5 >  translate < 0,  2.5, 0 > }
   object { CubeX1
            scale < 5, 0.5, 0.5 >  translate < 0, -2.5, 0 > }
      } // end Frame E

// **************************************************************

//   DEFINE   a quarter-height 5x 2.5y frame:
#declare Frame_F =
union {
   object { CubeY1                                         
            scale < 0.5, 2.5, 0.5 >  translate < -2.5, 0, 0 > }            
   object { CubeY1                                         
            scale < 0.5, 2.5, 0.5 >  translate <  2.5, 0, 0 > }            
   object { CubeX1                                        
            scale < 5.25, 0.5, 0.5 >  translate < 0,  1.25, 0 > }
   object { CubeX1                                        
            scale < 5.25, 0.5, 0.5 >  translate < 0, -1.25, 0 > }
      } // end Frame F

// *******************************************************************
//    B.   Frames: Single: Window:
// *******************************************************************

//    DEFINE  an inset frame for 3x 4y window in a 10x 10y wall frame:
#declare Window_Frame_1 =
union {
   object { CubeY1                                        
            scale < 0.76, 10, 0.75 >  translate < -1.76, 0, 0 > }
   object { CubeY1                                       
            scale < 0.76, 10, 0.75 >  translate <  1.76, 0, 0 > }
   object { CubeX1                                        
            scale <   10, 0.75, 0.75 >  translate < 0,  2, 0 > }
   object { CubeX1                                        
            scale < 4.25, 0.75, 0.75 >  translate < 0, -2, 0 > }
   object { Frame_A } // end frame
   #if ( ShowDetails )
      texture { T_Wood2 }
   #else
      texture { Red_Tex }
   #end
      }//end window frame 1

// **************************************************************

//    DEFINE  an inset frame for Window Panel 2 in a 10x 10y wall frame:
#declare Window_Frame_2 =
union {
   object { CubeY1                                        
            scale < 0.5,  10, 0.5 >  translate < -3.45,      0, 0 > }
   object { CubeY1                                        
            scale < 0.5,  10, 0.5 >  translate <  3.45,      0, 0 > }
   object { CubeX1                                        
            scale <  10, 0.5, 0.5 >  translate <     0,   3.15, 0 > }
   object { CubeX1                                        
            scale <   7, 0.5, 0.5 >  translate <     0, -1.125, 0 > }
   object { Frame_A } // end frame
   #if ( ShowDetails )
      texture { T_Wood2 }
   #else
      texture { Blue_Tex }
   #end
      }//end window frame 2

// **************************************************************

//    DEFINE  a frame for 4x 3y window in a 5x 10y wall:
#declare Window_Frame_3 =
union {
   object { CubeY1                                        
            scale < 1, 3, 1 >  translate < -2, 0, 0 > }
   object { CubeY1                                       
            scale < 1, 3, 1 >  translate <  2, 0, 0 > }
   object { CubeX1                                        
            scale < 4.5, 0.75, 1 >  translate < 0,  1.5, 0 > }
   object { CubeX1                                        
            scale < 4.5, 0.75, 1 >  translate < 0, -1.5, 0 > }
   #if ( ShowDetails )
      texture { T_Wood2 }
   #else
      texture { Blue_Tex }
   #end
      }//end window frame 3

// **************************************************************

//    DEFINE  a round post frame for fancy glass windows:
#declare Frame_Diamond_1 =
union {
  object { PostY1
           scale <0.5, 2.25, 0.5> rotate z*45  translate <-0.75,-0.75,0> }
  object { PostY1 
           scale <0.5, 2.25, 0.5> rotate z*45  translate < 0.75, 0.75,0> }
  object { PostY1 
           scale <0.5, 2.25, 0.5> rotate z*-45 translate <-0.75, 0.75,0> }
  object { PostY1 
           scale <0.5, 2.25, 0.5> rotate z*-45 translate < 0.75,-0.75,0> }
      } // end diamond frame 1

// *******************************************************************
//    C.   Panels: Single: Wall:
// *******************************************************************

//    DEFINE  a 10x 10y 1z panel:
#declare Panel_A =
object { UnitBox  scale < 5, 5, 0.5 > } // end panel a

// **************************************************************

//    DEFINE  a 10x 5y 1z panel:
#declare Panel_B =
object { UnitBox  scale < 5, 2.5, 0.5 > } // end panel b

// **************************************************************

//    DEFINE  a 10x 2.5y 1z panel:
#declare Panel_C =
object { UnitBox  scale < 5, 1.25, 0.5 > } // end panel c

// **************************************************************

//    DEFINE  a 5x 10y 1z panel:
#declare Panel_D =
object { UnitBox  scale < 2.5, 5, 0.5 > } // end panel d

// **************************************************************

//    DEFINE  a 5x 5y 1z panel:
#declare Panel_E =
object { UnitBox  scale < 2.5, 2.5, 0.5 > } // end panel e

// **************************************************************

//    DEFINE  a 5x 2.5y 1z panel:
#declare Panel_F =
object { UnitBox  scale < 2.5, 1.25, 0.25 > } // end panel f

// **************************************************************

#declare Panel_Tri_1 =
intersection {
   object { UnitBox  scale < 0.5, 0.5, 0.25 > }
   plane { y, 0            
           rotate z*135
           hollow on
         } //end clipping plane
             } // end  triangle pane 1

// *******************************************************************
//    D.   Panels: Single: windows:
// *******************************************************************

//   DEFINE   a 1-unit square glass pane: 0.01 units thick:
#declare Pane_Square_2 =
object { UnitBox
         #if ( ShowGlass )
            texture { T_Glass1 }
         #else
            texture { Black_Tex }
         #end
         scale < 0.5, 0.5, 0.01 >
       } // end square glass pane

// *******************************************************************
//    E.   Frames: Compound: Wall:
// *******************************************************************
// *******************************************************************
//    F.   Frames: Compound: Windows:
// *******************************************************************
// *******************************************************************
//    G.   Panels: Compound: Wall:
// *******************************************************************
// *******************************************************************
//    H.   Panels: compound: windows:
// *******************************************************************

//    DEFINE  a standard 3x 4y window panel:
#declare Window_Panel_1 =
union {
   //window
   #if ( ShowGlass )
      object { Pane_Square_2  scale < 3, 4, 1 > }
   #end
   object { Frame_E  scale < 0.65, 0.75, 5 >
            #if ( ShowDetails )
               texture { T_Wood2 }
            #else
               texture { Orange_Tex }
            #end
          } // window frame
   // wood panels:
   union {
   object { UnitBox scale <5.15, 1.55, 0.5> translate < 0,  3.50, 0> }//top
   object { UnitBox scale <5.15, 1.55, 0.5> translate < 0, -3.39, 0> }//bot
   object { UnitBox scale <1.75, 2, 0.5> translate <-3.375, 0, 0> }  //l
   object { UnitBox scale <1.75, 2, 0.5> translate < 3.375, 0, 0> }  //r
   #if ( ShowDetails )
      texture { EMBWood1  scale < 9, 0.6, 1 >  }//end textr
      finish { ambient 0.4  diffuse 0.6 }//end finish
   #else
      texture { Green_Tex }
    #end      
         }//end inner union: wood panels
      }// end window 1

// **************************************************************

//    DEFINE  a standard 6x 4y window panel:
#declare Window_Panel_2 =
union {
   object { Pane_Square_2  scale < 6, 4, 1 >  translate y*1 }
   object { Frame_E
            scale < 1.25, 0.75, 1 >
            translate y*1
            #if ( ShowDetails )
               texture { T_Wood2 }
            #else
               texture { Orange_Tex }
            #end
          } // frame
   // wood panels:
   union {
     object { CubeX1 scale < 10, 3.5, 0.5 > translate < 0,  4, 0 > }//top
     object { CubeX1 scale < 10,   8, 0.5 > translate < 0, -3, 0 > }//bot
     object { CubeY1 scale <  3,   8, 0.5 > translate < -4.25, -1, 0 > }//l
     object { CubeY1 scale <  3,   8, 0.5 > translate <  4.25, -1, 0 > }//r
      #if ( ShowDetails )
         texture { EMBWood1
                   scale < 9, 0.6, 1 >  }//end textr
         finish { ambient 0.4  diffuse 0.6 }//end finish
      #else
         texture { Green_Tex }
       #end      
         }// end union wood panels
      }//end window 2

// **************************************************************

//    DEFINE  a 4x3 window for 10x10 frame: big white bricks:
#declare Window_Panel_3 =
union {
   //window
   union {
    union {
      #if ( ShowGlass )
         object { Pane_Square_2 scale <3.6, 2.6, 1> translate y*1.5  }//glass
         object { Pane_Square_2 scale <3.6, 2.6, 1> translate y*-1.5 }//glass
      #end
      object { Window_Frame_3  translate y*1.5  } // upper sash
      object { Window_Frame_3  translate y*-1.5 } // lower sash
         }// end union: windows
   object { Frame_E  scale < 0.9, 1.35, 5 >
            #if ( ShowDetails )
               texture { T_Wood2 }
            #else
               texture { Orange_Tex }
            #end
          }// window casements
   translate y*1
          } // end union whole window
   // panels:
   union {
     object { CubeX1 scale <10, 1.20, 1.75> translate <0,  4.75, 0> }//top
     object { CubeX1 scale <10, 4.95, 1.75> translate <0, -3.75, 0> }//bot
     object { CubeY1 scale <5.25, 7, 1.75> translate <-3.65, 1, 0> }  //l
     object { CubeY1 scale <5.25, 7, 1.75> translate < 3.65, 1, 0> }  //r
     #if ( ShowDetails )
        texture { T_BH_BSBrick  scale < 1.25, 1, 1 > }
     #else
        texture { Orchid_Tex }
     #end      
        }// end union big brick panels
      } // end window 3

// **************************************************************

//    DEFINE  casement around two 4x 3y frames:
#declare Window_Panel_4 =
union {
   object { CubeX1 
            scale < 5, 1.2, 1.5 >  translate < 0,  3.5, 0 > } // top
   object { CubeX1 
            scale < 5, 1.2, 1.5 >  translate < 0, -3.5, 0 > } // bot
   object { CubeY1
            scale < 1, 6.5, 1.5 >  translate < -2.25, 0, 0 > } // left
   object { CubeY1 
            scale < 1, 6.5, 1.5 >  translate <  2.25, 0, 0 > } // right
   #if ( ShowDetails )
      texture { T_Stone2 }
   #else
      texture { Blue_Tex }
   #end
      }//end window 4

// **************************************************************

//    DEFINE  a tall narrow 2.5x 10y window:
#declare Window_Panel_5 =
union {
   #if ( ShowGlass )
      object { Pane_Square_2  scale < 2.5, 10, 1 > }    // pane
   #else  // render anti-error msg object
      object { UnitBox  scale 0.00005 texture {Black_Tex} }
   #end
   union {                                            // sash
      object { CubeY1  scale < 1, 10, 1 >  translate < -1.25, 0, 0 > }
      object { CubeY1  scale < 1, 10, 1 >  translate <  1.25, 0, 0 > }
      object { CubeX1  scale < 2,  1, 1 >  translate < 0, -4.75, 0 > }
      object { CubeX1  scale < 2,  1, 1 >  translate < 0,  4.75, 0 > }
      #if ( ShowDetails )
         texture { T_Wood2 }
      #else
         texture { Tan_Tex }
      #end
         }//end window sash
      }  // end window 5

// **************************************************************

//    DEFINE  a 4x3 window for 10x10 frame: small brown bricks:
#declare Window_Panel_6 =
union {
   //window:
   union {
    union {
      #if ( ShowGlass )
         object { Pane_Square_2 scale <3.6, 2.6, 1> translate y*1.5  }//glass
         object { Pane_Square_2 scale <3.6, 2.6, 1> translate y*-1.5 }//glass
      #end
      object { Window_Frame_3  translate y*1.5  } // upper sash
      object { Window_Frame_3  translate y*-1.5 } // lower sash
         }// end union: windows
   object { Frame_E  scale < 0.9, 1.35, 5 >
            #if ( ShowDetails )
               texture { T_Wood2 }
            #else
               texture { Red_Tex }
            #end
          }// window casements
   translate y*1
          } // end union whole window
   // panels:
   union {
      object { CubeX1 scale <10.15, 1.20, 1> translate <0,  4.75, 0> }//top
      object { CubeX1 scale <10.15, 4.95, 1> translate <0, -3.75, 0> }//bot
      object { CubeY1 scale <5.25, 7, 1> translate <-3.65, 1, 0> }  //l
      object { CubeY1 scale <5.25, 7, 1> translate < 3.65, 1, 0> }  //r
      #if ( ShowDetails )
         texture { T_BSBrick  scale < 1.25, 1.25, 1.25 > }
      #else
         texture { Blue_Tex }
      #end      
         }// end union small brick panels
      } // end window 6

// **************************************************************

//   DEFINE  a window transome:
#declare Window_Transome =
union {
   object { Frame_Diamond_1 
            scale < 0.5, 0.75, 0.5 >
            translate < -1.35, 0, 0 >
            texture { Black_Tex }
          } //end window grate left
   object { Frame_Diamond_1 
            scale < 0.5, 0.75, 0.5 >
            texture { Black_Tex }
          } //end window grate cntr
   object { Frame_Diamond_1 
            scale < 0.5, 0.75, 0.5 >
            translate < 1.35, 0, 0 >
            texture { Black_Tex }
          } //end window grate right
   object { Pane_Square_2 
            scale < 4.5, 2.5, 1 > 
            translate < 0, 0, 0 >
          } //end window pane          
      } // end window transome

// **************************************************************

//    DEFINE  semi circular window & arch:
#declare Window_Arch_1 =
union {
   object { Semi_Circle_1 
            scale < 2, 2, 0.001 >
            #if ( ShowGlass )
               texture { T_Glass1 }
            #else
               texture { Blue_Tex }
            #end
          }//end semi circle glass
   object { Arch_Z1
            scale < 2, 2, 0.2 >
            #if ( ShowDetails )
               texture { T_Stone1 }
            #else
               texture { Orange_Tex }  
            #end
          }// end arched frame 
   object { CubeX1
            scale < 3.75, 0.7, 0.75 >
            translate y*0.17
            #if ( ShowDetails )
               texture { T_Stone1 }
            #else
               texture { Magenta_Tex }  
            #end
          }// end lower frame 
   object { CubeX1
            scale < 2, 0.5, 0.5 >
            rotate z*90
            translate < 0, 1, 0 >
            #if ( ShowDetails )
               texture { T_Wood1 }
            #else
               texture { Magenta_Tex }  
            #end
          }// end vertical frame 
   object { CubeX1
            scale < 1.75, 0.5, 0.5 >
            rotate z*45
            translate < 0.7, 0.7, 0 >
            #if ( ShowDetails )
               texture { T_Wood1 }
            #else
               texture { Black_Tex }  
            #end
          }// end diagonal frame 
   object { CubeX1
            scale < 1.75, 0.5, 0.5 >
            rotate z*-45
            translate < -0.7, 0.7, 0 >
            #if ( ShowDetails )
               texture { T_Wood1 }
            #else
               texture { Brown_Tex }  
            #end
          }// end diagonal frame 
      } // union arched window 1

// **************************************************************

//    DEFINE  semi circle & arch: stone texture:
#declare Window_Arch_2 =
union {
   object { Semi_Circle_1 
            scale < 2, 2, 0.001 >
            #if ( ShowDetails )
               texture { T_Stone1 }
            #else
               texture { Blue_Tex }
            #end
          }//end semi circle glass
   object { Arch_Z1
            scale < 2, 2, 0.2 >
            #if ( ShowDetails )
               texture { T_Stone1 }
            #else
               texture { Orange_Tex }  
            #end
          }// end arched frame 
   object { CubeX1
            scale < 3.75, 0.7, 0.75 >
            translate y*0.17
            #if ( ShowDetails )
               texture { T_Stone1 }
            #else
               texture { Magenta_Tex }  
            #end
          }// end lower frame 
      } // union arched window 2


// *******************************************************************
// III.    DEFINE Basic Elements
// *******************************************************************
//    A.   Floors                                                     
// *******************************************************************

#declare Test_Floor =
plane { y, 0
   texture { Gray95_Tex
           } //end texture
   finish {
      ambient 0.3
      diffuse 0.8
          } //end finish
   hollow
   clipped_by { UnitBox scale < 1000, 1, 1000 > }
      } // end Test Floor

// **************************************************************

#declare Clip_Floor =
plane { y, 0
   texture { GreenYellow_Tex
             scale 4
           } //end texture
   finish {
      ambient 0.2
      diffuse 0.8
          } //end finish
   hollow
   clipped_by { UnitBox scale < 1000, 1, 1000 > }
      } // end Clipped Floor

// **************************************************************

//    DEFINE   basic floor: 2x 0.5y 2z
#declare Floor_One =
object { UnitBox  scale < 1, 0.25, 1 > }

// *******************************************************************
//    B.   Roofs
// *******************************************************************

//    DEFINE  a flat slab roof: 2x 1y 2z
#declare Roof_One =
object { Cube  scale < 1, 0.5, 1 > }

// **************************************************************

//    DEFINE  an a-frame roof:
#declare Roof_A_Frame =
union {
   object{ UnitBox
           scale < 9.5, 1, 5 >
           rotate z*-45
           translate < 6, 3.5, 0 >
           texture { Gray_Tex }
         }// right half
   object{ UnitBox
           scale < 9.5, 1, 5 >
           rotate z*45
           translate < -6, 3.5, 0 >
           texture { Gray_Tex }
         }// left half
      } // end a-frame roof

// *******************************************************************
//    C.   Balcony                                                     
// *******************************************************************

//    DEFINE  a semi-circular railing: 
#declare Railing_1 =
union {
   object { MBH_Torus_1
            scale < 6, 2.5, 5 >
            translate < 0, 1.75, 0 > 
            #if ( ShowDetails )
               texture { T_Stone1 }
            #else
               texture { Yellow_Tex }
            #end
          }// end upper torus
   object { MBH_Torus_1
            scale < 6, 2.5, 5 >
            translate < 0, -1.75, 0 >
            #if ( ShowDetails )
               texture { T_Stone1 }
            #else
               texture { Orange_Tex }
            #end
          }// end lower torus
      } // end union railing for balcony

// **************************************************************

//    DEFINE  balustrade:
#declare Balustrade_1 =
union { 
   #declare ThisScale = < 2, 3.25, 2 >;

   object { 
      PostY1
      scale ThisScale
      translate < -1, 0, 0 >
          }//end cylinder
   object { 
      PostY1
      scale ThisScale
      translate < 1, 0, 0 >
          }//end cylinder
   object { 
      PostY1
      scale ThisScale
      translate < -3, 0, 0.5 >
          }//end cylinder
   object { 
      PostY1
      scale ThisScale
      translate < 3, 0, 0.5 >
          }//end cylinder
   object { 
      PostY1
      scale ThisScale
      translate < -4.5, 0, 1.5 >
          }//end cylinder
   object { 
      PostY1
      scale ThisScale
      translate < 4.5, 0, 1.5 >
          }//end cylinder
   object { 
      PostY1
      scale ThisScale
      translate < -5.75, 0, 3 >
          }//end cylinder
   object { 
      PostY1
      scale ThisScale
      translate < 5.75, 0, 3 >
          }//end cylinder
   object { 
      PostY1
      scale ThisScale
      translate < -6.25, 0, 4.5 >
          }//end cylinder
   object { 
      PostY1
      scale ThisScale
      translate < 6.25, 0, 4.5 >
          }//end cylinder
   #if ( ShowDetails )
      texture { T_Stone1 }
   #else
      texture { Blue_Tex }
   #end
      } // end union balustrade

// **************************************************************

//    DEFINE  a balcony floor:
#declare Floor_Balcony_1 =
object {
   Disk_Y 
   clipped_by { plane { z, 0  hollow on } }
   #if ( ShowDetails )
      texture { T_Stone1 }
   #else
      texture { Black_Tex }
   #end
       } // end balcony floor

// **************************************************************

//    DEFINE   a semi-circular balcony:
#declare Balcony_1 =
union {
   object { Balustrade_1  translate < 0, 0, -5 > }
   object { Railing_1     translate < 0, 0,  0 > }
   object { Floor_Balcony_1  scale < 7.1, 0.25, 6 >
                             translate < 0, -2, 0> }
      } // end union balcony

// *******************************************************************
//    D.   Doors:                                                     
// *******************************************************************

//    DEFINE  a basic plain front door panel for 5x 10y frame:
#declare APT_Door_1 =
union {
   object{ CubeY1 
            scale < 8, 7, 1 >
            translate < 0, -1.5, 0 >
            #if ( ShowDetails )
               texture { EMBWood1  scale < 1, 15, 1 > } 
            #else
               texture { Yellow_Tex }
            #end 
          }//end door
   object { CubeY1 
            scale < 1.5, 10, 1.25 >
            translate < -2.25, 0, 0 >
            #if ( ShowDetails )
               texture { T_Stone2  scale < 2, 10, 1 > } 
            #else
               texture { Red_Tex }
            #end 
          }//end left of door
   object { CubeY1 
            scale < 1.5, 10, 1.25 >
            translate <  2.25, 0, 0 >
            #if ( ShowDetails )
               texture { T_Stone2  scale < 2, 8, 2 > } 
            #else
               texture { Red_Tex }
            #end 
          }//end right of door
   object { CubeX1 
            scale < 5.25, 1, 1.25 >
            translate <  0, 1.75, 0 >
            #if ( ShowDetails )
               texture { T_Stone2  scale < 7, 2, 1 > } 
            #else
               texture { Orchid_Tex }
            #end 
          }//end trim below window
   object { CubeX1 
            scale < 5.25, 1, 1.25 >
            translate <  0, 4.75, 0 >
            #if ( ShowDetails )
               texture { T_Stone2  scale < 9, 3, 1 > } 
            #else
               texture { Green_Tex }
            #end 
          }//end trim above window
   object { Window_Transome 
            scale < 0.9, 1.2, 1 >
            translate < 0, 3.125, 0 >
          } //end window above door
      } // end apartment door 1

// **************************************************************

//    DEFINE  a fancy front door panel for 5x 10y frame:
#declare APT_Door_2 =
union {
   //the door:
   object { Window_Transome
            rotate z*90    
            scale < 1.1, 0.65, 1 >
            translate < 0, -0.75, 0 >
          }//end transome as a window in the door
   object { CubeX1
            scale < 2.5, 3, 0.45 >
            translate < 0, -3.25, 0 >
            #if ( ShowDetails )
               texture { T_Wood2  scale < 2, 8, 2 >  rotate y*10 } 
            #else
               texture { Green_Tex }
            #end
          }// end lower door panel
   object { CubeX1 
            scale < 2.5, 1.25, 0.5 >
            translate < 0, 0.75, 0 >
            #if ( ShowDetails )
               texture { T_Wood2  scale < 8, 2, 2 > } 
            #else
               texture { Black_Tex }
            #end 
          }//end upper of door frame
   object { CubeX1 
            scale < 2.5, 1.25, 0.5 >
            translate < 0, -2.25, 0 >
            #if ( ShowDetails )
               texture { T_Wood2  scale < 6, 2, 2 > } 
            #else
               texture { Black_Tex }
            #end 
          }//end middle of door frame
   object { CubeX1 
            scale < 2.5, 1.7, 0.5 >
            translate < 0, -4.5, 0 >
            #if ( ShowDetails )
               texture { T_Wood2  scale < 7, 2, 2 > } 
            #else
               texture { Black_Tex }
            #end 
          }//end lower of door frame
   object { CubeY1 
            scale < 1.5, 6, 0.6 >
            translate < -1.5, -2, 0 >
            #if ( ShowDetails )
               texture { T_Wood2  scale < 2, 8, 2 > } 
            #else
               texture { Yellow_Tex }
            #end 
          }//end left frame
   object { CubeY1 
            scale < 1.5, 6, 0.6 >
            translate < 1.5, -2, 0 >
            #if ( ShowDetails )
               texture { T_Wood2  scale < 2, 8, 2 > } 
            #else
               texture { Yellow_Tex }
            #end 
          }//end right frame
   //door knob:
   sphere { < 2.25, -3, -0.2 >
            0.25 // radius
            scale < 0.7, 0.7, 0.7 >
            texture { Gold_Texture } 
          }//end door knob
   //door shashes:
   object { CubeY1 
            scale < 1.5, 10, 1 >
            translate < -2.25, 0, 0 >
            #if ( ShowDetails )
               texture { T_Stone2  scale < 2, 7, 2 > } 
            #else
               texture { Red_Tex }
            #end 
          }//end left of door
   object { CubeY1 
            scale < 1.5, 10, 1 >
            translate <  2.25, 0, 0 >
            #if ( ShowDetails )
               texture { T_Stone2  scale < 2, 7, 2 > } 
            #else
               texture { Red_Tex }
            #end 
          }//end right of door
   object { CubeX1 
            scale < 4, 1, 1 >
            translate <  0, 1.25, 0 >
            #if ( ShowDetails )
               texture { T_Wood2  scale < 10, 1, 1 > } 
            #else
               texture { Orchid_Tex }
            #end 
          }//end trim below window
   object { CubeX1 
            scale < 4, 1, 1 >
            translate <  0, 4.25, 0 >
            #if ( ShowDetails )
               texture { T_Stone2  scale < 10, 1, 1 > } 
            #else
               texture { Orchid_Tex }
            #end 
          }//end trim above window
   object { Window_Transome 
            scale < 1, 1.25, 1 >
            translate < 0, 2.75, 0 >
          }//end transome
      } // end apartment door 2


// *******************************************************************
// *******************************************************************



// ???????????????????????????????????????????????????????????????????
// NOTE...NOTE...NOTE...
// The declares above this point are for stand-alone objects, all the
// parts of the building that can be mixed and matched, transformed, etc.
// as the composer wishes. They can be used in any scene. 
//
// The declares below here all relie on the above declares to work.
//            Render Long and Prosper!         --Brendan
// ???????????????????????????????????????????????????????????????????



// *******************************************************************
// *******************************************************************
// IV.   DEFINE  Elements of an Apartment Building 
// *******************************************************************
//       A. A Generic Apartment Building:
// *******************************************************************
//          1. Frames:  used for designing initial layout:
// *******************************************************************

/*   --------COMMENTED OUT TO SAVE PARSING TIME-------- 

//    DEFINE  north frame:
#declare APT_NFrame_1 =
union { 
   object { Frame_D  translate <-10, 0, 0 > }
   object { Frame_D  translate < -5, 0, 0 > }
   object { Frame_D  translate <  0, 0, 0 > }
   object { Frame_D  translate <  5, 0, 0 > }
   object { Frame_D  translate < 10, 0, 0 > }
   #if ( ShowDetails )
      texture { T_Wood2 }
   #else
      texture { Red_Tex }
   #end 
      } // end apt north frame

// **************************************************************

//    DEFINE  south frame: w/ bay windows:
#declare APT_SFrame_1 =
union { 
   object { Frame_D  scale < 1.1, 1, 1.1 >
                     translate < -9.8, 0, 0 > }
   object { Frame_D  rotate y*45
                     scale < 1.1, 1, 1.1 > 
                     translate < -5, 0, -1.75 > }
   object { Frame_D  scale < 1.25, 1, 1.1 >
                     translate <  0, 0, -3.50 > }
   object { Frame_D  rotate y*-45
                     scale < 1.1, 1, 1.1 > 
                     translate <  5, 0, -1.75 > }
   object { Frame_D  scale < 1.1, 1, 1.1 >
                     translate < 9.8, 0, 0 > }
   #if ( ShowDetails )
      texture { T_Wood2 }
   #else
      texture { Magenta_Tex }
   #end 
      } // end apt south frame

// ************************************************************** 

//    DEFINE  east frame:
#declare APT_EFrame_1 =
union { 
   object { Frame_A  rotate y*90  translate < 0, 0, -35 > }
   object { Frame_A  rotate y*90  translate < 0, 0, -25 > }
   object { Frame_A  rotate y*90  translate < 0, 0, -15 > }
   object { Frame_A  rotate y*90  translate < 0, 0,  -5 > }
   object { Frame_A  rotate y*90  translate < 0, 0,   5 > }
   object { Frame_A  rotate y*90  translate < 0, 0,  15 > }
   object { Frame_A  rotate y*90  translate < 0, 0,  25 > }
   object { Frame_A  rotate y*90  translate < 0, 0,  35 > }
   #if ( ShowDetails )
      texture { T_Wood2 }
   #else
      texture { Green_Tex }
   #end 
      } // end apt east frame

*/

// *******************************************************************
//          2. Panels:  used for final render:
// *******************************************************************

//    DEFINE  a brownstone brick panel: 5x 10y:
#declare APT_Panel_1 =
object { Panel_D
         #if ( ShowDetails )
            texture { T_BSBrick  scale < 1.25, 1.25, 1.25 > }
         #else
            texture { Coral_Tex }
         #end
       } // end apt panel 1
 
// **************************************************************

//    DEFINE  a brownstone brick panel: 5x 2.5y:
#declare APT_Panel_2 =
object { Panel_F  scale < 1, 1, 2 >
         #if ( ShowDetails )
            texture { T_BSBrick  scale < 1.25, 1.25, 1.25 > }
         #else
            texture { Magenta_Tex }
         #end
       } // end apt panel 2
 
// **************************************************************

//    DEFINE  a brownstone brick panel: 10x 10y:
#declare APT_Panel_3 =
object { Panel_A
         #if ( ShowDetails )
            texture { T_BSBrick  scale < 1.25, 1.25, 1.25 > }
         #else
            texture { Violet_Tex }
         #end
       } // end apt panel 3
 
// **************************************************************

//    DEFINE  a 4x 6y window in a 5x 10y frame:
#declare APT_Panel_4 =
union {
   #if (ShowGlass)
      object { Pane_Square_2 scale <3.6, 2.6, 1> translate y*1.5  }//glass
      object { Pane_Square_2 scale <3.6, 2.6, 1> translate y*-1.5 }//glass
   #else
      //skip glass
   #end
   object { Window_Frame_3  translate y*1.5  } // upper
   object { Window_Frame_3  translate y*-1.5 } // lower
   object { Window_Panel_4           } // casement around frames
      } // end union apt panel 4 window

// **************************************************************

//    DEFINE  two  4x 6y windows in a 10x 10y frame:
#declare APT_Panel_5 =
union {
   object { CubeX1  scale < 10.25, 1.5, 2 >
                    translate < 0, 4.75, 0 >
                    #if ( ShowDetails )
                       texture { T_Stone2 }
                    #else
                       texture { Red_Tex }
                    #end
          }//end top panel
   object { APT_Panel_4  translate <  2.5, 0.75, 0 >  }//right window
   object { APT_Panel_4  translate < -2.5, 0.75, 0 > }//left window 
   object { CubeX1  scale < 10.25, 4, 2 >
                    translate < 0, -4, 0 >
                    #if ( ShowDetails )
                       texture { T_BSBrick  scale < 1.25, 1.25, 1.25 > }
                    #else
                       texture { Yellow_Tex }
                    #end
          }//end bottom panel
      } // end union apt panel 5 window

// **************************************************************

//    DEFINE  a stairwell panel for 5x 10y frame:
#declare APT_Panel_6 =
union {
   object { CubeX1 
            scale < 5.5, 1.1, 1.1 >
            translate <  0, 5, 0 >
            #if ( ShowDetails )
               texture { T_Stone2  scale < 10, 5, 2 > } 
            #else
               texture { Green_Tex }
            #end 
          }//end trim above panel
   object { CubeX1 
            scale < 5, 3, 0.75 >
            translate < 0, 4, 0 >
            #if ( ShowDetails )
               texture { T_BSBrick  scale < 1, 1, 1 > }
            #else
               texture { Brown_Tex }
            #end
          }//end upper panel
   object { Window_Transome 
            translate < 0, 2, 0 >
          }//end transome
   object { CubeY1 
            scale < 8, 6, 0.75 >
            translate < 0, -2, 0 >
            #if ( ShowDetails )
               texture { T_BSBrick  scale < 1, 1, 1 > }
            #else
               texture { Gray25_Tex }
            #end
          }//end lower panel
   object { CubeY1 
            scale < 1.5, 10, 1 >
            translate < -2.35, 0, 0 >
            #if ( ShowDetails )
               texture { T_BSBrick  scale < 1, 1, 1 > }
            #else
               texture { Red_Tex }
            #end 
          }//end left of window
   object { CubeY1 
            scale < 1.5, 10, 1 >
            translate <  2.35, 0, 0 >
            #if ( ShowDetails )
               texture { T_BSBrick  scale < 1, 1, 1 > }
            #else
               texture { Red_Tex }
            #end 
          }//end right of window
      } // end union stairwell panel

// **************************************************************

//    DEFINE  a grey stone large brick panel: 5x 10y:
#declare APT_Panel_7 =
object { Panel_D
         #if ( ShowDetails )
            texture { T_BH_BSBrick }
         #else
            texture { Gray_Tex }
         #end
       } // end apt panel 7
 
// **************************************************************

//    DEFINE  a grey stone brick panel: 10x 10y:
#declare APT_Panel_8 =
object { Panel_A
         #if ( ShowDetails )
            texture { T_BH_BSBrick }
         #else
            texture { Blue_Tex }
         #end
       } // end apt panel 8
 
// ************************************************************** 

//    DEFINE interior walls: to mark out a hallway, lobby:
#declare APT_HallPanel_1 =
union { 
   object { Panel_A  rotate y*90  translate < 0, 0, -35 > }
   object { Panel_A  rotate y*90  translate < 0, 0, -25 > }
   object { Panel_A  translate <    0, 0, -20 > }
   object { Panel_D  translate < -7.5, 0, -20 > }
   object { Panel_A  translate <  -15, 0, -20 > }
   texture { Tan_Tex }
      } // end apt hallway panels

// **************************************************************

//    DEFINE  bay windows:
#declare APT_Bay_Windows =
union {
   object { APT_Panel_4  rotate y*45
                         scale < 1.2, 1, 1.1 > 
                         translate < -5,  1.5, -2.00 > } //window
   object { APT_Panel_4  scale < 1.2, 1, 1.1 >
                         translate <  0,  1.5, -3.75 > } //window
   object { APT_Panel_4  rotate y*-45
                         scale < 1.2, 1, 1.1 > 
                         translate <  5,  1.5, -2.00 > } //window                         
   object { APT_Panel_2  rotate y*45
                         scale < 1.2, 1.1, 1 >
                         translate < -5, -3.5, -2.00 > } //bricks
   object { APT_Panel_2  scale < 1.2, 1.1, 1 >
                         translate <  0, -3.5, -3.75 > } //bricks
   object { APT_Panel_2  rotate y*-45
                         scale < 1.2, 1.1, 1 >
                         translate <  5, -3.5, -2.00 > } //bricks
      } // end bay windows

// ******************************************************************* 
//          3. Complete Walls
// ******************************************************************* 

//    DEFINE  south wall panels: 3 bay windows:
#declare APT_SPanel_1 =
union {
   object { CubeX1 
            scale < 5.5, 1.1, 1.1 >
            translate < -9.8, 5, 0 >
            #if ( ShowDetails )
               texture { T_Stone2  scale < 10, 1, 1 > } 
            #else
               texture { Green_Tex }
            #end 
          }//end trim above left panel
   object { APT_Panel_1  scale < 1.1, 1, 1 >
                         translate < -10, 0, 0 > }    //left panel
   object { APT_Bay_Windows }
   //insert door, panel, or window here at < 10, 0, 0 >:
//   object { APT_Panel_1  scale < 1.1, 1, 1 >
//                         translate < 10, 0, 0 > }   //right panel
      } // end south wall panels

// **************************************************************

//    DEFINE  south wall panels: 2 flat windows: 1 door:
#declare APT_SPanel_2 =
union {
   object { CubeX1 
            scale < 25.5, 1.75, 3 >
            translate < 0, 4.9, 0 >
            #if ( ShowDetails )
               texture { T_Stone2  scale < 15, 2, 1 > } 
            #else
               texture { Green_Tex }
            #end 
          }//end trim above all panels
   object { APT_Panel_7  scale < 1, 1, 1 >
                         translate < -10, 0, 0 > }   //left bricks
   object { APT_Panel_4  translate < -5,  0.6, 0 > } //window
   object { APT_Panel_4  translate <  5,  0.6, 0 > } //window
   object { APT_Panel_7 }                            //middle panel
   object { APT_Panel_2  scale < 1, 0.75, 1 >
                         translate < -5, -4, 0 > }   //bricks
   object { APT_Panel_2  scale < 1, 0.75, 1 >
                         translate <  5, -4, 0 > }   //bricks
   //insert door, panel, or window here at < 10, 0, 0 >
      } // end south wall panels 2

// **************************************************************

//    DEFINE  south wall: 2 flat windows: w/ balcony:
#declare APT_SPanel_3 =
union {
   object { CubeX1 
            scale < 25.5, 1.75, 3 >
            translate < 0, 4.9, 0 >
            #if ( ShowDetails )
               texture { T_Stone2  scale < 15, 2, 1 > } 
            #else
               texture { Green_Tex }
            #end 
          }//end trim above all panels
   object { APT_Panel_1  translate <  -10, 0, 0 > }    //left bricks
   object { APT_Panel_1  translate < -7.5, 0, 0 > }    //left bricks
   object { APT_Panel_4  translate < -2.5, 0.6, 0 > }  //window
   object { APT_Panel_4  translate <  2.5, 0.6, 0 > }  //window
   object { APT_Panel_2  scale < 1, 0.75, 1 >
                         translate < -2.5, -4, 0 > }   //bricks
   object { APT_Panel_2  scale < 1, 0.75, 1 >
                         translate <  2.5, -4, 0 > }   //bricks
   object { APT_Panel_1  translate < 7.5, 0, 0 > }     //right bricks
   object { APT_Panel_1  translate <  10, 0, 0 > }     //right bricks

   object { Balcony_1    scale < 1, 1, 1 >
                         translate < 0, -2.5, 0.5 > }  // end balcony
      } // end south wall panels 3

// **************************************************************

//    DEFINE  north wall panels:
#declare  APT_NPanel_1 =
union {
   object { APT_Panel_1  translate <  -10, 0, 0 > }
   object { APT_Panel_5  translate < -2.5, 0, 0 > }
   object { APT_Panel_1  translate <    5, 0, 0 > }
   object { APT_Door_1   translate < 10.1, 0, 0 > }
      } // end north wall

// **************************************************************

//    DEFINE  west wall panel:
#declare APT_WPanel_1 =
union {
   object { APT_Panel_3 rotate y*90 translate < 0, 0, -35 > }
   object { APT_Panel_3 rotate y*90 translate < 0, 0, -25 > }
   object { APT_Panel_3 rotate y*90 translate < 0, 0, -15 > }
   object { APT_Panel_3 rotate y*90 translate < 0, 0,  -5 > }
   object { APT_Panel_3 rotate y*90 translate < 0, 0,   5 > }
   object { APT_Panel_3 rotate y*90 translate < 0, 0,  15 > }
   object { APT_Panel_3 rotate y*90 translate < 0, 0,  25 > }
   object { APT_Panel_3 rotate y*90 translate < 0, 0,  35 > }
      } // end west wall

// **************************************************************

//    DEFINE  east wall panel: brown bricks:
#declare APT_EPanel_1 =
union {
   object { APT_Panel_3 rotate y*90 translate < 0, 0, -35 > }
   object { APT_Panel_3 rotate y*90 translate < 0, 0, -25 > }
   object { APT_Panel_5 rotate y*90 translate < 0, 0, -15 > }
   object { APT_Panel_3 rotate y*90 translate < 0, 0,  -5 > }
   object { APT_Panel_5 rotate y*90 translate < 0, 0,   5 > }
   object { APT_Panel_3 rotate y*90 translate < 0, 0,  15 > }
   object { APT_Panel_5 rotate y*90 translate < 0, 0,  25 > }
   object { APT_Panel_3 rotate y*90 translate < 0, 0,  35 > }
      } // end east wall v1

// **************************************************************

//    DEFINE  east wall panel: grey stones:
#declare APT_EPanel_2 =
union {
   object { APT_Panel_8 rotate y*90 translate < 0, 0, -35 > }
   object { APT_Panel_8 rotate y*90 translate < 0, 0, -25 > }
   object { APT_Panel_5 rotate y*90 translate < 0, 0, -15 > }
   object { APT_Panel_8 rotate y*90 translate < 0, 0,  -5 > }
   object { APT_Panel_5 rotate y*90 translate < 0, 0,   5 > }
   object { APT_Panel_8 rotate y*90 translate < 0, 0,  15 > }
   object { APT_Panel_5 rotate y*90 translate < 0, 0,  25 > }
   object { APT_Panel_8 rotate y*90 translate < 0, 0,  35 > }
   object { CubeZ1 
            scale < 3, 1.5, 81.5 >
            translate < 0, 4.9, 0 >
            #if ( ShowDetails )
               texture { T_Stone2  scale < 1, 2, 15 > } 
            #else
               texture { Green_Tex }
            #end 
          }//end trim above all panels
      } // end east wall  V2

// *******************************************************************
//          4. Other Parts:
// *******************************************************************

//    DEFINE  a floor for apt bldg:
#declare Floor_APT =
object { Floor_One
         scale < 12.75, 1, 40.25 >
         texture { Brown_Tex }
       }//end apartment floor

// **************************************************************

//    DEFINE  bay window floor:
#declare Floor_BayWindow =
object {
   intersection {
      object { Floor_One  scale < 15, 1.75, 2.25 >
                          translate y*0.25 }
      object { plane { x, 0 
                       rotate y*50
                       translate <  6.5, 0, 0 > } }
      object { plane { x, 0 
                       rotate y*130 
                       translate < -6.5, 0, 0 > } }
                } //end intersection
      #if ( ShowDetails )
         texture { T_Stone2  scale < 15, 2, 2 > } 
      #else
         texture { Gray_Tex }
      #end 
       } // end bay window floor
 
// **************************************************************

//    DEFINE  bay window roof section
#declare Roof_BayWindow =
object {
   intersection {
      object { Floor_One  scale < 7.5, 1.5, 2 > }
      object { plane { x, 0 
                       rotate y*45
                       translate <  5.5, 0, 0 > } }
      object { plane { x, 0 
                       rotate y*135 
                       translate < -5.5, 0, 0 > } }
                } //end intersection
   texture { Gray50_Tex }
       } // end bay window roof
 
// **************************************************************

//    DEFINE  some trim for the roof:
#declare Roof_Trim =
union {
   object { UnitBox 
            scale < 2, 1, 1.75 >  translate < -12.5, 1.25, -40.5 >
          }//end left front corner
   object { UnitBox 
            scale < 2, 1, 1.75 >  translate <  12.5, 1.25, -40.5 >
          }//end right front corner
   object { UnitBox 
            scale < 2, 1, 1.75 >  translate < -12.5, 1.25,  40.5 >
          }//end left rear corner
   object { UnitBox 
            scale < 2, 1, 1.75 >  translate <  12.5, 1.25,  40.5 >
          }//end right rear corner
   object { CubeX1
            scale < 25.5, 2.1, 2.5 >  translate < 0, 1, -42 >
          }//end lower front trim
   object { CubeX1
            scale < 25.5, 2.1, 2.5 >  translate < 0, 1,  42 >
          }//end lower rear trim
   object { CubeX1
            scale < 19, 2.1, 2.5 >  translate < 0, 1.5, -42 >
          }//end upper front trim
   object { CubeX1
            scale < 19, 2.1, 2.5 >  translate < 0, 1.5, 42 >
          }//end upper rear trim
   object { CubeZ1
            scale < 3, 2, 85 >  translate <  13.5, 1, 0 >
          }//end right trim
   object { CubeZ1
            scale < 3, 2, 85 >  translate < -13.5, 1, 0 >
          }//end left trim
   #if ( ShowDetails )
      texture { T_Stone2  scale < 8, 2, 2 > } 
   #else
      texture { Green_Tex }
   #end 
      } // end union roof trim

// **************************************************************

//    DEFINE  a generic chimney:
#declare Chimney_1 =
union {
   object { CubeY1  scale < 7, 55, 10 > }// end chimney
   object { CubeY1  scale < 8, 1.2, 11 > 
                    translate y*28     }// end chimney collar
   #if ( ShowDetails )
      texture { T_BSBrick scale < 0.75, 0.75, 0.75 > }
   #else
      texture { Goldenrod_Tex }
   #end
      } // end chimney union

// **************************************************************

//    DEFINE  triangular wall panel  w/ semi-circle cut out:
//            scaled to fit w/ APT_Panel_3 & Roof_A_Frame:
#declare Panel_Gable_1 =
object {
   difference {
      object { Panel_Tri_1
               rotate z*45
               scale < 5, 5, 0.75 >
             }//end wall panel
      object { Semi_Circle_1 
               scale < 1.25, 1.25, 1 >
             }//end cut-out
              } // end panel w/ window cut-out 
       } // end tri panel for gabled roof

// *******************************************************************
//          5.  one story of a building: east,west & center versions:
// *******************************************************************

//    DEFINE   an apartment in the building: centered on <0,0,0>:
#declare Apartment_East =
union {
   // floor:
   object { Floor_APT  translate y*-4.75 }

   // framing: exterior: for initial composition:
//   object { APT_EFrame_1  translate <  12.5, 0, 0 > } // e
//   object { APT_SFrame_1  translate <   0, 0, -40 > } // s
//   object { APT_NFrame_1  translate <   0, 0,  40 > } // n
//   object { APT_EFrame_1  translate < -12.5, 0, 0 > } // w

   // framing: interior:
   object { APT_HallPanel_1  translate < 7.5, 0, 0 > }

   // panels:
   object { APT_NPanel_1  translate <     0, 0,  40 > } // n

//   ****  !!!   declared below as options  !!!   ***
//   object { APT_EPanel_1  translate <  12.5, 0,   0 > } // e
//   object { APT_SPanel_1  translate <     0, 0, -40 > } // s
//   object { APT_WPanel_1  translate < -12.5, 0,   0 > } // w
      } // end east end apartment

// **************************************************************

//    DEFINE   an apartment in the building: centered on <0,0,0>:
#declare Apartment_West =
union {
   // floor:
   object { Floor_APT  translate y*-4.75 }

   // framing: exterior: for initial composition only:
//   object { APT_EFrame_1  translate <  12.5, 0, 0 > } // e
//   object { APT_SFrame_1  translate <   0, 0, -40 > } // s
//   object { APT_NFrame_1  translate <   0, 0,  40 > } // n
//   object { APT_EFrame_1  translate < -12.5, 0, 0 > } // w

   // framing: interior:
   object { APT_HallPanel_1  translate < 7.5, 0, 0 > }

   // panels:
   object { APT_NPanel_1  translate <     0, 0,  40 > } // n

//   ****  !!!   declared below as options  !!!   ***
//   object { APT_WPanel_1  translate <  12.5, 0,   0 > } // e
//   object { APT_SPanel_1  translate <     0, 0, -40 > } // s
//   object { APT_EPanel_1  translate < -12.5, 0,   0 > } // w
      } // end west end apartment

// **************************************************************

//    DEFINE   an apartment in the building: centered on <0,0,0>:
#declare Apartment_Center =
union {
   // floor:
   object { Floor_APT  translate y*-4.75 }

   // framing: exterior: for initial composition only:
//   object { APT_EFrame_1  translate <  12.5, 0, 0 > } // e
//   object { APT_SFrame_1  translate <   0, 0, -40 > } // s
//   object { APT_NFrame_1  translate <   0, 0,  40 > } // n
//   object { APT_EFrame_1  translate < -12.5, 0, 0 > } // w

   // framing: interior:
   object { APT_HallPanel_1  translate < 7.5, 0, 0 > }

   // panels:
   object { APT_NPanel_1  translate <     0, 0,  40 > } // n
   object { APT_WPanel_1  translate <  12.5, 0,   0 > } // e
   object { APT_WPanel_1  translate < -12.5, 0,   0 > } // w

//   ****  !!!   declared below as options  !!!   ***
//   object { APT_SPanel_1  translate <     0, 0, -40 > } // s
      } // end one central apartment

// *******************************************************************
//          6.  a whole building: east, west, center versions:
// *******************************************************************

//    DEFINE   the BrownStone Apartment Building: east end of row:
//             center of lowest floor = <0,0,0>:
#declare Brownstone_East =
union {
   // roof:
   #if ( FlatRoof )
      object { Roof_One  scale < 13.5, 1.75, 41.5 >
                         translate y*41
                         texture { Gray50_Tex } }
      object { Roof_Trim  translate < 0, 41, 0 > }
      object { Roof_BayWindow  translate < 0, 41, -43 > }
   #else
      object { Roof_A_Frame  scale < 1, 1, 8.5 >  translate < 0, 42.5, 0 > }
      object { Panel_Gable_1
               scale < 3.7, 3.7, 1 >
               translate < 0, 40, -41 >
               #if ( ShowDetails )
                  texture { T_BSBrick }
               #else
                  texture { Magenta_Tex }
               #end
             } // end gabled roof panel south
      object { Panel_Gable_1
               scale < 3.7, 3.7, 1 >
               translate < 0, 40, 41 >
               rotate y*180
               #if ( ShowDetails )
                  texture { T_BSBrick }
               #else
                  texture { Magenta_Tex }
               #end
             } // end gabled roof panel
      object { Window_Arch_1
               scale < 2.5, 2.5, 1 >
               translate < 0, 40, -41.2 >
             } // semi circle window
      object { Window_Arch_1
               scale < 2.5, 2.5, 1 >
               translate < 0, 40, 41.2 >
               rotate y*180
             } // semi circle window
   #end

   // building:
   #declare WhichFloor = 1;
   #while ( WhichFloor <= 4 )
      #if ( WhichFloor = 1 )
         object { Apartment_East translate y*5  }            // 1st floor
         object { APT_SPanel_2  translate <    0, 5, -40 > } // no bays
         object { APT_EPanel_2  translate < 12.5, 5,   0 > } // grey stone
         #if ( PlainDoor )
            object  { APT_Door_1  translate < 10, 5, -40 > }
         #else
            object  { APT_Door_2  translate < 10, 5, -40 > }
         #end
         #declare WhichFloor = WhichFloor + 1;
      #end
      #if ( WhichFloor = 2 )
#if (ShowDetails)
         object { Apartment_East translate y*15 }             // 2nd floor
         object { APT_SPanel_1  translate <  0.0, 15, -40 > } // bay windows
         object { APT_EPanel_1  translate < 12.5, 15,   0 > } // bricks
         object { APT_Panel_6   translate <  9.8, 15, -40 > } // stairwell
         object { Floor_BayWindow  translate < 0, 10, -43 > }
#end
         #declare WhichFloor = WhichFloor + 1;
      #end
      #if ( WhichFloor = 3 )
#if (ShowDetails)
         object { Apartment_East translate y*25 }             // 3rd floor
         object { APT_SPanel_1   translate < 0.0, 25, -40 > } // bay windows
         object { APT_EPanel_1  translate < 12.5, 25,   0 > } // bricks
         object { APT_Panel_6    translate < 9.8, 25, -40 > } // stairwell
         object { Floor_BayWindow  translate < 0, 20, -43 > }
#end
         #declare WhichFloor = WhichFloor + 1;
      #end
      #if ( WhichFloor = 4 )
#if (ShowDetails)
         object { Apartment_East translate y*35 }             // 4th floor
         object { APT_SPanel_1   translate < 0.0, 35, -40 > } // bay windows
         object { APT_EPanel_1  translate < 12.5, 35,   0 > } // bricks
         object { APT_Panel_6    translate < 9.8, 35, -40 > } // stairwell
         object { Floor_BayWindow  translate < 0, 30, -43 > }
#end
         #declare WhichFloor = WhichFloor + 1;
      #end
   #end  // while loop

   // chimney
   object { Chimney_1  translate  < -11, 27.7, -15 > } // end north
   object { Chimney_1  translate  < -11, 27.5,  15 > } // end south
      } // end brownstone building east

// *******************************************************************

//    DEFINE   the BrownStone Apartment Building: west end of row:
//             center of lowest floor = <0,0,0>:
#declare Brownstone_West =
union {

   // roof:
   #if ( FlatRoof )
      object { Roof_One  scale < 13.5, 1.75, 41.5 >
                         translate y*41
                         texture { Gray50_Tex } }
      object { Roof_Trim  translate < 0, 41, 0 > }
      object { Roof_BayWindow  translate < 0, 41, -43 > }
   #else
      object { Roof_A_Frame  scale < 1, 1, 8.5 >  translate < 0, 42.5, 0 > }
      object { Panel_Gable_1
               scale < 3.7, 3.7, 1 >
               translate < 0, 40, -41 >
               #if ( ShowDetails )
                  texture { T_BSBrick }
               #else
                  texture { Magenta_Tex }
               #end
             } // end gabled roof panel south
      object { Panel_Gable_1
               scale < 3.7, 3.7, 1 >
               translate < 0, 40, 41 >
               rotate y*180
               #if ( ShowDetails )
                  texture { T_BSBrick }
               #else
                  texture { Magenta_Tex }
               #end
             } // end gabled roof panel
      object { Window_Arch_1
               scale < 2.5, 2.5, 1 >
               translate < 0, 40, -41.2 >
             } // semi circle window
      object { Window_Arch_1
               scale < 2.5, 2.5, 1 >
               translate < 0, 40, 41.2 >
               rotate y*180
             } // semi circle window
   #end

   // building:
   #declare WhichFloor = 1;
   #while ( WhichFloor <= 4 )

      #if ( WhichFloor = 1 )
         object { Apartment_West translate y*5  }             // 1st floor
         object { APT_SPanel_2  translate <     0, 5, -40 > } // no bays
         object { APT_EPanel_2  translate < -12.5, 5,   0 > } // grey stone
         #if ( PlainDoor )
            object  { APT_Door_1  translate < 10, 5, -40 > }
         #else
            object  { APT_Door_2  translate < 10, 5, -40 > }
         #end
         #declare WhichFloor = WhichFloor + 1;
      #end  // end 1st floor

      #if ( WhichFloor = 2 )
#if (ShowDetails)
         object { Apartment_West translate y*15 }              // 2nd floor
         object { APT_SPanel_1  translate <   0.0, 15, -40 > } // bay windows
         object { APT_EPanel_1  translate < -12.5, 15,   0 > } // bricks
         object { APT_Panel_6   translate <   9.8, 15, -40 > } // stairwell
         object { Floor_BayWindow  translate < 0, 10, -43 > }
#end
         #declare WhichFloor = WhichFloor + 1;
      #end  // end 2nd floor

      #if ( WhichFloor = 3 )
#if (ShowDetails)
         object { Apartment_West translate y*25 }              // 3rd floor
         object { APT_SPanel_1   translate <  0.0, 25, -40 > } // bay windows
         object { APT_EPanel_1  translate < -12.5, 25,   0 > } // bricks
         object { APT_Panel_6    translate <  9.8, 25, -40 > } // stairwell
         object { Floor_BayWindow  translate < 0, 20, -43 > }
#end
         #declare WhichFloor = WhichFloor + 1;
      #end  // end 3rd floor

      #if ( WhichFloor = 4 )
#if (ShowDetails)
         object { Apartment_West translate y*35 }               // 4th floor
         object { APT_EPanel_1   translate < -12.5, 35,   0 > } // bricks
         object { APT_Panel_6    translate <  9.8, 35, -40 > }  // stairwell
          #if ( FlatRoof )
            object { APT_SPanel_1 translate < 0.0, 35, -40 > } // bay windows
          #else
            object { APT_SPanel_3 translate < 0.0, 35, -40 > } // flat windows
          #end
#end
         #declare WhichFloor = WhichFloor + 1;
      #end  //end 4th floor and roof
   #end  // while loop
      } // end brownstone building west

// **************************************************************

//    DEFINE   the BrownStone Apartment Building: center of row:
//             center of lowest floor = <0,0,0>:
#declare Brownstone_Center =
union {
   // roof:
   object { Roof_One  scale < 12.5, 1.5, 40 >
                      translate y*41
                      texture { Gray50_Tex } }
   object { Roof_Trim translate < 0, 41, 0 > }

   // building:
   #declare WhichFloor = 1;
   #while ( WhichFloor <= 4 )

      #if ( WhichFloor = 1 )
         object { Apartment_Center translate y*5  }           // 1st floor
         object { APT_SPanel_2  translate <     0, 5, -40 > } // no bays
         #if ( PlainDoor )
            object  { APT_Door_1  translate < 10, 5, -40 > }
         #else
            object  { APT_Door_2  translate < 10, 5, -40 > }
         #end
         #declare WhichFloor = WhichFloor + 1;
      #end

      #if ( WhichFloor = 2 )
#if (ShowDetails)
         object { Apartment_Center translate y*15 }            // 2nd floor
         object { APT_SPanel_1  translate <   0.0, 15, -40 > } // bay windows
         object { APT_Panel_6   translate <   9.8, 15, -40 > } // stairwell
         object { Floor_BayWindow  translate < 0, 10, -43 > }
#end
         #declare WhichFloor = WhichFloor + 1;
      #end

      #if ( WhichFloor = 3 )
#if (ShowDetails)
         object { Apartment_Center translate y*25 }            // 3rd floor
         object { APT_SPanel_1   translate <  0.0, 25, -40 > } // bay windows
         object { APT_Panel_6    translate <  9.8, 25, -40 > } // stairwell
         object { Floor_BayWindow  translate < 0, 20, -43 > }
#end
         #declare WhichFloor = WhichFloor + 1;
      #end

      #if ( WhichFloor = 4 )
#if (ShowDetails)
         object { Apartment_Center translate y*35 }            // 4th floor
         #if ( ShowBalcony )
            object { APT_SPanel_3  translate <  0.0, 35, -40 > } // balcony
         #else
            object { APT_SPanel_1  translate <  0.0, 35, -40 > } // bay windows
            object { Roof_BayWindow  translate < 0, 41, -43 > }
         #end
         object { APT_Panel_6    translate <  9.8, 35, -40 > } // stairwell
         object { Floor_BayWindow  translate < 0, 30, -43 > }
#end
         #declare WhichFloor = WhichFloor + 1;
      #end
   #end  // while loop

   // chimney
   object { Chimney_1  translate < -11, 27.7, -15 > } // end north
   object { Chimney_1  translate < -11, 27.5,  15 > } // end south
      } // end brownstone building center


// *******************************************************************
//          7.  define a macro to render complete building:
// *******************************************************************


//    DEFINE  a macro to render one whole block of apts Nbr_Units wide:
#macro BH_Make_Building (Start_X, APT_Width, Nbr_Units)

  #local BH_X_Offset = 25;
  #local BH_Count = 0;

  union {
     object { Brownstone_West  
              scale < 1*ft, 1*ft, 1*ft >
              translate < Start_X, 0, 0 >
            }//end West bldg

     #while (BH_Count < (Nbr_Units-2))      //-2 to allow for e & w apts
        object { Brownstone_Center  
                 scale < 1*ft, 1*ft, 1*ft >
                 translate < (Start_X)+(APT_Width+BH_X_Offset), 0, 0 >
               }//end a Center bldg
        #declare BH_Count = BH_Count + 1;
        #declare BH_X_Offset = BH_X_Offset + APT_Width;
     #end //while statement
  
     object { Brownstone_East  
              scale < 1*ft, 1*ft, 1*ft >
              translate < ((Start_X)+(APT_Width*Nbr_Units)-APT_Width), 0, 0 >
            }//end East bldg
        }// end whole building union

#end  //of macro make a brownstone building


// *******************************************************************
// *******************************************************************
//       B. A Courtyard Apartment Building:
// *******************************************************************
//          1. Frames:  used for designing initial layout:
// *******************************************************************

/*   --------COMMENTED OUT TO SAVE PARSING TIME-------- 

//    DEFINE  foyer front wall frames:  30x 10y 1z:
#declare F_Foyer_Front =
union {
   object { Frame_D  translate <  12.5, 0, 0 > } // left
   object { Frame_D  translate <   7.5, 0, 0 > } // 
   object { Frame_A  translate <     0, 0, 0 > } // middle
   object { Frame_D  translate <  -7.5, 0, 0 > } // 
   object { Frame_D  translate < -12.5, 0, 0 > } // right
   #if ( ShowDetails )
      texture { T_Wood2 }
   #else
      texture { Magenta_Tex }
   #end 
      } // end foyer front wall frames

// **************************************************************

//    DEFINE  foyer rear wall frames:  30x 10 y 1z:
#declare F_Foyer_Rear_1 =
union {
   object { Frame_A  translate <  10, 0, 0 > } // right
   object { Frame_A  translate <   0, 0, 0 > } // middle
   object { Frame_A  translate < -10, 0, 0 > } // left
   #if ( ShowDetails )
      texture { T_Wood2 }
   #else
      texture { Red_Tex }
   #end 
      } // end rear wall frames

// **************************************************************

//    DEFINE  foyer side wall frames:  30x 10 y 1z:
#declare F_Foyer_Side =
union {
   object { Frame_A  rotate y*90  translate < 0, 0,  10 > } // rear 
   object { Frame_A  rotate y*90  translate < 0, 0,   0 > } // middle
   object { Frame_A  rotate y*90  translate < 0, 0, -10 > } // front 
   #if ( ShowDetails )
      texture { T_Wood2 }
   #else
      texture { Blue_Tex }
   #end 
      } // end side walls frames

// **************************************************************

//    DEFINE  frames for center foyer: allows door:
#declare APT_Foyer_Frames_1 =
union {
   object { F_Foyer_Front  translate z*-15 } // south
   object { F_Foyer_Rear_1 translate  z*15 } // north
   object { F_Foyer_Side   translate  x*15 } // west
   object { F_Foyer_Side   translate x*-15 } // east
      } // end courtyard frames 1

// **************************************************************

//    DEFINE  frames for bldg wings: generic:
#declare APT_Foyer_Frames_2 =
union {
   object { F_Foyer_Rear_1  translate z*-15 } // south
   object { F_Foyer_Rear_1  translate  z*15 } // north
   object { F_Foyer_Side    translate  x*15 } // west
   object { F_Foyer_Side    translate x*-15 } // east
      } // end courtyard frames 2

*/

// ******************************************************************* 
//          2. Panels: used for final render:
// ******************************************************************* 

//    DEFINE  front panels: 30x 10y 1z: windows, white stone: 
#declare P_Foyer_Front_1 =
union {
   object { CubeX1 scale< 31, 2.1 , 2.5 >        // top of wall
                   translate y*5
                   #if ( ShowDetails )
                      texture { T_Stone1 }
                   #else
                      texture { Brown_Tex }
                   #end
          }// end top of all panels
   object { Window_Panel_5                    translate < -3.8, 0, 0 > }
   object { Window_Panel_5                    translate <  3.8, 0, 0 > }
   object { Pane_Square_2  scale < 5, 10, 1 > translate < -7.5, 0, 0 > }
   object { Pane_Square_2  scale < 5, 10, 1 > translate <  7.5, 0, 0 > }
   union {
      object { Panel_D scale < 1, 1, 1 > translate < -12.5, 0, 0 > }
      object { Panel_D scale < 1, 1, 1 > translate <  12.5, 0, 0 > }
      #if ( ShowDetails )         
         texture { T_BH_BSBrick }
      #else
         texture { White_Tex }
      #end
         }//end brick panels
      } // end union front wall  v.1

// **************************************************************

//    DEFINE  front panels: 30x 10y 1z: 2nd floor: all windows: 
#declare P_Foyer_Front_2 =
union {
   object { CubeX1 scale< 31, 2.1 , 2.5 >        // top of wall
                   translate y*5
                   #if ( ShowDetails )
                      texture { T_Stone1 }
                   #else
                      texture { Brown_Tex }
                   #end
          }// end top of all panels
   object { Window_Panel_5  translate < -8.75, 0, 0 > }
   object { Window_Panel_5  translate < -6.25, 0, 0 > }
   object { Window_Panel_5  translate < -3.75, 0, 0 > }
   object { Window_Panel_5  translate < -1.25, 0, 0 > }
   object { Window_Panel_5  translate <  1.25, 0, 0 > }
   object { Window_Panel_5  translate <  3.75, 0, 0 > }
   object { Window_Panel_5  translate <  6.25, 0, 0 > }
   object { Window_Panel_5  translate <  8.75, 0, 0 > }
   union {
      object { Panel_D scale < 1, 1, 1 > translate < -12.5, 0, 0 > }
      object { Panel_D scale < 1, 1, 1 > translate <  12.5, 0, 0 > }
      #if ( ShowDetails )         
         texture { T_BH_BSBrick }
      #else
         texture { White_Tex }
      #end
         }//end brick panels
      } // end front panel  v.2

// **************************************************************

//    DEFINE  foyer front panels: 30x 10y 1z: w/balcony: 
#declare P_Foyer_Front_3 =
union {
   object { CubeX1 scale< 31, 2.1 , 2.5 >        // top of wall
                   translate y*5
                   #if ( ShowDetails )
                      texture { T_Stone1 }
                   #else
                      texture { Brown_Tex }
                   #end
          }// end top of all panels
   union {
      object { Panel_A  translate < -10, 0, 0 > } // left panel
      object { Panel_A  translate <  10, 0, 0 > } // right panel
      #if ( ShowDetails )         
         texture { T_BSBrick  scale < 1.25, 1.25, 1.25 > }
      #else
         texture { Coral_Tex }
      #end
         }//end l & r panel union
   object { APT_Panel_5 }                        // center
   #if ( ShowBalcony )
      object { Balcony_1  scale < 1, 1, 1 >
                          translate < 0, -2.5, 0.5 > }  // end balcony
   #end
      } // end front panels  v.3

// *************************************************************

//    DEFINE  foyer front panels:  30x 10 y 5z: w/bay windows:
#declare P_Foyer_Front_4 =
union {
   // walls:
   object { CubeX1 scale< 31, 2.1 , 2.5 >        // top of wall
                   translate y*5
                   #if ( ShowDetails )
                      texture { T_Stone1 }
                   #else
                      texture { Brown_Tex }
                   #end
          }// end top of all panels
   //l & r panels:
   union {
      object { Panel_A scale < 0.85, 1, 1 > translate < -11, 0, 0 > }
      object { Panel_A scale < 0.85, 1, 1 > translate <  11, 0, 0 > }
      #if ( ShowDetails )         
         texture { T_BSBrick  scale < 1.25, 1.25, 1.25 > }
      #else
         texture { Coral_Tex }
      #end
          } //end union l & r panels
   //center panel:
   object { APT_Bay_Windows }
   object { Floor_BayWindow  translate < 0, -5, -2.5 > }
      } // end front panels  v.4: bay windows

// ******************************************************************* 

//    DEFINE  front panels: 30x 10y 1z: windows, white stone: 
#declare P_Foyer_Front_5 =
union {
   object { CubeX1 scale< 31, 2.1 , 2.5 >        // top of wall
                   translate y*5
                   #if ( ShowDetails )
                      texture { T_Stone1 }
                   #else
                      texture { Brown_Tex }
                   #end
          }// end top of all panels
   object { Window_Panel_3  translate < -10, 0, 0 > } // left
   object { Window_Panel_3  translate <  10, 0, 0 > } // right
   object { Panel_A  #if ( ShowDetails )              // cntr
                        texture { T_BH_BSBrick  scale < 1.25, 1, 1 > }
                     #else
                        texture { Magenta_Tex }
                     #end
          } //end cnter panel
      } // end union front wall  v.5

// *************************************************************
// *************************************************************

//    DEFINE  foyer rear panels:  30x 10 y 1z: 2 centered windows:
#declare P_Foyer_Rear_1 =
union {
   object { CubeX1 scale< 31, 2.1 , 2.5 >        // above
                   translate y*5
                   #if ( ShowDetails )
                      texture { T_Stone1 }
                   #else
                      texture { Brown_Tex }
                   #end
          }// end top of all panels
   object { APT_Panel_5 }                             // cntr
   union {
      object { Panel_A      translate <  10, 0, 0 > } // right
      object { Panel_A      translate < -10, 0, 0 > } // left
      #if ( ShowDetails )
         texture { T_BSBrick  scale < 1.25, 1.25, 1.25 > }
      #else
         texture { Yellow_Tex }
      #end
         } //end inner union
      } // end union foyer rear panels v.1

// ************************************************************** 

//    DEFINE  foyer rear panels:  30x 10 y 1z:
#declare P_Foyer_Rear_2 =
union {
   object { CubeX1 scale< 31, 2.1 , 2.5 >        // above
                   translate y*5
                   #if ( ShowDetails )
                      texture { T_Stone1 }
                   #else
                      texture { Brown_Tex }
                   #end
          }// end top of all panels
   object { Window_Panel_3  translate x*-10 }    // left
   object { Window_Panel_3  translate x*10 }     // right
   object { Panel_A  #if ( ShowDetails )         // center
                        texture { T_BSBrick  scale < 1.25, 1.25, 1.25 > }
                     #else
                        texture { Yellow_Tex }
                     #end
          } //end cnter panel
      } // end union foyer rear panels v.2

// **************************************************************
// **************************************************************

//    DEFINE  foyer side wall panels:  1x 10 y 30z: street level:
#declare P_Foyer_Side_1 =
union {
   object { CubeZ1 scale< 2.5, 2.1 , 31 >        // top of wall
                   translate y*5
                   #if ( ShowDetails )
                      texture { T_Stone1 }
                   #else
                      texture { Brown_Tex }
                   #end
          }// end top of all panels
   object { Window_Panel_3  rotate y*90  translate <0,0, 10> } // rear
   object { Window_Panel_3  rotate y*90  translate <0,0,-10> } // front
   object { Panel_A  rotate y*90                               // center
                     #if ( ShowDetails )         
                        texture { T_BH_BSBrick  scale < 1.25, 1, 1 > }
                     #else
                        texture { Green_Tex }
                     #end
          } //end cnter panel
      } // end foyer side panels v.1

// *************************************************************

//    DEFINE  foyer side panels: 1x 10 y 30z: bay windows:
#declare P_Foyer_Side_2 =
union {
   //top of wall:
   object { CubeZ1 scale< 2.5, 2.1 , 31 >
                   translate y*5
                   #if ( ShowDetails )
                      texture { T_Stone1 }
                   #else
                      texture { Brown_Tex }
                   #end
          }// end top of all panels
   //center panel:
   object { APT_Bay_Windows  rotate y*90
                             scale < 1, 1, 1 >
                             translate < 0, 0, 0 > }
   object { Floor_BayWindow  translate < 0, -5, -2.5 >
                             rotate y*90 }
   //left & right panels:
   union {
      object { Panel_A rotate y*90 scale < 1, 1, 0.75 > translate z*11  }
      object { Panel_A rotate y*90 scale < 1, 1, 0.75 > translate z*-11 }                              
      #if ( ShowDetails )         
         texture { T_BSBrick  scale < 1.25, 1.25, 1.25 > }
      #else
         texture { Coral_Tex }
      #end
         }//end l & r panels
      } // end foyer side panels v.2

// *************************************************************

//    DEFINE  foyer side panels: 1x 10 y 30z: balcony:
#declare P_Foyer_Side_3 =
union {
   //top of wall:
   object { CubeZ1 scale< 2.5, 2.1 , 31 >
                   translate y*5
                   #if ( ShowDetails )
                      texture { T_Stone1 }
                   #else
                      texture { Brown_Tex }
                   #end
          }// end top of all panels
   //center panel:
   object { APT_Panel_5 rotate y*90 }
   #if ( ShowBalcony )
      object { Balcony_1  rotate y*90
                          scale < 1, 1, 1 >
                          translate < 0, -2.5, 0.5 > }  // end balcony
   #end
   //left & right panels:
   union {
      object { Panel_A rotate y*90 scale < 1, 1, 1 > translate z*10  }
      object { Panel_A rotate y*90 scale < 1, 1, 1 > translate z*-10 }                              
      #if ( ShowDetails )         
         texture { T_BSBrick  scale < 1.25, 1.25, 1.25 > }
      #else
         texture { Orange_Tex }
      #end
         }//end l & r panels
      } // end foyer side panels v.3

// **************************************************************
// **************************************************************

//    DEFINE  blank interior walls: 30x 10y 1z:
#declare P_Foyer_Blank =
union {
   object { Panel_A  translate <  10, 0, 0 > }   // right
   object { Panel_A  translate < -10, 0, 0 > }   // left
   object { Panel_A  translate <   0, 0, 0 > }   // cntr
   texture { Brown_Tex }
      } // end blank panels

// ******************************************************************* 
//          3. Complete Wall Units:
// ******************************************************************* 

//    DEFINE  exteriors common to all floors:
#declare Courtyard_Common_Ext =
union {
   object { P_Foyer_Rear_1  translate <   0, 0, 15 > } //cntr
   object { P_Foyer_Rear_2  translate <  30, 0, 15 > } // se
   object { P_Foyer_Rear_2  translate < -30, 0, 15 > } // sw
      } // end union common ext elements

// **************************************************************

//    DEFINE  interiors common to all floors:
#declare Courtyard_Common_Int =
union {
   object { P_Foyer_Blank rotate y*90 translate <  15, 0,   0 > } //w
   object { P_Foyer_Blank rotate y*90 translate < -15, 0,   0 > } //e
   object { P_Foyer_Blank             translate <  30, 0, -15 > } //w
   object { P_Foyer_Blank             translate < -30, 0, -15 > } //e
   object { P_Foyer_Blank             translate <   0, 0,  10 > } //cntr
      } // end union common int elements

// **************************************************************

//    DEFINE  exteriors 1st floor:
#declare Courtyard_Storey_One =
union {
   object { P_Foyer_Front_1 translate <   0, 0, -15 > } //cntr
   object { P_Foyer_Front_5 translate <  30, 0, -45 > } //e
   object { P_Foyer_Front_5 translate < -30, 0, -45 > } //w 
   object { P_Foyer_Side_1  translate < -15, 0, -30 > } //sw
   object { P_Foyer_Side_1  translate <  15, 0, -30 > } //se
   object { P_Foyer_Side_1  translate < -45, 0,   0 > } //nw
   object { P_Foyer_Side_1  translate <  45, 0,   0 > } //ne
   object { P_Foyer_Side_1  translate < -45, 0, -30 > } //sw
   object { P_Foyer_Side_1  translate <  45, 0, -30 > } //se
      } // end union storey one

// **************************************************************

//    DEFINE  exteriors 2nd floor:
#declare Courtyard_Storey_Two =
union {
   object { P_Foyer_Front_2 translate <   0, 0, -15 > }
   object { P_Foyer_Front_4 translate <  30, 0, -45 > } // e
   object { P_Foyer_Front_4 translate < -30, 0, -45 > } // w 
   object { P_Foyer_Side_2  translate <  15, 0, -30 > } //se
   object { P_Foyer_Side_2  rotate y*180
                            translate <  45, 0, -30 > } //se
   object { P_Foyer_Side_2  translate < -45, 0,   0 > } //cntr
   object { P_Foyer_Side_2  rotate y*180
                            translate <  45, 0,   0 > } //cntr
   object { P_Foyer_Side_2  translate < -45, 0, -30 > } //sw
   object { P_Foyer_Side_2  rotate y*180
                            translate < -15, 0, -30 > } //sw
      } // end union storey two

// **************************************************************

//    DEFINE  exteriors top floor:
#declare Courtyard_Storey_Top =
union {
   object { P_Foyer_Front_3 translate <   0, 0, -15 > } //cntr
   object { P_Foyer_Front_4 translate < -30, 0, -45 > } //sw
   object { P_Foyer_Front_4 translate <  30, 0, -45 > } //se
   object { P_Foyer_Side_2  translate <  15, 0, -30 > } //se yard
   object { P_Foyer_Side_2  rotate y*180
                            translate < -15, 0, -30 > } //sw yard
   object { P_Foyer_Side_2  translate < -45, 0,   0 > } //nw
   object { P_Foyer_Side_2  rotate y*180
                            translate <  45, 0,   0 > } //ne
   object { P_Foyer_Side_2  translate < -45, 0, -30 > } //sw
   object { P_Foyer_Side_2  rotate y*180
                            translate <  45, 0, -30 > } //se
   //roofs for bays:
   object { Floor_BayWindow  translate < -30, 5, -47.5 > }//sw
   object { Floor_BayWindow  translate <  30, 5, -47.5 > }//se
   object { Floor_BayWindow  rotate y*90
                             translate < -47.5, 5,   0 > }//nw
   object { Floor_BayWindow  rotate y*-90
                             translate <  47.5, 5,   0 > }//ne
   object { Floor_BayWindow  rotate y*90
                             translate < -47.5, 5, -30 > }//sw
   object { Floor_BayWindow  rotate y*-90
                             translate <  47.5, 5, -30 > }//se
   object { Floor_BayWindow  rotate y*-90
                             translate < -12.5, 5, -30 > }//yard
   object { Floor_BayWindow  rotate y*90
                             translate <  12.5, 5, -30 > }//yard
      } // end union storey top

// **************************************************************

//    DEFINE  exteriors any other floor:
#declare Courtyard_Storey_Other =
union {
   object { P_Foyer_Front_3 translate < 0, 0, -15 > }
   object { P_Foyer_Front_4 translate < -30, 0, -45 > } //sw
   object { P_Foyer_Front_4 translate <  30, 0, -45 > } //se
   object { P_Foyer_Side_2  translate <  15, 0, -30 > } //se
   object { P_Foyer_Side_2  rotate y*180
                            translate < -15, 0, -30 > } //sw
   object { P_Foyer_Side_2  translate < -45, 0,   0 > } //cntr
   object { P_Foyer_Side_2  rotate y*180
                            translate <  45, 0,   0 > } //cntr
   object { P_Foyer_Side_2  translate < -45, 0, -30 > } //sw
   object { P_Foyer_Side_2  rotate y*180
                            translate <  45, 0, -30 > } //se
      } // end union any other storey

// **************************************************************
// **************************************************************

//    DEFINE  courtyard front ornamentation:
#declare Courtyard_Front_Ornaments =
union {
   object { Roof_A_Frame  scale < 0.9, 0.45, 0.20 > 
                          translate <  0, 6, -15 > }
   object { Panel_Gable_1
            scale < 2.8, 1.3, 2.25 >
            translate < 0, 5, -15 >
            #if ( ShowDetails )
               texture { T_Stone2  scale < 5, 4, 3 > }
            #else
               texture { Magenta_Tex }
            #end
          } // end gabled roof panel
   object { Window_Arch_2
            scale < 2.8, 1.31, 1.45 >
            translate < 0, 5, -15 >
             } // semi circle medalion

   #if ( ShowColumns )
   // Columns by (C) Nathan G. B. O'Brien  1997
      #declare Temp_Vers = version;    // Save original version value
      #version 3.0                     // Change to 3.0 mode
      #include "13_col.inc"
      #declare column_flute = off
      #declare col_scale_sm = < 4, 4.3, 4 >
      #declare col_scale_lg = < 6,  17, 6 >
      //around front door:
      object { column_doric scale col_scale_lg translate < -15, -5.4, -15 > }
      object { column_doric scale col_scale_sm translate < -10, -5.4, -15 > }
      object { column_doric scale col_scale_sm translate <  -5, -5.4, -15 > }
      object { column_doric scale col_scale_sm translate <   5, -5.4, -15 > }
      object { column_doric scale col_scale_sm translate <  10, -5.4, -15 > }
      object { column_doric scale col_scale_lg translate <  15, -5.4, -15 > }
      //corners of bldg:
      object { column_doric scale col_scale_lg translate < -45, -5,  15 > } //nw
      object { column_doric scale col_scale_lg translate < -45, -5, -45 > } //sw
      object { column_doric scale col_scale_lg translate <  45, -5,  15 > } //ne
      object { column_doric scale col_scale_lg translate <  45, -5, -45 > } //se
      //courtyard:
      object { column_doric scale col_scale_lg translate < -15, -5, -15 > } //nw
      object { column_doric scale col_scale_lg translate < -15, -5, -45 > } //sw
      object { column_doric scale col_scale_lg translate <  15, -5, -15 > } //ne
      object { column_doric scale col_scale_lg translate <  15, -5, -45 > } //se
      #version Temp_Vers;              // Restore original #version
   #end // if Show Columns

      } // union ornaments

// **************************************************************

//    DEFINE  courtyard roofing:
#declare Courtyard_Roof =
union {
   object { Roof_One scale < 46, 1, 16 > translate y*5 } // cntr
   object { Roof_One scale < 16, 1, 16 > translate <  30, 5, -30 > } // se
   object { Roof_One scale < 16, 1, 16 > translate < -30, 5, -30 > } // sw
   object { Roof_A_Frame  scale < 1.3, 0.66, 6.75 > 
                          translate < -30, 7, -15 > } // west 
   object { Roof_A_Frame  scale < 1.3, 0.66, 6.75 > 
                          translate <  30, 7, -15 > } // east
   //n & s roof end panels:
   union {    
      object { Panel_Gable_1 
               scale <4.4, 2.5, 2.25> translate <-30, 5, -45> } //w 
      object { Panel_Gable_1 
               scale <4.4, 2.5, 2.25> translate < 30, 5, -45> } //e 
      #if ( ShowDetails )
         texture { T_Stone2  scale < 5, 4, 2 > }
      #else
         texture { Magenta_Tex }
      #end
      }// end union gable 1
   //insets in gables:
   object { Window_Arch_2                             // west
            scale < 4, 2, 2 >                 
            translate < -30, 5, -45 >
             } // semi circle medalion
   object { Window_Arch_2                             // east
            scale < 4, 2, 2 >
            translate <  30, 5, -45 >
             } // semi circle medalion
   //center roof:
   intersection {                                     // cntr
      object { UnitBox  scale < 30, 3, 14 > }
      object { plane { y, 10  hollow on } 
               rotate x*-60 } //front
      object { plane { y, 10  hollow on } 
               rotate x*60  } //rear
      translate y*7.5
       } // end cntr roof box
   #if ( ShowDetails )
      texture { Gray25_Tex }
   #else
      texture { Gray_Tex }
   #end
      } // end courtyard roof

// **************************************************************

//    DEFINE  courtyard flooring:
#declare Courtyard_Floor =
union {
   object { Floor_One scale < 45, 0.25, 15 > translate y*-5 }// center
   object { Floor_One scale < 15, 0.25, 15 > translate < -30, -5, -30 > } //sw
   object { Floor_One scale < 15, 0.25, 15 > translate <  30, -5, -30 > } //se
   texture { Tan_Tex }
      } // end union floors

// **************************************************************

//    DEFINE  the actual courtyard this building overlooks:
#declare The_Courtyard =
union {
   object { CubeZ1 scale < 15, 1.25, 30 > translate < 0, 0, -30 > 
                   texture { Gray75_Tex } 
          } //end sidewalk
   //planter boxes:
   union {
     #local Go_X1 = 12.5;
     #local Go_X2 = -12.5;
     #local Go_Y = 0.5;
     #local Go_Z = -40;
     #local Looper = 1;
     #while ( Looper <= 3)
       union {
         object { CubeY1 scale < 4, 2, 7 > 
                         translate < Go_X1, Go_Y, Go_Z> } //east
         object { CubeY1 scale < 4, 2, 7 > 
                         translate < Go_X2, Go_Y, Go_Z> } //west
         #if ( ShowDetails )
            texture { T_Stone1 }
         #else
            texture { Red_Tex }
         #end
             }// end boxes
       union {
         object { Sphere scale 1.5  
                         translate < Go_X1, Go_Y+2, Go_Z > } //bottom
         object { Sphere scale 1  
                         translate < Go_X1, Go_Y+3.5, Go_Z > } //top
         object { Sphere scale 1.5  
                         translate < Go_X2, Go_Y+2, Go_Z > } //bottom
         object { Sphere scale 1  
                         translate < Go_X2, Go_Y+3.5, Go_Z > } //top
         #if ( ShowDetails )
            texture { Green_Tex }      //change later!!!!!!!!!!!!!!!
         #else
            texture { Green_Tex }
         #end
             }// end bushes
         #local Looper = Looper + 1;
         #local Go_Z = Go_Z + 10;
     #end  //loop 1 
         }//end planter boxes
      } // end the courtyard union


// *******************************************************************
// *******************************************************************
//          4.  Complete Building:
// *******************************************************************


//    DEFINE  macro for apt building w/ courtyard:

#macro  BH_Courtyard_Building ( NbrStoreys )
   // initialize counters:
   #local WhichFloor = 1;              // start parser at 1st floor
   #local Elevation = 5;               // move bldg to ground level

union {
   // set loop in motion:
   #while ( WhichFloor <= NbrStoreys )

   // *****************************************
   // 1. involk elements common to all storeys:
   // frames: for planning layout:
//   object { APT_Foyer_Frames_2  translate <  30, Elevation,   0 > } // e
//   object { APT_Foyer_Frames_2  translate < -30, Elevation,   0 > } // w
//   object { APT_Foyer_Frames_2  translate <  30, Elevation, -30 > } // se
//   object { APT_Foyer_Frames_2  translate < -30, Elevation, -30 > } // sw

   // exterior walls: for final render:
   object { Courtyard_Common_Ext  translate y*Elevation }
   // interior walls: for final render:
   object { Courtyard_Common_Int  translate y*Elevation }
   // floor:
   object { Courtyard_Floor  translate y*Elevation }


   // *******************************************
   // 2. involk elements specific to this storey:
   #switch ( WhichFloor )

   //***************************************
   #case ( 1 )  // 1st storey, ground floor:
      //frames: for planning layout:
//      object { APT_Foyer_Frames_1  translate y*Elevation }

      //exterior panels: for final render:
      object { Courtyard_Storey_One  translate y*Elevation }

      //front door and ornamentation:
      object { APT_Door_1  translate < 0, Elevation, -15 > }
      object { Courtyard_Front_Ornaments  translate y*Elevation }
      object { The_Courtyard }

      // chimney
      object { Chimney_1  translate < -16, 27.5, -20.0 > } // sw
      object { Chimney_1  translate < -16, 27.5,   7.5 > } // nw
      object { Chimney_1  translate <  16, 27.5, -20.0 > } // se
      object { Chimney_1  translate <  16, 27.5,   7.5 > } // ne
   #break // end of 1st floor specifics


   //***************************************
   #case ( 2 )  // 2nd storey
      //frames: for planning layout:
//      object { APT_Foyer_Frames_1  translate y*Elevation }

      //exterior panels: for final render:
      object { Courtyard_Storey_Two  translate y*Elevation }
   #break // end of 2nd floor


   //***************************************
   #case ( NbrStoreys )// if this is top floor, add roof & stuff:
      //frames: for planning layout:
//      object { APT_Foyer_Frames_2  translate y*Elevation } 

      //exterior panels: for final render:
      object { Courtyard_Storey_Top  translate y*Elevation }

      //roof:
      object { Courtyard_Roof  translate y*Elevation }
   #break  // end of top floor


   //***************************************
   #else  // if any other floor except those listed above:
      //frames: for planning layout:
//      object { APT_Foyer_Frames_2  translate y*Elevation }

      //panels: for final render:
      object { Courtyard_Storey_Other  translate y*Elevation }

   #end // end case switches

   // incriment counters
   #declare Elevation = Elevation + 10;  // increment +y per storey
   #declare WhichFloor = WhichFloor + 1; // increment current storey       

   #end // main while loop
      } // end building union

#end // courtyard building macro


// *******************************************************************
// *******************************************************************
//  BH_BROWN00.INC      Michael Brendan Hurley     (C) April-Aug 2000
// www.geocities.com/mbrendanh/                       mbhcgc@saber.net
// *******************************************************************
// *******************************************************************
