//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 9 lights, 16 materials and 32 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.2 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 07/06/2000    (06.07.2000)
//

/*
  (c) 2000 Dennis McDaniel
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray V3.2 For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.018
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 9
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera01
  location  <     23.168,      -8.898,      26.415>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.26060,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         30.00000    // Vertical      24.000
  look_at   <      1.190,       1.970,       4.591>
}

//
// *******  L I G H T S *******
//

#declare Light001 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.871, 0.724>*1.5000
  fade_distance  1.5
  fade_power 1.0
  translate  3.0*z
}


//
// ********  MATERIALS  *******
//

#include "candelabra.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare Wall1 = difference {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <0.0625, 1.499, 1.499>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <0.375, 0.125, 1.5>
    rotate -80.0*z
    translate  <0.15, 1.25, 0.0>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <0.375, 0.125, 1.5>
    rotate 80.0*z
    translate  <0.15, -1.25, 0.0>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <0.375, 0.125, 1.5>
    rotate <-90.0, -80.0, 0.0>
    translate  <0.15, 0.0, -1.25>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <0.375, 0.125, 1.5>
    rotate <-90.0, 80.0, 0.0>
    translate  <0.15, 0.0, 1.25>
  }
  translate  <1.575, 0.0, 1.5>
  material {
    Glass
  }
}
#declare RndCube001 = merge {
  sphere { <0.0000, 0.0000, 1.5000>, 0.0750 }
  sphere { <0.0000, 0.0000, -1.5000>, 0.0750 }
  cylinder { <0.0000, 0.0000, -1.5000>, <0.0000, 0.0000, 1.5000>, 0.0750 }
// Attributes returned success!
  material {
    Solder
  }
  translate  <1.5, -1.5, 1.5>
}
#declare RndCube002 = object {
  object { // RndCube002->RndCube001
    RndCube001
    rotate -90.0*y
    translate  <1.5, 0.0, 1.5>
  }
}
#declare Group001 = union {
  object { RndCube001 }
  object { RndCube002 }
  object { // RndCube003->RndCube002
    RndCube002
    rotate -0.0*y
    translate  -3.0*z
  }
}
//
// Include file contains 'Cup1'
//
#include "candelabra.in1"
#declare Cup1 = object {
  Cup1_Raw
  material {
    Glass
  }
}
#declare Candle1 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.6750, 0.6750, 2.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.7500, 0.7500, 1.8500> translate 0.0750*z }
  torus { 0.6750, 0.0750  rotate -x*90 translate  1.9250*z bounded_by { box { <-0.7515, -0.7515, 1.8485>, <0.7515, 0.7515, 2.0015> } } }
  torus { 0.6750, 0.0750  rotate -x*90 translate  0.0750*z bounded_by { box { <-0.7515, -0.7515, -0.0015>, <0.7515, 0.7515, 0.1515> } } }
  material {
    CandleTex
  }
  translate  0.33*z
}
//
// Include file contains 'Flame1'
//
#include "candelabra.in2"
#declare Flame1 = object {
  Flame1_Raw
  material {
    Flame1Tex
    scale <1.026128, 1.0, 0.568887>
    translate <0.013064, 0.000000, 0.535626>
  }
  no_shadow
  hollow
  translate  2.37*z
}
#declare Cube1 = union { // Cube1
  object { Wall1 }
  object { // Wall2->Wall1
    Wall1
    rotate -90.0*z
  }
  object { // Wall3->Wall1
    Wall1
    rotate -180.0*z
  }
  object { // Wall4->Wall1
    Wall1
    rotate 90.0*z
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    material {
      Mirror
    }
    scale <1.499, 1.499, 0.0625>
    translate  0.0625*z
  }
  object { Group001 }
  object { // Group002->Group001
    Group001
    rotate -90.0*z
  }
  object { // Group003->Group001
    Group001
    rotate -180.0*z
  }
  object { // Group004->Group001
    Group001
    rotate 90.0*z
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    material {
      MirrorBack
    }
    scale <1.498, 1.498, 0.02>
  }
  object { Cup1 }
  object { Candle1 }
  cylinder { // Wick1
    <0,0,1>, <0,0,0>, 1 
    material {
      WickTex
      scale <1.506514, 1.0, 0.574528>
      translate <0.000000, 0.000000, -0.698990>
    }
    no_shadow
    scale <0.03, 0.03, 0.5>
    translate  2.25*z
  }
  object { Flame1 }
  object { Light001 }
}
#declare Cube5 = object {
  object { // Cube5->Cube1
    Cube1
    translate  <-3.0, 0.0, 3.0>
  }
}
#declare Cube8 = object {
  object { // Cube8->Cube5
    Cube5
    translate  <6.0, 6.0, 0.0>
  }
}








//
// ********  OBJECTS  *******
//

plane { // Plane001
  z,0
  material {
    LegoBlackTex
  }
  translate  -8.0*z
}


sphere { // Sphere001
  <0,0,0>,1
  material {
    DaySkyTex
  }
  hollow
  scale 1000.0
}


object { // Cube9->Cube8
  Cube8
  translate  <-3.0, -3.0, 3.0>
}


object { Cube8 }


object { // Cube7->Cube5
  Cube5
  translate  6.0*y
}


object { // Cube6->Cube5
  Cube5
  translate  6.0*x
}


object { Cube5 }


object { // Cube4->Cube1
  Cube1
  translate  6.0*y
}


object { // Cube3->Cube1
  Cube1
  translate  <-3.0, 3.0, 0.0>
}


object { // Cube2->Cube1
  Cube1
  translate  <3.0, 3.0, 0.0>
}


object { Cube1 }


disc { // Disc001
  <0,0,0>, <0,0,1>, 1.0
  material {
    DMFWood4
  }
  scale <32.0, 32.0, 8.0>
  translate  <-0.108258, 3.031227, 0.0>
}


