/* Fischertechnik.inc

   by Hartmut Wagener
   
   objects :
   
   FT_pin : Black pin, only used in other objects
   
   FT_stone1 : Stone size 300x150x150, one pin
   
   FT_stone2 : Stone size 150x150x150, one pin
   
   FT_stone3 : Stone size 150x150x150, two pins
   
   FT_stone4 : Stone size 300x150x150, one pin, two holes in the middle
   
   FT_wheel1 : assembly-wheel, used to mount gear-wheels and tires
   
   FT_wheel2 : assembly-wheel with one side plane
   
   FT_wheel3 : big wheel, stones can be mounted on that
   
   FT_axis1 : metal-shaft, 640 long
   
   FT_axis2 : metal-shaft, 1200 long
   
   FT_gearwheel1 : gearwheel with 30 dents
   
   FT_gearwheel2 : gearwheel with 40 dents
   
   FT_plate : mounting-plate

*/    

#declare Weiss =
texture
{
  pigment { rgb <1,1,1> }
  finish
  {
    diffuse 1
    specular 0.3
  }
}

#declare Schwarz =
texture
{
  pigment { rgb <0.2,0.2,0.2> }
  finish
  {
    diffuse 1
    specular 0.3
  }
}

#declare Rot =
texture
{
  pigment { rgb <1,0,0> }
  finish
  {
    diffuse 1
    specular 0.3
  }
}

#declare FT_pin =
object
{
  union
  {
    box
    {
      <-25,55,55>,<-10,95,95>
    }
    box
    {
      <-10,65,65>,<10,85,85>
    }
    box
    {
      <-2,-7,-50>,<20,7,50>
      rotate <45,0,0>
      translate <0,75,75>
    }
    box
    {
      <-2,-7,-50>,<20,7,50>
      rotate <-45,0,0>
      translate <0,75,75>
    }
  }
}

#declare FT_stone1 =
object
{
  union
  {
    difference
    {
      box
      {
        <0,0,0>,<300,150,150>
      }
      cylinder
      {
        <-10,8,75>,<310,8,75>,20
      }
      cylinder
      {
        <-10,75,8>,<310,75,8>,20
      }
      cylinder
      {
        <-10,142,75>,<310,142,75>,20
      }
      cylinder
      {
        <-10,75,142>,<310,75,142>,20
      }
      cylinder
      {
        <292,75,-10>,<292,75,160>,20
      }
      box
      {
        <260,55,-10>,<310,95,40>
      }
      box
      {
        <260,55,110>,<310,95,160>
      }
      texture { Weiss }
    }
    object
    {
      FT_pin
      texture
      { Schwarz }
    }
  }
}

#declare FT_stone2 =
object
{
  difference
  {
    object { FT_stone1 }
    box
    {
      <150,-10,-10>,<310,160,160>
      texture { Weiss }
    }
    cylinder
    {
      <142,75,-10>,<142,75,160>,20
      texture { Weiss }

    }
    box
    {
      <110,55,-10>,<160,95,40>
      texture { Weiss }

    }
    box
    {
      <140,55,110>,<160,95,160>
      texture { Weiss }

    }
  }
}

#declare FT_stone3 =
object
{
  union
  {
    difference
    {
      object { FT_stone1 }
      box
      {
        <150,-10,-10>,<310,160,160>
        texture { Weiss }
      }
    }
    object
    {
      FT_pin
      translate <0,-75,-75>
      rotate <0,180,0>
      translate <150,75,75>
    }
  }
}


#declare FT_stone4 =
object
{
  difference
  {
    object{ FT_stone1 }
    cylinder
    {
      <150,-10,75>,<150,160,75>,20
      texture
      { Weiss }
    }
    cylinder
    {
      <150,75,-10>,<150,75,160>,20
      texture
      { Weiss }
    }
  }
}

#declare FT_wheel1 =
object
{
  union
  {
    difference
    {
      cylinder
      {
        <-30,0,0>,<30,0,0>,130
      }
      difference
      {
        cylinder
        {
          <-10,0,0>,<10,0,0>,150
        }
        cylinder
        {
          <-20,0,0>,<20,0,0>,110
        }
      }
      cylinder
      {
        <-50,0,0>,<50,0,0>,20
      }
    }
    difference
    {
      union
      {
        lathe
        {
          4,<0,-1>,<65,0>,<50,59>,<0,60>
        }
        lathe
        {
          4,<0,-120>,<50,-119>,<65,-59>,<0,-60>
        }
      }
      cylinder
      {
        <0,-150,0>,<0,150,0>,20
      }
      rotate <0,0,90>
      translate <-30,0,0>
    }
    difference
    {
      union
      {
        difference
        {
          box
          {
            <30,-130,-10>,<90,130,10>
          }
          intersection
          {
            difference
            {
              cylinder
              {
                <80,120,-100>,<80,120,100>,50
              }
              cylinder
              {
                <80,120,-100>,<80,120,100>,10
              }
            }
            box
            {
              <80,120,-100>,<100,150,100>
            }
          }
          intersection
          {
            difference
            {
              cylinder
              {
                <80,-120,-100>,<80,-120,100>,50
              }
              cylinder
              {
                <80,-120,-100>,<80,-120,100>,10
              }
            }
            box
            {
              <80,-120,-100>,<100,-150,100>
            }
          }
        }
        difference
        {
          box
          {
            <-30,-130,-10>,<-90,130,10>
          }
          intersection
          {
            difference
            {
              cylinder
              {
                <-80,120,-100>,<-80,120,100>,50
              }
              cylinder
              {
                <-80,120,-100>,<-80,120,100>,10
              }
            }
            box
            {
              <-80,120,-100>,<-100,150,100>
            }
          }
          intersection
          {
            difference
            {
              cylinder
              {
                <-80,-120,-100>,<-80,-120,100>,50
              }
              cylinder
              {
                <-80,-120,-100>,<-80,-120,100>,10
              }
            }
            box
            {
              <-80,-120,-100>,<-100,-150,100>
            }
          }
        }
      }
      cylinder
      {
        <-100,0,0>,<100,0,0>,20
      }
    }
  }
  texture
  {
    Rot
  }
}

#declare FT_wheel2 =
object
{
  union
  {
    difference
    {
      cylinder
      {
        <-30,0,0>,<30,0,0>,130
      }
      difference
      {
        cylinder
        {
          <-10,0,0>,<10,0,0>,150
        }
        cylinder
        {
          <-20,0,0>,<20,0,0>,110
        }
      }
      cylinder
      {
        <-50,0,0>,<50,0,0>,20
      }
    }
    difference
    {
      lathe
      {
        4,<0,-1>,<65,0>,<50,59>,<0,60>
      }
      cylinder
      {
        <0,-150,0>,<0,150,0>,20
      }
      rotate <0,0,90>
      translate <-30,0,0>
    }
    difference
    {
      difference
      {
        box
        {
          <-30,-130,-10>,<-90,130,10>
        }
        intersection
        {
          difference
          {
            cylinder
            {
              <-80,120,-100>,<-80,120,100>,50
            }
            cylinder
            {
              <-80,120,-100>,<-80,120,100>,10
            }
          }
          box
          {
            <-80,120,-100>,<-100,150,100>
          }
        }
        intersection
        {
          difference
          {
            cylinder
            {
              <-80,-120,-100>,<-80,-120,100>,50
            }
            cylinder
            {
              <-80,-120,-100>,<-80,-120,100>,10
            }
          }
          box
          {
            <-80,-120,-100>,<-100,-150,100>
          }
        }
      }
      cylinder
      {
        <-100,0,0>,<100,0,0>,20
      }
    }
  }
  texture
  {
    Rot
  }
}

#declare FT_tire1 =
object
{
  union
  {
    torus
    {
      185,55
    }
    #declare winkel=0;
    #while (winkel<360) 
      difference
      {
        box
        {
          <240,-60,-10>,<180,60,10>
        }
        intersection
        {
          difference
          {
            cylinder
            {
              <230,-100,0>,<230,100,0>,100
            }
            cylinder
            {
              <230,-110,0>,<230,110,0>,10
            }
          }
          box
          {
            <230,-100,-20>,<260,100,20>
          }
        }
      rotate <0,winkel,0>

      }

      #declare winkel=winkel+10;
    #end
  }  
  rotate <0,0,90>
  texture
  { 
    pigment { rgb <0.1,0.1,0.1> }
    finish { diffuse 1 specular 0.1 }
    normal { dents 1 scale 0.1 }
  }
}

#declare FT_axis1 =
object
{
  union
  {
    cylinder
    {
      <20,0,0>,<600,0,0>,20
    }
    sphere
    {
      <20,0,0>,20
    }
    sphere
    {
      <600,0,0>,20
    }
  }
  texture
  {
    pigment { rgb <1,1,1> }
    finish
    {
      diffuse 0.1
      specular 1
      metallic
      reflection 0.8
    }
  }
}

#declare FT_axis2 =
object
{
  union
  {
    cylinder
    {
      <20,0,0>,<1220,0,0>,20
    }
    sphere
    {
      <20,0,0>,20
    }
    sphere
    {
      <1220,0,0>,20
    }
  }
  texture
  {
    pigment { rgb <1,1,1> }
    finish
    {
      diffuse 0.1
      specular 1
      metallic
      reflection 0.8
    }
  }
}

#declare FT_gearwheel1 =
object
{
  union
  {
    difference
    {
      cylinder
      {
        <-30,0,0>,<30,0,0>,210
      }
      cylinder
      {
        <-100,0,0>,<100,0,0>,130
      }
      #declare winkel=0;
      #while (winkel<360)
        cylinder
        {
          <-100,160,0>,<100,160,0>,20
          rotate <winkel,0,0>
        }
        #declare winkel=winkel+360/3;
      #end
      #declare winkel=20;
      #while (winkel<100)
        cylinder
        {
          <100,160,0>,<-15,160,0>,20
          rotate <winkel,0,0>
        }
        #declare winkel=winkel+2;
      #end
      #declare winkel=140;
      #while (winkel<220)
        cylinder
        {
          <100,160,0>,<-15,160,0>,20
          rotate <winkel,0,0>
        }
        #declare winkel=winkel+2;
      #end
      #declare winkel=260;
      #while (winkel<340)
        cylinder
        {
          <100,160,0>,<-15,160,0>,20
          rotate <winkel,0,0>
        }
        #declare winkel=winkel+2;
      #end
    }
    #declare winkel=0;
    #while (winkel<360)
      difference
      {
        box
        {
          <-30,200,-15>,<30,235,15>
        }
        box
        {
          <-50,0,-15>,<50,50,-50>
          rotate <10,0,0>
          translate <0,200,0>
        }
        box
        {
          <-50,0,15>,<50,50,50>
          rotate <-10,0,0>
          translate <0,200,0>
        }
        rotate <winkel,0,0>
      }
      #declare winkel=winkel+360/30;
    #end
    
  }  
  texture
  {
    Rot
  }
}

#declare FT_gearwheel2 =
object
{
  union
  {
    difference
    {
      cylinder
      {
        <-30,0,0>,<-15,0,0>,270
      }
      cylinder
      {
        <-50,0,0>,<50,0,0>,210
      }
    }
    #declare winkel=0;
    #while (winkel<360)
      difference
      {
        box
        {
          <-15,0,-15>,<15,35,15>
        }
        box
        {
          <-50,0,-15>,<50,50,-50>
          rotate <10,0,0>
          translate <0,0,0>
        }
        box
        {
          <-50,0,15>,<50,50,50>
          rotate <-10,0,0>
          translate <0,0,0>
        }
        rotate <0,0,-90>
        translate <0,240,0>
        rotate <winkel,0,0>
      }
      #declare winkel=winkel+360/32;
    #end    
    difference
    {
      cylinder
      {
        <-30,0,0>,<30,0,0>,275
      }
      cylinder
      {
        <-50,0,0>,<50,0,0>,270
      }
    }
    difference
    {
      cylinder
      {
        <-30,0,0>,<30,0,0>,210
      }
      cylinder
      {
        <-100,0,0>,<100,0,0>,130
      }
      #declare winkel=0;
      #while (winkel<360)
        cylinder
        {
          <-100,160,0>,<100,160,0>,20
          rotate <winkel,0,0>
        }
        #declare winkel=winkel+360/3;
      #end
      #declare winkel=20;
      #while (winkel<100)
        cylinder
        {
          <100,160,0>,<-15,160,0>,20
          rotate <winkel,0,0>
        }
        #declare winkel=winkel+2;
      #end
      #declare winkel=140;
      #while (winkel<220)
        cylinder
        {
          <100,160,0>,<-15,160,0>,20
          rotate <winkel,0,0>
        }
        #declare winkel=winkel+2;
      #end
      #declare winkel=260;
      #while (winkel<340)
        cylinder
        {
          <100,160,0>,<-15,160,0>,20
          rotate <winkel,0,0>
        }
        #declare winkel=winkel+2;
      #end
    }
    #declare winkel=0;
    #while (winkel<360)
      difference
      {
        box
        {
          <-30,270,-15>,<30,310,15>
        }
        box
        {
          <-50,0,-15>,<50,50,-50>
          rotate <10,0,0>
          translate <0,270,0>
        }
        box
        {
          <-50,0,15>,<50,50,50>
          rotate <-10,0,0>
          translate <0,270,0>
        }
        rotate <winkel,0,0>
      }
      #declare winkel=winkel+360/40;
    #end
  }  
  texture
  {
    Rot
  }
}

#declare FT_wheel3 =
object
{
  difference
  {
    cylinder
    {
      <-30,0,0>,<30,0,0>,310
    }
    cylinder
    {
      <-50,0,0>,<50,0,0>,130
    }
    torus
    {
      300,30
      rotate <0,0,90>
    }
    #declare winkel=0;
    #while (winkel<360)
      box
      {
        <-100,320,-15>,<100,210,15>
        rotate <winkel,0,0>
      }
      #declare winkel=winkel+360/6;
    #end
    #declare i=0;
    #while (i<6)
      #declare winkel=10;
      #while (winkel<50)
        cylinder
        {
          <-100,230,0>,<100,230,0>,20
          rotate <winkel+i*60,0,0>
        }
        #declare winkel=winkel+2;
      #end
      #declare i=i+1;
    #end
    #declare winkel=0;
    #while (winkel<360)
      cylinder
      {
        <-100,170,0>,<100,170,0>,20
        rotate <winkel+30,0,0>
      }
      #declare winkel=winkel+360/6;
    #end
  }
  texture
  {
    Rot
  }
}

#declare FT_plate1 =
object
{
  difference
  {
    box
    {
      <0,0,0>,<1800,-60,900>
    }
    #declare i=0;
    #while (i<13)
      box
      {
        <60,60,950>,<90,-100,700>
        translate <i*150,0,0>
      }
      box
      {
        <60,60,-10>,<90,-100,250>
        translate <i*150,0,0>
      }
      cylinder
      {
        <20,-100,450>,<20,100,450>,20
        translate <i*150,0,0>
      }
      #declare i=i+1;
    #end
  }
  texture
  {
    Rot
  }
}
