//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 4 lights, 2 materials and 6 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.2 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 06/13/2000    (13.06.2000)
//

#version Unofficial MegaPov 0.5;

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <    -46.808,     -49.906,     -12.023>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35836,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         40.00000    // Vertical      30.000
  look_at   <     -0.301,      -0.599,     -15.092>
}

//
// *******  L I G H T S *******
//

light_source {   // Light003
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*0.4000
  shadowless
  translate  <-200.0, 200.0, 0.0>
}

light_source {   // Light002
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*0.4000
  shadowless
  translate  <200.0, 200.0, 200.0>
}

light_source {   // Light001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*0.4000
  shadowless
  translate  <200.0, -200.0, 200.0>
}

light_source {   // Light1
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*1.4000
  translate  <-200.0, -200.0, 200.0>
}


//
// ********  MATERIALS  *******
//

#declare Material1 = 
   material  // Material1
   {   
      texture
      {      
         pigment
         {
            image_map
            {
               png   "DSC01619.png"
            }
            scale  0.1
         }
      }
   }


//  $MRY$: 'Carribean_Cloud_Sky'


#declare Carribean_Cloud_Sky = 
   material  // Carribean_Cloud_Sky
   {   
      texture
      {      
         pigment
         {
            bozo
            color_map
            {
               [ 0.0     rgbft <0.196078, 0.6, 0.8, 0.0, 0.0> ]
               [ 0.1     rgbft <0.196078, 0.6, 0.8, 0.0, 0.0> ]
               [ 0.7     rgbft <0.8, 0.8, 0.833333, 0.0, 0.0> ]
               [ 1.0     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
            }
            turbulence 0.5
            octaves 3
            lambda 6.0
            ramp_wave
         }      
         finish
         {
            ambient 1.0
            diffuse 0.0
         }
      }
   }


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//







sphere { // Sphere001
  <0,0,0>,1
  material {
    Carribean_Cloud_Sky
  }
  scale 100000.0
}


object {   // HgtFld001
  height_field {
    tga "mountain.tga"
    water_level 0.001  
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    Material1
  }
  scale <50.0, 50.0, 15.0>
}




