/*                            POV-Ray Push-Ball v1.0
                              **********************
   
   "My vision is that someday I could figure out how to make a game IN povray.
   Two people each submit an INC, and then a server renders them together to
   see how the army battle, football game, fox & hound hunt, goes. You'd
   compete on the basis of intelligent code that you write."
                                                               Greg M. Johnson
   
   That message fom Greg M. Johnson was what inspired me to make POV-Ray Push-Ball.
   Push-Ball is a very simple game, and the possibilities are limited, but I hope
   to be able to use my experience creating this game, to be able to make more
   interesting games in the future.
   
   To get started with this game, see Pushball.txt.
   Thank you for your interest!
                                                               Rune S. Johansen
*/
   
   #declare pb_players   = 4;   // Number of players (ball is not a player).
   
// The name of the include file for each player.
   #declare pb_name      = array[pb_players] {"bot4.inc","bot4.inc","bot4.inc","bot5.inc"}
   
   #declare pb_botsize   = 1.5; // Diameter of each bot.
   #declare pb_fieldsize = 08;  // Radius of the playing field
   #declare pb_goalrot   = 181; // Y Rotation of goals relative to bots' initial positions.
   #declare pb_power     = 0.05; // The influence each bot has on its own movement.
   #declare pb_inertia   = 0.95; // The influence inertia has on the bot's movements.
   #declare pb_maxspeed  = 0.3; // must be less than pb_botsize/2
   #declare pb_vibrate   = 0.001; // How much each bot vibrate (to add a random factor).
   #declare pb_seednr    = 1234;  // Controls the random initial positions and vibrations.
   
   #include "pushball.inc"
   