// BOT 3 - by Rune S. Johansen
// ***************************
// For POV-Ray Push-Ball v1.0
   
// Make names that are easier to remember and understand.
   #local ball = pb_location[0];
   #local me   = pb_location[pb_current];
   
// The bot should try to push the ball forward...
   #local forward = vnormalize(-pb_goalcenter[pb_current]);
   
// The direction from my bot to the ball.
   #local balldirection = vnormalize(ball-me);
   
// Returns 0 if I'm behinf the ball (which is good),
// and 1 if I'm in front of the ball (which is bad).
   #local orientation = 1-(vdot(balldirection,forward)/2+0.5);
   
// In order to get down behind the ball my bot must go to one of 2 locations.
   #local desiredlocation1 = (
      ball
      +vrotate (
         -forward*2*pb_botsize,
         orientation*+1*90*y
      )
      * pow(sin(orientation/4*2*pi),2) // These two lines are what makes this...
   );
   
   #local desiredlocation2 = (
      ball
      +vrotate (
         -forward*2*pb_botsize,
         orientation*-1*90*y
      )
      * pow(sin(orientation/4*2*pi),2) // ...bot different from bot4 and bot5.
   );
   
// I choose the one of those locations that is closest to my bot.
   #local desiredlocation = (
      vlength(desiredlocation1-me) < vlength(desiredlocation2-me)
      ?
      desiredlocation1
      :
      desiredlocation2
   );
   
// The direction I should go is my desired location relative to
// my current location.
   #declare VECTOR = desiredlocation-me;
   
// Make sure I always use full throttle...
   #if (vlength(VECTOR)<pb_maxspeed)
      #declare VECTOR = vnormalize(VECTOR)*pb_maxspeed;
   #end
   
// When the game is over there's no reason to keep playing...
   #if (pb_goal=true) #declare VECTOR = <0,0,0>; #end
   