/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* Pent.Inc                                                                    */
/*                                                                             */
/* Pentagram include file.                                                     */
/*                                                                             */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#local DEPTH = 2;
#local DEPTH_ = DEPTH + .1;

#local p180 = 3.14159265358 / 180;
#local y1 = sin (18 * p180) * 6;
#local i = 0;

#local BAR = intersection {
   box {<-6, -6, 0> <6, 6, DEPTH>}
   plane {y, y1}                //Top
   plane {y, y1 - .8 inverse}   //Bottom
   plane {y, y1 rotate 216 * z} //Right
   plane {y, y1 rotate 144 * z} //Left
} //intersection

#declare PENTAGRAM = union {
   difference {
      cylinder {<0, 0, 0>, <0, 0, DEPTH>, 6.8}
      cylinder {<0, 0, -.1>, <0, 0, DEPTH_>, 6}
   } //difference
   #while (i < 5)
      object {BAR rotate (i * 72) * z}
      #local i = i + 1;
   #end
} //union
