/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* POV 3.0 include file                                                    */
/*                                                                         */
/*                      GREEK COLUMN WITH PENTAGRAM BASE                   */
/*                                                                         */
/*                            By Dave Blandston                            */
/*                                                                         */
/* You must define the "ColumnColor" texture before including this file.   */
/* Also define ColumnHeight, ColumnDiameter, ColumnScale, ColumnX, and     */
/* ColumnZ. The column will always start at y = 0 at the bottom of the     */
/* base and reach ColumnHeight at the top. The column starts out centered  */
/* around the y axis, then gets translated by the ColumnX and ColumnZ      */
/* amounts.                                                                */
/*                                                                         */
/* Note: You need to include "Pent.inc" before including this file.        */
/*                                                                         */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#local i = 0;

#local Pillar = difference {
   cylinder {<0, 0, 0> <0, ColumnHeight, 0>, ColumnDiameter}
   #while (i < 360)
      union {
         cylinder {<ColumnDiameter * .933333, 3.5 + ColumnDiameter * .48, 0> <ColumnDiameter * .933333, ColumnHeight - 3.6, 0>, ColumnDiameter * .133333}
         sphere {<ColumnDiameter * .933333, ColumnHeight - 3.6, 0> ColumnDiameter * .133333}
         sphere {<ColumnDiameter * .933333, 3.5 + ColumnDiameter * .48, 0> ColumnDiameter * .133333}
         rotate i * y
      } //union
      #local i = i + 20;
   #end
} //difference

#local Base = union {
   box {<-ColumnDiameter * 1.4, 0, -ColumnDiameter * 1.4> <ColumnDiameter * 1.4, 3.2, ColumnDiameter * 1.4>}
   torus {ColumnDiameter * .8, ColumnDiameter * .4 scale <1, .6, 1> translate 3.5 * y}
   object {PENTAGRAM texture {PentColor} rotate 180 * z scale .2 translate <0, 1.6, -ColumnDiameter * 1.4 - .25>}
   object {PENTAGRAM texture {PentColor} rotate 180 * z scale .2 translate <0, 1.6, -ColumnDiameter * 1.4 - .25> rotate 90 * y}
   object {PENTAGRAM texture {PentColor} rotate 180 * z scale .2 translate <0, 1.6, -ColumnDiameter * 1.4 - .25> rotate 180 * y}
   object {PENTAGRAM texture {PentColor} rotate 180 * z scale .2 translate <0, 1.6, -ColumnDiameter * 1.4 - .25> rotate 270 * y}
} //union

#local Top = union {
   box {<-ColumnDiameter * 1.4, ColumnHeight - 1.2, -ColumnDiameter * 1.4> <ColumnDiameter * 1.4, ColumnHeight, ColumnDiameter * 1.4>}
   torus {ColumnDiameter * .8, ColumnDiameter * .4 scale <1, .6, 1> translate <0, ColumnHeight - 1.5, 0>}
   //cylinder {<0, ColumnHeight * .86, 0> <0, ColumnHeight, 0>, ColumnDiameter * 1.1}
} //union

#local Column = union {
   object {Base}
   object {Pillar}
   object {Top}
} //union

object {Column scale ColumnScale translate <ColumnX, 0, ColumnZ> texture {ColumnColor}}
