/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* Important: To use this file, you must first prepare a Fractint .pot     */
/* file. From Fractint, select 1024x768 256 color video mode, Plasma       */
/* fractal type, about 10 for the graininess factor, enter 1 in the "Save  */
/* as Pot File?" box, then save the image. Rename the .pot file to         */
/* "DBStones.pot" and move it to your POV scene directory. If you prefer,  */
/* you can download the 1.6M .pot file from                                */
/* home.earthlink.net/~grasshoppah/DBStones.pot                            */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "colors.inc"
#include "stones.inc"
#include "DBStones.inc"

camera {
   location <0, 4, -24>
   direction <0, 0, 1.3>
   look_at <11.5, 6, 0>
} //camera

light_source {<-500, 600, -1000> color White}

#local WallWidth = 14;
#local WallHeight = 12;
#local WallDepth = 1;
#local BrickSize = 1.2;
#local PlacementMethod = 2; //Somewhat random brick placement

MakeBrickWall (WallWidth, WallHeight, WallDepth, BrickSize, PlacementMethod)
object {BrickWall} //Back wall

#local BrickSize = 2;
#local PlacementMethod = 1; //Standard brick wall

MakeBrickWall (WallWidth, WallHeight, WallDepth, BrickSize, PlacementMethod)
object {BrickWall rotate 90 * y translate <WallWidth - .25, 0, .25>} //Side wall
