/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* POV 3.0 include file                                                    */
/*                                                                         */
/*                     METALLICA LOGO WITH BEVELED BORDER                  */
/*                                                                         */
/*                            By Dave Blandston                            */
/*                                                                         */
/* This .inc file defines the Metallica logo. The boundaries of the logo   */
/* are <0 0 -.36> <49.3 21.5 9>. There are three variables that you may    */
/* want to adjust: B_WIDTH defines the width of the border, and B_HEIGHT   */
/* defines the height of the inner extruded portion. DEPTH defines the     */
/* total depth of the logo. You should also define two textures before     */
/* including this file: MetalColor1 is the texture of the outer border,    */
/* and MetalColor2 is the texture of the inner part.                       */
/*                                                                         */
/* If you make a scene with this thing, I would love to see it. You can    */
/* contact me through my website, home.earthlink.net/~grasshoppah where    */
/* you can see the scenes that I've made.                                  */
/*                                                                         */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#local B_WIDTH = .14;
#local B_HEIGHT = -.36;
#local DEPTH  = 9;

#ifndef (MetalColor1)
   #declare MetalColor1 = texture {pigment {color rgb <1, 1, 1>}}
#end

#ifndef (MetalColor2)
   #declare MetalColor2 = texture {pigment {color rgb <.137255, .556863, .419608>} normal {wrinkles}}
#end

#local DEPTH_ = DEPTH + .1;

#local B_DEPTH = DEPTH - B_WIDTH;
#local B_DEPTH_ = B_DEPTH + .1;

#local OuterM = object {
   difference {
      intersection {
         union {
            intersection {
               box {<0, 0, 0> <12, 21.5, DEPTH>}
               plane {x, 0 rotate <0, 0, -27.23908808> inverse}                  //left side of long part of M
               plane {x, 0 rotate <0, 0, -23.89516142> translate <5, 5.7, 0>}    //right side of long part of M
            } //intersection * longest part of M
            intersection {
               box {<6.5, 15.5, 0> <12, 21.5, DEPTH>}
               plane {x, 0 rotate <0, 0, -27.23908808>}                          //left side of long part of M
               plane {x, 0 rotate <0, 0, -57.17145821> translate <6.5, 15.5, 0>}
            } //intersection * top part of M
            intersection {
               box {<8, 12, 0> <10.5, 17, DEPTH>}
               plane {x, 0 rotate <0, 0, -27.23908808> inverse}                  //left side of long part of M
               plane {x, 0 rotate <0, 0, 13.2> translate <9.6, 15.5, 0>}         //top part of first stroke
               plane {x, 0 rotate <0, 0, 13.2> translate <9.1, 12.5, 0> inverse} //left part of first stroke
               plane {x, 0 rotate <0, 0, -28> translate <9, 12.5, 0>}            //right part of first stroke
            } //intersection * first stroke
            intersection {
               box {<9.6, 14.2, 0> <11.7, 17.2, DEPTH>}
               plane {x, 0 rotate <0, 0, -51.00900596> translate <9.6, 15.5, 0> inverse}
            } //intersection * glitch fix
            intersection {
               box {<8.5, 8.5, 0> <11.7, 17.4, DEPTH>}
               plane {x, 0 rotate <0, 0, -36> translate <11.7, 17.2, 0> inverse}    //top of right side of M
               plane {x, 0 rotate <0, 0, -9.819300639> translate <9, 9, 0> inverse} //left side of right side of M
            } //intersection * right side of M
            intersection {
               box {<0, 0, 0> <8, 8, DEPTH>}
               plane {x, 0 rotate <0, 0, -27.23908808> inverse}                          //left side of long part of M
               plane {x, 0 rotate <0, 0, -54.24611275> translate <7.8, 7.6, 0> inverse}  //right side of hook
            } //intersection * bottom hook
         } //union * the whole thing
         plane {x, 0 rotate <0, 0, -45.7440592>}
      } //intersection * chop off lower right part of M
      cylinder {<-10.42576807, 36.53612073, -.1>, <-10.42576807, 36.53612073, DEPTH_>, 27}
   } //difference * cut out curved part
} //object
   
#local InnerM = object {
   difference {
      intersection {
         union {
            intersection {
               box {<0, 0, B_HEIGHT> <12, 21.5, B_DEPTH>}
               plane {x, 0 translate <B_WIDTH, 0, 0> rotate <0, 0, -27.23908808> inverse} //left side of long part of M
               plane {x, 0 translate <-B_WIDTH, 0, 0> rotate <0, 0, -23.89516142> translate <5, 5.7, 0>} //right side of long part of M
            } //intersection * longest part of M
            intersection {
               box {<6.5, 15.5, B_HEIGHT> <12, 21.5, B_DEPTH>}
               plane {x, 0 translate <10, 0, 0>}
               plane {x, 0 translate <-B_WIDTH, 0, 0> rotate <0, 0, -57.17145821> translate <6.5, 15.5, 0>}
            } //intersection * top part of M
            intersection {
               box {<8, 12, B_HEIGHT> <10.5, 17, B_DEPTH>}
               plane {x, 0 translate <B_WIDTH, 0, 0> rotate <0, 0, -27.23908808> inverse} //left side of long part of M
               plane {x, 0 translate <-B_WIDTH, 0, 0> rotate <0, 0, 13.2> translate <9.6, 15.5, 0>}    //top part of first stroke
               plane {x, 0 translate <B_WIDTH, 0, 0> rotate <0, 0, 13.2> translate <9.1, 12.5, 0> inverse} //left part of first stroke
               plane {x, 0 translate <-B_WIDTH, 0, 0> rotate <0, 0, -28> translate <9, 12.5, 0>}            //right part of first stroke
            } //intersection * first stroke
            intersection {
               box {<9.4, 14.2, B_HEIGHT> <11.7, 17.2, B_DEPTH>}
               plane {x, 0 translate <B_WIDTH, 0, 0> rotate <0, 0, -51.00900596> translate <9.6, 15.5, 0> inverse}
               plane {x, 0 translate <-B_WIDTH, 0, 0> rotate <0, 0, -28> translate <9, 12.5, 0>} //right part of first stroke
            } //intersection * glitch fix
            intersection {
               box {<8.5 + B_WIDTH, 8.5 + B_WIDTH, B_HEIGHT> <11.7 - B_WIDTH, 17.4, B_DEPTH>}
               plane {x, 0 translate <B_WIDTH, 0, 0> rotate <0, 0, -51.00900596> translate <11.7, 17.2, 0> inverse}  //top of right side of M
               plane {x, 0 translate <B_WIDTH, 0, 0> rotate <0, 0, -9.819300639> translate <9, 9, 0> inverse} //left side of right side of M
            } //intersection * right side of M
            intersection {
               box {<0, 0, B_HEIGHT> <8, 8, B_DEPTH>}
               plane {x, 0 translate <B_WIDTH, 0, 0> rotate <0, 0, -27.23908808> inverse} //left side of long part of M
               plane {x, 0 translate <B_WIDTH, 0, 0> rotate <0, 0, -54.24611275> translate <7.8, 7.6, 0> inverse} //right side of hook
            } //intersection * bottom hook
         } //union * the whole thing
         plane {x, 0 translate <-B_WIDTH, 0, 0> rotate <0, 0, -45.7440592>}
      } //intersection * chop off lower right part of M
      cylinder {<-10.42576807, 36.53612073, B_HEIGHT - .1>, <-10.42576807, 36.53612073, B_DEPTH_>, 27 + B_WIDTH}
   } //difference * cut out curved part
} //object

#local M_ = object {
   union {
      object {OuterM texture {MetalColor1}}
      object {InnerM texture {MetalColor2}}
   } //union
} //object

#local OuterE = object {
   union {
      box {<11.9, 11.4, 0> <13.6, 17.2, DEPTH>}               //left side of E
      box {<13.5, 11.4, 0> <15.7, 13.06666667, DEPTH>}        //lower bar of E
      box {<13.5, 13.46666667, 0> <15.7, 15.13333333, DEPTH>} //middle bar of E
      box {<13.5, 15.53333333, 0> <15.7, 17.2, DEPTH>}        //upper bar of E
   } //union
} //object * OuterE

#local InnerE = object {
   union {
      box {<11.9 + B_WIDTH, 11.4 + B_WIDTH, B_HEIGHT> <13.6 - B_WIDTH, 17.2 - B_WIDTH, B_DEPTH>}               //left side border
      box {<11.9 + B_WIDTH, 11.4 + B_WIDTH, B_HEIGHT> <15.7 - B_WIDTH, 13.06666667 - B_WIDTH, B_DEPTH>}        //lower bar border
      box {<11.9 + B_WIDTH, 13.46666667 + B_WIDTH, B_HEIGHT> <15.7 - B_WIDTH, 15.13333333 - B_WIDTH, B_DEPTH>} //middle bar border
      box {<11.9 + B_WIDTH, 15.53333333 + B_WIDTH, B_HEIGHT> <15.7 - B_WIDTH, 17.2 - B_WIDTH, B_DEPTH>}        //upper bar border
   } //union
} //object * InnerE

#local E_ = object {
   union {
      object {OuterE texture {MetalColor1}}
      object {InnerE texture {MetalColor2}}
   } //union
} //object

#local InnerT = object {
   union {
      intersection {
         box {<15.9 + B_WIDTH, 15.53333333 + B_WIDTH, B_HEIGHT> <20.8 - B_WIDTH, 17.2 - B_WIDTH, B_DEPTH>}
         plane {x, 0 translate <-B_WIDTH, 0, 0> rotate <0, 0, -23.96248897> translate <20.8, 17.2, 0>}
      } //intersection * top of T
      box {<16.9 + B_WIDTH, 11.4 + B_WIDTH, B_HEIGHT> <18.6 - B_WIDTH, 17.2 - B_WIDTH, B_DEPTH>} //bottom of T
   } //union
} //object

#local OuterT = object {
   union {
      intersection {
         box {<15.9, 15.53333333, 0> <20.8, 17.2, DEPTH>}
         plane {x, 0 rotate <0, 0, -23.96248897> translate <20.8, 17.2, 0>}
      } //intersection * top of T
      box {<16.9, 11.4, 0> <18.6, 15.7, DEPTH>} //bottom of T
   } //union
} //object

#local T_ = object {
   union {
      object {OuterT texture {MetalColor1}}
      object {InnerT texture {MetalColor2}}
   } //union
} //object

#local OuterLittleA = object {
   difference {
      union {
         intersection {
            box {<18.75, 11.4, 0> <23.15, 17.2, DEPTH>}
            plane {x, 0 rotate <0, 0, -23.96248897> translate <18.75, 11.4, 0> inverse}
            plane {x, 0 rotate <0, 0, -23.96248897> translate <20.55, 11.4, 0>}
         } //intersection * left side of A
         box {<21.35, 11.4, 0> <23.15, 17.2, DEPTH>} //right side of A
      } // union
      intersection {
         box {<21.2, 14.4, -.1> <21.7, 16, DEPTH_>}
         plane {x, 0 rotate <0, 0, -23.96248897> translate <21.2, 14.4, 0> inverse}
      } //intersection * hole in A
   } //difference * cut out hole in A
} //object
   
#local InnerLittleA = object {
   difference {
      union {
         intersection {
            box {<18.75 + B_WIDTH, 11.4 + B_WIDTH, B_HEIGHT> <23.15 - B_WIDTH, 17.2 - B_WIDTH, B_DEPTH>}
            plane {x, 0 translate <B_WIDTH, 0, 0> rotate <0, 0, -23.96248897> translate <18.75, 11.4, 0> inverse}
            plane {x, 0 translate <-B_WIDTH, 0, 0> rotate <0, 0, -23.96248897> translate <20.55, 11.4, 0>}
         } //intersection * left side of A
         box {<21.35 + B_WIDTH, 11.4 + B_WIDTH, B_HEIGHT> <23.15 - B_WIDTH, 17.2 - B_WIDTH, B_DEPTH>} //right side of A
      } // union
      intersection {
         box {<21.2 - B_WIDTH, 14.4 - B_WIDTH, B_HEIGHT - .1> <21.7 + B_WIDTH, 16 + B_WIDTH, B_DEPTH_>}
         plane {x, 0 translate <-B_WIDTH, 0, 0> rotate <0, 0, -23.96248897> translate <21.2, 14.4, 0> inverse}
      } //intersection * hole in A
   } //difference * cut out hole in A 
} //object

#local LittleA_ = object {
   union {
      object {OuterLittleA texture {MetalColor1}}
      object {InnerLittleA texture {MetalColor2}}
   } //union
} //object

#local OuterL1 = object {
   union {
      box {<23.395, 11.4, 0> <25.045, 17.2, DEPTH>} //left side of L
      box {<24.545, 11.4, 0> <26.945, 13.3, DEPTH>} //bottom of L
   } //union
} //object

#local InnerL1 = object {
   union {
      box {<23.395 + B_WIDTH, 11.4 + B_WIDTH, B_HEIGHT> <25.045 - B_WIDTH, 17.2 - B_WIDTH, B_DEPTH>} //left side of L
      box {<23.395 + B_WIDTH, 11.4 + B_WIDTH, B_HEIGHT> <26.945 - B_WIDTH, 13.3 - B_WIDTH, B_DEPTH>} //bottom of L
   } //union
} //object

#local L1_ = object {
   union {
      object {OuterL1 texture {MetalColor1}}
      object {InnerL1 texture {MetalColor2}}
   } //union
} //object

#local OuterL2 = object {
   union {
      box {<27.2, 11.4, 0> <28.85, 17.2, DEPTH>}  //left side of L
      box {<28.35, 11.4, 0> <30.75, 13.3, DEPTH>} //bottom of L
   } //union
} //object

#local InnerL2 = object {
   union {
      box {<27.2 + B_WIDTH, 11.4 + B_WIDTH, B_HEIGHT> <28.85 - B_WIDTH, 17.2 - B_WIDTH, B_DEPTH>} //left side of L
      box {<27.2 + B_WIDTH, 11.4 + B_WIDTH, B_HEIGHT> <30.75 - B_WIDTH, 13.3 - B_WIDTH, B_DEPTH>} //bottom of L
   } //union
} //object

#local L2_ = object {
   union {
      object {OuterL2 texture {MetalColor1}}
      object {InnerL2 texture {MetalColor2}}
   } //union
} //object

#local I_ = object {
   union {
      box {<31, 11.4, 0> <32.8, 17.2, DEPTH> texture {MetalColor1}}
      box {<31 + B_WIDTH, 11.4 + B_WIDTH, B_HEIGHT> <32.8 - B_WIDTH, 17.2 - B_WIDTH, B_DEPTH> texture {MetalColor2}}
   } //union
} //object

#local OuterC = object {
   difference {
      cylinder {<36.05, 14.45, 0>, <36.05, 14.45, DEPTH>, 3.05}
      cylinder {<36.05, 14.45, -.1>, <36.05, 14.45, DEPTH_>, 1}
      intersection {
         box {<36, 14.5, -.1> <40, 18.5, DEPTH_>}                            //clip off top part of C
         plane {x, 0 rotate <0, 0, -40.60129465> translate <36.6, 15, 0> inverse}
      } //intersection
      intersection {
         box {<36, 12, -.1> <40, 14.6, DEPTH_>}                            //clip off bottom part of C
         plane {x, 0 rotate <0, 0, -125.5376778> translate <36.8, 14.15, 0>}
      } //intersection
   } //difference
} //object

#local InnerC = object {
   difference {
      cylinder {<36.05, 14.45, B_HEIGHT>, <36.05, 14.45, B_DEPTH>, 3.05 - B_WIDTH}
      cylinder {<36.05, 14.45, B_HEIGHT - .1>, <36.05, 14.45, B_DEPTH_>, 1 + B_WIDTH}
      intersection {
         box {<36, 14.5, B_HEIGHT - .1> <40, 18.5, B_DEPTH_>}                  //clip off top part of C border
         plane {x, 0 translate <-B_WIDTH, 0, 0> rotate <0, 0, -40.60129465> translate <36.6, 15, 0> inverse}
      } //intersection
      intersection {
         box {<36, 12, B_HEIGHT - .1> <40, 14.6, B_DEPTH_>}                  //clip off bottom part of C border
         plane {x, 0 translate <B_WIDTH, 0, 0> rotate <0, 0, -125.5376778> translate <36.8, 14.15, 0>}
      } //intersection
   } //difference
} //object

#local C_ = object {
   union {
      object {OuterC texture {MetalColor1}}
      object {InnerC texture {MetalColor2}}
   } //union
} //object

#local OuterBigA = object {
   union {
      intersection {
         box {<38.8, 8.5, 0> <41, 18.1, DEPTH>}
         plane {x, 0 rotate <0, 0, -138.0127875> translate <38.8, 11.35, 0>}             //bottom of left side of BigA
         plane {x, 0 rotate <0, 0, 9.462322208> translate <40.95, 9, 0>}                 //right side of left side of BigA
      } //intersection * left side of BigA
      intersection {
         union {
            intersection {
               box {<38.8, 0, 0> <49.3, 18.1, DEPTH>}
               plane {x, 0 rotate <0, 0, 23.23747611> translate <46.65, 0, 0> inverse}   //left side of right side of bigA
            } //intersection * right side of BigA
            intersection {
               box {<40.8, 0, 0> <49.3, 8, DEPTH>}
               plane {x, 0 rotate <0, 0, 56.30993247> translate <41.3, 7.6, 0>}          //top of hook
            } //intersection * bottom hook
         } //union * right side of BigA and bottom hook
         plane {x, 0 rotate <0, 0, 46.46880071> translate <49.3, 0, 0> inverse}          //chop off left side of bottom hook
         plane {x, 0 rotate <0, 0, 27.73154613> translate <49.3, 0, 0>}                  //right side of right side of BigA
      } //intersection * right side of BigA and bottom hook
      box {<39.3, 13.2, 0> <41.2, 14.8, DEPTH>}                                          //bar for BigA
      intersection {
         union {
            intersection {
               box {<36.8, 17.5, 0> <42.3, 21.5, DEPTH>}
               plane {x, 0 rotate <0, 0, 30.46554492> translate <36.8, 21.5, 0> inverse} //left side of left half of top part of BigA
            } //intersection * left half of top part of BigA
            intersection {
               box {<40.1, 15, 0> <43.8, 17.5, DEPTH>}
               plane {x, 0 rotate <0, 0, 56.30993247> translate <40.1, 17.5, 0> inverse} //left side of right half of top part of BigA
            } //intersection * right half of top part of BigA
         } //union * left and right halves of top part of BigA
         plane {x, 0 rotate <0, 0, 45.50702906> translate <36.8, 21.5, 0>}               //right side of top part of BigA
      } //intersection * top of BigA
   } //union
} //object

#local InnerBigA = object {
   union {
      intersection {
         box {<38.8 + B_WIDTH, 8.5 + B_WIDTH, B_HEIGHT> <41 - B_WIDTH, 18.2, B_DEPTH>}
         plane {x, 0 translate <-B_WIDTH, 0, 0> rotate <0, 0, -138.0127875> translate <38.8, 11.35, 0>} //bottom of left side of BigA
         plane {x, 0 translate <-B_WIDTH, 0, 0> rotate <0, 0, 9.462322208> translate <40.95, 9, 0>}    //right side of left side of BigA
      } //intersection * left side of BigA
      intersection {
         union {
            intersection {
               box {<38.8 + B_WIDTH, B_WIDTH, B_HEIGHT> <49.3 - B_WIDTH, 18.2, B_DEPTH>}
               plane {x, 0 translate <B_WIDTH, 0, 0> rotate <0, 0, 23.23747611> translate <46.65, 0, 0> inverse} //left side of right side of bigA
            } //intersection * right side of BigA
            intersection {
               box {<40.8, 0, B_HEIGHT> <49.3, 8, B_DEPTH>}
               plane {x, 0 translate <-B_WIDTH, 0, 0> rotate <0, 0, 56.30993247> translate <41.3, 7.6, 0>} //top ofhook
            } //intersection * bottom hook
         } //union * right side of BigA and bottom hook
         plane {x, 0 translate <B_WIDTH, 0, 0> rotate <0, 0, 46.46880071> translate <49.3, 0, 0> inverse} //chop off left side of bottom hook
         plane {x, 0 translate <-B_WIDTH, 0, 0> rotate <0, 0, 27.73154613> translate <49.3, 0, 0>}        //right side of right side of BigA
      } //intersection * right side of BigA and bottom hook
      box {<39.3, 13.2 + B_WIDTH, B_HEIGHT> <41.2, 14.8 - B_WIDTH, B_DEPTH>} //bar for BigA
      intersection {
         union {
            intersection {
               box {<36.8, 17.8, B_HEIGHT> <42.3, 21.5, B_DEPTH>}
               plane {x, 0 translate <B_WIDTH, 0, 0> rotate <0, 0, 30.46554492> translate <36.8, 21.5, 0> inverse} //left side of left half of top part of BigA
            } //intersection * left half of top part of BigA
            intersection {
               box {<39, 15, B_HEIGHT> <43.8, 18.1, B_DEPTH>}
               plane {x, 0 translate <B_WIDTH, 0, 0> rotate <0, 0, 56.30993247> translate <40.1, 17.5, 0> inverse} //left side of right half of top part of BigA border
            } //intersection * right half of top part of BigA
         } //union * left and right halves of top part of BigA
         plane {x, 0 translate <-B_WIDTH, 0, 0> rotate <0, 0, 45.50702906> translate <36.8, 21.5, 0>} //right side of top part of BigA border
      } //intersection * top of BigA
   } //union
} //object

#local BigA_ = object {
   union {
      object {OuterBigA texture {MetalColor1}}
      object {InnerBigA texture {MetalColor2}}
   } //union
} //object

#declare METALLICA = object {
   union {
      object {M_}
      object {E_}
      object {T_}
      object {LittleA_}
      object {L1_}
      object {L2_}
      object {I_}
      object {C_}
      object {BigA_}
   } //union
} //object
