// People in the Desert
// Sigmund Kyrre s <c> 2000

// Note that the camera has 35/24 aspect ratio. 
// Scroll down to change it or use the accompanying sizes
  
#version unofficial MegaPov 0.4;

$Ant=15; // Ant*Ant people
$Skala=180; // size of desert

//Probably have to increase these for bigger renders:
$GrinDistance=100; // chinese further away won't get a grin. 
$U=5;  // image pattern size * 100

#default{finish {specular .15 roughness .2 diffuse .7 ambient 0} }
#macro Lys(Farge) light_source { 0, Farge } #end
#macro ALys(Farge)
light_source {
    0*x // light's position (translated below)
    color rgb Farge  // light's color
    area_light
    <30, 0, 0> <0, 0, 30> // lights spread out across this distance (x * z)
    4, 4                // total number of lights in grid (4x*4z = 16 lights)
    adaptive 1          // 0,1,2,3... 
    jitter              // adds random softening of light
    circular
}
#end

#declare Lpos=<3,7,-3>*100;
object { ALys(1) translate Lpos }

#macro snu(nX,nY,nZ)
matrix <nX.x,nX.y,nX.z,
        nY.x,nY.y,nY.z,
        nZ.x,nZ.y,nZ.z,
        0,   0,   0    >
#end

camera {
   #local L=26;
   right 35/24*x   // 420,288 525,360  700,480  875,600  1050,720  1152,790
   $Kam=<2, 3.7 ,-12>*4;
   location  Kam
   look_at   0//.5*x
   angle degrees(atan2(35,L))
   #macro Trans() 
    translate -z*70 
    rotate y*40 
   #end
   Trans() 
   $Kam_pos=vtransform(Kam, Trans() );  // sorry 'bout the mess
   $Kam_look=vtransform(0, Trans() );
}

$Bakke=
material{
    texture {
        pigment { bozo
            colour_map {
                [0 rgb <255,224,126>/255 ]
                [1 rgb <255,227,140>/255 ]
            }
            scale 10
        }
        finish {blinn .15 facets .25 crand .07}
        normal {marble .02
            turbulence .15
             octaves 3 omega .7 frequency 8 
             scale 8
       }
        
    }
    rotate 5*y
    interior{ior 30}
}

#macro Kineser(A,B,Pos,Kampos)
union {                   
    $P=seed(50+300*A); $Q=seed(200*B);
    $H=1.3*(.8+.2*rand(P)); $R=.2*(.5+.5*rand(Q));
    $Avstkamera=vlength(Pos-Kampos);
    sphere {0,H/2 
        pigment {
            // skips image_map on distant chineese and those behind the camera:
            #if (Avstkamera<GrinDistance & vlength(Pos)<vlength(Kampos))
                image_map {gif 
                    #if  (rand(P)<.52*(.8+.2*rand(Q))) "kinasmil.gif" #else "kinasmil2.gif" #end
                    map_type 1 interpolate 2 
                } 
                rotate 90*y
            #else
                rgb <255,209,67>/255
            #end
        } 
        translate (H/2+H)*y
    }
    cone {0, 2*R, H*y*1.1, R pigment {rgb <0,91*(.5+.5*rand(P)),149*(.5+.5*rand(R))>/255} }
    $i=1;
    #while (i<=4) 
        sphere { 0,.06 
            pigment {rgb <212,206,82>/255} 
            translate <0 , i/4*H ,2*R-i/4*R>
        }
        $i=i+1;
    #end
    #if (rand(Q)>.52) // Hat
        cone {0, H/1.5, H/3*y, 0 pigment {rgb <114,62,0>/255} translate y*H/2 rotate -x*25 translate 4/3*H*y }
    #end
    #if (rand(P)<.52*(.8+.2*rand(Q))) // Shades
        disc {0,z,H/7 pigment {rgbt .1} finish{specular 0.5 diffuse .1 } translate <H/6,1.8*H,H/2.2> }
        disc {0,z,H/7 pigment {rgbt .1} finish{specular 0.5 diffuse .1 } translate <-H/6,1.8*H,H/2.2> }
    #end
}
#end

$HF=
height_field {
    pattern 100*U,100*U  {
        hf_gray_16
        average
        pigment_map {
           $i=0;
            #while (i<1)
                $P=seed(i*100+21); $R=seed(i*5500+550);
                [1 cylindrical 
                    color_map { [0 rgb 0] [1 rgb 1] }
                    scale .5+.5*max(rand(P),rand(R))
                    translate <rand(P),0,rand(R)> 
                    //warp { turbulence .1 lambda 3 octaves 7 omega .6 }
                ]
                $i=i+.2;
            #end
            [.45 bozo color_map { [0 rgb 0] [1 rgb 1] } scale .3]
            [2.5 spiral1 2 color_map { [0 rgb 0] [.1 rgb .01] [.9 rgb .99] [1 rgb 1] } 
                scale <1,.2,1> 
                rotate 60*y 
                turbulence .2 lambda 2.2 octaves 2 omega .95 
                //turbulence .2 lambda 2.2 octaves 2 omega .9 
            ]
        }
        translate 1
        scale .3
    } 
    translate (x+z)*-.5
    scale <1,1/10,1>*Skala
    material{Bakke}
}

$j=0;
$k=0;
$telle=0;
// Where to start and stop tracing:
$Min_x=-.5*Skala;$Max_x=.5*Skala;
$Min_z=-.5*Skala;$Max_z=.5*Skala;

$Siste=0; // previous position in #while
$Avoided=0; // avoid collision
#while (j<=1)
    #while (k<=1)
        $S=seed(13+k*23*pow(4,j*2));
        $T=seed(13*pow(3*k,2*k)+130*j);
        $N=<0,0,0>; $Dir=-y;
        $Start = <Min_x+2*j*Max_x, 10, Min_z+2*k*Max_z>+<Min_x/Ant*rand(S),0,Min_z/Ant*rand(T)>; 
        $Start = Start + vturbulence(2.5*(.5+j),.5,4, Start);
        $Inter= trace ( HF, Start, Dir, N ); 
        #if (N.x != 0 | N.y != 0 | N.z != 0)
            #if ( vlength(Inter-Siste)>2 )
            object { 
                Kineser(5+ sin(j)*k*10 , 4+2*pow(j*2,k*3), Inter,Kam_pos ) 
                rotate (.6-rand(T))*60*y
                scale 1+9/pow(vlength(Inter-Kam_pos),.8)
                $N=vnormalize(N+y);
                snu(vcross(N,z),N,vcross(N,x)) 
                translate Inter
                $Siste=Inter;
                $telle=telle+1;
            }
            #else $Avoided=Avoided+1;
            #end
        #end
        $k=k+1/Ant;
    #end
    $k=0;
    $j=j+1/Ant;
#end

object { HF }

#render concat("Number/traced: ",str(telle,0,0),"/",str(Ant*Ant,0,0),"\n","Avoided: ",str(Avoided,0,0),"\n")

sky_sphere {
    pigment {
        gradient y
        color_map { 
            [0  rgb <232,239,249>/255]
            [.1 rgb <195,213,238>/255] 
            [.3 rgb <173,199,231>/255]
            [1  rgb <16,17,184>/255]
        }
        turbulence .01
   }
}

global_settings {
    max_trace_level 6
    ini_option  "+QR"
    ini_option "Preview_Start_Size=16"
    ini_option "Preview_End_Size=8"
    //adc_bailout 1/20
    
    radiosity{
        count 20             // CHANGE range from 20 to 150 (at least 80 if lit by ambient)
        nearest_count 4      // CHANGE range from 3 to 10
        error_bound 2.5      // CHANGE - range from 1 to 3 - should correspond with Preview_End_Size
                             //   1 : preview_end_size = 4
                             //   3 : preview_end_size = 8
                             //   use preview_start_size = 16
        recursion_limit 3
        
        low_error_factor .5  // leave this
        gray_threshold 0.0   // leave this
        minimum_reuse 0.015  // leave this
        brightness 1         // leave this
        
        adc_bailout 0.01/(18*2)  // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
    }
}
