// *******************************************************************
// BH_BROWN00.POV                                            10 MAY 00
// IRTC Group Image--Apartment Building Tester 
// *******************************************************************

#version 3.1;

#include "bh_brown00.inc"     // declarations specific to 
                              // Brownstone and Courtyard Apts.

// IRTC GIP Scaling //////////////////////////////////////////////////

// 1 cm = 1 baseUnit
#ifndef(baseUnit)
   #declare baseUnit = 1;
#end

// Metric
#ifndef (m)  #local  m = 100 *baseUnit; #end
#ifndef(cm)  #local cm = 1.0 *baseUnit; #end
#ifndef(mm)  #local mm = 0.1 *baseUnit; #end
// English
#ifndef(in)  #local in = 2.54 *baseUnit; #end 
#ifndef(ft)  #local ft = 12*in*baseUnit; #end 
#ifndef(yd)  #local yd = 3*ft *baseUnit; #end 


// *******************************************************************
// Define Ambient Lights                                             
// *******************************************************************

#if ( ShowDetails )
   //quicker:
   light_source { < 180*ft, 160*ft, -240*ft >  color White }
/*
   //slower:
   light_source {
      0*x                              // position (translated below)
      color rgb 1.0                    // color
      area_light < 2,0,0 > < 0,0,2 >   // light's spread
      2, 2                             // total number of lights
      adaptive 0                       // 0,1,2,3... 
      jitter                           // random softening
      translate < -180*ft, 160*ft, -240*ft> // location of light
             } // end area light
*/
#else
   light_source { < 180*ft, 160*ft, -240*ft >  color White }
#end


// *******************************************************************
// Define Sky                                                        
// *******************************************************************

#if ( ShowDetails )
   #include "skies.inc"
   sky_sphere { S_Cloud3 }
   background { color LightBlue }         
#else
   background { color LightBlue }         // day 
   sky_sphere { pigment  { LightBlue } }  // day
#end


// *******************************************************************
// Define Camera
// *******************************************************************

#declare Beauty_Shot =
camera {
   direction < 0, 0, 2 >               //the Beauty Shot
   location  < 200*ft, 25*ft, -140*ft >  
   look_at   <  40*ft, 20*ft,  -20*ft > }      

#declare Camera_SE =
camera {
   direction < 0,  0, 4 >
   location  < 110*ft, 6*ft, -50*ft >  // SE of center
   look_at   <  0, 10*ft, -45*ft > }     

#declare Camera_SW =
camera {
   direction < 0, 0, 3 >
   location  < -120*ft, 25*ft, -200*ft >           // SW of center
   look_at   <   40*ft,  25*ft,   0 > }          

#declare Camera_North =
camera {
   direction < 0, 0, 4 >
   location  < 0, 50, 100 >            // North  of center
   look_at   < 0, 50,  0 > }           

#declare Camera_South =                // 2/-20=view exactly y*10 units
camera {                               // 3/-30=   "         ", etc.
   direction < 0, 0, 2 >
   location  < 0, 0, -100 >           
   look_at   < 0, 0, 0 > }           
                                       
#declare Camera_East =
camera {
   direction <   0,  0, 6 >
   location  < 80, 0, 0 >              // East
   look_at   <  0, 0, 0 > }       

#declare Camera_West =
camera {
   direction < 0, 0, 5 >
   location  < -200*ft, 100*ft, -30*ft >            // West
   look_at   <  0, 0, -30*ft > }           

#declare Camera_Above =
camera {
   direction < 0, 0, 4 >
   location  < 0, 400*ft,-20*ft >           // Above
   look_at   < 0,  0,  -20*ft > }           

#declare Quarter_Above =
camera {
   direction < 0, 0, 2 >
   location  < -45*ft, 37*ft, -200*ft >          // 3/4 ul viewpoint
   look_at   < 7.5*ft, 11*ft,    0 > }      


// *******************************************************************
//  Define Test Scene:
// *******************************************************************

// CAMERA
//camera { Beauty_Shot }
//camera { Camera_SE }
//camera { Camera_SW }
//camera { Camera_North }
//camera { Camera_South }
//camera { Camera_East }
//camera { Camera_West }
//camera { Camera_Above }
camera { Quarter_Above }

// FLOOR
object { Clip_Floor scale < 1*ft, 1*ft, 1*ft > }
//object { Clip_Floor }
//object { Test_Floor }


// *******************************************************************
//  Define these new objects:
// *******************************************************************


// *******************************************************************
//  Generate this image:
// *******************************************************************


// Macro: BH_Make_Building (Start_X, APT_Width, Nbr_Units):
// to make a block of apartments from Start_X, each unit APT_Width wide,
// containing Nbr_Units buildings.

 
BH_Make_Building(0, 25*ft, 5 ) //invoke the macro


// *******************************************************************
// *******************************************************************


// Macro: Courtyard_Building ( Nbr_Storeys):
// to make an apartment building Nbr_Storeys tall.

/*
#ifndef ( NbrStoreys )
   #declare NbrStoreys = 4;  // how tall is bldg? **MUST BE HARD CODED**
#end

object {
    BH_Courtyard_Building  ( NbrStoreys )
    scale < 1*ft, 1*ft, 1*ft >    //to US feet
    translate < 45, 0, 45 >       //move front lower left corner to <0,0,0>
       } // end macro
*/

// *******************************************************************
// *******************************************************************

//#declare GridOn = true;
//#declare GridOn = false;

#if ( GridOn )
//   object { Grid10XY } // vert rods
   object { Grid10XZ } // horz rods
//   object { Grid10XZ  translate x*-10 } // horz rods
//   object { Grid10XZ  translate x*10  } // horz rods
/*
   object { Mark01 } // center
   object { Mark01 translate x*-5 } 
   object { Mark01 translate x*5  } 
   object { Mark01 translate x*-10 } 
   object { Mark01 translate x*10  } 
   object { Mark01 translate x*-20 } 
   object { Mark01 translate x*20  } 
   object { Mark01 translate x*-10 translate z*10 } 
   object { Mark01 translate x*10  translate z*10 } 
   object { Mark01 translate x*-20 translate z*-10 } 
   object { Mark01 translate x*20  translate z*-10 } 
*/
#end 

// *******************************************************************
// *******************************************************************

// *******************************************************************
//  Michael Brendan Hurley, SDE, Ltd.     (c) Winter 1999-Spring 2000
//  www.geocities.com/mbrendanh/                     mbhcgc@saber.net
// *******************************************************************
