// mediagames, a late saturday night abstract
// by Anthony L. Bennett U.
// bennetts@panama.c-com.net | snotbucket@usa.net
// 22-04-2000
// please credit me if you use this in one
// of your projects. thank you. =)

#version unofficial megapov 0.4;

camera {up y right x location <1,2,-3>*1.85 look_at 0}

#declare P1 = function {pigment {function noise3d(x,y,z) triangle_wave}}

//Radius, Amount, Power
#macro Twirl (R,A,P)
#local PI = pi/2;
#local Atan = function {PI*abs(x)/x+atan(y/x)}
#local Sphere = function {pigment {spherical}}

function
{
 P1
 (
  sqrt(x*x+y*y)*sin(A*Sphere(x/R,y/R,z/R)^P+Atan(x,y,z)),
  sqrt(x*x+y*y)*cos(A*Sphere(x/R,y/R,z/R)^P+Atan(x,y,z)),
  z
 )
}
#end

sphere
{
 0,3 hollow pigment {rgbf 1}
 interior
 {
  media
  {
   method 3 samples 20,20 intervals 20 jitter 0.00 aa_level 5 aa_threshold .1
   emission rgb 1/3
   density
   {
    spherical scale 3
    density_map
    {
     [0 rgb 0]
     [.25 Twirl(4,10,2) scale 1/4
     color_map
     {
      [.150 rgb 0]
      [.250 blue 1*1.25]
      [.375 rgb <1,2,4>*1.25]
      [.500 blue 1*1.25]
      [.600 rgb 0]
     }]
     [.5 Twirl(4,-10,2) scale 1/4
     color_map
     {
      [.150 rgb 0]
      [.250 red 1*1.5]
      [.375 rgb <4,2,1>*1.5]
      [.500 red 1*1.5]
      [.600 rgb 0]
     }]
     [.75 Twirl(4,10,2) scale 1/4
     color_map
     {
      [.150 rgb 0]
      [.250 green 1*1.75]
      [.375 rgb <2,4,1>*1.75]
      [.500 green 1*1.75]
      [.600 rgb 0]
     }]
    }
   }
  }
 }
}