// Persistence of Vision Ray Tracer Scene Description File
// File: navigation_water.pov
// Vers: 3.*
// Desc: Waterway navigation markers and signals 
// Date: 96.4, 00.24 
// Auth: Bob Hughes
// Mail: inversez@aol.com?Subject=Pov-Scene


// Lights, Camera
light_source {<50,200,-600> color rgb<1.4,1.45,1.5>}
light_source {<0,200,0> color <.3,.5,.7>}

camera {
        location <0,3,-500>
        direction <0,0,3>
        look_at <0,2,0>
        }


// Sky
sphere{<0,0,0>,2500
        texture {pigment {rgb<.2,.6,.9>} finish {ambient 0.8 diffuse 0.3}}
        texture {pigment {gradient z
                color_map {[0,0.7    color rgbf<0.99,0.99,0.99,1.0>
                                     color rgbf<0.9,0.95,1,0.9>]
                           [0.7,0.8  color rgbf<0.9,0.95,1,0.9>
                                     color rgbf<0.9,0.95,0.9,0.8>]
                           [0.8,0.93 color rgbf<0.9,0.95,0.9,0.8>
                                     color rgbf<0.9,0.95,0.99,0.7>]
                           [0.93,1.0 color rgbf<0.9,0.95,0.99,0.7>
                                     color rgbf<0.95,0.96,0.99,0.6>]}}
                                    scale 6000}
    scale <1,0.1,1>
  hollow
}

fog {color rgbft<0.7,0.8,0.9,.6,.3> distance 2000}

// Base
sphere{<0,0,0>,2500
        texture {pigment {gradient z
                color_map {[0,1 color rgb<0.9,0.9,0.9>
                                color rgb<0.9,0.95,1>]}}
        finish {ambient 0.8 diffuse 0.8}}
        clipped_by {plane {y,0}}
   scale <1,0.09,1>
 hollow
}

// Ground
object {
height_field {gif "landw.gif" water_level 0.001 smooth}
                texture {
                pigment { color rgb <0.0,0.44,0.34> }
        finish {
                ambient .45
                diffuse 0.76
                crand .067
                }
        normal {
                wrinkles 0.17
                scale 0.34
                }
scale 0.14
 }
        scale <1000,40,2000> translate <-515,0,-150>
}

// Water (no refraction)
plane {y,0 pigment {color rgbf<0.4,0.5,0.45,0.5>}
        finish {ambient 0.15 diffuse 0.8 reflection 0.45}
        normal {bumps 0.2 scale 0.4}
}

plane {y,-1.5 pigment {color rgbf<0.3,0.4,0.35,0.7>}
        finish {ambient 0.2 diffuse 0.9}
        normal {waves 0.5 frequency 0.6 scale 2}
}

plane {y,-5 pigment {color rgbf<0.7,0.6,0.4,0.5>}
        finish {ambient 0.1 diffuse 1}
        normal {wrinkles 0.5 scale 4}
}


// TEXTURES

#declare Shine_F =
        finish {
                ambient 0.24
                diffuse 0.76
                specular 0.89
                roughness 0.019
                reflection 0.09
                }

#declare Smooth_F =
        finish {
                ambient 0.26
                diffuse 0.83
                specular 0.87
                roughness 0.01
                reflection 0.06
                }

#declare Rough_F =
        finish {
                ambient 0.14
                diffuse 0.43
                specular 0.5
                roughness 0.1
                }

#declare Ruddy_F =
        finish {
                ambient 0.12
                diffuse 0.67
                specular 0.2
                roughness 0.9
                }

#declare Steel_M =
 texture {
  pigment { color rgb <0.76, 0.79, 0.78> }
  finish {
    specular 0.62
    roughness 0.025
    ambient 0.18
    diffuse 0.5
    reflection 0.36
    metallic
    brilliance 3
  }
}

#declare Aluminum_O =
 texture {
  pigment {
   spotted scale 0.2
   color_map
    {[0.0, 0.45   color red 0.60 green 0.63 blue 0.65
                  color red 0.70 green 0.68 blue 0.69]
     [0.45, 0.5   color red 0.67 green 0.71 blue 0.72
                  color red 0.73 green 0.72 blue 0.70]
     [0.5, 0.65   color red 0.76 green 0.74 blue 0.75
                  color red 0.80 green 0.81 blue 0.82]
     [0.65, 1.1   color red 0.77 green 0.78 blue 0.77
                  color red 0.62 green 0.64 blue 0.65]
    }
  }
   normal {
bumps 0.15 scale 0.2
  }
  finish { metallic
           brilliance 1
           ambient 0.2
           crand 0.09 }
 }

// OBJECTS

#declare StarB =
union {
cone {<0,0.25,0>,0.7,<0,2.5,0>,0.1
        pigment {color rgb<0.8,0.1,0.1>}
        finish {Smooth_F}
}
cylinder {<0,-2,0>,<0,0.25,0>,0.7
        pigment {color rgb<0.8,0.1,0.1>}
        finish {Smooth_F}
}
}

#declare PortB =
cylinder {<0,-2,0>,<0,2.4,0>,0.7
        pigment {color rgb<0.1,0.45,0.1>}
        finish {Smooth_F}
}

#declare MidcB =
cylinder {<0,-2,0>,<0,2.4,0>,0.7
        pigment {radial
                color_map {
                        [0,0.1     color rgb<1.05,1.05,1.05>
                                   color rgb<1.05,1.05,1.05>]
                        [0.1,0.25  color rgb<0.1,0.35,0.1>
                                   color rgb<0.1,0.35,0.1>]
                        [0.25,0.35 color rgb<1.05,1.05,1.05>
                                   color rgb<1.05,1.05,1.05>]
                        [0.35,0.5  color rgb<0.1,0.35,0.1>
                                   color rgb<0.1,0.35,0.1>]
                        [0.5,0.6   color rgb<1.05,1.05,1.05>
                                   color rgb<1.05,1.05,1.05>]
                        [0.6,0.75  color rgb<0.1,0.35,0.1>
                                   color rgb<0.1,0.35,0.1>]
                        [0.75,0.85 color rgb<1.05,1.05,1.05>
                                   color rgb<1.05,1.05,1.05>]
                        [0.85,1    color rgb<0.1,0.35,0.1>
                                   color rgb<0.1,0.35,0.1>]
                         } scale 0.35}
        finish {Smooth_F} rotate y*10
}

#declare ShorB =
cylinder {<0,-2,0>,<0,2.4,0>,0.7
        pigment {radial
                color_map {
                        [0,0.1     color rgb<1.05,1.05,1.05>
                                   color rgb<1.05,1.05,1.05>]
                        [0.1,0.25  color rgb<0.8,0.1,0.1>
                                   color rgb<0.8,0.1,0.1>]
                        [0.25,0.35 color rgb<1.05,1.05,1.05>
                                   color rgb<1.05,1.05,1.05>]
                        [0.35,0.5  color rgb<0.8,0.1,0.1>
                                   color rgb<0.8,0.1,0.1>]
                        [0.5,0.6   color rgb<1.05,1.05,1.05>
                                   color rgb<1.05,1.05,1.05>]
                        [0.6,0.75  color rgb<0.8,0.1,0.1>
                                   color rgb<0.8,0.1,0.1>]
                        [0.75,0.85 color rgb<1.05,1.05,1.05>
                                   color rgb<1.05,1.05,1.05>]
                        [0.85,1    color rgb<0.8,0.1,0.1>
                                   color rgb<0.8,0.1,0.1>]
                         } scale 0.35}
        finish {Smooth_F ambient 0.3 diffuse 1} rotate y*10
}

#declare SoweB =
cylinder {<0,0,0>,<0,1,0>,0.7
        pigment {gradient y
                color_map {
                        [0,0.8  color rgb<0.95,0.95,0.95>
                                color rgb<0.95,0.95,0.95>]
                        [0.8,1  color rgb<0.9,0.2,0.1>
                                color rgb<0.9,0.2,0.1>]
                         }}
        finish {Smooth_F ambient 0.3 diffuse 1}
        scale <1,4.4,1> translate y*-2
}

#declare NoeaB =
cylinder {<0,0,0>,<0,1,0>,0.7
        pigment {gradient y
                color_map {
                        [0,0.8  color rgb<0.95,0.95,0.95>
                                color rgb<0.95,0.95,0.95>]
                        [0.8,1  color rgb<0.1,0.45,0.1>
                                color rgb<0.1,0.45,0.1>]
                         }}
        finish {Smooth_F ambient 0.3 diffuse 1}
        scale <1,4.4,1> translate y*-2
}

#declare AnchB =
cylinder {<0,0,0>,<0,1,0>,0.7
        pigment {gradient y
                color_map {
                        [0,0.8   color rgb<0.95,0.95,0.95>
                                 color rgb<0.95,0.95,0.95>]
                        [0.8,0.9 color rgb<0.1,0.3,0.9>
                                 color rgb<0.1,0.3,0.9>]
                        [0.9,1   color rgb<0.95,0.95,0.95>
                                 color rgb<0.95,0.95,0.95>]
                         }}
        finish {Smooth_F ambient 0.3 diffuse 1}
        scale <1,4.4,1> translate y*-2
}

#declare WarnB =
cylinder {<0,0,0>,<0,1,0>,0.7
        texture {
        pigment {image_map {gif "buoywarn.gif" map_type 2 interpolate 2 once}}
        finish {Smooth_F ambient 0.3 diffuse 1}
}         scale <1,4.4,1> rotate y*270 translate y*-2
}

#declare ContB =
cylinder {<0,0,0>,<0,1,0>,0.7
        texture {
        pigment {image_map {gif "buoycont.gif" map_type 2 interpolate 2 once}}
        finish {Smooth_F ambient 0.3 diffuse 1}
}         scale <1,4.4,1> rotate y*270 translate y*-2
}

#declare KoutB =
cylinder {<0,0,0>,<0,1,0>,0.7
        texture {
        pigment {image_map {gif "buoykout.gif" map_type 2 interpolate 2 once}}
        finish {Smooth_F ambient 0.3 diffuse 1}
}         scale <1,4.4,1> rotate y*270 translate y*-2
}

#declare InfoB =
cylinder {<0,0,0>,<0,1,0>,0.7
        texture {
        pigment {image_map {gif "buoyinfo.gif" map_type 2 interpolate 2 once}}
        finish {Smooth_F ambient 0.3 diffuse 1}
}         scale <1,4.4,1> rotate y*270 translate y*-2
}

#declare DiveF =
union {
plane {z,0 texture {pigment {image_map {gif "buoydive.gif" interpolate 2 once}}
        normal {wrinkles .5 scale <.4,.9,1> rotate 45*z}
        finish {ambient 0.3 diffuse .7 phong .05 phong_size 5}}
 clipped_by {box{<0,0,-1>,<1,1,1>}}
 }
cylinder {<0,-1,0>,<0,1,0>,0.1 pigment {rgb 0.5}
        finish {Smooth_F ambient 0.2}
 }
sphere {<0,-1.5,0>,0.5 pigment {color rgb<1.25,0.67,0.1>}
        finish {Smooth_F ambient 0.3}
 }
}

#declare Hood =
cylinder {<0,0,-1>,<0,0,0>,0.5 pigment {color rgb<0.95,0.9,0.3>}
finish {Smooth_F}
clipped_by {box {<-1,-1,0>,<1,1,1> rotate x*30 translate y*1}}
}

#declare Signal =
union {
object {Hood translate y*1}
object {Hood translate y*0}
object {Hood translate y*-1}

//light_source {<0,1,-0.15> color rgb<1,0.1,0.1> spotlight radius 15 falloff 30 point_at -z}
sphere {<0,1,0>,0.33 scale <1,1,0.2> pigment {color rgbf<1,0,0,0.25>}
finish {Shine_F ambient 0.8 diffuse .9}
normal {leopard 0.75 scale 0.15}}

//light_source {<0,0,-0.15> color rgb<1,0.9,0.1> spotlight radius 15 falloff 30 point_at -z}
sphere {<0,0,0>,0.33 scale <1,1,0.2> pigment {color rgbf<0.8,0.6,0,0.25>}
finish {Shine_F ambient 0.8 diffuse .9}
normal {leopard 0.75 scale 0.15}}

//light_source {<0,-1,-0.15> color rgb<0.1,1,0.1> spotlight radius 15 falloff 30 point_at -z}
sphere {<0,-1,0>,0.33 scale <1,1,0.2> pigment {color rgbf<0,0.65,0,0.25>}
finish {Shine_F ambient 0.8 diffuse .9}
normal {leopard 0.75 scale 0.15}}

box {<-0.6,-1.75,0>,<0.6,2,1> pigment {color rgb<1.15,0.95,0.15>}
     finish {ambient .25 diffuse .75 specular .33 roughness 0.3}
        clipped_by {sphere {<0,0,0>,1.75}}
finish {Smooth_F}}
}

#declare Sound =
object {
union {
sphere {<0,0,0>,9}
sphere {<0,0,0>,8}
sphere {<0,0,0>,7}
sphere {<0,0,0>,6}
sphere {<0,0,0>,3.5}
sphere {<0,0,0>,2.5}
}
        pigment {color rgbft<0.97,0.95,0.99,0.1,0.9>}
        finish {Rough_F}
       clipped_by {sphere{<0,0,0>,1 scale <9,3.3,3.3> translate x*9}}
  hollow
}

#declare Horn =
union {
object {Sound scale <1.5,1,1> translate x*3}
torus {5.5,5 rotate z*90
        texture {Steel_M}
        clipped_by {sphere {<2,0,0>,2}}
}
sphere {<-0.5,0,0>,1 scale <0.6,1.5,1.5>
        texture {Steel_M}
}
}

#declare Lock =
union {
box {<-1,-1,-1>,<1,1,1> scale <8,4,1> rotate y*-25 translate x*7.5}
box {<-1,-1,-1>,<1,1,1> scale <8,4,1> rotate y*25 translate x*-7.5}
        pigment {gradient y
                color_map {
                        [0,0.1     color rgb<0.15,0.25,0.15>
                                   color rgb<0.15,0.35,0.25>]
                        [0.1,0.25  color rgb<0.15,0.35,0.25>
                                   color rgb<0.4,0.5,0.2>]
                        [0.25,0.35 color rgb<0.4,0.5,0.2>
                                   color rgb<0.5,0.45,0.15>]
                        [0.35,0.5  color rgb<0.5,0.45,0.15>
                                   color rgb<0.8,0.7,0.5>]
                        [0.5,0.6   color rgb<0.8,0.7,0.5>
                                   color rgb<0.7,0.7,0.7>]
                        [0.6,1     color rgb<0.7,0.7,0.7>
                                   color rgb<0.8,0.8,0.8>]
                         } scale 4}
}

#declare Dam =
union {
box {<-1,-1,-1>,<1,1,1> scale <30,4,1> rotate x*6}
box {<-1,-1,-1>,<1,1,1> scale <10,4,1> translate x*65}
        texture {Aluminum_O scale .3}

        texture {
        pigment {gradient y
                color_map {
                        [0,0.1     color rgbf<0.15,0.25,0.15,0.3>
                                   color rgbf<0.15,0.35,0.25,0.4>]
                        [0.1,0.25  color rgbf<0.15,0.35,0.25,0.4>
                                   color rgbf<0.4,0.5,0.2,0.5>]
                        [0.25,0.35 color rgbf<0.4,0.5,0.2,0.5>
                                   color rgbf<0.5,0.45,0.15,0.6>]
                        [0.35,0.5  color rgbf<0.5,0.45,0.15,0.6>
                                   color rgbf<0.8,0.7,0.5,0.7>]
                        [0.5,0.6   color rgbf<0.8,0.7,0.5,0.7>
                                   color rgbf<0.7,0.7,0.7,0.8>]
                        [0.6,1     color rgbf<0.7,0.7,0.7,0.8>
                                   color rgbf<0.8,0.8,0.8,0.9>]
                         } scale 4}}

}

object {StarB translate <20,0,-400>} // Starboard Buoy
object {PortB translate <-20,0,-400>} // Port Buoy
object {MidcB translate <0,0,-400>} // Mid-Channel Buoy
object {SoweB translate <25,0,-350>} // South or West Buoy
object {NoeaB translate <-25,0,-350>} // North or East Buoy
object {AnchB translate <-4,0,-350>} // Anchor Buoy
object {ShorB translate <10,0,-425>} // Shoreline Buoy
object {ContB translate <3,0,-450>} // Controlled Buoy
object {WarnB translate <10.5,0,-400>} // Warning (Danger) Buoy
object {InfoB translate <-3,0,-450>} // Information Buoy
object {KoutB translate <-10.5,0,-400>} // Keep Out Buoy
object {DiveF translate <-10,1.4,-425>} // Divers Flag Buoy
object {Signal translate <6,6,-467>} // Locks: Signal Light
object {Horn rotate y*20 translate <-14,9,-425>} // Locks: Horn
object {Lock translate <25,0,-275>} // Lock Doors
object {Dam translate <-20,0,-275>} // Dam
