//////////////////////////////////////////////////////////////////////////////
//
// ruined_wall_macro.pov
//
// Copyright Ian Shumsky / OuterArm 2000
//
//////////////////////////////////////////////////////////////////////////////
//
// This pov file demonstrates the ruined wall macro.
//
//////////////////////////////////////////////////////////////////////////////

#include "colors.inc"
#include "skies.inc"

#include "ruined_wall_macro.inc"

//
// Set the camera and the lights.
//

camera
{
	location <0, 1.4, -10>
	look_at <0, 0.75, 0>
	rotate y*35
}

light_source
{
	<0,2000,0>
	colour White/10
	shadowless
}

light_source
{
	<1000,2000,-1000>
	colour White
	area_light
	<20, 0, 0> <0, 0, 20>
	3, 3
	adaptive 0
	jitter
}

//
// Define a simple surrounding world.
//

background
{
	SkyBlue
}

sky_sphere
{
	S_Cloud2
}

plane
{
	y, 0
	texture
	{
		checker
		texture
		{
			T_Stone31
			finish
			{
				reflection .3
			}
		},
		texture
		{
			T_Stone15
			finish
			{
				reflection .3
			}
		}

		scale 0.5 rotate y*45
	}
}

//
// Create a few walls by setting some values and calling
// the macro. The marco parameters are:
//
// rw_wall_length      : The maximum length of the wall
// rw_wall_height      : The maximum height of the wall
// rw_max_bricks_z     : The number of bricks thick the wall is
// rw_brick_height     : The y dimension of the brick object
// rw_brick_width      : The z dimension of the brick object 
// rw_brick_length     : The x dimension of the brick object 
// rw_mortar_thickness : How much space is between bricks 
// rw_mortar_depth     : How far below the surface of the bricks the mortar
//                       starts  
// rw_brick_type       : The type of brick. Valid values are 0 for a box
//                       brick, any other value for a superelipsoid 
// rw_seed_value       : A randow seed value.
//

#declare my_wall_length = 4;
#declare my_wall_height = 4;
#declare my_max_bricks_z = 3;

#declare my_brick_height = 0.065;
#declare my_brick_width = 0.1;
#declare my_brick_length = 0.22;

#declare my_mortar_thickness = 0.015;
#declare my_mortar_depth = 0.005;

#declare my_brick_type = 1;
#declare my_seed_value = 50;

#declare mywall1 = object
{
	gen_ruined_wall (my_wall_length, my_wall_height, my_max_bricks_z, my_brick_height, my_brick_width, my_brick_length, my_mortar_thickness, my_mortar_depth, my_brick_type, my_seed_value)
}

#declare my_seed_value = 100;

#declare mywall2 = object
{
	gen_ruined_wall (my_wall_length, my_wall_height, my_max_bricks_z, my_brick_height, my_brick_width, my_brick_length, my_mortar_thickness, my_mortar_depth, my_brick_type, my_seed_value)
}

#declare ruined_walls = union
{
	object
	{
		mywall1
	}
	object
	{
		mywall2
		rotate y*180
		translate <9,0,0>
	}
	object
	{
		mywall2
		rotate y*90
		translate <9, 0, 0>
	}
	object
	{
		mywall1
		rotate y*90
	}
}

object
{
	ruined_walls
	translate <-4.5,0,0>
}
