
/* IMPORTANT - the output file needs to be square, 
   so use +w200 +h200(or someother size) on the command line */

//#declare go_color = 1;
//#declare go_map = 1;
#declare go_bump = 1;

#declare dx = sqrt(12);						 // these declares needed for transformations
#declare cnt = 2;
#declare w = cnt*dx*2;
#declare w2 = cnt*dx;

camera {                           // this camera setup creates a tilable image
	location <w2, w2, w2+1>          // output file needs to be square
	right <1, 0, 0>
	look_at <w2, 0, w2+1>
	orthographic
}

light_source { <  0, 100, 0> color rgb 0.5 }
light_source { < 10, 100, 0> color rgb 0.5 }
light_source { <-10, 100, 0> color rgb 0.5 }

#include "weave.inc"               // this is the single object that makes 
                                   // the weave.

#declare PieceV1 = object { 
	object { 
		Object1 
	}
	#ifdef (go_color)
		pigment {											// this is for the color map
			gradient <1, 0, 1>
			color_map {
				[0.0000 color rgb <0.65, 0.45, 0>]
				[0.3333 color rgb <0.65, 0.45, 0>]
				[0.3333 color rgb <0.6, 0.4, 0>]
				[0.6666 color rgb <0.6, 0.4, 0>]
				[0.6666 color rgb <0.7, 0.5, 0>]
				[1.0000 color rgb <0.7, 0.5, 0>]
			}
			scale dx
		}
		normal {										 // I threw this in, but am not sure how
			gradient <1, 0, 1>         // much it will affect the final output.
			slope_map {
				[0.0000 <0, 1>]
				[0.1667 <1, -1>]
				[0.3333 <0, 1>]
				[0.5000 <1, -1>] 
				[0.6666 <0, 1>]
				[0.8333 <1, -1>]
				[1.0000 <0, 1>] 
			}
			scale dx
		}
	#end
}

#declare PieceV2 = object { object { PieceV1 rotate <0,  0, 180> translate <  dx+2, 4,      0> } }
#declare PieceH1 = object { object { PieceV1 rotate <0, 90,   0> translate <     1, 0,   dx+1> } }
#declare PieceH2 = object { object { PieceV1 rotate <0, 90, 180> translate <2*dx+1, 4, 2*dx+1> } }

union {                             // this creates an array of weave objects																										   
	#declare tx = 0;
	#declare i = 0;
	#while (i < cnt)
		#declare ty = 0;
		#declare j = 0;
		#while (j  < cnt)
			object { PieceV1 translate <tx, 0, ty> }
			object { PieceV2 translate <tx, 0, ty> }
			object { PieceH1 translate <tx, 0, ty> }
			object { PieceH2 translate <tx, 0, ty> }
			#declare ty = ty + dx * 2;
			#declare j = j + 1;
		#end
		#declare tx = tx + dx * 2;
		#declare i = i + 1;
	#end
	
	#ifdef (go_bump)			            // for bump map
		pigment { color rgb 1 } 
	#end
	#ifdef (go_map)                   // for material map
		pigment { color rgb 1 }
		finish { ambient 1 }
	#end
}
