light_source { <-20, 40, -20>*15 color rgb 1 }
camera {
   #local L=28;
   location  <10 , 12 ,-30>*.8
   look_at   <0, .5 , -2>
   angle degrees(atan2(35,L))
}
#declare Alu_fin=finish {specular .3 roughness .1 }
#declare Alu_pig=
pigment { bozo
    color_map { [ 0.0   rgb 0.51] [ 0.32  rgb 0.37] [ 0.62  rgb 0.4 ] [ 1.0   rgb 0.51] }
    turbulence 0.13 octaves 1 omega 0.108 lambda 2 frequency 1
}

#declare Base_tex=
texture {pigment {Alu_pig} finish {Alu_fin}}

#declare Alu_tex=
texture { spiral1 5
    texture_map { 
        [ 0.0 pigment {Alu_pig} finish {Alu_fin} ]
        [ 0.5 pigment {Alu_pig} finish{specular .6 roughness .01 } ]
        [ 1.0 pigment {Alu_pig} finish {Alu_fin} ]
    }
    turbulence 0.0444 ramp_wave scale  <1.0, 1.0, 0.2> rotate x*90
}

// Commenting out the following line causes crash in MegaPov 0.4:
#declare Alu_tex=Base_tex

#declare Slug_fin=
finish {specular .36 roughness .05}

#declare With= 
texture {
    material_map {
        png "louisville_slugger_rough.png"  map_type 2 once
        #local i=0;
        #while (i<=111) 
            texture { 
                pigment {rgb  x+(y+z)*195/255/111*i filter .2 } 
                finish {Slug_fin}
            } 
            #local i=i+1; 
        #end 
        #while (i<=175) texture {Alu_tex scale 1/25} #local i=i+1; #end 
        #while (i<=255) 
            texture {
                pigment {rgb -50/255/(255-175)*(i-255) filter .2} 
                finish {Slug_fin}
            }
            #local i=i+1; 
        #end 
    }
    scale 25
}

cylinder {0,-27*y,2.6 texture {Alu_tex} rotate -90*z translate -x*8}
cylinder {0,27*y,2.6 texture {With} rotate -90*z translate -x*8}

