#version unofficial MegaPov 0.4;

/* Okay, so by now you know that this doesn't produce perfect meshes, 
   but in case you're in pursuit of at least a little more perfection,
   one of my experiments in "gap patching" did yield a little success,
   but whether the degree of quality it adds is worth the higher file
   size and longer scan time is something you'll have to decide for
   yourself. Here's an example of how it's used. To activate the extra
   scan (known as "fill scanning") you must invoke a second macro called
   ScanLevel prior to invoking the Triscan macro. The numeric parameter
   is a multiple factor. It must be set to either zero, which turns off
   fill scanning altogether (the default), or something greater than 1.
   Any value between 0 and 1 will default to 2x. Basically, when the
   multiple, "X", is set to anything above 1, Triscan will first make a 
   preliminary pass identical to normal scanning, then will go back
   over everything at a density of X times the original specified density.
   This has two effects: it tends to patch many of the holes left in the
   preliminary pass, and it means you can use a lower initial density to
   begin with so as much as possible of the surface is filled with the
   larger, less numerous triangles 
*/

#include "triscan.mcr"

#declare objSphere =  
sphere { 0,1 }

//set the fill scan pass to 5x the initial density...
ScanLevel(5) 
//...and that means we can use a lower initial density, too.
Triscan(objSphere,"MySphere","sphere2.raw",5)

