#version unofficial MegaPov 0.4;

#include "triscan.mcr"

/* Here's an example of how to make a Leveller reference shape file.
   Below is declared a simple house (when I say "simple" I mean
   "think of the hotels in Monopoly"... but it's enough to make the
   point). All that needs be done differently is to make the filename
   end in .lsl -- the macro knows what to do from there. You now have
   a Leveller reference shape that you could sculpt a terrain around,
   then load that heightfield into POV and use it with the original
   house. Again, as with UDOs, don't go too crazy on the scan depth. 
   This is only a basic reference shape.
*/

#declare House =
union { 
   prism { ///lprsRoof
      linear_sweep
      linear_spline
      -1.0,0.0
      4  
      <-1.0, 0.0>,<1.0, 0.0>,<0.0, 1.0>,<-1.0, 0.0>
      rotate -x*90 scale <2.0, 1.0, 6.25> 
      rotate <-90.0, -180.0, 90.0> translate  <3.125, 0.0, 2.0>
   }
   box { // cubBuilding
      <-1, -1, -1>, <1, 1, 1>
      scale <3.0, 1.75, 1.0>
      translate  1.0*z
   }
   box { // cubChimney
      <-1, -1, -1>, <1, 1, 1>
      scale <0.25, 0.25, 0.5>
      translate  <2.045854, 0.0, 3.136976>
   }
   /*I created this example quickly in Moray, which uses right handed coords,
     but Leveller uses left handed coords so before we scan, we apply...  
     RHC -> LHC conversion*/ 
     rotate -90*x  scale <1,1,-1>
}


Triscan(House,"House","house.lsl",8)

