#version unofficial MegaPov 0.4;

/* Here, by contrast, is an example of the kind of shape Triscan is really
   bad at duplicating well. A cylinder has rounded sides, but flat capped
   ends, so there are two faces that fall off at sharp 90 degree angles to
   the scan direction here. I include this example to get the limitations 
   of the scan routine known right from the very beginning. Notice how the 
   rounded surfaces of the cylinder scan fairly well, but the flat circular 
   end pieces leave lots of gappy holes. Now, this would be fine for a quick
   and dirty reference object, but it's not exactly a high quality replica.
   To minimize this effect, increase the mesh density as much as you think
   is reasonable given the level of quality you need. 
*/

#include "triscan.mcr"

#declare objCylinder =  
   cylinder{ <0,0,-.5>,<0,0,.5>,.5 }

Triscan(objCylinder,"MyCylinder","cylinder.raw",20)

