#version unofficial MegaPov 0.4;

/* This is the most basic example of how to work with triscan.mcr
   Just include the macro definition file (make sure to follow the
   new #version restrictions!) then declare an object (or #include
   an INC file with an existing object #declare) and invoke the
   triscan macro. Format is...

   Triscan( objTarget, "objName", "filename.ext", density)

   where objTarget is the declared name of the target object,
         "objName" is a quoted string containing the name you
                   want your mesh to be given (RAW files do 
                   support naming your mesh elements, and triscan
                   takes advantage of this...)
         "filename.ext" - pretty self explanatory. File names, 
                   such as "Outmesh.raw" will determine the mesh
                   file created. Valid filenames should end in
                   ".raw" for a RAW triangle file, or ".lsl" for
                   a Leveller reference shape file. The extension
                   is recognized by the macro and is used to 
                   determine the desired output type. 
         Density - is a numeric value which approximately amounts     
                   to "how many mesh segments do you want per POV
                   unit?" 10 gives relatively good definition,
                   although for large objects this will result in
                   phenomenal file sizes. I've never obtained more
                   that "fair" results even at wildly excessive
                   mesh densities with this technique, so use your
                   own judgement and don't go too crazy.
*/

#include "triscan.mcr"

#declare objSphere =  
sphere { 0,1 }

Triscan(objSphere,"MySphere","sphere.raw",10)

