#version unofficial MegaPov 0.4;

#include "triscan.mcr"

/* What follows is the beginning of an experiment you can use to scan a
   Julia fractal object and use it in Moray. Now, a mesh density of 8 will
   produce a somewhat gappy, not very detailed looking scan, but no matter, 
   as we only want it to make an UDO object anyway. To proceed...
   1.) Run the scan you see below to generate the file "julia1.raw"
   2.) Run the julia1.raw file through either Crossroads or 3DWin and
       convert it into an UDO/INC pair. 
   3.) Delete the INC file created in the last step, but then create a
       new file of exactly the same name.
   4.) copy the #declare below into that file. You now have an UDO that
       will provide a wireframe for Moray and points to the actual POV
       object provided below.
   5.) Experiment in a text editor creating your perfect dream julia and
       substitute it below, repeating 1-4 to create any julia you like
       in Moray
*/


#declare Julia_1 =  
julia_fractal {
  <.2,0.02,.5,0>
  max_iteration 5
  precision 20
 }     

Triscan(Julia_1,"Julia_1","julia1.raw",8)

