//  Makes a Fly or bug, around <7L*3W*2H>
//  on z-plane, center of thorax at origin and with head towards +x.

#include "wings.inc"

#local BodyT =
texture{ pigment{ gradient x
                  colour_map{ [0.81 rgb <0.05,0.04,0.03> ]
                              [0.85 rgb <0.24,0.15,0.10> ] }
                  scale 0.4 }
         finish{ phong 0.2 phong_size 20 ambient 0.2 }
         normal{ bumps 1 scale <0.02,1,1> }
       }

#local ScarabGreen =
texture{ pigment{ rgb <0.02,0.1,0> }
         finish{ phong 1 phong_size 20 metallic
                 brilliance 30 diffuse 0.8 ambient 0.1 }
         normal{ bumps 0.2 scale <1,0.01,1> }
       }

#local BugBrown =
texture{ pigment{ rgb <0.1, 0.05, 0.02> }
         finish{  ambient .15
                  diffuse .4
                  specular 0.8
                  roughness .01
                  brilliance 30
                  metallic
                 }
         normal{ bumps 0.1 scale 0.005 }
       }

#local WingTex=
texture{ pigment{ rgbf <0.8,0.85,0.9,0.96> }
         finish{ phong 0.6 phong_size 40 diffuse 0.6 reflection 0.05 ambient 0.2
                 irid{ 0.35 thickness 0.3 turbulence .25 }
               }
       }

#local WngL =
height_field{ png "hfield.png" smooth
         clipped_by{ object{ WingL } }
         scale <4.3,0.06,4.3>
         texture{ WingTex }
  }
#local WngS =
height_field{ png "hfield.png" smooth
         clipped_by{ object{ WingS } }
         scale <4.3,0.06,4.3>
         texture{ WingTex }
  }

#local Leg1 =
union{
  cone{ 0,0.09, <0,2,0.75>, 0.07 } sphere{ <0, 2, 0.75>, 0.07 }
  cone{ <0, 2, 0.75>, 0.07, <0, 1.7,1.95>, 0.05 } sphere{ <0,1.7,1.95>, 0.05 }
  cone{ <0, 1.7, 1.95>, 0.05, <0,2,2.7>, 0.025 }
  rotate -x*7   // Lifts leg
 }

#local Leg2 =
union{
  cone{ 0, 0.09, <0,1.85,1.1>, 0.07 } sphere{ <0, 1.85, 1.1>, 0.07 }
  cone{ <0, 1.85, 1.1>, 0.07, <0, 0.85,1.85>, 0.05 } sphere{ <0,0.85,1.85>, 0.05 }
  cone{ <0,0.85,1.85>, 0.05, <0,1,2.6>, 0.025 }
  rotate -x*8
 }

#local Legs =
union{ object{ Leg1 rotate -z*50 }  object{ Leg1 rotate -z*130 } // Front
       object{ Leg2 } object{ Leg2 rotate z*180 }   // Middle
       object{ Leg1 rotate z*50 } object{ Leg1 rotate z*130 } // Rear
     }

#local Count=0.04;
#local Antenna=
union{ sphere{ y*1.5,0.06 rotate -z*60 }
       #while (Count<1)
          cone{ <-0.2,1.49,0>,0, <0,1.5,0>,0.06 rotate -z*Count*60 }
          #local Count=Count+0.059;
       #end
       translate <0,-1.5,0> 
      }

#local Head =
union{
  union{     // Eyes
    sphere{ 0,0.7 scale <1,0.75,1> rotate z*45 translate <0.4,-0.3,-0.1> }
    sphere{ 0,0.7 scale <1,0.75,1> rotate -z*45 translate <0.4, 0.3,-0.1> }
    pigment{ Black } finish{ phong 0.75 phong_size 16 }
    normal{ bumps 0.2 scale 0.01 }
       }
  union{
    sphere{ 0,0.9 }  // Head
    sphere{ 0,0.75 scale <1,0.6,1> translate <0.35,0,-0.03> }
    union{ object{ Antenna rotate <-45,20,-10> }
           object{ Antenna rotate <-135,20,10> }
           texture{ BugBrown }
           translate <0.75,0,-0.6>
          }
    cone{ <0.80,0, 0.4>, 0.12, <0.9,0,1>, 0.06 }    // Mouth
    texture{ BodyT scale 0.01 }
       }
  scale <0.75,1,0.8>
}

#declare Bug =
union{
  object{ Head translate x*1.35 }
  superellipsoid{ <0.5,0.8> texture{ ScarabGreen } rotate y*90 scale <1,1,0.8> } // Thorax
  sphere{ -x*2, 2 scale <1,0.6,0.5> texture{ BodyT } } // Abdomen
  object{ Legs translate z*0.7 texture{ BugBrown }
  }
     // Use Z to open wings
object{ WngL rotate <-90,0, 130>
             rotate < 20,-6,0> translate <0, 0.65,-0.74> } // L
object{ WngL rotate <-90,0, 130> scale <1,-1,1>
             rotate <-20,-6,0> translate <0,-0.65,-0.74> } // R
object{ WngS rotate <-90,0, 128> scale <1.1, 0.6, 1>
             rotate < 28,-6,0> translate <0, 0.4,-0.77> }  // L
object{ WngS rotate <-90,0, 128> scale <1.1,-0.6, 1>
             rotate <-28,-6,0> translate <0,-0.4,-0.77> }  // R

}

//object{ Bug }

