//*****************************************************************************************************************************
// scene environment
//*****************************************************************************************************************************
#local pov=<0,0,-8>;
#local poi=<2,0,5>;
#local rot=z*30;

camera {
	location pov
	sky vrotate(y*image_height,rot)
	right vrotate(x*image_width/image_width,rot)
	look_at poi
	normal { bump_map { png "logomask.png" interpolate 2 } 1 translate -0.5 }
}
                     z
global_settings {
	max_trace_level 20
}

#include "rotobj.inc"

#local mirror = texture {
	pigment { rgb 1 }
	finish {
		reflection 0.5
		diffuse 0.2
		specular 0.2
	}
}
	
rotobj (2,<0,1,20>,<0,4,5>,1,0.1,2,mirror)
rotobj (3,<0,1,20>,<0,4,5>,1,0.1,2,mirror)

light_source { vrotate(z*2,y*0)	rgb <1,0,0> }
light_source { vrotate(z*2,y*120)	rgb <0,1,0> }
light_source { vrotate(z*2,y*240)	rgb <0,0,1> }

