// IKN.inc problem demo file
// anthony bennett
// 26(01)2000
// requires: pov-ray 3.1

camera
{
 location vnormalize(<1,2,-3>)*40
 look_at 0
}

light_source {vnormalize(<1,1,-1>)*50 1}

$ikn_p1=<0,0, 10>;
$ikn_p2=<0,0,-10>;
$ikn_z1=-z;
$ikn_z2=z;  // anything but z or -z works
$ikn_y1=y;
$ikn_y2=y;
$ikn_length=vlength(ikn_p1-ikn_p2)*1.5;
$ikn_radius1=1;
$ikn_radius2=1;
$ikn_links=15;
$ikn_stiffness1=1;
$ikn_stiffness2=1;
$ikn_twist=0;
$ikn_samples=50;

#include "ikn.inc"

#declare C = 0;
#while (C<=ikn_links-1)
 sphere
 {
  0,1
  pigment {red 1}
  scale ikn_r[C]
  transform ikn_transform[C]
 }
 #declare C = C+1;
#end