//*****************************************************************************************************************************
// scene environment
//*****************************************************************************************************************************
#local pov=<1/3,2/3,-1>;
#local dist=3;
#local poi=<0,0,0>;
#local pov=vnormalize(pov)*dist+poi;
#local rot=0;
#local quality = 0;

camera {
	location pov
	sky vrotate(y*1,rot)
	right vrotate(x*image_width/image_height,rot)
	look_at poi
	normal { bump_map { png "logomask.png" interpolate 2 } 1 translate -0.5 }
}

global_settings {
	max_trace_level 20
	number_of_waves 20
	#if (quality >=1)
		#if(quality >= 2)
	  		// High Quality - slow rendering
		  	ini_option "+QR"
		  	ini_option "Preview_Start_Size=8"
		  	ini_option "Preview_End_Size=4"
		  
		  	radiosity{
			    count 80             // CHANGE range from 20 to 150
			    nearest_count 6      // CHANGE range from 3 to 10
			    error_bound 1        // CHANGE - range from 1 to 3 - should correspond with Preview_End_Size
			                         //   1 : preview_end_size = 4
			                         //   3 : preview_end_size = 8
			                         //   use preview_start_size = 16 (or 8 for high quality)
			                         // you can go lower than 1, but then you probably will want to set
			                         // preview_end_size to 2, which is really slow
			    recursion_limit 4    // CHANGE
			    
			    low_error_factor .5  // leave this
			    gray_threshold 0.0   // leave this
			    minimum_reuse 0.015  // leave this
			    brightness 1         // leave this
			    
			    max_sample 1         // CHANGE - this should be the same as the brightest object
			    adc_bailout 0.01/1   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
			    normal on
		  	}
		#else
		  	// Medium Quality - works for most scenes
		  	ini_option "+QR"
		  	ini_option "Preview_Start_Size=16"
		  	ini_option "Preview_End_Size=8"
		  
		  	radiosity{
			    count 40             // CHANGE range from 20 to 150
			    nearest_count 3      // CHANGE range from 3 to 10
			    error_bound 3        // CHANGE - range from 1 to 3 - should correspond with Preview_End_Size
			                         //   1 : preview_end_size = 4
			                         //   3 : preview_end_size = 8
			                         //   use preview_start_size = 16
			                         // you can go lower than 1, but then you probably will want to set
			                         // preview_end_size to 2, which is really slow
			    recursion_limit 3    // CHANGE
			    
			    low_error_factor .5  // leave this
			    gray_threshold 0.0   // leave this
			    minimum_reuse 0.015  // leave this
			    brightness 1         // leave this
			    
			    max_sample 1         // CHANGE - this should be the same as the brightest object
			    adc_bailout 0.01/1   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
			    normal on
			}
		#end
	#end
}

#local isobase = function { y }
#local isoripple = function {
	pigment {
		wood
		rotate x*90
		sine_wave
		frequency 2
		colour_map {
			[0 rgb 0]
			[1 rgb 1]
		}
	}
}
#local isofade = function {
	pigment {
		cylindrical
		colour_map {
			[0 rgb 0]
			[1 rgb 1]
		}
	}
}

isosurface {
	function { isobase(0,y*10,0) +isoripple(x,y,z)*isofade(x,y,z) }
	max_gradient 20
	eval
	accuracy 0.01
	bounded_by { box { <-1000,-1,-1000> <1000,1,1000> } }
	texture {
		pigment { rgb 1 }
		finish { ambient 0 diffuse 0.5 reflection 0.5 }
	}
}

light_source { vrotate(<0,1,1>,0*y) rgb <1,0,0> }
light_source { vrotate(<0,1,1>,120*y) rgb <0,1,0> }
light_source { vrotate(<0,1,1>,240*y) rgb <0,0,1> }

#local sp1 = seed(27);

#macro _split(p1,p2,si,lev)
	#local p3= p1+(p2-p1)/2+(<rand(sp1),rand(sp1),rand(sp1)>-0.5)*vlength(p2-p1)/4;
	#if (lev>0)
		_split(p1,p3,si,lev-1)
		#write (sweep,p3," ",si,"\n")
		_split(p3,p2,si,lev-1)
	#end
#end

#macro split(p1,p2,si,lev)
	#fopen sweep "split.out" write
	#write (sweep,pow(2,lev)+3,"\n")
	#write (sweep,p1," ",si,"\n")
	#write (sweep,p1," ",si,"\n")
	_split(p1,p2,si,lev)
	#write (sweep,p2," ",si,"\n")
	#write (sweep,p2," ",si,"\n")
	#fclose sweep
#end

#macro ssw(p1,p2)
	sphere_sweep {
		catmull_rom_spline_sphere_sweep
		split(p1,p2,0.01,5)
		#include "split.out"
	}
#end

merge {
	#local p1= vrotate(<0,1,1>,0*y);
	#local p2= vrotate(<0,1,1>,120*y);
	#local p3= vrotate(<0,1,1>,240*y);
	#local sc= 2;
	ssw(p1,p2)
	ssw(p2,p3)
	ssw(p3,p1)
	ssw(p1,0)
	ssw(p2,0)
	ssw(p3,0)
	sphere { p1,0.05 }
	sphere { p2,0.05 }
	sphere { p3,0.05 }
	sphere { 0, 0.1 }
	pigment { rgbt 1 }
	hollow
	interior {
		media {
			emission 100			
			intervals 1
			samples 5,5
			confidence 1-2/10
			variance 1/65
			density {
				spherical
				scale sc
				translate p1
				colour_map {
					[0 rgb 0]
					[1 rgb <1,0,0>]
				}
			}
		}
		media {
			emission 100
			intervals 1
			samples 5,5
			confidence 1-2/10
			variance 1/65
			density {
				spherical
				scale sc
				translate p2
				colour_map {
					[0 rgb 0]
					[1 rgb <0,1,0>]
				}
			}
		}
		media {
			emission 100
			intervals 1
			samples 5,5
			confidence 1-2/10
			variance 1/65
			density {
				spherical
				scale sc
				translate p3
				colour_map {
					[0 rgb 0]
					[1 rgb <0,0,1>]
				}
			}
		}
	}
}

	
