//Additional macros for "fur.inc"
//Created by Margus Ramst (margus@peak.edu.ee)
//January 23, 2000

//Vector debug
//Requires the vector identifier

#macro v_debug(V)
concat("<",str(V.x,0,3),",",str(V.y,0,3),",",str(V.z,0,3),">")
#end

//Interpolation
//GC - global current
//GS - global start
//GE - global end
//TS - target start
//TE - target end
//Method - interpolation method:
//         Method = 0 - cosine interpolation
//         Method > 0 - exponential (1 - linear, etc)

#macro Interpolate(GC,GS,GE,TS,TE,Method)
    (#if(Method!=0)
        (TS+(TE-TS)*pow((GC-GS)/(GE-GS),Method))
    #else
        #local X=(GC-GS)/(GE-GS);
        #local F=(1-cos(X*pi))*.5;
        (TS*(1-F)+TE*F)
    #end)
#end

//Create random number of given mean and maximum deviation
//M - mean value
//D - maximum deviation
//Seed - (declared) random number seed identifier
#macro rand_ext(M,D,Seed)
        (M+(rand(Seed)-.5)*2*D)
#end

//Give a random vector of given mean and max deviation
//M - mean (vector/float)
//D - max deviation (vector/float)
//Seed - (declared) random number seed identifier

#macro v_rand_ext(M,D,Seed)
        #local MV=M+<0,0,0>;
        #local DV=D+<0,0,0>;
        (<rand_ext(MV.x,DV.x,Seed),rand_ext(MV.y,DV.y,Seed),rand_ext(MV.z,DV.z,Seed)>)
#end
