//Fur Generator (version 2) example scene
//Created by Margus Ramst (margus@peak.edu.ee)
//January 23, 2000

//A furry torus created with fur.inc
//Expect parsing to take a few minutes :)
//This file also demonstrates file export. It outputs the cones
//to "furtemp.o" and point coordinates to "furtemp.p"

//NB! I recommend you turn off warning console stream with the
//"-gw" commandline switch, otherwise you will get multiple warnings
//about manual bounding (see readme.txt for details).

#include "fur.inc"

//Camera and light
#declare CPos=<4,4,-4>;
#declare LPos1=<0,10,-20>;
#declare LPos2=<0,50,0>;

camera{location CPos look_at 0}
light_source{LPos1 color 1}
light_source{LPos2 color .5 spotlight point_at 0 radius 10 falloff 15}

//Object to be sampled:
#declare Obj=torus{1, 0.5}

//Display the object (not necessary, of course)
object{Obj pigment{rgb <1, 0.5, 0.5>}}

//A plane to test fur shadows
plane{y,-2 pigment{rgb 1}}

//Create the array of test points for culling:
//positions of the camera and light sources
#declare TPos=array[3]{CPos,LPos1,LPos2}

//Generating the fur.
//Note that since a torus is flatter along the Y axis,
//we can use fewer samples in that direction.

object{
    Fur(
        Obj, <40,20,40>, 2, //Sampling options
        3, 0.3, 0.2, 0.01,  //Length and thickness options
        -y, .5, .1,         //Bend and twist options
        1, "furtemp.o",     //Object file output
        1, "furtemp.p",     //Point file output
        1, TPos, 115,       //Culling options
        12345               //Random number seed
        )
    pigment{rgb <.7,.3,.25>}
}

//When "furtemp.o" is created, you can comment out the
//object above and uncomment the lines below to save parse time;
//Remember to delete "furtemp.o" and comment out the below lines
//when you want to generate fur with different settings.

/*
#include "furtemp.o"
object{Hairs pigment{rgb <.7,.3,.25>}}
*/

//Also, comment out the original macro and uncomment the lines below
//to see a demonstration of 'Fur_PF' creating fur from the
//coordinates in file "furtemp.p"

/*
object{
    Fur_PF(
        "furtemp.p", 1,
        3, 0.3, 0.2, 0.01,
        -y, .5, .1,
        0, 0,
        1, TPos, 115,
        12345
        )
    pigment{rgb <.7,.3,.25>}
}
*/