// A.Zandomeneghi         AZ// 23-1-2000
// Source was created for www.anna-fans.com
// "Anna Kournikova, VidCaps, News and More."
// The models coming with Lipstick 7/8 are public domain
// Comments have to remain in all POV files, though.
// Written for POV V3.1 (Persistance of Vision Raytracer)


#include "stairs_tex.inc"
#include "handle.inc"             // import handles for stairs
#declare CylScrew0 = object {     // tiny screws on base of stairs
  cylinder {
    <0,0,1>, <0,0,0>, 1 
    scale <0.008, 0.008, 0.01>
    translate  <0.0, -0.05, 0.01>
  }
}
#declare Base = union {           // Base of stairs
  cylinder { // CylBasePlate
    <0,0,1>, <0,0,0>, 1 
    scale <0.07, 0.07, 0.01>
  }
  object { CylScrew0 }
  object {
    CylScrew0
    rotate -0.0*x
    translate  <-0.05, 0.05, -0.0>
  }
  object {
    CylScrew0
    rotate -0.0*x
    translate  <0.0, 0.1, -0.0>
  }
  object {
    CylScrew0
    rotate -0.0*x
    translate  <0.05, 0.05, -0.0>
  }
}
#declare OneSide = union {        // Handle with base
  object { Handle }
  object { Base }
}
#declare RndCbStepPlate = merge {      // Don't see much of this on Lipstick. But we want a full model.
                                       // Creates are nice looking stainless steel step
  sphere { <0.4100, 0.1100, 0.1100>, 0.0400 }
  sphere { <0.4100, -0.1100, 0.1100>, 0.0400 }
  sphere { <-0.4100, -0.1100, 0.1100>, 0.0400 }
  sphere { <-0.4100, 0.1100, 0.1100>, 0.0400 }
  sphere { <0.4100, 0.1100, -0.1100>, 0.0400 }
  sphere { <0.4100, -0.1100, -0.1100>, 0.0400 }
  sphere { <-0.4100, -0.1100, -0.1100>, 0.0400 }
  sphere { <-0.4100, 0.1100, -0.1100>, 0.0400 }
  cylinder { <0.4100, 0.1100, 0.1100>, <-0.4100, 0.1100, 0.1100>, 0.0400 }
  cylinder { <0.4100, -0.1100, 0.1100>, <-0.4100, -0.1100, 0.1100>, 0.0400 }
  cylinder { <0.4100, -0.1100, -0.1100>, <-0.4100, -0.1100, -0.1100>, 0.0400 }
  cylinder { <0.4100, 0.1100, -0.1100>, <-0.4100, 0.1100, -0.1100>, 0.0400 }
  cylinder { <0.4100, 0.1100, -0.1100>, <0.4100, 0.1100, 0.1100>, 0.0400 }
  cylinder { <0.4100, -0.1100, -0.1100>, <0.4100, -0.1100, 0.1100>, 0.0400 }
  cylinder { <-0.4100, -0.1100, -0.1100>, <-0.4100, -0.1100, 0.1100>, 0.0400 }
  cylinder { <-0.4100, 0.1100, -0.1100>, <-0.4100, 0.1100, 0.1100>, 0.0400 }
  cylinder { <0.4100, 0.1100, 0.1100>, <0.4100, -0.1100, 0.1100>, 0.0400 }
  cylinder { <0.4100, 0.1100, -0.1100>, <0.4100, -0.1100, -0.1100>, 0.0400 }
  cylinder { <-0.4100, 0.1100, -0.1100>, <-0.4100, -0.1100, -0.1100>, 0.0400 }
  cylinder { <-0.4100, 0.1100, 0.1100>, <-0.4100, -0.1100, 0.1100>, 0.0400 }
  box { <-0.4100, -0.1100, -0.1500> <0.4100, 0.1100, 0.1500> }
  box { <-0.4100, -0.1500, -0.1100> <0.4100, 0.1500, 0.1100> }
  box { <-0.4500, -0.1100, -0.1100> <0.4500, 0.1100, 0.1100> }

  scale <0.22, 2.0, 0.04>
  translate  <0.45, -0.25, -0.3>
}
#declare CbCutSmall0 = object {
  box {
    <-1, -1, -1>, <1, 1, 1>
    scale <0.005, 0.2, 0.04>
    translate  <0.41, -0.25, -0.3>
  }
}
#declare CbCutLong0 = object {
  box {
    <-1, -1, -1>, <1, 1, 1>
    scale <0.005, 0.28, 0.04>
    translate  <0.53, -0.25, -0.3>
  }
}

// One complete step
#declare Step0 = difference {
  object { RndCbStepPlate }
  object { CbCutSmall0 }
  object { CbCutLong0 }
  object {
    CbCutLong0
    rotate 0.0*y
    translate  -0.02*x
  }
  object {
    CbCutLong0
    rotate 0.0*y
    translate  -0.04*x
  }
  object {
    CbCutLong0
    rotate 0.0*y
    translate  -0.06*x
  }
  object {
    CbCutLong0
    rotate 0.0*y
    translate  -0.08*x
  }
  object {
    CbCutSmall0
    rotate -0.0*z
    translate  <-0.02, 0.0, 0.0>
  }
  object {
    CbCutSmall0
    rotate -0.0*z
    translate  <-0.04, 0.0, 0.0>
  }
  object {
    CbCutLong0
    rotate 0.0*y
    translate  -0.1*x
  }
}

#declare BothHandles = union {
  object { OneSide }
  object {
    OneSide
    translate  -0.5*y
  }
  object { Step0 }
  object {
    Step0
    translate  -0.4*z
  }
  object {
    Step0
    translate  -0.8*z
  }
}
union {         // The complete stair with 3 steps
  object { BothHandles }
  material {
    Chrome_Texture
  }
  scale 1.5
  rotate 90.0*z
  translate  <0.3, -6.3, 0.0>
}