#declare r0 = 0.024;
#declare a1 = 1.1;
#declare a2 = 0.5;
#declare t1 = 1.5;
#declare h1 = 0.2;
#declare b1 = 0.4;
#declare r1 = 0.14;
#declare r2 = 0.25;


#declare alpha1 = atan2(b1, a1-a2);
#declare u1 = r1/tan(0.5*alpha1);
#declare u2 = r2*tan(0.5*alpha1);

#declare l1 = sqrt(pow(a1-a2, 2) + b1*b1) - u1;

#declare TwoPlanes1 = union {
  plane {
    z,0
    rotate -(180/pi)*alpha1*y
    translate  <r1+r1*cos(alpha1), 0.0, a1-u1+r1*sin(alpha1)>
  }
  plane {
    z,0
    translate (a1-u1)*z
  }
}                             

#declare Bogen1 = difference {
  torus {
    r1, r0
    translate  <r1, 0.0, a1-u1>
  }
  object { TwoPlanes1 }
}

#declare TwoPlanes1 = union {
  plane {
    -z,0
    rotate -(180/pi)*alpha1*y    
    translate  <b1-r2+r2*cos(alpha1), 0.0, a2-u2+r2*sin(alpha1)>
  }
  plane {
    z,0
    translate (a2-u2)*z
  }
}                             
  
#declare Bogen2 = difference {
  torus {
    r2, r0
    translate  <b1-r2, 0.0, a2-u2>
  }
  object { TwoPlanes1 }
}

#declare Handle = union {

  cylinder {
    <0,0,1>, <0,0,0>, 1 
    scale <r0, r0, a1-u1>
  }

  cylinder {
    <0,0,1>, <0,0,0>, 1 
    scale <r0, r0, a2-u2+t1>
    translate  <b1, 0.0, -t1>
  }
  cylinder {
    <0,0,1>, <0,0,0>, 1 
    scale <r0, r0, l1-u2>
    rotate -(180/pi)*alpha1*y                         
                         
    translate <b1-r2*(1-cos(alpha1)), 0.0, a2-u2+r2*sin(alpha1)>
  }
  
  cylinder {
    <0,0,1>, <0,0,0>, 1 
    scale <0.07, 0.07, 0.015>
  }
  
  cylinder {
    <0,0,0>, <1,0,0>, 1 
    scale <b1, r0, r0>
    translate  <0, 0.0, h1>
  }
  object { Bogen1 }
  object { Bogen2 }
}