// This code was made by Ms Ehry (e-ri-@remus.dti.ne.jp)
// http://www.remus.dti.ne.jp/~e-ri-/
// Code at http://www.remus.dti.ne.jp/~e-ri-/suikan.html
// I've fixed a few things that prevented it to work properly
// and merged the include file and the demo file
// Gilles Tran

//////////////////////////////////////////////////////////////////////////////////
// Include file
/////////////////////////////////suikan///////////////////////////////////////////

// Note : the original texture was created to work in POV 3.0 so I changed it to POV 3.1
#declare T_Suikan = material{
        texture {
                pigment { color rgbf < .94, .98, 1, .8> }
                finish {  ambient  .04
                        diffuse  .09
                        brilliance 1
                        reflection .3
                        metallic off
                        phong  .8
                        phong_size 200
                }
        }
        interior{
//                refraction  on
                ior  1.4
                // caustics  .8
                fade_distance  5
                fade_power 1
        }
}


#declare Chu_Num = 8 ; 

#declare Kihon_W = 3 ;
#declare Kihon_H = 2 ;

#declare Kankaku_H =  .3 ;
#declare Kankaku_W =  .5 ;

#declare Bai_W = 3 ;
#declare Bai_H = 2.5 ;
#declare Bai_A_H = 1.5 ;
#if ( Kihon_H > Bai_A_H )
#declare Bai_A_H = Kihon_H -0.1 ;
#end
#declare Bai_A_W = 3 ;

#declare R =  .5;  /// hankei
#declare RV = 20 ;
#declare Sikii = 5 ; // threshold

#declare Seed_H = seed(3) ;
#declare Seed_W = seed(7) ;
#declare Seed_A = seed(2) ;

#declare EN = on ;
#declare EN_R =  3 ;
#declare Sore = 11 ;

#declare KYU = on ;
#declare Kyu_R_Bai = 1.3 ;

#declare Randam =  .5 ;
#declare W_Count = 1 ;

/////////////////////////kokokara///////////////////
#declare Suikan =
blob {  threshold Sikii
        
        ////chu- no kurikaesi///////
        #declare C_Chu = 0 ;
        #while ( C_Chu < Chu_Num )
        
                #declare Rand_H = rand(Seed_H) ;
                #declare Rand_W = rand(Seed_W) ;
                #declare Aida_Rand_H = rand(Seed_A) ;
                
                #if ( C_Chu = 0 )
                        #declare Hidari_Chu_H = rand(Seed_H)*Bai_H ;
                        #declare Owari_Chu_H = Hidari_Chu_H ;
                #else
                        #declare Hidari_Chu_H = Migi_Chu_H ;
                #end

                
                #declare Migi_Chu_H = Rand_H *Bai_H ;
                #declare Aida_Chu_H = Aida_Rand_H *Bai_A_H ;
                
                #if ( C_Chu = 0)
                        #declare Hidari_Chu_W = 0 ;
                        #declare Migi_Chu_W = Kihon_W + Rand_W *Bai_W ;
                #else
                        #declare Hidari_Chu_W = Migi_Chu_W ;
                        #declare Migi_Chu_W =  Migi_Chu_W + Kihon_W + Rand_W *Bai_W ;
                #end
                

                #declare Aida_Chu_W = Hidari_Chu_W + Kihon_W/3 +(Kihon_W/3 + Rand_W*Bai_W/2)*rand(Seed_A) ;
                
                #declare Hidari_Katamuki =(Hidari_Chu_H + Aida_Chu_H) / ((Aida_Chu_W - Hidari_Chu_W)*(Aida_Chu_W - Hidari_Chu_W)) ;
                #declare Migi_Katamuki=(Migi_Chu_H + Aida_Chu_H) / ((Migi_Chu_W - Aida_Chu_W)*(Migi_Chu_W - Aida_Chu_W)) ;
                
                //////yoko no kurikaesi//////
                #declare C_Yoko = Hidari_Chu_W ;
                #while ( C_Yoko <= Migi_Chu_W )
                
                        //////tate no kurikaesi//////
                        #declare H_Count = 1 ;
                        #declare C_Tate = -1 * Kihon_H ;
// Fix starts here                        
                        #if ( C_Yoko < Aida_Chu_W )
                             #declare toto=(Hidari_Katamuki * (Aida_Chu_W - C_Yoko)*(Aida_Chu_W - C_Yoko)-Aida_Chu_H);
                        #else
                             #declare toto=(Migi_Katamuki * (C_Yoko - Aida_Chu_W) * (C_Yoko - Aida_Chu_W )-Aida_Chu_H);
                        #end
// Fix ends here                        
                        #while ( C_Tate <= toto)
// Original code starts here
//                                #if ( C_Yoko < Aida_Chu_W )
//                                     (Hidari_Katamuki * (Aida_Chu_W - C_Yoko)*(Aida_Chu_W - C_Yoko)-Aida_Chu_H)
//                                #else
//                                     (Migi_Katamuki * (C_Yoko - Aida_Chu_W) * (C_Yoko - Aida_Chu_W )-Aida_Chu_H)
//                               #end
//                               )
// Original code ends here
                        
                                sphere {0, R, RV
                                        translate <C_Yoko, 0, 0 >
                                        
                                        /////*///en ni suru ///*///////
                                        #ifdef ( EN )
                                                translate <-1* C_Yoko, 0, 0>
                                                #declare EN_Kaku = 360 / (Chu_Num*( (Kihon_W+Randam*Bai_W)/Kankaku_W)) ;
                                                        translate< cos(radians( W_Count*EN_Kaku ))*(EN_R+( H_Count/Sore * H_Count/Sore )),
                                                        0,  sin(radians( W_Count*EN_Kaku ))*(EN_R+ ( H_Count/Sore * H_Count/Sore)) >
                                        #end
                                        /////////en owari/////////////
                                        
                                        translate <0, C_Tate, 0 >
                                }
                                 /////tate  owari/////////
                                #declare H_Count = H_Count + 1 ;
                                #declare C_Tate = C_Tate + Kankaku_H ;
                        #end
                        
                                                /////*//saki no tubutubu//*////
                        #ifdef ( KYU )
                                #if ( C_Yoko = 0 )
                                        sphere {0, R*Kyu_R_Bai, RV
                                                translate< cos(radians( W_Count*EN_Kaku ))*(EN_R+( H_Count/Sore * H_Count/Sore )+0.5),
                                                0,  sin(radians( W_Count*EN_Kaku ))*(EN_R+ ( H_Count/Sore * H_Count/Sore)+0.5) >
                                                translate <0, C_Tate+0.5, 0 >
                                        }
                                #else
                                        #if (  C_Yoko > Migi_Chu_W - Kankaku_W )
                                                sphere {0, R*Kyu_R_Bai, RV
                                                translate< cos(radians( W_Count*EN_Kaku ))*(EN_R+( H_Count/Sore * H_Count/Sore )+0.5),
                                                0,  sin(radians( W_Count*EN_Kaku ))*(EN_R+ ( H_Count/Sore * H_Count/Sore)+0.5) >
                                                translate <0, C_Tate+0.5, 0 >
                                                }
                                        #end //  else no if
                                #end //  saisho no if
                        #end //  ifdef
                                                ////////tubutubu owari////////
                        
                        /////yoko owari//////////
                        #declare W_Count = W_Count + 1 ;
                        #declare C_Yoko = C_Yoko + Kankaku_W ;
                #end
                
                /////chu- owari//////////
                #declare C_Chu = C_Chu + 1 ;
        #end
        
        //translate y*Kihon_H //takasa wo chousetu 
        
        material { T_Suikan }
}


////////////////////////////////////////////////////////////////////////////
// Demo file
////////////////////////////////////////////////////////////////////////////
camera { location < 3, 8, -13.5>
         look_at < 0,0,0>
        }

light_source { < 200, 500, -700 > color rgb <1, 1, 1 > }


//#include "Suikan2.inc"

object { Suikan 
        translate y*Kihon_H 
        }
        
plane { y, 0
     texture {  pigment { color rgb 0 } 
                finish {  ambient      .1
                          diffuse      .4
                          brilliance   1
                          reflection   .4
                          phong        .7
                          phong_size  150
                }
      }
 }

sky_sphere {  pigment { color rgb < .8, .8, 1> } }



