/*************************************************************
* Overlay Macro v0.5 Jan 2000
* By Darcy Johnston, djohnston@iname.com
* 
* This macro is based heeavily on the work of Glenn McCarter,
* so much of the credit goes to him. 
*
* To use this macro, render your image normally. They start a 
* new image by calling this macro with the image name as one
* of the parameters. IMage height is important if you want to
* place other object (such as text) in the image. Renderheight
* and aspect ratio help specify the proper values for the 
* interlacing affect. If by chance you want to limit the number
* of bands, set NUmStripes to any positive number. Grainfilter
* controls the static graininess of the image (use values 
* between 0 and 1). Size can also be used to dictate the 
* thickness of the interlacing bands. For the most part, Size
* and NumStripes should just be set to 1 and 0 respectively, 
* as the results are most times not great.
*
* If you make any improvements to this macro, please email
* them to me and I'll keep an up to date version with all
* enhancements, including any I add.
*
* Feel free ot email me with any questions, comments or 
* suggestions.
*                                         
*************************************************************/

#macro overlay(ImageHeight, RenderHeight, AspectRatio, Image, Size, GrainFilter, NumStripes)
// Typical values for Size and Grainfilter are 1, .75
#version 3.1;
global_settings {
	adc_bailout 0.003922
	ambient_light <1.0,1.0,1.0>
	assumed_gamma 1.0
	hf_gray_16 off
	irid_wavelength <0.25,0.18,0.14>
	max_intersections 64
	max_trace_level 10
	number_of_waves 10
}

//===============================================
//             Variables
//===============================================

#local IH = ImageHeight;
#local AR = AspectRatio;
#local ImageWidth = IH * AR;
#local IW = ImageWidth;
#local RH = RenderHeight;
#local scale_factor = (2*IH)/RH; // this must be 1/2 of the final rendering height

// Setting the image height is useful if you want to place objects
// in front of the image.  If you leave the ImageHeight at 1, the total
// image will be 1 unit tall.  So objects placed in front of the image
// would have to be very small to be visible.

//===============================================
//             Cameras
//===============================================

// ----------------------------------------

camera
{   
	orthographic
  direction <1, 0, 0>
	sky       <0, 1, 0>  
	up        <0, IH, 0>
	right     <0, 0, IW>
  location  <IW/2, IH/2, 2>
  look_at   <IW/2, IH/2, 0>
}

background { color rgb 0 }

//===============================================
//             Textures
//===============================================

#local TVTex = // alternating bands
	texture {
		pigment {
			gradient y
			color_map {
				[ 0	rgbt 1 ]
				[ .25 	rgbt 1 ]
				[ .25 	rgbt<0.1,0.1,0.1,0.27> ]
				[ .75 	rgbt<0.1,0.1,0.1,0.27> ]
				[ .75 	rgbt 1 ]
				[ 1	rgbt 1 ]
			}  
			#if(NumStripes)
				scale (2*IH)/NumStripes
			#else
				scale scale_factor	  
			#end
		}
		finish { ambient 0.05 specular .3 roughness .01 }
	}		             
#local GrainTex = // noisy fuzz
	texture {
		pigment {
			bozo
			color_map {
				[ 0.00 rgbt 1 ]
				[ 0.25 rgbt 1 ]
//				[ 0.25 rgbt<0.1,0.1,0.1,0.17> ]
				[ 0.50 rgbt<0.1,0.1,0.1,GrainFilter> ]
//				[ 0.75 rgbt<0.1,0.1,0.1,0.17> ]
				[ 0.75 rgbt 1 ]
				[ 1.00 rgbt 1 ]
			}
			scale scale_factor

		}
		finish { ambient 0.05 specular .3 roughness .01 }
	}		             

#local TVEdgeTex = // a little darker at the sides of the image
	texture {
		pigment {
			gradient x
			color_map {
				[ 0.00 rgbt 1 ]
				[ 0.25 rgbt 1 ]
				[ 0.25 rgbt<1.1,1.1,1.1,0.03> ]
				[ 0.75 rgbt<1.1,1.1,1.1,0.03> ]
				[ 0.75 rgbt 1 ]
				[ 1.00 rgbt 1 ]
			}
			scale scale_factor
		}
		finish { ambient 0 specular .3 roughness .01 }
	}		             
#local TVEdgeTexT =
	texture {
		pigment { color rgb<1,0,0> }
		finish { ambient 0.95 specular .3 roughness .01 }
	}		             

                        	
#local ImageBox =
	box {
		<0,0,-.1>,<1,1,0> // the box is initially square
		//texture { WhiteInk }
		texture {
			pigment {
				image_map { // image is always projected from -z, with front facing +z, top to +Y
					png Image
					once
					interpolate 4
				}
			}
			finish { ambient 1 diffuse 0 }
			scale <1,1,1> // the image is initially square
		}
		scale <ImageWidth*1.005,ImageHeight*1.005, 1> // scale it up to match camera view
	}

#local Grain =
	box {
		<0,0,-.1>,<1,1,0> // the box is initially square
		scale <ImageWidth+1,ImageHeight+1,1> // scale it up to match camera view
		texture { GrainTex }
	}

#local TVStripes =
	box {
		<0,0,-.1>,<1,1,0> // the box is initially square
		scale <ImageWidth,ImageHeight,1> // scale it up to match camera view
		texture { TVTex scale <1,Size,1>}
	}

#local TVEdgeStripes =
	box {
		<0,0,-.1>,<1,1,0> // the box is initially square
		scale <ImageWidth/120,ImageHeight,1> // scale it up to match camera view
		translate <-ImageWidth/120/2,0,0> // align to right edge
		texture { TVEdgeTex }
	}


//===============================================
//             Object Placement
//===============================================

// Scene Coordinates:
// Camera is in z direction
// Image is at X=0, extending width into +X and height into +Y

object { Grain translate <0,0,0.45> } // add fuzzy noise in front of the image
object { ImageBox translate <0,0,0> } // put it behind any overlays
object { TVStripes translate <0,0,0.1> }
object { TVEdgeStripes translate <0,0,0.2> }
object { TVEdgeStripes translate <ImageWidth,0,.2> }

#end
	
#macro Overlay(ImageHeight, RenderHeight, AspectRatio, Image, Size, GrainFilter, NumStripes)
	overlay(ImageHeight, RenderHeight, AspectRatio, Image, Size, GrainFilter, NumStripes)
#end

#declare RedInk = texture {
	pigment { color rgb<1,0,0> }
	finish { ambient 0.95 specular .3 roughness .01 }
}                  

#declare WhiteInk =	texture {
	pigment { color rgb<1,1,1> }
	finish { ambient 1.5 specular .3 roughness .01 }
}

#declare BlackInk =	texture {
	pigment { color rgb<.06,.06,.06> }
	finish { ambient .04 specular .3 roughness .01 }
}

#declare TransInk = texture {
	pigment { color rgbt <1,1,1,.75> }
	finish { ambient .04 specular .3 roughness .01 }
}