// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc: appartement
// Date: begonnen op 2 juli 1999
// Auth: Erick

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "CONSTS.INC"   // Various constants and alias definitions
#include "FINISH.INC"   // Some basic finishes
#include "GLASS.INC"    // Glass textures
#include "GOLDS.INC"    // Gold textures
#include "METALS.INC"   // Metallic pigments, finishes, and textures
#include "SHAPES.INC"   // Standard objects from POV-Ray's earlier days
#include "SHAPES2.INC"  // Useful, but seldom used shapes
#include "SHAPESQ.INC"  // Pre-defined quartic shapes
#include "STONES.INC"   // Binding include-file for STONES1 and STONES2
#include "STONES1.INC"
#include "WOODS"    
#include "DEUR.INC"
#include "badkuipgroot.inc"
#include "raam.inc"
#include "bankstel.inc"
#include "keuken.inc"
#include "lampen.inc" 
#include "basisbeton.inc"    
#include "eethoek.inc"   
global_settings {
  adc_bailout 0.003
  ambient_light <1.2,1.2,1.2>
  assumed_gamma 1
  irid_wavelength <0.25, 0.18, 0.14>
  max_intersections 64
  max_trace_level 32
  number_of_waves 10
}

      #declare P_Cloud_PTD_1 = pigment {
        wrinkles turbulence 0.65 octaves 6 omega 0.7 lambda 2
        color_map {
                [0.0, 0.1   color red 0.90 green 0.70 blue 0.85
                            color red 0.7 green 0.75 blue 0.90]
                [0.1, 0.5   color red 0.7 green 0.75 blue 0.90
                            color rgb <0.22, 0.258, 0.27>  ]
                [0.5, 1.001 color rgb <0.22, 0.258, 0.27>
                            color rgb <0.12, 0.15, 0.18> ] }
                scale <6, 1, 6> }

        #declare P_Cloud_PTD_2 = pigment {
        bozo
        color_map {
                [0.0, 0.1   color red 0.80 green 0.75 blue 0.60
                            color red 0.65 green 0.55 blue 0.45]
                [0.1, 0.6   color red 0.65 green 0.55 blue 0.45
                            color rgb <0.184, 0.2, 0.2> ]
                [0.6, 1.001 color rgb <0.184, 0.2, 0.2>
                            color rgb <0.1, 0.05, 0.1>] }
        turbulence 0.65 octaves 6 omega 0.707 lambda 2
        scale <6, 4, 6> }

        #declare S_Cloud_99 = sky_sphere {
        pigment { gradient y pigment_map {
                [0.01 rgb <0.5, 0.5, 0.6> ]
                [0.25 P_Cloud_PTD_1 scale 0.25 rotate z*5]
                [0.60 P_Cloud_PTD_2 scale <0.25, 0.15, 0.25> rotate z*10]
        } } }

 sky_sphere { S_Cloud_99 rotate x*10 }
camera
{
  location  <14,2, 6.5>          
angle 75
   look_at   <9,.7,0>
}
/*camera
{
  location  <7,15, 5>          
angle 75
   look_at   <7,1,7>
}*/


object {balkonwand}
object {kleinraam rotate y*-90 translate <14.35,0,.2>} 
object {kleinraam rotate y*-90 translate <14.35,0,1.875>}
object {kleinraam rotate y*-90 translate <14.35,0,4.00>}
object {glasdeur rotate y*-90 translate <14.25,0,5.5>} 

object {badkuipgroot rotate y*90 scale <1,1,.90> translate <6.55,0,6.75>}
object {kraan rotate y*90 translate <7.25,.65,6.5>}  
object {bankstelklein rotate y*-90 translate <12,0,4.75>}
object {bankstelgroot rotate y*180 translate <14,0,4>}

object {toilet scale <.6,.6,.6> rotate y*180 translate <6.85, 0, 3>}
object {keuken translate <6.5,0,2.45>} 
object {gasstel translate <8.67,.89,2.10>} 

object {vitrine  rotate y*-90 translate <10.2, 0,3.4>}
object {vitrine2  rotate y*-90 translate <10.2, 0,2.05>}
object {eethoek rotate y*10 translate <12.55, 0,1.5> }

object {salontafel rotate y*-10 translate <12.55, 0,4.5> } 
 
object {bureau rotate y*90 translate <8,0,5.75>}
object {bureau translate <9.6,0,6.15>}

object {televisie translate <13,1,6.3>}
object {boekenkast rotate y*180 translate <14.24,0,0.15>}

object {computerset translate <9,.74,6>}  
object {solarmeter translate <12.85,.41,4.85>}