//  Saturns ring system. Povfile by Sigmund Kyrre Aas <as@stud.ntnu.no>
//  Uses colour_map in saturn.inc based on Bjrn Jnsson's ring data
//  avail. at http://www.mmedia.is/~bjj/data/saturn/rings.html 
//  Pov conversion by Sigmund Kyrre Aas <as@stud.ntnu.no>

#include "saturn.inc"
#declare i=1;
#declare Width=140460/74500-1 // The width of the ring system, inner radius being 1 unit.
#declare Step=Width/15;       // Due to the 8-bit entry-limitation in colour_map, the 
#while (i<=15)                // ring system is divided into 15 discs.
disc {                        
   <0, 0, 0> y,
   1+i*Step,       // outer radius
   1+(i-1)*Step    // inner radius
   pigment {
      onion
      colour_map { Map(i) }
   }
   finish {ambient 0 diffuse 4}  // try increasing diffuse if the rings are too dark
   scale 74500
}
#declare i=i+1;
#end