//--- Jack's Castle

#declare CastleStone =
texture {
  color Gray20
  ambient .1
  diffuse .4
  .05
  phong .2
  phong_size 20
  .07
}

#declare TileRoof =
texture {
  color Salmon
  ambient .1
  diffuse .35
  .05
  phong .2
  phong_size 50
  .07
}


#declare RodTexture =
texture {
  color Gold
  ambient .1
  diffuse .2
  phong 1
  phong_size 90
}


#declare MoldingTexture =
texture {
  color Tan
  ambient .1
  diffuse .2
  phong .2
  phong_size 90
}

//-- Graduated Stone
#declare GradStone =
texture {
  gradient <0 1 0> 
    color_map {
    [0 .1 color Black color Black]
    [.1 .5 color Black color Gray10]
    [.5 1 color Gray10 color Gray20]

    }
    scale <100 400 100>
    translate <0 -400 0>
    ambient .1
    diffuse .3
    phong .2
    phong_size 20
    .07
}
 


#declare Tower1 =
composite {
  object {
    union {
     difference {
      intersection { Disk_Y scale <10 45 10> translate <0 45 0> }
      quadric { Cylinder_Z scale <5.25 5.25 1> translate <0 77.5 0> }
      box { UnitBox scale <5.25 10 12> translate <0 67.5 0> }
     }
      intersection { Disk_Y scale <11.3 2.5 11.3> translate <0 87.5 0> }
    }
      texture { CastleStone }
	bounded_by {
	box { UnitBox scale <11 46 11> translate <0 45 0> }
	}
  }

  //--- Tower Peek
  object {
   intersection {  
      quadric { QCone_Y scale <13.8 30 13.8> translate <0 120 0> }
      plane { <0 1 0> 120 }
      plane { <0 1 0> 90 inverse }
     }
      texture { TileRoof }
	bounded_by {
	box { UnitBox scale <14 15 14> translate <0 105 0> }
	}
  }

  //--- Roof Points
  object {
    union {
      intersection {
        quadric { QCone_Y scale <3.8 11.5 3.8> translate <0 128 0> }
        plane { <0 1 0> 128 }
        plane { <0 1 0> 115 inverse }
      }
      intersection {
        quadric { QCone_Y scale <1.3 29.3 1.3> translate <0 148 0> }
        plane { <0 1 0> 148 }
        plane { <0 1 0> 118.7 inverse }
      }
    }
      texture { RodTexture }
	bounded_by {
	box { UnitBox scale <5 19 5> translate <0 131 0> }
	}
  }
	bounded_by {
	box { UnitBox scale <15 75 15> translate <0 75 0> }
	}
}

#declare MainExit =
composite {
  object {
   difference {
    box { UnitBox scale <22.5 25 35> translate <0 25 0> }
    box { UnitBox scale <20.5 26 33> translate <0 25 0> }
    box { UnitBox scale <10.5 15.01 40> translate <0 15 0> }
    quadric { Cylinder_Z scale <10.5 10.5 1> translate <0 30 0> }

    box { UnitBox scale <30 5 2> translate <0 30 -25> }
    box { UnitBox scale <30 5 2> translate <0 30 -15> }
    box { UnitBox scale <30 5 2> translate <0 30 15> }
    box { UnitBox scale <30 5 2> translate <0 30 25> }
   }
     texture { CastleStone }
	bounded_by {
	box { UnitBox scale <23 26 36> translate <0 25 0> }
	}
  }
  //--- Molding
  object {
   union {
     box { UnitBox scale <25 2.5 37.5> translate <0 47.5 0> }     
     difference {
      union{
       intersection { Disk_Z scale <15 15 2.5> translate <0 30 -35> }
       box { UnitBox scale <15 15 2.5> translate <0 15 -35> }
      }
       quadric { Cylinder_Z scale <10 10 1> translate <0 30 0> }
       box { UnitBox scale <10 15.01 40> translate <0 15 0> }
     }
    }
     texture { MoldingTexture }
	bounded_by {
	box { UnitBox scale <26 26 40> translate <0 25 0> }
	}
  }

  //--- Exit Roof
  object {
   intersection {
     plane { <0 1 0> 50 inverse }
     plane { <0 1 0> 80 }
     plane { <1 0 0> 0 rotate <0 0 14> translate <30 50 0> }
     plane { <1 0 0> 0 rotate <0 0 -14> translate <-30 50 0> inverse}
     plane { <0 0 1> 0 rotate <28 0 0> translate <0 50 -40> inverse}
     plane { <0 0 1> 0 rotate <-28 0 0> translate <0 50 40> }
    }
     texture { TileRoof }
	bounded_by {
	box { UnitBox scale <31 16 41> translate <0 65 0> }
	}
  }
	bounded_by {
	box { UnitBox scale <31 41 41> translate <0 40 0> }
	}


}

//--- Castle Slab
#declare Slab =
  object {
   union {
     box { UnitBox scale <90 3 30> translate <0 -3 16.5> }
     box { UnitBox scale <50 3 40> translate <0 -3 0> }
     box { UnitBox scale <27 3 50> translate <0 -3 0> }
   }
      texture { MoldingTexture }
}

#declare BR1 =
box { UnitBox scale <2.5 27.5 1> }


#declare Brace =
object { 
  union { 
   box { BR1 translate <0 0 -16> }
   box { BR1 translate <0 0 -8> } 
   box { BR1 translate <0 0 0> } 
   box { BR1 translate <0 0 16> }
   box { BR1 translate <0 0 8> } 
  }
    texture { MoldingTexture }
	bounded_by {
	box { UnitBox scale <3 28 25> }
	}
}


#declare BR2 =
box { UnitBox scale <1 10 50> }


#declare Brace2 =
object { 
  union { 
   box { BR2 translate <-24 0 0> }
   box { BR2 translate <-16 0 0> }
   box { BR2 translate <-8 0 0> }
   box { BR2 translate <-0 0 0> }
   box { BR2 translate <24 0 0> }
   box { BR2 translate <16 0 0> }
   box { BR2 translate <8 0 0> }
   box { BR2 translate <0 0 0> }

  }
    texture { MoldingTexture }
	bounded_by {
	box { UnitBox scale <27 11 51> }
	}
}








