// =========================================
// MakeBook and MakeShelf macros examples
// -----------------------------------------
// Copyright Gilles Tran 1999
// -----------------------------------------
// Feel free to use and modify
// Let's build a little library !
// -----------------------------------------
#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
 
#include "MakeBook.inc"
#include "MakeShelf.inc"

camera{location  <0, 25, -120.0>   
direction 2.1*z  
//direction 7*z  // zoom on the library  
right 4*x/3  look_at   <0, 22, 0.0>}
background{White}        
#declare colLum=White*2;
light_source{<0,1,-1.5>*100 color colLum}

// -----------------------------------------
// CHECK THAT THE PATH AND FONT NAMES BELOW ARE OK BEFORE PROCEEDING
// Well if one of these is wrong you'll just get an error message...
// You can replace the font names by whatever font you want
// -----------------------------------------
#declare fontpath="c:\windows\fonts\\"
#declare fontname_1="arial.ttf"
#declare fontname_2="times.ttf"
// -----------------------------------------
// Shelf variables (in fact they'll be changed for each shelf but they are useful to define the library)
// -----------------------------------------
#declare rd=seed(2);      // seed for randomness
#declare xShelf=40;       // width of shelf (inner size)
#declare nSet=2;          // number of sets
#declare typeShelf=1;     // start with random books
#declare slackShelf=0.5;  // little slack
#declare xBook=1.5;       // book thickness and pseudo-standard deviation
#declare sdxBook=0.2;
#declare yBook=7;         // book height and pseudo-standard deviation
#declare sdyBook=1;
#declare zBook=7;         // book depth and pseudo-standard deviation
#declare sdzBook=0.2;                             

// -----------------------------------------
// Library variables
// -----------------------------------------
#declare ePlank=1; // thickness of the planks
#declare zShelf=zBook+sdzBook*0.6; // depth of library
#declare yShelf=(yBook+sdyBook*0.5)*cos(atan2(xBook+sdxBook*0.5,yBook+sdyBook*0.5))+(xBook+sdxBook*0.5)*sin(atan2(xBook+sdxBook*0.5,yBook+sdyBook*0.5));

#declare Plank=box{0,<xShelf,ePlank,zShelf> translate <0,0,-zShelf>}

// -----------------------------------------
// Library
// -----------------------------------------
union{
        // -----------------------------------------
        // Library frame
        // -----------------------------------------
        object{Plank scale <1,1,(zShelf+ePlank)/zShelf>}
        object{Plank translate y*(ePlank+yShelf)}
        object{Plank translate 2*y*(ePlank+yShelf)}
        object{Plank translate 3*y*(ePlank+yShelf)}
        object{Plank translate 4*y*(ePlank+yShelf)}
        object{Plank translate 5*y*(ePlank+yShelf) scale <1,1,(zShelf+ePlank)/zShelf>}
        box{<-ePlank,0,-zShelf-ePlank>,<0,5*(yShelf+ePlank)+ePlank,0>}
        box{<0,0,-zShelf-ePlank>,<ePlank,5*(yShelf+ePlank)+ePlank,0> translate x*xShelf}
        box{<-ePlank,0,0>,<xShelf+ePlank,5*(yShelf+ePlank)+ePlank,ePlank>}

        // -----------------------------------------
        // shelf #1 Here we go
        // -----------------------------------------
        // little slackness, all random, olds books
        #declare typeBook=0; // old book
        #declare yBook=7;         // book height and pseudo-standard deviation
        #declare sdyBook=0.2;
        object{mShelf(xShelf,nSet,typeShelf,slackShelf,xBook,sdxBook,yBook,sdyBook,zBook,sdzBook) translate y*ePlank}
        
        // -----------------------------------------
        // shelf #2
        // -----------------------------------------
        // more slackness, all random, modern books
        #declare typeShelf=1;
        #declare slackShelf=2;
        #declare xBook=1.5;
        #declare sdxBook=1;
        #declare yBook=7;
        #declare sdyBook=1;
        #declare zBook=8; // big books that overhang
        #declare sdzBook=2;                             
        #declare typeBook=1; // modern book
        object{mShelf(xShelf,nSet,typeShelf,slackShelf,xBook,sdxBook,yBook,sdyBook,zBook,sdzBook) translate y*(2*ePlank+yShelf)}
        
        // -----------------------------------------
        // shelf #3
        // -----------------------------------------
        // narrower books, all random, more sets, modern books
        #declare typeShelf=1;
        #declare nSet=4;
        #declare xBook=0.8;
        #declare sdxBook=1;
        #declare yBook=7;
        #declare sdyBook=1;
        #declare zBook=6.5;
        #declare sdzBook=1;                             

        #declare typeBook=1; // modern book
        object{mShelf(xShelf,nSet,typeShelf,slackShelf,xBook,sdxBook,yBook,sdyBook,zBook,sdzBook) translate y*(3*ePlank+2*yShelf)}
        
        // -----------------------------------------
        // shelf #4
        // -----------------------------------------
        // thin books, series, little slackness, old books
        #declare typeShelf=0;
        #declare nSet=3;
        #declare slackShelf=0.4;
        #declare yBook=6;
        #declare sdyBook=3;
        #declare zBook=6;
        #declare sdzBook=1;                             
        #declare typeBook=0; // old book
        object{mShelf(xShelf,nSet,typeShelf,slackShelf,xBook,sdxBook,yBook,sdyBook,zBook,sdzBook) translate y*(4*ePlank+3*yShelf)}
        
        // -----------------------------------------
        // shelf #5
        // -----------------------------------------
        // small books, series, high slackness, modern books
        #declare typeShelf=0;
        #declare nSet=5;
        #declare slackShelf=6;
        #declare xBook=0.7;
        #declare sdxBook=0.7;
        #declare yBook=5;
        #declare sdyBook=1;
        #declare zBook=4;
        #declare sdzBook=2;
        #declare typeBook=1; // modern book        
        object{mShelf(xShelf,nSet,typeShelf,slackShelf,xBook,sdxBook,yBook,sdyBook,zBook,sdzBook) translate y*(5*ePlank+4*yShelf)}
        
        // -----------------------------------------
        // final position and texture
        // -----------------------------------------
        translate <ePlank,0,-ePlank>
        texture{T_Wood4 scale 20}
        translate -x*(xShelf+2*ePlank)*0.5
        rotate y*30
}

