// =========================================
// mBook macro 1.0
// -----------------------------------------
// Copyright Gilles Tran 1999
// -----------------------------------------
// Feel free to use and modify
// -----------------------------------------
// This macro creates a closed book
// The book is enclosed in the box {<0,0,0>,<xBook,yBook,zBook>}
// The book has a title made of random letters chosen in two different fonts and cases
// eCover is the thickness of the cover
// typeBook=0 creates old style books, with rounded binding, dark colors and gold trim
// typeBook=1 creates modern style books, with flat binding and funky colors
// flatratio is the flatness of the binding (this variable is set by the typeBook variable)
// -----------------------------------------
// Notes
// -----------------------------------------
// Randomness : if you don't declare a seed before launching the macro, it will default to rd=seed(0)
// #declare rd=seed(0) before the macro is used
// -----------------------------------------
// This macro uses the mRandomText macro at the end of this file
// Declare the font path and names before using these files.
// For example :
// #declare fontpath="\windows\fonts\\"
// #declare fontname_1="arial.ttf"
// #declare fontname_2="times.ttf"
// -----------------------------------------

#macro mBook(xBook,yBook,zBook,eCover,typeBook)
#ifndef (rd) #declare rd=seed(0); #end // a seed must be declared
union{    
        // -------------------------------------------
        // Book types
        // -------------------------------------------
        #switch (typeBook)
        // -------------------------------------------
        #case (0) // old book
        // -------------------------------------------
                #local flatratio=0.3+(0.3*rand(rd)); 
                #switch (rand(rd))
                        #range (0,0.2)
                                #local colBook_1=<1+0.3*rand(rd),0.3*rand(rd),0.2*rand(rd)>*0.3; // dark red
                        #break
                                
                        #range (0.2,0.4)
                                #local colBook_1=<0.2*rand(rd),0.2*rand(rd),1+0.3*rand(rd)>*0.3; // dark blue
                        #break

                        #range (0.4,0.6)
                                #local colBook_1=<0.2*rand(rd),1+0.3*rand(rd),0.2*rand(rd)>*0.3; // dark green
                        #break

                        #range (0.6,0.8)
                                #local colBook_1=<1+0.2*rand(rd),1+0.2*rand(rd),0.4*rand(rd)>*0.3; // dark orange
                        #break
                        #else
                                #local colBook_1=<1+0.2*rand(rd),0.2*rand(rd),1+0.2*rand(rd)>*0.3; // dark purple
                #end
                #local colBook_2=rgb<1+rand(rd)*0.2,1+rand(rd)*0.2,rand(rd)*0.2>; // gold color
                #local colPage=rgb<0.9+0.1*rand(rd),0.8+0.1*rand(rd),0.8>; // yellowish
                #declare finCover=finish{ambient 0.1 diffuse 0.4 specular 0.1 roughness 0.1}
                #declare finPage=finish{ambient 0.1 diffuse 0.5 specular 0.1 roughness 0.1}
                #declare txtCover=texture{pigment{color colBook_1} finish{finCover}}
                #declare txtBinding=texture{
                        pigment{
                                gradient y
                                color_map{
                                        [0 color colBook_2]
                                        [0.04 color colBook_2]
                                        [0.04 color colBook_1]
                                        [1.0 color colBook_1]
                                        }
                                }
                       finish{finCover}
                       scale yBook*rand(rd)*0.5 
                       translate y*yBook*(3+(rand(rd)))
                }
                #declare txtTitle=texture{
                        pigment{color colBook_2}
                        finish{finCover}
                }
                #local txtPage=texture{
                        pigment{
                                gradient x
                                turbulence 0.1
                                color_map{
                                        [0 color colPage]
                                        [1 color colPage*0.7]
                                }
                        }
                        finish{finPage}
                        scale xBook*rand(rd)*0.06
                        translate x*xBook
                }
        #break
        // -------------------------------------------
        #case (1) // modern book
        // -------------------------------------------
                #switch (rand(rd))        
                        #range (0,0.2)
                                #local colBook_1=White*1.5;
                        #break
                        #range (0.2,0.3)
                                #local colBook_1=Black;
                        #break
                        #else
                                #local colBook_1=rgb <rand(rd),rand(rd),rand(rd)>;
                #end
                #local colBook_2=rgb <rand(rd),rand(rd),rand(rd)>*2;        
                #switch (rand(rd))        
                        #range (0,0.3)
                                #local colTitle=White*2;
                        #break
                        #range (0.3,0.6)
                                #local colTitle=Black;
                        #break
                        #else
                                #local colTitle=rgb <1-colBook_1.x,1-colBook_1.y,1-colBook_1.z>;
                #end
                #local flatratio=rand(rd)*0.2;
                #local colPage=rgb<0.9+0.1*rand(rd),0.9+0.1*rand(rd),0.9>*1.1;
                #declare finCover=finish{ambient 0.1 diffuse 0.4 specular 0.4 roughness 0.01}
                #declare finPage=finish{ambient 0.1 diffuse 0.5 specular 0.1 roughness 0.1}
                #declare txtCover=texture{
                        pigment{brick color colBook_1,color colBook_2 brick_size <1+rand(rd),1+rand(rd),1+rand(rd)> mortar rand(rd)}
                       finish{finCover}
                       scale yBook*rand(rd)
                       translate y*yBook*rand(rd)
                }
                #declare txtTitle=texture{
                        pigment{color colTitle}
                        finish{finCover}
                }
                #declare txtBinding=texture{
                        pigment{
                                gradient y
                                color_map{
                                        [0 color colBook_2]
                                        [0.3 color colBook_2]
                                        [0.3 color colBook_1]
                                        [1.0 color colBook_1]
                                        }
                                }
                       finish{finCover}
                       scale yBook*(1+rand(rd))
                       translate y*yBook*(3+(rand(rd)))
                       
                }
                #local txtPage=texture{
                        pigment{
                                gradient x
                                turbulence 0.1
                                color_map{
                                        [0 color colPage]
                                        [1 color colPage*0.7]
                                }
                        }
                        finish{finPage}
                        scale xBook*rand(rd)*0.06
                        translate x*xBook
                }
        #break
        // -------------------------------------------
        #else // single random color and random flatness
        // -------------------------------------------
                #local flatratio=rand(rd);
                #local colBook_1=rgb <rand(rd),rand(rd),rand(rd)>;
                #local colBook_2=rgb <1-colBook_1.x,1-colBook_1.y,1-colBook_1.z>;
                #switch (rand(rd))        
                        #range (0,0.3)
                                #local colTitle=White*2;
                        #break
                        #range (0.3,0.6)
                                #local colTitle=Black;
                        #break
                        #else
                                #local colTitle=colBook_2;
                #end
                #local colPage=rgb<0.9+0.1*rand(rd),0.9+0.1*rand(rd),0.9+0.1*rand(rd)>*1.1;
                #declare finCover=finish{ambient 0.1 diffuse 0.4 specular 0.4 roughness 0.01}
                #declare finPage=finish{ambient 0.1 diffuse 0.5 specular 0.1 roughness 0.1}
                #declare txtCover=texture{
                        pigment{color colBook_1}
                        finish{finCover}
                }
                #declare txtTitle=texture{
                        pigment{color colTitle}
                        finish{finCover}
                }
                #declare txtBinding=texture{
                        pigment{color colBook_1}
                        finish{finCover}
                }
                #local txtPage=texture{
                        pigment{colPage}
                        finish{finPage}
                }
        #end
        // -------------------------------------------
        // Book parameters
        // -------------------------------------------
        #local rCover=eCover*0.5; // radius of cover thickness
        #local rBinding=xBook*0.5;  // radius of binding
        #local zBinding=rBinding*flatratio; // thickness of binding
        #local zCover=zBook-rCover-zBinding;
        #local yCover=yBook-eCover;
        #local zPage=zCover-4*eCover;
        #local yPage=yBook-4*eCover;
        #local xPage=xBook-2*eCover;

        // -------------------------------------------
        // front cover
        // -------------------------------------------
        union{
                box{0,<eCover,yCover,zCover>}          
                union{
                        cylinder{0,z*zCover,rCover translate <0,yCover,0>}
                        cylinder{0,z*zCover,rCover translate <0,0,0>}   
                        cylinder{0,y*yCover,rCover translate z*zCover}
                        sphere{0,rCover translate <0,0,zCover>}
                        sphere{0,rCover translate <0,yCover,zCover>}
                        translate x*rCover
                }                                     
                translate <rBinding-eCover,rCover,zBinding>
        }
        // -------------------------------------------
        // back cover
        // -------------------------------------------
        union{
                box{0,<eCover,yCover,zCover>}          
                union{
                        cylinder{0,z*zCover,rCover translate <0,yCover,0>}
                        cylinder{0,z*zCover,rCover translate <0,0,0>}
                        cylinder{0,y*yCover,rCover translate z*zCover}
                        sphere{0,rCover translate <0,0,zCover>}
                        sphere{0,rCover translate <0,yCover,zCover>}
                        translate x*rCover
                }                                     
                translate <rBinding-eCover,rCover,zBinding>
                scale <-1,1,1>
        }          
        
        // -------------------------------------------
        // binding
        // -------------------------------------------
        union{
                // -------------------------------------------
                // Book title on the binding
                // -------------------------------------------
                #local nLetters=5+int(15*rand(rd));
                #if (typeBook=0) #local titleSize=0.3+0.4*rand(rd);#else #local titleSize=0.5+0.3*rand(rd);#end
                #local titleBook=object{mRandomText(nLetters) translate y*-0.3 scale <yBook*titleSize/nLetters,xBook*titleSize,rCover>}
                object{titleBook rotate z*90 translate <0,yBook*(1-titleSize),zBinding-rBinding*flatratio> texture{txtTitle}}
                difference{               
                        union{
                                cylinder{0,y*yCover,rBinding}
                                torus{rBinding-rCover,rCover sturm}
                                torus{rBinding-rCover,rCover  sturm translate y*yCover}
                        }
                        cylinder{-rCover*2*y,y*(yCover+rCover)*1.1,rBinding-eCover}
                        plane{z,0 inverse}                
                        scale <1,1,flatratio>
                        translate <0,rCover,zBinding>
                        texture{txtBinding}
                } 
        }
        // -------------------------------------------
        // pages        
        // -------------------------------------------
        union{
                difference{
                        box{0,<xPage,yPage,zPage>}
                        cylinder{-y*0.1,y*yPage*1.1,xPage*0.5 scale <1,1,flatratio*rand(rd)> translate <xPage*0.5,0,zPage>}
                }
                difference{
                        cylinder{0,y*yPage,xPage*0.5}
                        cylinder{-y*0.1,y*yPage*1.1,xPage*0.5 scale <1,1,0.5> translate -z*0.5*xPage}
                        scale <1,1,flatratio> translate x*xPage*0.5
                }                                                            
                
                translate <-xPage*0.5,2*eCover,zBinding>
                texture{txtPage}
        } 
        translate x*xBook*0.5
        texture{txtCover}
}
#end  

// -----------------------------------------
// end of mBook macro
// =========================================

// =========================================
// mRandomText macro 1.0
// -----------------------------------------
// Copyright Gilles Tran 1999
// -----------------------------------------
// This macro creates a random text of nLetters letters
// -----------------------------------------
// Declare the font path and names before using this file.
// For example :
// #declare fontpath="\windows\fonts\\"
// #declare fontname_1="arial.ttf"
// #declare fontname_2="times.ttf"
// -----------------------------------------
#macro mRandomText(nLetters)
        #local rtext=""
        #if (rand(rd)<0.5)
                #local fontname=concat(fontpath,fontname_1)
        #else
                #local fontname=concat(fontpath,fontname_2)
        #end                
//                #warning fontname
        #local i=0;
        #if (rand(rd)<0.5)
                #local asciistart=65; // majuscule
        #else
                #local asciistart=97; // minuscule
        #end
        #while (i<nLetters)
                #local rtext=concat(rtext,chr(asciistart+int(27*rand(rd))))
                #local i=i+1;                  
        #end
        text{ttf fontname rtext 1,0}
#end
// -----------------------------------------
// end of mRandomText macro
// =========================================
