#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "stones.inc"

global_settings { radiosity { brightness 0.7 count 10 distance_maximum 800 }}

fog { fog_type 1 distance 3000 color red 0.1 blue 0.1 green 0.1 turbulence 0.5 turb_depth 5 up <0,0,1> }

/* FOG_ITEMS:

fog_type Fog_Type | distance Distance | COLOR | 
turbulence <Turbulence> | turb_depth Turb_Depth | 
omega Omega | lambda Lambda | octaves Octaves | 
fog_offset Fog_Offset | fog_alt Fog_Alt | 
up <Fog_Up> | TRANSFORMATION
*/
/* RADIOSITY_ITEMS:

brightness Float | count Integer | distance_maximum Float | 
error_bound Float | gray_threshold Float | low_error_factor Float | 
minimum_reuse Float | nearest_count Integer | recursion_limit Integer
*/
camera {
  location < 440.776775,452.393253,-488.097120 >
  up <0,1,0>
  right <4/3,0,0>
  look_at < 0,100,0 >
  angle 40
}


/* Lichtquellen aus Animation
light_source {
< 255.235600,405.940000,-233.097075 > color White
}

light_source
{
  <240+sin(winkel)*1000,400,106+cos(winkel)*1000> color White
}
*/

/*  Lichtquellen aus Einzelbild */
light_source {
< 255.235600,405.940000,-533.097075 > color White
area_light <50, 0, 0>, <0, 20,0>, 5, 5
    adaptive 1
    jitter
    fade_distance 1500
    fade_power 1

}

light_source
{
  <350,2000,-2000> color White
area_light <10, 0, 0>, <0, 0, 10>, 5, 5
    adaptive 1
    jitter
    fade_distance 1500
    fade_power 1

}


/* cylinder
{
  <0,0,-110>,<0,0,-100>,50
  texture
  {
    pigment { White }
    finish { Shiny }
  }
} */


#declare tiefe=9.5;
#declare raddiff=8;


object
{
  difference
  {
    box
    {
        <-100,-100,-100>,<100,100,100>

    }
    cylinder
    {
      <0,0,-101>,<0,0,-100+1*tiefe>,100-raddiff
    }
    cylinder
    {
      <0,0,-101+1*tiefe>,<0,0,-100+2*tiefe>,100-2*raddiff
    }
    cylinder
    {
      <0,0,-101+2*tiefe>,<0,0,-100+3*tiefe>,100-3*raddiff
    }
    cylinder
    {
      <0,0,-101+3*tiefe>,<0,0,-100+4*tiefe>,100-4*raddiff
    }
    cylinder
    {
      <0,0,-101+4*tiefe>,<0,0,-100+5*tiefe>,100-5*raddiff
    }
    cylinder
    {
      <0,0,-101+5*tiefe>,<0,0,-100+6*tiefe>,100-6*raddiff
    }   
    
    
    cylinder
    {
      <0,0,100-1*tiefe>,<0,0,101>,100-raddiff
    }
    cylinder
    {
      <0,0,100-2*tiefe>,<0,0,101-1*tiefe>,100-2*raddiff
    }
    cylinder
    {
      <0,0,100-3*tiefe>,<0,0,101-2*tiefe>,100-3*raddiff
    }
    cylinder
    {
      <0,0,100-4*tiefe>,<0,0,101-3*tiefe>,100-4*raddiff
    }
    cylinder
    {
      <0,0,100-5*tiefe>,<0,0,101-4*tiefe>,100-5*raddiff
    }
    cylinder
    {
      <0,0,100-6*tiefe>,<0,0,101-5*tiefe>,100-6*raddiff
    }

    cylinder
    {
      <-101,0,0>,<-100+1*tiefe,0,0>,100-raddiff
    }
    cylinder
    {
      <-101+1*tiefe,0,0>,<-100+2*tiefe,0,0>,100-2*raddiff
    }
    cylinder
    {
      <-101+2*tiefe,0,0>,<-100+3*tiefe,0,0>,100-3*raddiff
    }
    cylinder
    {
      <-101+3*tiefe,0,0>,<-100+4*tiefe,0,0>,100-4*raddiff
    }
    cylinder
    {
      <-101+4*tiefe,0,0>,<-100+5*tiefe,0,0>,100-5*raddiff
    }
    cylinder
    {
      <-101+5*tiefe,0,0>,<-100+6*tiefe,0,0>,100-6*raddiff
    }

    cylinder
    {
      <100-1*tiefe,0,0>,<101,0,0>,100-raddiff
    }
    cylinder
    {
      <100-2*tiefe,0,0>,<101-1*tiefe,0,0>,100-2*raddiff
    }
    cylinder
    {
      <100-3*tiefe,0,0>,<101-2*tiefe,0,0>,100-3*raddiff
    }
    cylinder
    {
      <100-4*tiefe,0,0>,<101-3*tiefe,0,0>,100-4*raddiff
    }
    cylinder
    {
      <100-5*tiefe,0,0>,<101-4*tiefe,0,0>,100-5*raddiff
    }
    cylinder
    {
      <100-6*tiefe,0,0>,<101-5*tiefe,0,0>,100-6*raddiff
    }

    cylinder
    {
      <0,-101,0>,<0,-100+1*tiefe,0>,100-raddiff
    }
    cylinder
    {
      <0,-101+1*tiefe,0>,<0,-100+2*tiefe,0>,100-2*raddiff
    }
    cylinder
    {
      <0,-101+2*tiefe,0>,<0,-100+3*tiefe,0>,100-3*raddiff
    }
    cylinder
    {
      <0,-101+3*tiefe,0>,<0,-100+4*tiefe,0>,100-4*raddiff
    }
    cylinder
    {
      <0,-101+4*tiefe,0>,<0,-100+5*tiefe,0>,100-5*raddiff
    }
    cylinder
    {
      <0,-101+5*tiefe,0>,<0,-100+6*tiefe,0>,100-6*raddiff
    }

    cylinder
    {
      <0,100-1*tiefe,0>,<0,101,0>,100-raddiff
    }
    cylinder
    {
      <0,100-2*tiefe,0>,<0,101-1*tiefe,0>,100-2*raddiff
    }
    cylinder
    {
      <0,100-3*tiefe,0>,<0,101-2*tiefe,0>,100-3*raddiff
    }
    cylinder
    {
      <0,100-4*tiefe,0>,<0,101-3*tiefe,0>,100-4*raddiff
    }
    cylinder
    {
      <0,100-5*tiefe,0>,<0,101-4*tiefe,0>,100-5*raddiff
    }
    cylinder
    {
      <0,100-6*tiefe,0>,<0,101-5*tiefe,0>,100-6*raddiff
    }

  rotate <45,0,0>
  rotate <0,0,45>
  translate <0,100,0>
  }
  texture
  {
    pigment { White }
    finish { reflection 0.1 specular 0.6 diffuse 0.4 }
    normal { dents 0.5 scale 0.1 }
  }
}

light_source
{
  <-150,-60,-150>,White
}

object
{
  difference
  {
    box
    {
      <-100,-100,-100>,<100,-60,100>
    }
    difference
    { 
      box
      {
        <-120,-120,-120>,<120,-50,-60>
      }
      
      cylinder
      {
        <-140,-100,-60>,<140,-100,-60>,40
      }
    }
    difference
    { 
      box
      {
        <-120,-120,120>,<120,-50,60>
      }
      
      cylinder
      {
        <-140,-100,60>,<140,-100,60>,40
      }
    }
    difference
    { 
      box
      {
        <-120,-120,-120>,<-60,-50,120>
      }
      
      cylinder
      {
        <-60,-100,-140>,<-60,-100,140>,40
      }
    }
    difference
    { 
      box
      {
        <120,-120,-120>,<60,-50,120>
      }
      
      cylinder
      {
        <60,-100,-140>,<60,-100,140>,40
      }
    }
  }
  texture
  {
    T_Wood1
    translate <10,0,10>
    scale 100
  }
}
box
{
  <-400,-400,-400>,<400,-100,400>
  texture
  {
    T_Wood2
    translate <10,0,10>
    scale 50
  }
}

box
{
  <-2500,-800,-2500>,<2500,2500,-2600>
  texture
  {
    T_Stone9
    scale 50
  }
}

box
{
  <-2500,-800,-2500>,<-2600,2500,2500>
  texture
  {
    T_Stone9
    scale 50
  }
}

box
{
  <-2500,-800,2500>,<2500,2500,2600>
  texture
  {
    T_Stone9
    scale 50
  }
}

box
{
  <2500,-800,-2500>,<2600,2500,2500>
  texture
  {
    T_Stone9
    scale 50
  }
}

box
{
  <-2500,-800,-2500>,<2500,-810,2500>
  texture
  {
    T_Stone11
    scale 100
  }
}

box
{
  <-2500,2500,-2500>,<2500,2600,2500>
  texture
  {
    pigment
    {
      Blue
    }
    finish
    {
      diffuse 0.8
    }
    normal
    {
      dents 1 scale 10
    }
  }
}
