// Persistence of Vision Ray Tracer Scene Description File
// File: "Mannequin.inc"
// Vers: 3.1g
// Desc:
// Date: 1999
// Auth: Arthur F. Flint
#include "FileInUse.inc"
#include "Colors.inc"
#include "Textures.inc"
#include "manntex.inc"

default {finish{ambient .4}} //Try negative values here in the UV patches

global_settings	{assumed_gamma 1.7}
//Use something like this in the calling scene.
#declare LFoot		=<  0,  0,  0>;
#declare LKnee		=<  0,  0,  0>;
#declare LHip 		=<  0,  0,  0>;
#declare RFoot		=<  0,  0,-10>;
#declare RKnee		=<  0,  0, 40>;
#declare RHip 		=<  0,  0,-10>;
#declare LHTwist	=<  0, 90,  0>;
#declare LFABend	=<-60,  0,  0>;
#declare LUASwing	=<  0,  0, 15>;
#declare RHTwist	=<-70,  0,  0>;
#declare RFABend	=<-10,  0,  0>;
#declare RUASwing	=<-80,-90,  0>;
#declare HeadTilt	=< 20,-20,  0>;
//#include "Mannequin.inc" //Use this part in the calling scene also

// ********  MATERIALS  *******
#ifndef(LFoot)#declare TFoot=<0,0,0>;#else #declare TFoot=LFoot;#end
#ifndef(LKnee)#declare TKnee=<0,0,0>;#else #declare TKnee=LKnee;#end
#ifndef(LHip )#declare THip =<0,0,0>;#else #declare THip =LHip ;#end
#include "Leg.inc"#declare LeftLeg=Leg

#ifndef(RFoot)#declare TFoot=<0,0,0>;#else #declare TFoot=RFoot;#end
#ifndef(RKnee)#declare TKnee=<0,0,0>;#else #declare TKnee=RKnee;#end
#ifndef(RHip )#declare THip =<0,0,0>;#else #declare THip =RHip ;#end
#include "Leg.inc"#declare RightLeg=Leg

#ifndef(LHTwist ) #declare HTwist  =<0,0,0>;#else #declare HTwist =LHTwist ;#end
#ifndef(LFABend ) #declare FABend  =<0,0,0>;#else #declare FABend =LFABend ;#end
#ifndef(LUASwing) #declare UASwing =<0,0,0>;#else #declare UASwing=LUASwing;#end
#declare Handed = 1;#include "Arm.inc"#declare LeftArm=Arm

#ifndef(RHTwist ) #declare HTwist  =<0,0,0>;#else #declare HTwist =RHTwist ;#end
#ifndef(RFABend ) #declare FABend  =<0,0,0>;#else #declare FABend =RFABend ;#end
#ifndef(RUASwing) #declare UASwing =<0,0,0>;#else #declare UASwing=RUASwing;#end
#declare Handed = 0;#include "Arm.inc"#declare RightArm=Arm

#ifndef(HeadTilt)#declare HeadTilt=<0,-40,0>;#end

#declare Head =
union	{
	//camera	{location -x*.5 look_at -x angle 55}
	difference{sphere{0,0.5}box{-1,1 translate -y}translate  0.8*y}
	difference{
		difference{sphere{0,0.5}box{-1,1 translate +y}scale<1.0,1.5,1.0>}
		sphere	{0,.055 translate   +z*.1-y*.13-x*.49}
		cylinder{+z,+z*.1,.055 translate -y*.13-x*.49}
		sphere	{0,.055 translate   -z*.1-y*.13-x*.49}
		cylinder{-z,-z*.1,.055 translate -y*.13-x*.49}
		translate  0.8*y
		}
	sphere	{0,.05 pigment{Blue}finish{ambient 1.5}scale<1,1,1.5>translate<-.41,.67,+.14>}
	sphere	{0,.05 pigment{Blue}finish{ambient 1.5}scale<1,1,1.5>translate<-.41,.67,-.14>}
	material{ Mannequin }
	scale	<1,1,.8>
	rotate	HeadTilt
	}
	
#declare TORSO =
union	{
	sphere	{0,.2 scale<1,2,1>translate y*.4}
	difference{sphere{0,.5}box{-1,1 translate -y}scale<1.2*.65,.7,1*1.35>}
	difference{superellipsoid{<1,.8>}box{-1,1 translate y}scale<.6*.65,1.1,.5*1.35>}
	cylinder{-z*.85,+z*.85,.2}
	object	{ RightArm	translate +z*.85}
	object	{ LeftArm	translate -z*.85}
	material{ Mannequin }
	}

#declare Hips=
union	{
	sphere {0,1 scale <0.3, 0.4, 0.3> translate 0.3*y}
	difference{sphere{0,.5}box{-1,1 translate -y}scale<1*.65,.4,.8>}
	difference{superellipsoid{<1.0,.8>}box{-1,1 translate y}scale<.5*.65,.8,.4>}
	cylinder{-z*.35,+z*.35,.2 translate -y*.7}
	object	{ RightLeg	translate <0,-.7, .35>}
	object	{ LeftLeg	translate <0,-.7,-.35>}
	}

#declare Simon =
union	{
	object	{ Head 		translate y*2.0}
	object	{ TORSO		translate y*1.7}
	object	{ Hips 		translate y*0.3}
	material{ Mannequin }
	translate y*4.6
	scale .2190
	}

#declare Crackle =
pigment {
	crackle
	color_map	{[.05 color Green*.35][.10 color Green*.65]
			 [.10 color DarkBrown*.50][.40 color DarkBrown*.80]
			}
	scale <5,1,1>
	}

#declare Crackle_in_Crackle =
texture {pigment{crackle pigment_map{[.1 Crackle][.1 Crackle scale .25]}}}
	
#if	(FileInUse=0)
	#local Hi=1.0;
	camera		{location <-1,Hi,-3> look_at y*Hi angle 55 }
	plane		{ y,0 texture{Crackle_in_Crackle}}
//	#include	"UVSun.inc"object{UVSun translate z*100000 rotate -x*3}
	light_source	{0,2 translate z*100000 rotate -x*3}
	object		{ Simon }
	fog		{rgb<1 1 .3>*.8 distance 200 fog_type 2 fog_alt 20 fog_offset 0}
	background	{<.8 .5 .2>}
#end
#include "FileNotInUse.inc"
