// Persistence of Vision Ray Tracer Scene Description File
// File: "StandardSetup.inc"
// Vers: 3.1g
// Desc:
// Date: 1999
// Auth: Arthur F. Flint
#include "FileInUse.inc"
#include "Colors.inc"
#include "Textures.inc"
#include "manntex.inc"
#ifndef(TFoot)#declare TFoot=<+0,0,0>;#end
#ifndef(TKnee)#declare TKnee=<-0,0,0>;#end
#ifndef(THip )#declare THip =<+0,0,0>;#end
#include "Foot.inc"

#declare HalfSuperQ =difference {superellipsoid {<1.0, 0.8>}box{-1,1 translate +y}}

#declare UpperLeg =
union	{
	sphere{0,.20}
	union	{
		object{HalfSuperQ scale<0.3,1.50,0.3> }
		object{HalfSuperQ scale<0.3,0.35,0.3>rotate x*180 }
		translate  -y*.4  
		}
	material{Mannequin}
	}

#declare LowerLeg =
union	{
	sphere{0,.25}
	union	{
		object{HalfSuperQ scale<0.25,1.50,0.25>}
		object{HalfSuperQ scale<0.25,0.35,0.25>rotate x*180}  
		translate  -y*.4
		}
	material{Mannequin}
	}
#declare Leg =
union	{
	object	{ UpperLeg }
	union	{
		object	{ LowerLeg }
		object	{ Foot rotate TFoot translate -y*1.9}
		rotate	TKnee
		translate  -y*2
		}
	material{ Mannequin }
	rotate THip
	}

#if	(FileInUse=0)
	camera		{location <0,0,-16> look_at -y*2 angle 40 }
	#include 	"Sun.inc"object	{ Sun rotate <45,-10,0> }
	object		{ Leg }
#end
#include "FileNotInUse.inc"
