// Persistence of Vision Ray Tracer Scene Description File
// File: "Arm.inc"
// Vers: 3.1g
// Desc:
// Date: 1999
// Auth: Arthur F. Flint
#include "FileInUse.inc"
#include "Colors.inc"
#include "Textures.inc"
#include "manntex.inc"

#ifndef(Handed ) #declare Handed = 1; #end #include "Hand.inc"
#ifndef(HTwist ) #declare HTwist  =<-  0,   0,   0>;#end 
#ifndef(FABend ) #declare FABend  =<   0,-  0,-  0>;#end
#ifndef(UASwing) #declare UASwing =<   0,   0,   0>;#end

#declare HalfSuperQ =difference {superellipsoid {<1.0, 0.8>}box{-1,1 translate +y}}
#declare UMArm=
union	{
	sphere{0,.20}
	union	{
		object{HalfSuperQ scale	<0.25,0.3 ,0.25>rotate x*180}
		object{HalfSuperQ scale	<0.25,1.15,0.25>}
		translate -y*.3
		}
	material{Mannequin}
	}

#declare ForeArm =
union	{
	sphere{0,.14}
	union	{
		object{HalfSuperQ scale<.2,.3,.2>rotate x*180}
		object{HalfSuperQ scale<.2,.9,.2>}
		translate -y*.3  
		}
	material{Mannequin}
	}

#declare Arm =
union	{
	object	{ UMArm }
	union	{
		object	{ ForeArm }
		#if (Handed = 0)object	{RHand translate -y*1.2}#end
		#if (Handed = 1)object	{LHand translate -y*1.2}#end
		rotate	FABend
		translate  -y*1.4
		}
	material{ Mannequin }
	rotate UASwing
	}

#if	(FileInUse=0)
	camera		{ location <0,0,-15> look_at 0 angle 40 }
	background	{ color White }
	#include 	"Sun.inc"object	{ Sun rotate <40,-10,0> }
	object		{ Arm rotate y*0 }
#end
#include "FileNotInUse.inc"
