// Persistence of Vision Ray Tracer Scene Description File
// File: "Hand.inc"
// Vers: 3.1g
// Desc: Hand For Simon the Mannequin
// Date: 1999
// Auth: Arthur F. Flint
#include "FileInUse.inc"
#include "Colors.inc"
#include "Textures.inc"
#include "manntex.inc"

#ifndef  (HTwist ) #declare HTwist =<0,0,0>;#end
#declare Wrist =
union{sphere{-x*.15,.1}cylinder{-x*.15,+x*.15,.1}sphere{+x*.15,.1}material{Mannequin}}
#declare Thumb =
union{cylinder{0,-y*.4,.075}sphere{0,.075 translate -y*.4}material{Mannequin}}
#declare RHand =
union	{
	object	{ Wrist }
	object	{ Thumb translate -x*.165 }
	union	{
		intersection{sphere{0,.5}box{-1,1 translate<.55,+1,+1>}scale .5}
		intersection{sphere{0,.5}box{-1,1 translate<.75,-1,+1>}scale<.5,1,.5>}
		material{Mannequin}
		translate<0,-.2,.05>}
	rotate HTwist
	}

#declare LHand =
union	{
	object	{ Wrist }
	object	{ Thumb translate -x*.165 }
	union	{
		intersection{sphere{0,.5}box{-1,1 translate<.55,+1,-1>}scale .5}
		intersection{sphere{0,.5}box{-1,1 translate<.75,-1,-1>}scale<.5,1,.5>}
		material{Mannequin}
		translate<0,-.2,.05>
		}
	rotate HTwist
	}

#if	(FileInUse=0)
	camera		{location <0,0,-2.5> look_at 0 angle 40 }
	#include 	"Sun.inc"object	{ Sun rotate <2,-10,0> }
	object		{ LHand rotate -y*30}
#end
#include "FileNotInUse.inc"
