
// include file for the "smilie" object
#include "Smile.inc"

global_settings { ambient_light 0.75 }

// Default texture to be used by all reflective surfaces 
#declare Reflect_Texture =
texture {
        pigment { rgb 1 }
        finish { reflection 1
                 diffuse 0
                 ambient 0
                 specular 0.5
                 roughness 0.02
        }
}

//Camera Position - variables are needed because the position of
// the camera will be used later to rotate all smilies to face it
#declare CameraX = 2.8;
#declare CameraY = 2;
#declare CameraZ = -10;

camera { location <CameraX, CameraY, CameraZ>
         look_at <0, 0, 0>
         angle 90
}

light_source { <11, 11, -11> rgb 1 }

light_source { <-11, -11, -11> rgb 1 }

// Outer sphere
sphere { 0, 21
        texture { Reflect_Texture pigment { transmit 1 } }
        hollow
}

//Cheap code to create a pyramid of smilies, Recursion_Level high
#declare Current_Level = 0;

#declare Recursion_Level = 3;

#declare Spacing = 4.2; //amount of space between each object on the
                        // x and y axes

// Loop #1
#while (Current_Level < Recursion_Level)

#declare x_iter = 0;
#declare y_iter = 0;

// Loop #2
#while (x_iter <= 20-(Spacing*Current_Level))

// Loop #3
#while (y_iter <= 20-(Spacing*Current_Level))

// Position of each individual object is calc'd into these variables
#declare X_Pos = x_iter-(10-(Spacing*Current_Level/2));
#declare Y_Pos = y_iter-(10-(Spacing*Current_Level/2));
#declare Z_Pos = -7*(Current_Level/Recursion_Level);

// values to rotate each object by so that it will face the camera
#declare X_Angle = degrees(atan2(CameraY-Y_Pos, -(CameraZ-Z_Pos)));
#declare Y_Angle = degrees(atan2(-(CameraX-X_Pos), -(CameraZ-Z_Pos)));
#declare Z_Angle = 0;

// The actual object itself
object { Smilie
      scale 2-(Current_Level/Recursion_Level) // The shrink as they near the 
                                              // pyramid's top

      rotate <X_Angle, Y_Angle, Z_Angle> // Rotate to face the camera

      // standard reflection texture with a colored ambient value
      texture { Reflect_Texture finish { ambient <x_iter/20, y_iter/40, 0> } }

      translate <X_Pos, Y_Pos, Z_Pos> // Now reposition the object
}

#declare y_iter = y_iter + Spacing;

#end // End Loop #3

#declare y_iter = 0; // Reset this variable for the next loop

#declare x_iter = x_iter + Spacing;

#end // End Loop #2

#declare Current_Level = Current_Level + 1;

#end // End Loop #1

// The "Have a nice day" message
// translate values approximated

text  { ttf "timrom.ttf" "Have a" 0.1, 0
        scale 5
        translate <-5, 2, -11>
        pigment { rgb 1 }
        finish { ambient rgb <0.3, 0.8, 0> }
}

text  { ttf "timrom.ttf" "nice day" 0.1, 0
        scale 5
        translate <-5, -2, -11>
        pigment { rgb 1 }
        finish { ambient rgb <0.3, 0.8, 0> }
}
