// Creates a generic 3D Smilie

////////////////////////////////////////////////////////////////
// Definitions
////////////////////////////////////////////////////////////////

#declare Smile_Texture =
texture {
pigment { rgbt <1, 1, 0, 0.2> }
finish {
        phong 0.6
        phong_size 3
        ambient 0.3
}

}

#declare Face_Texture =
texture {
 pigment { rgb 0 }
 finish { reflection 0.5
          phong 0.8
          phong_size 150
 }
}

#declare Mouth =
intersection {
torus { 0.8, 0.1 translate z*.7}
sphere { 0, 1 }

rotate x*-100
scale 0.8

texture { Face_Texture }

}

#declare Eye =
sphere { 0, 0.15
        scale <1, 1.5, 1>
        rotate x*25
texture { Face_Texture }
}

////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////


#declare Smilie =
////////////////////////////////////////////////////////////////
// Body
////////////////////////////////////////////////////////////////

// Position of face objects approximated

difference {
sphere { 0, 1 } 

object { Eye
        translate <0.3, 0.4, -.78>
        texture { Face_Texture }
}
object { Eye
        translate <-0.3, 0.4, -.78>
        texture { Face_Texture }
}

object { Mouth
        translate <0, -0.65, -.7>
        texture { Face_Texture }
}


}
////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////

// To ensure we are using the correct version of smile.inc (I have several)
#debug "\nSmilie include file for reflect.pov\n"
