// 3 Dimensional Mandelbrot Set
#include "textures.inc"

//global_settings{max_trace_level 100 adc_bailout .005}
camera{location <3,3,3> look_at <0,0,0> }
light_source{<10,20,10> rgb 1 }

// Define area to calculate
#declare X0 = -2;
#declare Y0 = -1;
#declare Z0 = -1;
#declare XMax = 1;
#declare YMax = 1;
#declare ZMax = 1;

//Size of voxels
//Reminder: Parsing time increases as the CUBE of this value, so be careful
#declare DS = .1; 

#declare Iterations = 20;


#declare IterInter = 1/Iterations;
#declare X = X0;
union{
	#while( X < XMax )
		#declare Y = Y0;
		#while( Y < YMax )
			#declare Z = Z0;
			#while( Z < ZMax )
				#declare N = 0;
				#declare R = X;
				#declare I = Y;
				#declare J = Z;
				#while((N<1)&(((R*R)+(I*I)+(J*J))<4))
					#declare Rn = (R*R-I*I)+X;
					#declare In = (2*R*I-J*J)+Y;
					#declare J = (2*J*I+2*J*R)+Z;
					#declare R = Rn;
					#declare I = In;
					#declare N = N + IterInter;
				#end
	
				#if(N = 1)
					sphere{<X,Y,Z>,DS}
				#end
				#declare Z = Z + DS;
			#end
			#declare Y = Y + DS;
		#end
		#declare X = X + DS;
	#end
//	pigment{rgb <1,1,1>}
	texture{New_Brass}
	rotate z*-15
}

plane{ y, -1.2 pigment{checker color rgb 1.3 color rgb <0,0,1>} }