#include "colors.inc"
#include "woods.inc"
#include "metals.inc"
#include "cdbox.inc"
#include "cdtextures.inc"
#include "cd.inc"
#include "cd2.inc"

global_settings {

  radiosity {
    brightness       4
    count            150
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.2
    low_error_factor 0.7
    minimum_reuse    0.01
    nearest_count    9
    recursion_limit  2
  }

} 


#declare cam1 = camera { location <10,21,-31>
                         look_at <1,1,0>
                       }

camera { cam1 }


    light_source {
    <0,70,-100>
    color rgb <1,0.7333,0.47481>*0.1
    area_light <5, 0, 0>, <0, 0, 5>, 5, 5
    adaptive 1
    jitter
  }


    light_source {
    <100,70,-100>
    color rgb <1,0.7333,0.47481>*0.5
    area_light <5, 0, 0>, <0, 0, 5>, 5, 5
    adaptive 1
    jitter
  } 
  
    light_source {
    <120,70,-100>
    color rgb <1,0.7333,0.47481>*0.5
    area_light <5, 0, 0>, <0, 0, 5>, 5, 5
    adaptive 1
    jitter
  }

    light_source {
    <110,70,-110>
    color rgb <1,0.7333,0.47481>*0.5
    area_light <5, 0, 0>, <0, 0, 5>, 5, 5
    adaptive 1
    jitter
  }


#declare front1a = difference {
box { <-34/2,-0.2,0>, <34/2,-6.2,-0.7> }
plane { y, 0 inverse  rotate -45*x translate <0,-0.2,-0.5> }
}

#declare front1b = difference {
box { <34/2,-0.2,-0.5>, <34/2-2,-6.2+1.2,-1> }
plane { x, 0 rotate -45*y translate <34/2-2,0,-0.5> }
}

#declare front1c = difference {
box { <34/2,-6.2+1.2,-0.7>, <-34/2,-6.2,-1> }
plane { y, 0 inverse rotate -45*x translate <0,-6.2+1.2,-0.7> }
}

#declare front1 = union {
object { front1a }
object { front1b }
object { front1c }
box { <-34/2+0.1,-0.5,-0.7>, <34/2-0.1,-0.9,-0.72> texture { T_Chrome_4D } }
}

#declare front = difference {
object { front1 }
box { <3.5/2+0.05,0.4/2+0.05,-1.1>, <-3.5/2-0.05,-0.4/2-0.05,-0.6> translate <12,-5.75,0> }
box { <3.5/2+0.05,0.4/2+0.05,-1.1>, <-3.5/2-0.05,-0.4/2-0.05,-0.6> translate <12-2*(3.5/2+0.05)-0.4,-5.75,0> }
box { <1.5/2+0.05,0.4/2+0.05,-1.1>, <-1.5/2-0.05,-0.4/2-0.05,-0.6> translate <4,-5.75,0> }
box { <1.5/2+0.05,0.4/2+0.05,-1.1>, <-1.5/2-0.05,-0.4/2-0.05,-0.6> translate <1,-5.75,0> }
box { <-34/2+2-0.05,(-6.2+1.2-0.9)/2+1.5/2+0.05,-0.4>, <-34/2+2+1.5+0.05,(-6.2+1.2-0.9)/2-1.5/2-0.05,-0.8> }
box { <-34/2+4.5-0.05,(-6.2+1.2-0.9)/2+1.8/2+0.05,-0.8>, <-34/2+4.5+14.6+0.05,(-6.2+1.2-0.9)/2-1.8/2-0.05,0.1> }
box { <-34/2+4.5+14.6+0.6+0.1+0.5,(-6.2+1.2-0.9)/2+2/2-0.2,-0.8>, <-34/2+4.5+14.6+0.6+7-0.1-0.5,(-6.2+1.2-0.9)/2-2/2+0.2,-0.1> }
box { <-34/2+4.5+14.6+1+7+0.6-0.05,(-6.2+1.2-0.9)/2+1.4/2+0.4+0.05,-0.4>, <-34/2+4.5+14.6+1+7+3+0.05,(-6.2+1.2-0.9)/2-1.4/2+0.4-0.05,-0.8> }
}

#declare buttons1 = union {
box { <3.5/2,0.4/2,-1.1>, <-3.5/2,-0.4/2,-0.6> translate <12,-5.75,0> }
box { <3.5/2,0.4/2,-1.1>, <-3.5/2,-0.4/2,-0.6> translate <12-2*(3.5/2+0.05)-0.4,-5.75,0> }
box { <1.5/2,0.4/2,-1.1>, <-1.5/2,-0.4/2,-0.6> translate <4,-5.75,0> }
box { <1.5/2,0.4/2,-1.1>, <-1.5/2,-0.4/2,-0.6> translate <1,-5.75,0> }
box { <-34/2+2,(-6.2+1.2-0.9)/2+1.5/2,-0.4>, <-34/2+2+1.5,(-6.2+1.2-0.9)/2-1.5/2,-1> }
box { <-34/2+4.5+14.6+0.6+7+1,(-6.2+1.2-0.9)/2+1.4/2+0.4,-0.4>, <-34/2+4.5+14.6+1+7+3,(-6.2+1.2-0.9)/2-1.4/2+0.4,-0.8> }

box { <-34/2+4.5+14.6+0.6+7+1,(-6.2+1.2-0.9)/2+1.4/2+0.4,-0.801>, <-34/2+4.5+14.6+1+7+3,(-6.2+1.2-0.9)/2-1.4/2+0.4,-0.8005>
texture { pigment { image_map { gif "player button 2.gif" map_type 0 interpolate 0 once transmit 1, 1 }
translate <-0.5,-0.5,0> scale <2.4,1.4,0> translate <-34/2+4.5+14.6+0.6+7+1+2.4/2,(-6.2+1.2-0.9)/2+0.4,0> } finish { reflection 0.2 } } }

box { <3.5/2,0.4/2,-1.101>, <-3.5/2,-0.4/2,-1.105>
texture { pigment { image_map { gif "player button 3.gif" map_type 0 interpolate 0 once transmit 1, 1 }
translate <-0.5,-0.5,0> scale <3.5,0.4,1> }
finish { reflection 0.2 } }
translate <12-2*(3.5/2+0.05)-0.4,-5.75,0> }
 

box { <1.5/2,0.4/2,-1.101>, <-1.5/2,-0.4/2,-1.105> 
texture { pigment { image_map { gif "player button 4.gif" map_type 0 interpolate 0 once transmit 1, 1 }
translate <-0.5,-0.5,0> scale <1.5,0.4,1> }
finish { reflection 0.2 } }
translate <4,-5.75,0> }


box { <1.5/2,0.4/2,-1.101>, <-1.5/2,-0.4/2,-1.105> 
texture { pigment { image_map { gif "player button 5.gif" map_type 0 interpolate 0 once transmit 1, 1 }
translate <-0.5,-0.5,0> scale <1.5,0.4,1> }
finish { reflection 0.2 } }
translate <1,-5.75,0> }

}

#declare buttons2 = union {
box { <-34/2+4.5+14.6-1.8,(-6.2+1.2-0.9)/2+1.8/2,-0.7>, <-34/2+4.5+14.6,(-6.2+1.2-0.9)/2-1.8/2,-0.4> }
}

#declare cadre = difference {
box { <-34/2+4.5+14.6+0.6,(-6.2+1.2-0.9)/2+2/2,-0.7>, <-34/2+4.5+14.6+0.6+7,(-6.2+1.2-0.9)/2-2/2,-0.701> }
box { <-34/2+4.5+14.6+0.6+0.1,(-6.2+1.2-0.9)/2+2/2-0.1,-0.6>, <-34/2+4.5+14.6+0.6+7-0.1,(-6.2+1.2-0.9)/2-2/2+0.1,-0.8> }
}

#declare vitre =
box { <-34/2+4.5+14.6+0.6+0.1+0.5,(-6.2+1.2-0.9)/2+2/2-0.2,-0.7>, <-34/2+4.5+14.6+0.6+7-0.1-0.5,(-6.2+1.2-0.9)/2-2/2+0.2,-0.5> }

#declare R = ((-34/2+4.5+14.6-1.8-0.15)-(-34/2+4.5+0.15))/2

#declare support1 = union {
box { <-34/2+4.5,(-6.2+1.2-0.9)/2+1.8/2-0.1,-0.7-2*R>, <-34/2+4.5+14.6-1.8,(-6.2+1.2-0.9)/2-1.8/2,-0.7-2*R-0.8> }
box { <-34/2+4.5+0.05,(-6.2+1.2-0.9)/2-1.8/2+0.2,-0.7-2*R>, <-34/2+4.5+14.6-1.8-0.05,(-6.2+1.2-0.9)/2-1.8/2,0.1> }
box { <-34/2+4.5+0.15,(-6.2+1.2-0.9)/2+1.8/2-0.1-0.02,-0.7-2*R>, <-34/2+4.5+14.6-1.8-0.15,(-6.2+1.2-0.9)/2-1.8/2,0.1> }
}

#declare planediff = difference {
plane { z, 0 rotate 40*x }
plane { y, 0 }
}

#declare support2 = difference { 
object { support1 }
cylinder { <-((-34/2+4.5+14.6-1.8-0.15)-(-34/2+4.5+0.15))/2+(-34/2+4.5+14.6-1.8-0.15),(-6.2+1.2-0.9)/2+1.8/2+1,-0.7-R>,
<-((-34/2+4.5+14.6-1.8-0.15)-(-34/2+4.5+0.15))/2+(-34/2+4.5+14.6-1.8-0.15),(-6.2+1.2-0.9)/2-1.8/2+0.2,-0.7-R>, R }
object { planediff translate <0,(-6.2+1.2-0.9)/2-1.8/2+0.2,-0.7-34/2+4.5+0.15+(34/2-4.5-0.15)/2+1> }
cylinder { <-((-34/2+4.5+14.6-1.8-0.15)-(-34/2+4.5+0.15))/2+(-34/2+4.5+14.6-1.8-0.15),(-6.2+1.2-0.9)/2+1.8/2+1,-0.7-R>,
<-((-34/2+4.5+14.6-1.8-0.15)-(-34/2+4.5+0.15))/2+(-34/2+4.5+14.6-1.8-0.15),(-6.2+1.2-0.9)/2-1.8/2-0.2,-0.7-R>, 5 }
}

#declare player = union {
box { <-34/2+0.1,-0.2-0.1,0>, <34/2-0.1,-6.2+0.1,27.5> pigment { Black } finish { reflection 0.3 specular 0.8 roughness 0.002 } }
object { vitre texture { Glass } }
object { cadre pigment { White } finish { reflection 0.3 specular 0.8 roughness 0.002 } }

object { buttons2 texture { pigment { image_map { tga "player button 1.tga" map_type 0 interpolate 0 once }
translate <-0.5,-0.5,0> scale 1.8 translate <-34/2+4.5+14.6-1.8/2,(-6.2+1.2-0.9)/2,0> }
finish { reflection 0.3 specular 0.8 roughness 0.002 } } }

object { buttons1 texture { T_Chrome_4D } }
object { front pigment { Black } finish { reflection 0.3 specular 0.8 roughness 0.002 } }

object { support2 pigment { Black } finish { reflection 0.3 specular 0.8 roughness 0.002 } }
object { CD_DOTM scale (R-0.05)/9.6 rotate 80*y translate <-((-34/2+4.5+14.6-1.8-0.15)-(-34/2+4.5+0.15))/2+(-34/2+4.5+14.6-1.8-0.15),(-6.2+1.2-0.9)/2-1.8/2+0.6,-0.7-R> }

text { ttf "c:\windows\fonts\arial.ttf",  "COMPACT DISC PLAYER", 2, 0 scale 0.5 translate <-16,-1.5,-0.7-0.01> pigment { White }  }
text { ttf "c:\windows\fonts\arial.ttf",  "TRACK INFO", 0.01, 0 scale 0.3 translate <3.8,-1.8,-0.7-0.01> pigment { Wheat }  }
text { ttf "c:\windows\fonts\arial.ttf",  "ELAPSED TIME", 0.01, 0 scale 0.3 translate <6.8,-1.8,-0.7-0.01> pigment { Wheat }  }
text { ttf "c:\windows\fonts\arial.ttf",  "MIN", 0.01, 0 scale 0.3 translate <6.9,-3.7,-0.7-0.01> pigment { Wheat }  }
text { ttf "c:\windows\fonts\arial.ttf",  "SEC", 0.01, 0 scale 0.3 translate <8,-3.7,-0.7-0.01> pigment { Wheat }  }

text { ttf "c:\windows\fonts\arial.ttf",  ":", 0.01, 0 scale 1.2 translate <7.8,-3.2,-0.7-0.01> pigment { Green } finish { ambient 1 } }

text { ttf "c:\windows\fonts\arial.ttf",  "PLAY/PAUSE", 0.01, 0 scale 0.3 translate <11,-1.67,-0.7-0.01> pigment { Wheat }  }
text { ttf "c:\windows\fonts\arial.ttf",  "STOP/CLEAR", 0.01, 0 scale 0.3 translate <11,-4.1,-0.7-0.01> pigment { Wheat }  }

}
    
#declare planche = merge {
box { <-34/2-15,-0.21-0.4,30-0.4>, <60,-5.21+0.4,-2*1.4-8+0.4> }
cylinder { <(-34/2)*1.4-15,-0.21-0.4,30-0.4>, <60,-0.21-0.4,30-0.4>, 0.4 }
cylinder { <(-34/2)*1.4-15,-5.21+0.4,30-0.4>, <60,-5.21+0.4,30-0.4>, 0.4 }
cylinder { <(-34/2)*1.4-15,-0.21-0.4,-2*1.4-8+0.4>, <60,-0.21-0.4,-2*1.4-8+0.4>, 0.4 }
cylinder { <(-34/2)*1.4-15,-5.21+0.4,-2*1.4-8+0.4>, <60,-5.21+0.4,-2*1.4-8+0.4>, 0.4 }

box { <(-34/2)*1.4-15,-0.21-0.4,30-0.4>, <60,-0.21,-2*1.4-8+0.4> }
box { <(-34/2)*1.4-15,-0.21-0.4,30-0.4>, <60,-5.21+0.4,30> }
box { <(-34/2)*1.4-15,-5.21+0.4,30-0.4>, <60,-5.21,-2*1.4-8+0.4> }
box { <(-34/2)*1.4-15,-0.21-0.4,-2*1.4-8+0.4>, <60,-5.21+0.4,-2*1.4-8> }

box { <(-34/2)*1.4-15,-5.21,-2*1.4-8+0.4+.4>, <60,-40,30-0.4> }
}


#declare CD_ORGa = union {
#declare N = 0;
#while (N<10+13-0.25)
box { <27-0.25,-10+N,30-0.4>, <27+0.25,-10+0.25+N,30-0.4-20.3> }
#declare N = N+1;
#end
}


#declare CD_ORGb = union {
#declare N = 0;
#while (N<6.2*1.4-0.2+13-0.25)
box { <27,-6.2*1.4+0.2+N,30-0.4>, <27+0.7,-6.2*1.4+0.2+0.17+N,30-0.4-20.3+0.25> }
#declare N = N+1.4;
#end
}

#declare CD_ORGc = union {
#declare N = 0;
#while (N<6.2*1.4-0.2+13-0.25)
box { <27+17.5,-6.2*1.4+0.2+N,30-0.4>, <27+17.5-0.7,-6.2*1.4+0.2+0.17+N,30-0.4-20.3+0.25> }
#declare N = N+1.4;
#end
}

#declare CD_ORGd = union {
#declare N = 0;
#while (N<6.2*1.4-0.2+13-0.25)
box { <27+17.5/2-0.7-0.1,-6.2*1.4+0.2+N,30-0.4>, <27+17.5/2+0.7+0.1,-6.2*1.4+0.2+0.17+N,30-0.4-19.8> }
#declare N = N+1.4;
#end
}


#declare CD_ORG = union {
box { <27,-10,30-0.4>, <27+0.25,13,30-0.4-20.3> }

box { <27-0.25,-10,30-0.4>, <27,13,30-0.4-0.5> }
box { <27-0.25,-10,30-0.4-20.3>, <27,13,30-0.4+0.5-20.3> }

box { <27-0.125+3,13,30-0.4>, <27+0.125+3,13+0.2,30-0.4-20.3> }

 
box { <27-0.25,13,30-0.4>, <27+0.25,13/*+0.25*/,30-0.4-20.3> }
box { <27+17.5+0.25,13,30-0.4>, <27+17.5-0.25,13+0.25,30-0.4-20.3> }

box { <27,13-0.25,30-0.4>, <27+17.5,13,30-0.4-20.3>  }

box { <27,0.25,30-0.4>, <27+17.5,0,30-0.4-20.3> translate (-6.2*1.4+0.2)*y }

object { CD_ORGa }
object { CD_ORGb }
object { CD_ORGc }
object { CD_ORGd }


box { <27+17.5,-10,30-0.4>, <27+17.5+0.25,13,30-0.4-20.3> }

box { <27+17.5/2-0.1,-10,30-0.4>, <27+17.5/2+0.1,13,30-0.4-20.3> }

box { <27,-10,30-0.4>, <27+17.5,13,30-0.4-0.5> }


}
 
#declare scene = union {

object { CD_ORG pigment { White } finish { crand 0.05 } }
 
object { player scale 1.4 translate -8*z }

object { BOX4 translate 0.21*y scale 0.9 translate -0.21*y rotate 5*y translate <-11.25,0,5.625> translate 2*z }
object { BOX3 translate 0.21*y scale 0.9 translate -0.21*y  rotate 10*y translate <-11.25,1.4*0.9,5.625> translate 2*z }
object { BOX2 translate 0.21*y scale 0.9 translate -0.21*y rotate -8*y translate <-11.25,2.8*0.9,5.625> translate 2*z }
object { BOX1 translate 0.21*y scale 0.9 translate -0.21*y rotate 12*y translate <-11.25,4.2*0.9,5.625> translate 2*z }
object { BOX translate 0.21*y scale 0.9 translate -0.21*y translate <12.375,0.3*0.9,5.625> translate 2*z }
    
object { planche translate (-6.2*1.4+0.2)*y material { Maple } finish { diffuse 0.4 } translate 2.5*x translate -0.05*y }


object { BOX5 scale 0.9 rotate -90*y translate <9.7*0.9,(-5-0.2),-11.5*0.9> translate <27+0.25,-6.2*1.4+0.2+(0.17+1.4)*7,30-0.4> }
object { BOX6 scale 0.9 rotate -90*y translate <9.7*0.9,(-5-0.2),-11.5*0.9> translate <27+0.25,-6.2*1.4+0.2+(0.17+1.4)*8,30-0.4> }
object { BOX7 scale 0.9 rotate -90*y translate <9.7*0.9,(-5-0.2),-11.5*0.9> translate <27+0.25,-6.2*1.4+0.2+(0.17+1.4)*9,30-0.4> }
object { BOX8 scale 0.9 rotate -90*y translate <9.7*0.9,(-5-0.2),-11.5*0.9> translate <27+0.25,-6.2*1.4+0.2+(0.17+1.4)*10,30-0.4> }
object { BOX10 scale 0.9 rotate -90*y translate <9.7*0.9,(-5-0.2),-11.5*0.9> translate <27+0.25,-6.2*1.4+0.2+(0.17+1.4)*11,30-0.4> }
object { BOX9 scale 0.9 rotate -90*y translate <9.7*0.9,(-5-0.2),-11.5*0.9> translate <27+0.25,-6.2*1.4+0.2+(0.17+1.4)*12,30-0.4> }
object { BOX10 scale 0.9 rotate -90*y translate <9.7*0.9,(-5-0.2),-11.5*0.9> translate <27+0.25,-6.2*1.4+0.2+(0.17+1.4)*13,30-0.4> }
object { BOX9 scale 0.9 rotate -90*y translate <9.7*0.9,(-5-0.2),-11.5*0.9> translate <27+0.25,-6.2*1.4+0.2+(0.17+1.4)*15,30-0.4> }
object { BOX10 scale 0.9 rotate -90*y translate <9.7*0.9,(-5-0.2),-11.5*0.9> translate <27+0.25,-6.2*1.4+0.2+(0.17+1.4)*16,30-0.4> }
}

#declare plane1 = difference {
plane { z , 0 texture { wallpaper scale 5 } rotate 90*y translate (-34/2-15-15-10)*x }
plane { z,  0 translate -10*z }
}

#declare plane2 = difference { 
plane { x, -34/2-15-15-10 }
plane { z,  0 inverse translate -10*z }
}

object { scene translate -5*y translate -2.5*x } 
  
plane { z , 40 texture { wallpaper scale 5  } } 

object { plane1 }
object { plane2 texture { pigment { image_map { tga "wallmap.tga" map_type 0 interpolate 0 } scale 150 scale 10*x rotate 90 } } } 

plane { z, -120 texture { pigment { image_map { tga "wallmap.tga" map_type 0 interpolate 0 } scale 150 scale 10*x } } }
plane { x, 120 texture { pigment { image_map { tga "wallmap.tga" map_type 0 interpolate 0 } scale 150 scale 10*x  } } }
plane { y, 80 pigment { White } }

#declare cd_samples    = 9.0; // Samples per color cycle.
#declare cd_phong      = 1.0; // How visible the cd effect is (works like phong).
#declare cd_phong_size = 200; // How thick the cd effect is (works like phong_size).
#declare cd_dispertion = 1.5; // Color dipertion (or frequency of color cycles).
#declare cd_offset     = 1.0; // Offset of color cycles in color cycles.
#declare cd_cycles     = 5.0; // Number of color cycles.
#declare cd_scale      = 2.0; // Scale of cd texture.

object {cd_object scale 8.68 rotate 180*z translate -8.68*z rotate 6.98*x translate 8.68*z translate <13.5,-5,15.75> translate 2*z}
object { COVER_DOTM scale 0.9 translate (-5-0.2)*y rotate 35*y translate <10.125-1,0,-2.25> translate 2*z }


height_field {
   tga "poster_hf.tga" 
   translate <-0.5, 0, -0.5>
   scale <1,1,1>
texture { pigment { image_map { tga "pinkf_poster.tga" map_type 0 interpolate 0 once } translate <-0.5,-0.5,0> rotate 90*x } }
scale <20,1,20*0.85> scale 3.6 rotate -90*x  translate <-12,27+2,40> }

sphere { 0, 0.6 scale <1,1,0.1> translate <20*1.7-1.5,20*0.85*1.7-1.5,-1> translate <-12,27+2,40> texture { T_Chrome_4D } }
sphere { 0, 0.6 scale <1,1,0.1> translate <20*1.7-1.5,-20*0.85*1.7+1.5,-1> translate <-12,27+2,40> texture { T_Chrome_4D } }
sphere { 0, 0.6 scale <1,1,0.1> translate <-20*1.7+1.5,20*0.85*1.7-1.5,-1> translate <-12,27+2,40> texture { T_Chrome_4D } }
sphere { 0, 0.6 scale <1,1,0.1> translate <-20*1.7+1.5,-20*0.85*1.7+1.5,-1> translate <-12,27+2,40> texture { T_Chrome_4D } }
   
