#declare T_Cold=
texture
{
  pigment
  {
    image_map
    {
      tga "cold.tga"
      interpolate 2
    }
  }
  finish { ambient 1 }
}

#declare T_Hot=
texture
{
  pigment
  {
    image_map
    {
      tga "hot.tga"
      interpolate 2
    }
  }
  finish { ambient 1 }
}

plane
{
  -z, 0
  texture
  {
    material_map
    {
      tga "mask.tga"
      #declare i=0;
      #while (i<256)
        texture { average texture_map { [1-i/255 T_Cold] [i/255 T_Hot] } }
        #declare i=i+1;
      #end
    }
    translate -0.5
  }
}

camera
{
  location  <0.0 , 0.0 ,-2>
  up y
  right x
  angle degrees (atan2(1,2))
  look_at   <0.0 , 0.0 , 0.0>
  orthographic
}
